<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/logging/v2/logging_metrics.proto

namespace Google\Logging\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes a logs-based metric.  The value of the metric is the
 * number of log entries that match a logs filter in a given time interval.
 *
 * Generated from protobuf message <code>google.logging.v2.LogMetric</code>
 */
class LogMetric extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     * Metric identifiers are limited to 100 characters and can include
     * only the following characters: `A-Z`, `a-z`, `0-9`, and the
     * special characters `_-.,+!*',()%/`.  The forward-slash character
     * (`/`) denotes a hierarchy of name pieces, and it cannot be the
     * first character of the name.
     * The metric identifier in this field must not be
     * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
     * However, when the metric identifier appears as the `[METRIC_ID]`
     * part of a `metric_name` API parameter, then the metric identifier
     * must be URL-encoded. Example:
     * `"projects/my-project/metrics/nginx%2Frequests"`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Optional. A description of this metric, which is used in documentation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
     * which is used to match log entries.
     * Example:
     *     "resource.type=gae_app AND severity>=ERROR"
     * The maximum length of the filter is 20000 characters.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     */
    private $filter = '';
    /**
     * Output only. The API version that created or updated this metric.
     * The version also dictates the syntax of the filter expression. When a value
     * for this field is missing, the default value of V2 should be assumed.
     *
     * Generated from protobuf field <code>.google.logging.v2.LogMetric.ApiVersion version = 4;</code>
     */
    private $version = 0;

    public function __construct() {
        \GPBMetadata\Google\Logging\V2\LoggingMetrics::initOnce();
        parent::__construct();
    }

    /**
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     * Metric identifiers are limited to 100 characters and can include
     * only the following characters: `A-Z`, `a-z`, `0-9`, and the
     * special characters `_-.,+!*',()%/`.  The forward-slash character
     * (`/`) denotes a hierarchy of name pieces, and it cannot be the
     * first character of the name.
     * The metric identifier in this field must not be
     * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
     * However, when the metric identifier appears as the `[METRIC_ID]`
     * part of a `metric_name` API parameter, then the metric identifier
     * must be URL-encoded. Example:
     * `"projects/my-project/metrics/nginx%2Frequests"`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     * Metric identifiers are limited to 100 characters and can include
     * only the following characters: `A-Z`, `a-z`, `0-9`, and the
     * special characters `_-.,+!*',()%/`.  The forward-slash character
     * (`/`) denotes a hierarchy of name pieces, and it cannot be the
     * first character of the name.
     * The metric identifier in this field must not be
     * [URL-encoded](https://en.wikipedia.org/wiki/Percent-encoding).
     * However, when the metric identifier appears as the `[METRIC_ID]`
     * part of a `metric_name` API parameter, then the metric identifier
     * must be URL-encoded. Example:
     * `"projects/my-project/metrics/nginx%2Frequests"`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. A description of this metric, which is used in documentation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A description of this metric, which is used in documentation.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
     * which is used to match log entries.
     * Example:
     *     "resource.type=gae_app AND severity>=ERROR"
     * The maximum length of the filter is 20000 characters.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Required. An [advanced logs filter](/logging/docs/view/advanced_filters)
     * which is used to match log entries.
     * Example:
     *     "resource.type=gae_app AND severity>=ERROR"
     * The maximum length of the filter is 20000 characters.
     *
     * Generated from protobuf field <code>string filter = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Output only. The API version that created or updated this metric.
     * The version also dictates the syntax of the filter expression. When a value
     * for this field is missing, the default value of V2 should be assumed.
     *
     * Generated from protobuf field <code>.google.logging.v2.LogMetric.ApiVersion version = 4;</code>
     * @return int
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * Output only. The API version that created or updated this metric.
     * The version also dictates the syntax of the filter expression. When a value
     * for this field is missing, the default value of V2 should be assumed.
     *
     * Generated from protobuf field <code>.google.logging.v2.LogMetric.ApiVersion version = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Logging\V2\LogMetric_ApiVersion::class);
        $this->version = $var;

        return $this;
    }

}

