<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/logging/v2/logging_config.proto

namespace Google\Logging\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes a sink used to export log entries to one of the following
 * destinations in any project: a Cloud Storage bucket, a BigQuery dataset, or a
 * Cloud Pub/Sub topic.  A logs filter controls which log entries are
 * exported. The sink must be created within a project, organization, billing
 * account, or folder.
 *
 * Generated from protobuf message <code>google.logging.v2.LogSink</code>
 */
class LogSink extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The client-assigned sink identifier, unique within the
     * project. Example: `"my-syslog-errors-to-pubsub"`.  Sink identifiers are
     * limited to 100 characters and can include only the following characters:
     * upper and lower-case alphanumeric characters, underscores, hyphens, and
     * periods.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Required. The export destination:
     *     "storage.googleapis.com/[GCS_BUCKET]"
     *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
     *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
     * The sink's `writer_identity`, set when the sink is created, must
     * have permission to write to the destination or else the log
     * entries are not exported.  For more information, see
     * [Exporting Logs With Sinks](/logging/docs/api/tasks/exporting-logs).
     *
     * Generated from protobuf field <code>string destination = 3;</code>
     */
    private $destination = '';
    /**
     * Optional.
     * An [advanced logs filter](/logging/docs/view/advanced_filters).  The only
     * exported log entries are those that are in the resource owning the sink and
     * that match the filter. The filter must use the log entry format specified
     * by the `output_version_format` parameter.  For example, in the v2 format:
     *     logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity>=ERROR
     *
     * Generated from protobuf field <code>string filter = 5;</code>
     */
    private $filter = '';
    /**
     * Deprecated. The log entry format to use for this sink's exported log
     * entries.  The v2 format is used by default and cannot be changed.
     *
     * Generated from protobuf field <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6;</code>
     */
    private $output_version_format = 0;
    /**
     * Output only. An IAM identity&mdash;a service account or group&mdash;under
     * which Stackdriver Logging writes the exported log entries to the sink's
     * destination.  This field is set by
     * [sinks.create](/logging/docs/api/reference/rest/v2/projects.sinks/create)
     * and
     * [sinks.update](/logging/docs/api/reference/rest/v2/projects.sinks/update),
     * based on the setting of `unique_writer_identity` in those methods.
     * Until you grant this identity write-access to the destination, log entry
     * exports from this sink will fail. For more information,
     * see [Granting access for a
     * resource](/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
     * Consult the destination service's documentation to determine the
     * appropriate IAM roles to assign to the identity.
     *
     * Generated from protobuf field <code>string writer_identity = 8;</code>
     */
    private $writer_identity = '';
    /**
     * Optional. This field applies only to sinks owned by organizations and
     * folders. If the field is false, the default, only the logs owned by the
     * sink's parent resource are available for export. If the field is true, then
     * logs from all the projects, folders, and billing accounts contained in the
     * sink's parent resource are also available for export. Whether a particular
     * log entry from the children is exported depends on the sink's filter
     * expression. For example, if this field is true, then the filter
     * `resource.type=gce_instance` would export all Compute Engine VM instance
     * log entries from all projects in the sink's parent. To only export entries
     * from certain child projects, filter on the project part of the log name:
     *     logName:("projects/test-project1/" OR "projects/test-project2/") AND
     *     resource.type=gce_instance
     *
     * Generated from protobuf field <code>bool include_children = 9;</code>
     */
    private $include_children = false;
    /**
     * Optional. The time at which this sink will begin exporting log entries.
     * Log entries are exported only if their timestamp is not earlier than the
     * start time.  The default value of this field is the time the sink is
     * created or updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 10;</code>
     */
    private $start_time = null;
    /**
     * Optional. The time at which this sink will stop exporting log entries.  Log
     * entries are exported only if their timestamp is earlier than the end time.
     * If this field is not supplied, there is no end time.  If both a start time
     * and an end time are provided, then the end time must be later than the
     * start time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 11;</code>
     */
    private $end_time = null;

    public function __construct() {
        \GPBMetadata\Google\Logging\V2\LoggingConfig::initOnce();
        parent::__construct();
    }

    /**
     * Required. The client-assigned sink identifier, unique within the
     * project. Example: `"my-syslog-errors-to-pubsub"`.  Sink identifiers are
     * limited to 100 characters and can include only the following characters:
     * upper and lower-case alphanumeric characters, underscores, hyphens, and
     * periods.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The client-assigned sink identifier, unique within the
     * project. Example: `"my-syslog-errors-to-pubsub"`.  Sink identifiers are
     * limited to 100 characters and can include only the following characters:
     * upper and lower-case alphanumeric characters, underscores, hyphens, and
     * periods.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The export destination:
     *     "storage.googleapis.com/[GCS_BUCKET]"
     *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
     *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
     * The sink's `writer_identity`, set when the sink is created, must
     * have permission to write to the destination or else the log
     * entries are not exported.  For more information, see
     * [Exporting Logs With Sinks](/logging/docs/api/tasks/exporting-logs).
     *
     * Generated from protobuf field <code>string destination = 3;</code>
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }

    /**
     * Required. The export destination:
     *     "storage.googleapis.com/[GCS_BUCKET]"
     *     "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
     *     "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
     * The sink's `writer_identity`, set when the sink is created, must
     * have permission to write to the destination or else the log
     * entries are not exported.  For more information, see
     * [Exporting Logs With Sinks](/logging/docs/api/tasks/exporting-logs).
     *
     * Generated from protobuf field <code>string destination = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDestination($var)
    {
        GPBUtil::checkString($var, True);
        $this->destination = $var;

        return $this;
    }

    /**
     * Optional.
     * An [advanced logs filter](/logging/docs/view/advanced_filters).  The only
     * exported log entries are those that are in the resource owning the sink and
     * that match the filter. The filter must use the log entry format specified
     * by the `output_version_format` parameter.  For example, in the v2 format:
     *     logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity>=ERROR
     *
     * Generated from protobuf field <code>string filter = 5;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Optional.
     * An [advanced logs filter](/logging/docs/view/advanced_filters).  The only
     * exported log entries are those that are in the resource owning the sink and
     * that match the filter. The filter must use the log entry format specified
     * by the `output_version_format` parameter.  For example, in the v2 format:
     *     logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity>=ERROR
     *
     * Generated from protobuf field <code>string filter = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Deprecated. The log entry format to use for this sink's exported log
     * entries.  The v2 format is used by default and cannot be changed.
     *
     * Generated from protobuf field <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6;</code>
     * @return int
     */
    public function getOutputVersionFormat()
    {
        return $this->output_version_format;
    }

    /**
     * Deprecated. The log entry format to use for this sink's exported log
     * entries.  The v2 format is used by default and cannot be changed.
     *
     * Generated from protobuf field <code>.google.logging.v2.LogSink.VersionFormat output_version_format = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setOutputVersionFormat($var)
    {
        GPBUtil::checkEnum($var, \Google\Logging\V2\LogSink_VersionFormat::class);
        $this->output_version_format = $var;

        return $this;
    }

    /**
     * Output only. An IAM identity&mdash;a service account or group&mdash;under
     * which Stackdriver Logging writes the exported log entries to the sink's
     * destination.  This field is set by
     * [sinks.create](/logging/docs/api/reference/rest/v2/projects.sinks/create)
     * and
     * [sinks.update](/logging/docs/api/reference/rest/v2/projects.sinks/update),
     * based on the setting of `unique_writer_identity` in those methods.
     * Until you grant this identity write-access to the destination, log entry
     * exports from this sink will fail. For more information,
     * see [Granting access for a
     * resource](/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
     * Consult the destination service's documentation to determine the
     * appropriate IAM roles to assign to the identity.
     *
     * Generated from protobuf field <code>string writer_identity = 8;</code>
     * @return string
     */
    public function getWriterIdentity()
    {
        return $this->writer_identity;
    }

    /**
     * Output only. An IAM identity&mdash;a service account or group&mdash;under
     * which Stackdriver Logging writes the exported log entries to the sink's
     * destination.  This field is set by
     * [sinks.create](/logging/docs/api/reference/rest/v2/projects.sinks/create)
     * and
     * [sinks.update](/logging/docs/api/reference/rest/v2/projects.sinks/update),
     * based on the setting of `unique_writer_identity` in those methods.
     * Until you grant this identity write-access to the destination, log entry
     * exports from this sink will fail. For more information,
     * see [Granting access for a
     * resource](/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
     * Consult the destination service's documentation to determine the
     * appropriate IAM roles to assign to the identity.
     *
     * Generated from protobuf field <code>string writer_identity = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setWriterIdentity($var)
    {
        GPBUtil::checkString($var, True);
        $this->writer_identity = $var;

        return $this;
    }

    /**
     * Optional. This field applies only to sinks owned by organizations and
     * folders. If the field is false, the default, only the logs owned by the
     * sink's parent resource are available for export. If the field is true, then
     * logs from all the projects, folders, and billing accounts contained in the
     * sink's parent resource are also available for export. Whether a particular
     * log entry from the children is exported depends on the sink's filter
     * expression. For example, if this field is true, then the filter
     * `resource.type=gce_instance` would export all Compute Engine VM instance
     * log entries from all projects in the sink's parent. To only export entries
     * from certain child projects, filter on the project part of the log name:
     *     logName:("projects/test-project1/" OR "projects/test-project2/") AND
     *     resource.type=gce_instance
     *
     * Generated from protobuf field <code>bool include_children = 9;</code>
     * @return bool
     */
    public function getIncludeChildren()
    {
        return $this->include_children;
    }

    /**
     * Optional. This field applies only to sinks owned by organizations and
     * folders. If the field is false, the default, only the logs owned by the
     * sink's parent resource are available for export. If the field is true, then
     * logs from all the projects, folders, and billing accounts contained in the
     * sink's parent resource are also available for export. Whether a particular
     * log entry from the children is exported depends on the sink's filter
     * expression. For example, if this field is true, then the filter
     * `resource.type=gce_instance` would export all Compute Engine VM instance
     * log entries from all projects in the sink's parent. To only export entries
     * from certain child projects, filter on the project part of the log name:
     *     logName:("projects/test-project1/" OR "projects/test-project2/") AND
     *     resource.type=gce_instance
     *
     * Generated from protobuf field <code>bool include_children = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setIncludeChildren($var)
    {
        GPBUtil::checkBool($var);
        $this->include_children = $var;

        return $this;
    }

    /**
     * Optional. The time at which this sink will begin exporting log entries.
     * Log entries are exported only if their timestamp is not earlier than the
     * start time.  The default value of this field is the time the sink is
     * created or updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 10;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    /**
     * Optional. The time at which this sink will begin exporting log entries.
     * Log entries are exported only if their timestamp is not earlier than the
     * start time.  The default value of this field is the time the sink is
     * created or updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Optional. The time at which this sink will stop exporting log entries.  Log
     * entries are exported only if their timestamp is earlier than the end time.
     * If this field is not supplied, there is no end time.  If both a start time
     * and an end time are provided, then the end time must be later than the
     * start time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 11;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    /**
     * Optional. The time at which this sink will stop exporting log entries.  Log
     * entries are exported only if their timestamp is earlier than the end time.
     * If this field is not supplied, there is no end time.  If both a start time
     * and an end time are provided, then the end time must be later than the
     * start time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 11;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

}

