<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/notebooks/v1beta1/instance.proto

namespace Google\Cloud\Notebooks\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The definition of a notebook instance.
 *
 * Generated from protobuf message <code>google.cloud.notebooks.v1beta1.Instance</code>
 */
class Instance extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path (`gs://path-to-file/file-name`).
     *
     * Generated from protobuf field <code>string post_startup_script = 4;</code>
     */
    private $post_startup_script = '';
    /**
     * Output only. The proxy endpoint that is used to access the Jupyter
     * notebook.
     *
     * Generated from protobuf field <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $proxy_uri = '';
    /**
     * Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     *
     * Generated from protobuf field <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $instance_owners;
    /**
     * The service account on this instance, giving access to other Google
     * Cloud services.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     *
     * Generated from protobuf field <code>string service_account = 7;</code>
     */
    private $service_account = '';
    /**
     * Required. The [Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) of this
     * instance.
     *
     * Generated from protobuf field <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $machine_type = '';
    /**
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you
     * have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;</code>
     */
    private $accelerator_config = null;
    /**
     * Output only. The state of this instance.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Whether the end user authorizes Google Cloud to install GPU driver
     * on this instance.
     * If this field is empty or set to false, the GPU driver won't be installed.
     * Only applicable to instances with GPUs.
     *
     * Generated from protobuf field <code>bool install_gpu_driver = 11;</code>
     */
    private $install_gpu_driver = false;
    /**
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     * If not specified, we'll automatically choose from official GPU drivers.
     *
     * Generated from protobuf field <code>string custom_gpu_driver_path = 12;</code>
     */
    private $custom_gpu_driver_path = '';
    /**
     * Input only. The type of the boot disk attached to this instance, defaults
     * to standard persistent disk (`PD_STANDARD`).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $boot_disk_type = 0;
    /**
     * Input only. The size of the boot disk in GB attached to this instance, up
     * to a maximum of 64000&nbsp;GB (64&nbsp;TB). The minimum recommended value
     * is 100&nbsp;GB. If not specified, this defaults to 100.
     *
     * Generated from protobuf field <code>int64 boot_disk_size_gb = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $boot_disk_size_gb = 0;
    /**
     * Input only. The type of the data disk attached to this instance, defaults
     * to standard persistent disk (`PD_STANDARD`).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $data_disk_type = 0;
    /**
     * Input only. The size of the data disk in GB attached to this instance, up
     * to a maximum of 64000&nbsp;GB (64&nbsp;TB). You can choose the size of the
     * data disk based on how big your notebooks and data are. If not specified,
     * this defaults to 100.
     *
     * Generated from protobuf field <code>int64 data_disk_size_gb = 26 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $data_disk_size_gb = 0;
    /**
     * Input only. If true, the data disk will not be auto deleted when deleting
     * the instance.
     *
     * Generated from protobuf field <code>bool no_remove_data_disk = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $no_remove_data_disk = false;
    /**
     * Input only. Disk encryption method used on the boot and data disks,
     * defaults to GMEK.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $disk_encryption = 0;
    /**
     * Input only. The KMS key used to encrypt the disks, only applicable if
     * disk_encryption is CMEK. Format:
     * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     * Learn more about [using your own encryption keys](
     * https://cloud.google.com/kms/docs/quickstart).
     *
     * Generated from protobuf field <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $kms_key = '';
    /**
     * If true, no public IP will be assigned to this instance.
     *
     * Generated from protobuf field <code>bool no_public_ip = 17;</code>
     */
    private $no_public_ip = false;
    /**
     * If true, the notebook instance will not register with the proxy.
     *
     * Generated from protobuf field <code>bool no_proxy_access = 18;</code>
     */
    private $no_proxy_access = false;
    /**
     * The name of the VPC that this instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     *
     * Generated from protobuf field <code>string network = 19;</code>
     */
    private $network = '';
    /**
     * The name of the subnet that this instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     *
     * Generated from protobuf field <code>string subnet = 20;</code>
     */
    private $subnet = '';
    /**
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 21;</code>
     */
    private $labels;
    /**
     * Custom metadata to apply to this instance.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 22;</code>
     */
    private $metadata;
    /**
     * Output only. Instance creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. Instance update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    protected $environment;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The name of this notebook instance. Format:
     *           `projects/{project_id}/locations/{location}/instances/{instance_id}`
     *     @type \Google\Cloud\Notebooks\V1beta1\VmImage $vm_image
     *           Use a Compute Engine VM image to start the notebook instance.
     *     @type \Google\Cloud\Notebooks\V1beta1\ContainerImage $container_image
     *           Use a container image to start the notebook instance.
     *     @type string $post_startup_script
     *           Path to a Bash script that automatically runs after a notebook instance
     *           fully boots up. The path must be a URL or
     *           Cloud Storage path (`gs://path-to-file/file-name`).
     *     @type string $proxy_uri
     *           Output only. The proxy endpoint that is used to access the Jupyter
     *           notebook.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $instance_owners
     *           Input only. The owner of this instance after creation. Format:
     *           `alias&#64;example.com`
     *           Currently supports one owner only. If not specified, all of the service
     *           account users of your VM instance's service account can use
     *           the instance.
     *     @type string $service_account
     *           The service account on this instance, giving access to other Google
     *           Cloud services.
     *           You can use any service account within the same project, but you
     *           must have the service account user permission to use the instance.
     *           If not specified, the [Compute Engine default service
     *           account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     *           is used.
     *     @type string $machine_type
     *           Required. The [Compute Engine machine
     *           type](https://cloud.google.com/compute/docs/machine-types) of this
     *           instance.
     *     @type \Google\Cloud\Notebooks\V1beta1\Instance\AcceleratorConfig $accelerator_config
     *           The hardware accelerator used on this instance. If you use
     *           accelerators, make sure that your configuration has
     *           [enough vCPUs and memory to support the `machine_type` you
     *           have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     *     @type int $state
     *           Output only. The state of this instance.
     *     @type bool $install_gpu_driver
     *           Whether the end user authorizes Google Cloud to install GPU driver
     *           on this instance.
     *           If this field is empty or set to false, the GPU driver won't be installed.
     *           Only applicable to instances with GPUs.
     *     @type string $custom_gpu_driver_path
     *           Specify a custom Cloud Storage path where the GPU driver is stored.
     *           If not specified, we'll automatically choose from official GPU drivers.
     *     @type int $boot_disk_type
     *           Input only. The type of the boot disk attached to this instance, defaults
     *           to standard persistent disk (`PD_STANDARD`).
     *     @type int|string $boot_disk_size_gb
     *           Input only. The size of the boot disk in GB attached to this instance, up
     *           to a maximum of 64000&nbsp;GB (64&nbsp;TB). The minimum recommended value
     *           is 100&nbsp;GB. If not specified, this defaults to 100.
     *     @type int $data_disk_type
     *           Input only. The type of the data disk attached to this instance, defaults
     *           to standard persistent disk (`PD_STANDARD`).
     *     @type int|string $data_disk_size_gb
     *           Input only. The size of the data disk in GB attached to this instance, up
     *           to a maximum of 64000&nbsp;GB (64&nbsp;TB). You can choose the size of the
     *           data disk based on how big your notebooks and data are. If not specified,
     *           this defaults to 100.
     *     @type bool $no_remove_data_disk
     *           Input only. If true, the data disk will not be auto deleted when deleting
     *           the instance.
     *     @type int $disk_encryption
     *           Input only. Disk encryption method used on the boot and data disks,
     *           defaults to GMEK.
     *     @type string $kms_key
     *           Input only. The KMS key used to encrypt the disks, only applicable if
     *           disk_encryption is CMEK. Format:
     *           `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     *           Learn more about [using your own encryption keys](
     *           https://cloud.google.com/kms/docs/quickstart).
     *     @type bool $no_public_ip
     *           If true, no public IP will be assigned to this instance.
     *     @type bool $no_proxy_access
     *           If true, the notebook instance will not register with the proxy.
     *     @type string $network
     *           The name of the VPC that this instance is in.
     *           Format:
     *           `projects/{project_id}/global/networks/{network_id}`
     *     @type string $subnet
     *           The name of the subnet that this instance is in.
     *           Format:
     *           `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this instance.
     *           These can be later modified by the setLabels method.
     *     @type array|\Google\Protobuf\Internal\MapField $metadata
     *           Custom metadata to apply to this instance.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Instance creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Instance update time.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Notebooks\V1Beta1\Instance::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The name of this notebook instance. Format:
     * `projects/{project_id}/locations/{location}/instances/{instance_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Use a Compute Engine VM image to start the notebook instance.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     * @return \Google\Cloud\Notebooks\V1beta1\VmImage|null
     */
    public function getVmImage()
    {
        return $this->readOneof(2);
    }

    public function hasVmImage()
    {
        return $this->hasOneof(2);
    }

    /**
     * Use a Compute Engine VM image to start the notebook instance.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.VmImage vm_image = 2;</code>
     * @param \Google\Cloud\Notebooks\V1beta1\VmImage $var
     * @return $this
     */
    public function setVmImage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Notebooks\V1beta1\VmImage::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Use a container image to start the notebook instance.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     * @return \Google\Cloud\Notebooks\V1beta1\ContainerImage|null
     */
    public function getContainerImage()
    {
        return $this->readOneof(3);
    }

    public function hasContainerImage()
    {
        return $this->hasOneof(3);
    }

    /**
     * Use a container image to start the notebook instance.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.ContainerImage container_image = 3;</code>
     * @param \Google\Cloud\Notebooks\V1beta1\ContainerImage $var
     * @return $this
     */
    public function setContainerImage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Notebooks\V1beta1\ContainerImage::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path (`gs://path-to-file/file-name`).
     *
     * Generated from protobuf field <code>string post_startup_script = 4;</code>
     * @return string
     */
    public function getPostStartupScript()
    {
        return $this->post_startup_script;
    }

    /**
     * Path to a Bash script that automatically runs after a notebook instance
     * fully boots up. The path must be a URL or
     * Cloud Storage path (`gs://path-to-file/file-name`).
     *
     * Generated from protobuf field <code>string post_startup_script = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPostStartupScript($var)
    {
        GPBUtil::checkString($var, True);
        $this->post_startup_script = $var;

        return $this;
    }

    /**
     * Output only. The proxy endpoint that is used to access the Jupyter
     * notebook.
     *
     * Generated from protobuf field <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProxyUri()
    {
        return $this->proxy_uri;
    }

    /**
     * Output only. The proxy endpoint that is used to access the Jupyter
     * notebook.
     *
     * Generated from protobuf field <code>string proxy_uri = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProxyUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->proxy_uri = $var;

        return $this;
    }

    /**
     * Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     *
     * Generated from protobuf field <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInstanceOwners()
    {
        return $this->instance_owners;
    }

    /**
     * Input only. The owner of this instance after creation. Format:
     * `alias&#64;example.com`
     * Currently supports one owner only. If not specified, all of the service
     * account users of your VM instance's service account can use
     * the instance.
     *
     * Generated from protobuf field <code>repeated string instance_owners = 6 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInstanceOwners($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->instance_owners = $arr;

        return $this;
    }

    /**
     * The service account on this instance, giving access to other Google
     * Cloud services.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     *
     * Generated from protobuf field <code>string service_account = 7;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * The service account on this instance, giving access to other Google
     * Cloud services.
     * You can use any service account within the same project, but you
     * must have the service account user permission to use the instance.
     * If not specified, the [Compute Engine default service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used.
     *
     * Generated from protobuf field <code>string service_account = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Required. The [Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) of this
     * instance.
     *
     * Generated from protobuf field <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * Required. The [Compute Engine machine
     * type](https://cloud.google.com/compute/docs/machine-types) of this
     * instance.
     *
     * Generated from protobuf field <code>string machine_type = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you
     * have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;</code>
     * @return \Google\Cloud\Notebooks\V1beta1\Instance\AcceleratorConfig|null
     */
    public function getAcceleratorConfig()
    {
        return $this->accelerator_config;
    }

    public function hasAcceleratorConfig()
    {
        return isset($this->accelerator_config);
    }

    public function clearAcceleratorConfig()
    {
        unset($this->accelerator_config);
    }

    /**
     * The hardware accelerator used on this instance. If you use
     * accelerators, make sure that your configuration has
     * [enough vCPUs and memory to support the `machine_type` you
     * have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig accelerator_config = 9;</code>
     * @param \Google\Cloud\Notebooks\V1beta1\Instance\AcceleratorConfig $var
     * @return $this
     */
    public function setAcceleratorConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Notebooks\V1beta1\Instance\AcceleratorConfig::class);
        $this->accelerator_config = $var;

        return $this;
    }

    /**
     * Output only. The state of this instance.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of this instance.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.State state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Notebooks\V1beta1\Instance\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Whether the end user authorizes Google Cloud to install GPU driver
     * on this instance.
     * If this field is empty or set to false, the GPU driver won't be installed.
     * Only applicable to instances with GPUs.
     *
     * Generated from protobuf field <code>bool install_gpu_driver = 11;</code>
     * @return bool
     */
    public function getInstallGpuDriver()
    {
        return $this->install_gpu_driver;
    }

    /**
     * Whether the end user authorizes Google Cloud to install GPU driver
     * on this instance.
     * If this field is empty or set to false, the GPU driver won't be installed.
     * Only applicable to instances with GPUs.
     *
     * Generated from protobuf field <code>bool install_gpu_driver = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setInstallGpuDriver($var)
    {
        GPBUtil::checkBool($var);
        $this->install_gpu_driver = $var;

        return $this;
    }

    /**
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     * If not specified, we'll automatically choose from official GPU drivers.
     *
     * Generated from protobuf field <code>string custom_gpu_driver_path = 12;</code>
     * @return string
     */
    public function getCustomGpuDriverPath()
    {
        return $this->custom_gpu_driver_path;
    }

    /**
     * Specify a custom Cloud Storage path where the GPU driver is stored.
     * If not specified, we'll automatically choose from official GPU drivers.
     *
     * Generated from protobuf field <code>string custom_gpu_driver_path = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomGpuDriverPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_gpu_driver_path = $var;

        return $this;
    }

    /**
     * Input only. The type of the boot disk attached to this instance, defaults
     * to standard persistent disk (`PD_STANDARD`).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int
     */
    public function getBootDiskType()
    {
        return $this->boot_disk_type;
    }

    /**
     * Input only. The type of the boot disk attached to this instance, defaults
     * to standard persistent disk (`PD_STANDARD`).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskType boot_disk_type = 13 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setBootDiskType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Notebooks\V1beta1\Instance\DiskType::class);
        $this->boot_disk_type = $var;

        return $this;
    }

    /**
     * Input only. The size of the boot disk in GB attached to this instance, up
     * to a maximum of 64000&nbsp;GB (64&nbsp;TB). The minimum recommended value
     * is 100&nbsp;GB. If not specified, this defaults to 100.
     *
     * Generated from protobuf field <code>int64 boot_disk_size_gb = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int|string
     */
    public function getBootDiskSizeGb()
    {
        return $this->boot_disk_size_gb;
    }

    /**
     * Input only. The size of the boot disk in GB attached to this instance, up
     * to a maximum of 64000&nbsp;GB (64&nbsp;TB). The minimum recommended value
     * is 100&nbsp;GB. If not specified, this defaults to 100.
     *
     * Generated from protobuf field <code>int64 boot_disk_size_gb = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setBootDiskSizeGb($var)
    {
        GPBUtil::checkInt64($var);
        $this->boot_disk_size_gb = $var;

        return $this;
    }

    /**
     * Input only. The type of the data disk attached to this instance, defaults
     * to standard persistent disk (`PD_STANDARD`).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int
     */
    public function getDataDiskType()
    {
        return $this->data_disk_type;
    }

    /**
     * Input only. The type of the data disk attached to this instance, defaults
     * to standard persistent disk (`PD_STANDARD`).
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskType data_disk_type = 25 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDataDiskType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Notebooks\V1beta1\Instance\DiskType::class);
        $this->data_disk_type = $var;

        return $this;
    }

    /**
     * Input only. The size of the data disk in GB attached to this instance, up
     * to a maximum of 64000&nbsp;GB (64&nbsp;TB). You can choose the size of the
     * data disk based on how big your notebooks and data are. If not specified,
     * this defaults to 100.
     *
     * Generated from protobuf field <code>int64 data_disk_size_gb = 26 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int|string
     */
    public function getDataDiskSizeGb()
    {
        return $this->data_disk_size_gb;
    }

    /**
     * Input only. The size of the data disk in GB attached to this instance, up
     * to a maximum of 64000&nbsp;GB (64&nbsp;TB). You can choose the size of the
     * data disk based on how big your notebooks and data are. If not specified,
     * this defaults to 100.
     *
     * Generated from protobuf field <code>int64 data_disk_size_gb = 26 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setDataDiskSizeGb($var)
    {
        GPBUtil::checkInt64($var);
        $this->data_disk_size_gb = $var;

        return $this;
    }

    /**
     * Input only. If true, the data disk will not be auto deleted when deleting
     * the instance.
     *
     * Generated from protobuf field <code>bool no_remove_data_disk = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return bool
     */
    public function getNoRemoveDataDisk()
    {
        return $this->no_remove_data_disk;
    }

    /**
     * Input only. If true, the data disk will not be auto deleted when deleting
     * the instance.
     *
     * Generated from protobuf field <code>bool no_remove_data_disk = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setNoRemoveDataDisk($var)
    {
        GPBUtil::checkBool($var);
        $this->no_remove_data_disk = $var;

        return $this;
    }

    /**
     * Input only. Disk encryption method used on the boot and data disks,
     * defaults to GMEK.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int
     */
    public function getDiskEncryption()
    {
        return $this->disk_encryption;
    }

    /**
     * Input only. Disk encryption method used on the boot and data disks,
     * defaults to GMEK.
     *
     * Generated from protobuf field <code>.google.cloud.notebooks.v1beta1.Instance.DiskEncryption disk_encryption = 15 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDiskEncryption($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Notebooks\V1beta1\Instance\DiskEncryption::class);
        $this->disk_encryption = $var;

        return $this;
    }

    /**
     * Input only. The KMS key used to encrypt the disks, only applicable if
     * disk_encryption is CMEK. Format:
     * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     * Learn more about [using your own encryption keys](
     * https://cloud.google.com/kms/docs/quickstart).
     *
     * Generated from protobuf field <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return string
     */
    public function getKmsKey()
    {
        return $this->kms_key;
    }

    /**
     * Input only. The KMS key used to encrypt the disks, only applicable if
     * disk_encryption is CMEK. Format:
     * `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
     * Learn more about [using your own encryption keys](
     * https://cloud.google.com/kms/docs/quickstart).
     *
     * Generated from protobuf field <code>string kms_key = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key = $var;

        return $this;
    }

    /**
     * If true, no public IP will be assigned to this instance.
     *
     * Generated from protobuf field <code>bool no_public_ip = 17;</code>
     * @return bool
     */
    public function getNoPublicIp()
    {
        return $this->no_public_ip;
    }

    /**
     * If true, no public IP will be assigned to this instance.
     *
     * Generated from protobuf field <code>bool no_public_ip = 17;</code>
     * @param bool $var
     * @return $this
     */
    public function setNoPublicIp($var)
    {
        GPBUtil::checkBool($var);
        $this->no_public_ip = $var;

        return $this;
    }

    /**
     * If true, the notebook instance will not register with the proxy.
     *
     * Generated from protobuf field <code>bool no_proxy_access = 18;</code>
     * @return bool
     */
    public function getNoProxyAccess()
    {
        return $this->no_proxy_access;
    }

    /**
     * If true, the notebook instance will not register with the proxy.
     *
     * Generated from protobuf field <code>bool no_proxy_access = 18;</code>
     * @param bool $var
     * @return $this
     */
    public function setNoProxyAccess($var)
    {
        GPBUtil::checkBool($var);
        $this->no_proxy_access = $var;

        return $this;
    }

    /**
     * The name of the VPC that this instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     *
     * Generated from protobuf field <code>string network = 19;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * The name of the VPC that this instance is in.
     * Format:
     * `projects/{project_id}/global/networks/{network_id}`
     *
     * Generated from protobuf field <code>string network = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * The name of the subnet that this instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     *
     * Generated from protobuf field <code>string subnet = 20;</code>
     * @return string
     */
    public function getSubnet()
    {
        return $this->subnet;
    }

    /**
     * The name of the subnet that this instance is in.
     * Format:
     * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
     *
     * Generated from protobuf field <code>string subnet = 20;</code>
     * @param string $var
     * @return $this
     */
    public function setSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->subnet = $var;

        return $this;
    }

    /**
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 21;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this instance.
     * These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 21;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Custom metadata to apply to this instance.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 22;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * Custom metadata to apply to this instance.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 22;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * Output only. Instance creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Instance creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Instance update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Instance update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getEnvironment()
    {
        return $this->whichOneof("environment");
    }

}

