<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gkeconnect/gateway/v1beta1/gateway.proto
 * Updates to the above are reflected here through a refresh process.
 *
 * @experimental
 */

namespace Google\Cloud\GkeConnect\Gateway\V1beta1\Gapic;

use Google\Api\HttpBody;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Protobuf\Any;

/**
 * Service Description: Gateway service is a public API which works as a Kubernetes resource model
 * proxy between end users and registered Kubernetes clusters. Each RPC in this
 * service matches with an HTTP verb. End user will initiate kubectl commands
 * against the Gateway service, and Gateway service will forward user requests
 * to clusters.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $gatewayServiceClient = new GatewayServiceClient();
 * try {
 *     $response = $gatewayServiceClient->deleteResource();
 * } finally {
 *     $gatewayServiceClient->close();
 * }
 * ```
 *
 * @experimental
 */
class GatewayServiceGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.gkeconnect.gateway.v1beta1.GatewayService';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'connectgateway.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/gateway_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/gateway_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/gateway_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/gateway_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'connectgateway.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     *
     * @experimental
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * DeleteResource performs an HTTP DELETE on the Kubernetes API Server.
     *
     * Sample code:
     * ```
     * $gatewayServiceClient = new GatewayServiceClient();
     * try {
     *     $response = $gatewayServiceClient->deleteResource();
     * } finally {
     *     $gatewayServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $contentType
     *           The HTTP Content-Type header value specifying the content type of the body.
     *     @type string $data
     *           The HTTP request/response body as raw binary.
     *     @type Any[] $extensions
     *           Application specific response metadata. Must be set in the first response
     *           for streaming APIs.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Api\HttpBody
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function deleteResource(array $optionalArgs = [])
    {
        $request = new HttpBody();
        if (isset($optionalArgs['contentType'])) {
            $request->setContentType($optionalArgs['contentType']);
        }

        if (isset($optionalArgs['data'])) {
            $request->setData($optionalArgs['data']);
        }

        if (isset($optionalArgs['extensions'])) {
            $request->setExtensions($optionalArgs['extensions']);
        }

        return $this->startCall(
            'DeleteResource',
            HttpBody::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * GetResource performs an HTTP GET request on the Kubernetes API Server.
     *
     * Sample code:
     * ```
     * $gatewayServiceClient = new GatewayServiceClient();
     * try {
     *     $response = $gatewayServiceClient->getResource();
     * } finally {
     *     $gatewayServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $contentType
     *           The HTTP Content-Type header value specifying the content type of the body.
     *     @type string $data
     *           The HTTP request/response body as raw binary.
     *     @type Any[] $extensions
     *           Application specific response metadata. Must be set in the first response
     *           for streaming APIs.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Api\HttpBody
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function getResource(array $optionalArgs = [])
    {
        $request = new HttpBody();
        if (isset($optionalArgs['contentType'])) {
            $request->setContentType($optionalArgs['contentType']);
        }

        if (isset($optionalArgs['data'])) {
            $request->setData($optionalArgs['data']);
        }

        if (isset($optionalArgs['extensions'])) {
            $request->setExtensions($optionalArgs['extensions']);
        }

        return $this->startCall(
            'GetResource',
            HttpBody::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * PatchResource performs an HTTP PATCH on the Kubernetes API Server.
     *
     * Sample code:
     * ```
     * $gatewayServiceClient = new GatewayServiceClient();
     * try {
     *     $response = $gatewayServiceClient->patchResource();
     * } finally {
     *     $gatewayServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $contentType
     *           The HTTP Content-Type header value specifying the content type of the body.
     *     @type string $data
     *           The HTTP request/response body as raw binary.
     *     @type Any[] $extensions
     *           Application specific response metadata. Must be set in the first response
     *           for streaming APIs.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Api\HttpBody
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function patchResource(array $optionalArgs = [])
    {
        $request = new HttpBody();
        if (isset($optionalArgs['contentType'])) {
            $request->setContentType($optionalArgs['contentType']);
        }

        if (isset($optionalArgs['data'])) {
            $request->setData($optionalArgs['data']);
        }

        if (isset($optionalArgs['extensions'])) {
            $request->setExtensions($optionalArgs['extensions']);
        }

        return $this->startCall(
            'PatchResource',
            HttpBody::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * PostResource performs an HTTP POST on the Kubernetes API Server.
     *
     * Sample code:
     * ```
     * $gatewayServiceClient = new GatewayServiceClient();
     * try {
     *     $response = $gatewayServiceClient->postResource();
     * } finally {
     *     $gatewayServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $contentType
     *           The HTTP Content-Type header value specifying the content type of the body.
     *     @type string $data
     *           The HTTP request/response body as raw binary.
     *     @type Any[] $extensions
     *           Application specific response metadata. Must be set in the first response
     *           for streaming APIs.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Api\HttpBody
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function postResource(array $optionalArgs = [])
    {
        $request = new HttpBody();
        if (isset($optionalArgs['contentType'])) {
            $request->setContentType($optionalArgs['contentType']);
        }

        if (isset($optionalArgs['data'])) {
            $request->setData($optionalArgs['data']);
        }

        if (isset($optionalArgs['extensions'])) {
            $request->setExtensions($optionalArgs['extensions']);
        }

        return $this->startCall(
            'PostResource',
            HttpBody::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * PutResource performs an HTTP PUT on the Kubernetes API Server.
     *
     * Sample code:
     * ```
     * $gatewayServiceClient = new GatewayServiceClient();
     * try {
     *     $response = $gatewayServiceClient->putResource();
     * } finally {
     *     $gatewayServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $contentType
     *           The HTTP Content-Type header value specifying the content type of the body.
     *     @type string $data
     *           The HTTP request/response body as raw binary.
     *     @type Any[] $extensions
     *           Application specific response metadata. Must be set in the first response
     *           for streaming APIs.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Api\HttpBody
     *
     * @throws ApiException if the remote call fails
     *
     * @experimental
     */
    public function putResource(array $optionalArgs = [])
    {
        $request = new HttpBody();
        if (isset($optionalArgs['contentType'])) {
            $request->setContentType($optionalArgs['contentType']);
        }

        if (isset($optionalArgs['data'])) {
            $request->setData($optionalArgs['data']);
        }

        if (isset($optionalArgs['extensions'])) {
            $request->setExtensions($optionalArgs['extensions']);
        }

        return $this->startCall(
            'PutResource',
            HttpBody::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
