<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/functions/v2/functions.proto

namespace Google\Cloud\Functions\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes EventTrigger, used to request events to be sent from another
 * service.
 *
 * Generated from protobuf message <code>google.cloud.functions.v2.EventTrigger</code>
 */
class EventTrigger extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the Eventarc trigger. The format of this field is
     * `projects/{project}/locations/{region}/triggers/{trigger}`.
     *
     * Generated from protobuf field <code>string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $trigger = '';
    /**
     * The region that the trigger will be in. The trigger will only receive
     * events originating in this region. It can be the same
     * region as the function, a different region or multi-region, or the global
     * region. If not provided, defaults to the same region as the function.
     *
     * Generated from protobuf field <code>string trigger_region = 2;</code>
     */
    private $trigger_region = '';
    /**
     * Required. The type of event to observe. For example:
     * `google.cloud.audit.log.v1.written` or
     * `google.cloud.pubsub.topic.v1.messagePublished`.
     *
     * Generated from protobuf field <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $event_type = '';
    /**
     * Criteria used to filter events.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v2.EventFilter event_filters = 4;</code>
     */
    private $event_filters;
    /**
     * Optional. The name of a Pub/Sub topic in the same project that will be used
     * as the transport topic for the event delivery. Format:
     * `projects/{project}/topics/{topic}`.
     * This is only valid for events of type
     * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     * will not be deleted at function deletion.
     *
     * Generated from protobuf field <code>string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $pubsub_topic = '';
    /**
     * Optional. The email of the trigger's service account. The service account must have
     * permission to invoke Cloud Run services, the permission is
     * `run.routes.invoke`.
     * If empty, defaults to the Compute Engine default service account:
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $service_account_email = '';
    /**
     * Optional. If unset, then defaults to ignoring failures (i.e. not retrying them).
     *
     * Generated from protobuf field <code>.google.cloud.functions.v2.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $retry_policy = 0;
    /**
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     *
     * Generated from protobuf field <code>string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $channel = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $trigger
     *           Output only. The resource name of the Eventarc trigger. The format of this field is
     *           `projects/{project}/locations/{region}/triggers/{trigger}`.
     *     @type string $trigger_region
     *           The region that the trigger will be in. The trigger will only receive
     *           events originating in this region. It can be the same
     *           region as the function, a different region or multi-region, or the global
     *           region. If not provided, defaults to the same region as the function.
     *     @type string $event_type
     *           Required. The type of event to observe. For example:
     *           `google.cloud.audit.log.v1.written` or
     *           `google.cloud.pubsub.topic.v1.messagePublished`.
     *     @type array<\Google\Cloud\Functions\V2\EventFilter>|\Google\Protobuf\Internal\RepeatedField $event_filters
     *           Criteria used to filter events.
     *     @type string $pubsub_topic
     *           Optional. The name of a Pub/Sub topic in the same project that will be used
     *           as the transport topic for the event delivery. Format:
     *           `projects/{project}/topics/{topic}`.
     *           This is only valid for events of type
     *           `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     *           will not be deleted at function deletion.
     *     @type string $service_account_email
     *           Optional. The email of the trigger's service account. The service account must have
     *           permission to invoke Cloud Run services, the permission is
     *           `run.routes.invoke`.
     *           If empty, defaults to the Compute Engine default service account:
     *           `{project_number}-compute&#64;developer.gserviceaccount.com`.
     *     @type int $retry_policy
     *           Optional. If unset, then defaults to ignoring failures (i.e. not retrying them).
     *     @type string $channel
     *           Optional. The name of the channel associated with the trigger in
     *           `projects/{project}/locations/{location}/channels/{channel}` format.
     *           You must provide a channel to receive events from Eventarc SaaS partners.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Functions\V2\Functions::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the Eventarc trigger. The format of this field is
     * `projects/{project}/locations/{region}/triggers/{trigger}`.
     *
     * Generated from protobuf field <code>string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getTrigger()
    {
        return $this->trigger;
    }

    /**
     * Output only. The resource name of the Eventarc trigger. The format of this field is
     * `projects/{project}/locations/{region}/triggers/{trigger}`.
     *
     * Generated from protobuf field <code>string trigger = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setTrigger($var)
    {
        GPBUtil::checkString($var, True);
        $this->trigger = $var;

        return $this;
    }

    /**
     * The region that the trigger will be in. The trigger will only receive
     * events originating in this region. It can be the same
     * region as the function, a different region or multi-region, or the global
     * region. If not provided, defaults to the same region as the function.
     *
     * Generated from protobuf field <code>string trigger_region = 2;</code>
     * @return string
     */
    public function getTriggerRegion()
    {
        return $this->trigger_region;
    }

    /**
     * The region that the trigger will be in. The trigger will only receive
     * events originating in this region. It can be the same
     * region as the function, a different region or multi-region, or the global
     * region. If not provided, defaults to the same region as the function.
     *
     * Generated from protobuf field <code>string trigger_region = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setTriggerRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->trigger_region = $var;

        return $this;
    }

    /**
     * Required. The type of event to observe. For example:
     * `google.cloud.audit.log.v1.written` or
     * `google.cloud.pubsub.topic.v1.messagePublished`.
     *
     * Generated from protobuf field <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getEventType()
    {
        return $this->event_type;
    }

    /**
     * Required. The type of event to observe. For example:
     * `google.cloud.audit.log.v1.written` or
     * `google.cloud.pubsub.topic.v1.messagePublished`.
     *
     * Generated from protobuf field <code>string event_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setEventType($var)
    {
        GPBUtil::checkString($var, True);
        $this->event_type = $var;

        return $this;
    }

    /**
     * Criteria used to filter events.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v2.EventFilter event_filters = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEventFilters()
    {
        return $this->event_filters;
    }

    /**
     * Criteria used to filter events.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v2.EventFilter event_filters = 4;</code>
     * @param array<\Google\Cloud\Functions\V2\EventFilter>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEventFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Functions\V2\EventFilter::class);
        $this->event_filters = $arr;

        return $this;
    }

    /**
     * Optional. The name of a Pub/Sub topic in the same project that will be used
     * as the transport topic for the event delivery. Format:
     * `projects/{project}/topics/{topic}`.
     * This is only valid for events of type
     * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     * will not be deleted at function deletion.
     *
     * Generated from protobuf field <code>string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getPubsubTopic()
    {
        return $this->pubsub_topic;
    }

    /**
     * Optional. The name of a Pub/Sub topic in the same project that will be used
     * as the transport topic for the event delivery. Format:
     * `projects/{project}/topics/{topic}`.
     * This is only valid for events of type
     * `google.cloud.pubsub.topic.v1.messagePublished`. The topic provided here
     * will not be deleted at function deletion.
     *
     * Generated from protobuf field <code>string pubsub_topic = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setPubsubTopic($var)
    {
        GPBUtil::checkString($var, True);
        $this->pubsub_topic = $var;

        return $this;
    }

    /**
     * Optional. The email of the trigger's service account. The service account must have
     * permission to invoke Cloud Run services, the permission is
     * `run.routes.invoke`.
     * If empty, defaults to the Compute Engine default service account:
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getServiceAccountEmail()
    {
        return $this->service_account_email;
    }

    /**
     * Optional. The email of the trigger's service account. The service account must have
     * permission to invoke Cloud Run services, the permission is
     * `run.routes.invoke`.
     * If empty, defaults to the Compute Engine default service account:
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account_email = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_email = $var;

        return $this;
    }

    /**
     * Optional. If unset, then defaults to ignoring failures (i.e. not retrying them).
     *
     * Generated from protobuf field <code>.google.cloud.functions.v2.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getRetryPolicy()
    {
        return $this->retry_policy;
    }

    /**
     * Optional. If unset, then defaults to ignoring failures (i.e. not retrying them).
     *
     * Generated from protobuf field <code>.google.cloud.functions.v2.EventTrigger.RetryPolicy retry_policy = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setRetryPolicy($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Functions\V2\EventTrigger\RetryPolicy::class);
        $this->retry_policy = $var;

        return $this;
    }

    /**
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     *
     * Generated from protobuf field <code>string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * Optional. The name of the channel associated with the trigger in
     * `projects/{project}/locations/{location}/channels/{channel}` format.
     * You must provide a channel to receive events from Eventarc SaaS partners.
     *
     * Generated from protobuf field <code>string channel = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setChannel($var)
    {
        GPBUtil::checkString($var, True);
        $this->channel = $var;

        return $this;
    }

}

