<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/reservation/v1/reservation.proto

namespace Google\Cloud\BigQuery\Reservation\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A reservation is a mechanism used to guarantee slots to users.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.reservation.v1.Reservation</code>
 */
class Reservation extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     * The reservation_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end with a dash. Its
     * maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceeds the project's slot capacity
     * or if total slot capacity of the new reservation and its siblings exceeds
     * the project's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     * NOTE: for reservations in US or EU multi-regions, slot capacity constraints
     * are checked separately for default and auxiliary regions. See
     * multi_region_auxiliary flag for more details.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     */
    private $slot_capacity = 0;
    /**
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     */
    private $ignore_idle_slots = false;
    /**
     * Maximum number of queries that are allowed to run concurrently in this
     * reservation. This is a soft limit due to asynchronous nature of the system
     * and various optimizations for small queries.
     * Default value is 0 which means that concurrency will be automatically set
     * based on the reservation size.
     *
     * Generated from protobuf field <code>int64 concurrency = 16;</code>
     */
    private $concurrency = 0;
    /**
     * Output only. Creation time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $creation_time = null;
    /**
     * Output only. Last update time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Applicable only for reservations located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this reservation is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this reservation is placed in the organization's default region.
     *
     * Generated from protobuf field <code>bool multi_region_auxiliary = 14;</code>
     */
    private $multi_region_auxiliary = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the reservation, e.g.,
     *           `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *           The reservation_id must only contain lower case alphanumeric characters or
     *           dashes. It must start with a letter and must not end with a dash. Its
     *           maximum length is 64 characters.
     *     @type int|string $slot_capacity
     *           Minimum slots available to this reservation. A slot is a unit of
     *           computational power in BigQuery, and serves as the unit of parallelism.
     *           Queries using this reservation might use more slots during runtime if
     *           ignore_idle_slots is set to false.
     *           If the new reservation's slot capacity exceeds the project's slot capacity
     *           or if total slot capacity of the new reservation and its siblings exceeds
     *           the project's slot capacity, the request will fail with
     *           `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *           NOTE: for reservations in US or EU multi-regions, slot capacity constraints
     *           are checked separately for default and auxiliary regions. See
     *           multi_region_auxiliary flag for more details.
     *     @type bool $ignore_idle_slots
     *           If false, any query or pipeline job using this reservation will use idle
     *           slots from other reservations within the same admin project. If true, a
     *           query or pipeline job using this reservation will execute with the slot
     *           capacity specified in the slot_capacity field at most.
     *     @type int|string $concurrency
     *           Maximum number of queries that are allowed to run concurrently in this
     *           reservation. This is a soft limit due to asynchronous nature of the system
     *           and various optimizations for small queries.
     *           Default value is 0 which means that concurrency will be automatically set
     *           based on the reservation size.
     *     @type \Google\Protobuf\Timestamp $creation_time
     *           Output only. Creation time of the reservation.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Last update time of the reservation.
     *     @type bool $multi_region_auxiliary
     *           Applicable only for reservations located within one of the BigQuery
     *           multi-regions (US or EU).
     *           If set to true, this reservation is placed in the organization's
     *           secondary region which is designated for disaster recovery purposes.
     *           If false, this reservation is placed in the organization's default region.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Reservation\V1\Reservation::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     * The reservation_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end with a dash. Its
     * maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     * The reservation_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end with a dash. Its
     * maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceeds the project's slot capacity
     * or if total slot capacity of the new reservation and its siblings exceeds
     * the project's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     * NOTE: for reservations in US or EU multi-regions, slot capacity constraints
     * are checked separately for default and auxiliary regions. See
     * multi_region_auxiliary flag for more details.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     * @return int|string
     */
    public function getSlotCapacity()
    {
        return $this->slot_capacity;
    }

    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceeds the project's slot capacity
     * or if total slot capacity of the new reservation and its siblings exceeds
     * the project's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     * NOTE: for reservations in US or EU multi-regions, slot capacity constraints
     * are checked separately for default and auxiliary regions. See
     * multi_region_auxiliary flag for more details.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSlotCapacity($var)
    {
        GPBUtil::checkInt64($var);
        $this->slot_capacity = $var;

        return $this;
    }

    /**
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     * @return bool
     */
    public function getIgnoreIdleSlots()
    {
        return $this->ignore_idle_slots;
    }

    /**
     * If false, any query or pipeline job using this reservation will use idle
     * slots from other reservations within the same admin project. If true, a
     * query or pipeline job using this reservation will execute with the slot
     * capacity specified in the slot_capacity field at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreIdleSlots($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_idle_slots = $var;

        return $this;
    }

    /**
     * Maximum number of queries that are allowed to run concurrently in this
     * reservation. This is a soft limit due to asynchronous nature of the system
     * and various optimizations for small queries.
     * Default value is 0 which means that concurrency will be automatically set
     * based on the reservation size.
     *
     * Generated from protobuf field <code>int64 concurrency = 16;</code>
     * @return int|string
     */
    public function getConcurrency()
    {
        return $this->concurrency;
    }

    /**
     * Maximum number of queries that are allowed to run concurrently in this
     * reservation. This is a soft limit due to asynchronous nature of the system
     * and various optimizations for small queries.
     * Default value is 0 which means that concurrency will be automatically set
     * based on the reservation size.
     *
     * Generated from protobuf field <code>int64 concurrency = 16;</code>
     * @param int|string $var
     * @return $this
     */
    public function setConcurrency($var)
    {
        GPBUtil::checkInt64($var);
        $this->concurrency = $var;

        return $this;
    }

    /**
     * Output only. Creation time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreationTime()
    {
        return $this->creation_time;
    }

    public function hasCreationTime()
    {
        return isset($this->creation_time);
    }

    public function clearCreationTime()
    {
        unset($this->creation_time);
    }

    /**
     * Output only. Creation time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->creation_time = $var;

        return $this;
    }

    /**
     * Output only. Last update time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Last update time of the reservation.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Applicable only for reservations located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this reservation is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this reservation is placed in the organization's default region.
     *
     * Generated from protobuf field <code>bool multi_region_auxiliary = 14;</code>
     * @return bool
     */
    public function getMultiRegionAuxiliary()
    {
        return $this->multi_region_auxiliary;
    }

    /**
     * Applicable only for reservations located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this reservation is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this reservation is placed in the organization's default region.
     *
     * Generated from protobuf field <code>bool multi_region_auxiliary = 14;</code>
     * @param bool $var
     * @return $this
     */
    public function setMultiRegionAuxiliary($var)
    {
        GPBUtil::checkBool($var);
        $this->multi_region_auxiliary = $var;

        return $this;
    }

}

