<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/dataset.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes what part of the Dataset is to be exported, the destination of
 * the export and how to export.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.ExportDataConfig</code>
 */
class ExportDataConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * A filter on Annotations of the Dataset. Only Annotations on to-be-exported
     * DataItems(specified by [data_items_filter][]) that match this filter will
     * be exported. The filter syntax is the same as in
     * [ListAnnotations][google.cloud.aiplatform.v1.DatasetService.ListAnnotations].
     *
     * Generated from protobuf field <code>string annotations_filter = 2;</code>
     */
    private $annotations_filter = '';
    protected $destination;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AIPlatform\V1\GcsDestination $gcs_destination
     *           The Google Cloud Storage location where the output is to be written to.
     *           In the given directory a new directory will be created with name:
     *           `export-data-<dataset-display-name>-<timestamp-of-export-call>` where
     *           timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     *           output will be written into that directory. Inside that directory,
     *           annotations with the same schema will be grouped into sub directories
     *           which are named with the corresponding annotations' schema title. Inside
     *           these sub directories, a schema.yaml will be created to describe the
     *           output format.
     *     @type string $annotations_filter
     *           A filter on Annotations of the Dataset. Only Annotations on to-be-exported
     *           DataItems(specified by [data_items_filter][]) that match this filter will
     *           be exported. The filter syntax is the same as in
     *           [ListAnnotations][google.cloud.aiplatform.v1.DatasetService.ListAnnotations].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\Dataset::initOnce();
        parent::__construct($data);
    }

    /**
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-<dataset-display-name>-<timestamp-of-export-call>` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination gcs_destination = 1;</code>
     * @return \Google\Cloud\AIPlatform\V1\GcsDestination|null
     */
    public function getGcsDestination()
    {
        return $this->readOneof(1);
    }

    public function hasGcsDestination()
    {
        return $this->hasOneof(1);
    }

    /**
     * The Google Cloud Storage location where the output is to be written to.
     * In the given directory a new directory will be created with name:
     * `export-data-<dataset-display-name>-<timestamp-of-export-call>` where
     * timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format. All export
     * output will be written into that directory. Inside that directory,
     * annotations with the same schema will be grouped into sub directories
     * which are named with the corresponding annotations' schema title. Inside
     * these sub directories, a schema.yaml will be created to describe the
     * output format.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination gcs_destination = 1;</code>
     * @param \Google\Cloud\AIPlatform\V1\GcsDestination $var
     * @return $this
     */
    public function setGcsDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\GcsDestination::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * A filter on Annotations of the Dataset. Only Annotations on to-be-exported
     * DataItems(specified by [data_items_filter][]) that match this filter will
     * be exported. The filter syntax is the same as in
     * [ListAnnotations][google.cloud.aiplatform.v1.DatasetService.ListAnnotations].
     *
     * Generated from protobuf field <code>string annotations_filter = 2;</code>
     * @return string
     */
    public function getAnnotationsFilter()
    {
        return $this->annotations_filter;
    }

    /**
     * A filter on Annotations of the Dataset. Only Annotations on to-be-exported
     * DataItems(specified by [data_items_filter][]) that match this filter will
     * be exported. The filter syntax is the same as in
     * [ListAnnotations][google.cloud.aiplatform.v1.DatasetService.ListAnnotations].
     *
     * Generated from protobuf field <code>string annotations_filter = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAnnotationsFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->annotations_filter = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestination()
    {
        return $this->whichOneof("destination");
    }

}

