<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies the Event-driven transfer options. Event-driven transfers listen to
 * an event stream to transfer updated files.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.EventStream</code>
 */
class EventStream extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Specifies a unique name of the resource such as AWS SQS
     * ARN in the form 'arn:aws:sqs:region:account_id:queue_name',
     * or Pub/Sub subscription resource name in the form
     * 'projects/{project}/subscriptions/{sub}'.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $name = '';
    /**
     * Specifies the date and time that Storage Transfer Service starts
     * listening for events from this stream. If no start time is specified or
     * start time is in the past, Storage Transfer Service starts listening
     * immediately.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_stream_start_time = 2;</code>
     */
    private $event_stream_start_time = null;
    /**
     * Specifies the data and time at which Storage Transfer Service stops
     * listening for events from this stream. After this time, any transfers in
     * progress will complete, but no new transfers are initiated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_stream_expiration_time = 3;</code>
     */
    private $event_stream_expiration_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Specifies a unique name of the resource such as AWS SQS
     *           ARN in the form 'arn:aws:sqs:region:account_id:queue_name',
     *           or Pub/Sub subscription resource name in the form
     *           'projects/{project}/subscriptions/{sub}'.
     *     @type \Google\Protobuf\Timestamp $event_stream_start_time
     *           Specifies the date and time that Storage Transfer Service starts
     *           listening for events from this stream. If no start time is specified or
     *           start time is in the past, Storage Transfer Service starts listening
     *           immediately.
     *     @type \Google\Protobuf\Timestamp $event_stream_expiration_time
     *           Specifies the data and time at which Storage Transfer Service stops
     *           listening for events from this stream. After this time, any transfers in
     *           progress will complete, but no new transfers are initiated.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Specifies a unique name of the resource such as AWS SQS
     * ARN in the form 'arn:aws:sqs:region:account_id:queue_name',
     * or Pub/Sub subscription resource name in the form
     * 'projects/{project}/subscriptions/{sub}'.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Specifies a unique name of the resource such as AWS SQS
     * ARN in the form 'arn:aws:sqs:region:account_id:queue_name',
     * or Pub/Sub subscription resource name in the form
     * 'projects/{project}/subscriptions/{sub}'.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Specifies the date and time that Storage Transfer Service starts
     * listening for events from this stream. If no start time is specified or
     * start time is in the past, Storage Transfer Service starts listening
     * immediately.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_stream_start_time = 2;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventStreamStartTime()
    {
        return $this->event_stream_start_time;
    }

    public function hasEventStreamStartTime()
    {
        return isset($this->event_stream_start_time);
    }

    public function clearEventStreamStartTime()
    {
        unset($this->event_stream_start_time);
    }

    /**
     * Specifies the date and time that Storage Transfer Service starts
     * listening for events from this stream. If no start time is specified or
     * start time is in the past, Storage Transfer Service starts listening
     * immediately.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_stream_start_time = 2;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventStreamStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_stream_start_time = $var;

        return $this;
    }

    /**
     * Specifies the data and time at which Storage Transfer Service stops
     * listening for events from this stream. After this time, any transfers in
     * progress will complete, but no new transfers are initiated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_stream_expiration_time = 3;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventStreamExpirationTime()
    {
        return $this->event_stream_expiration_time;
    }

    public function hasEventStreamExpirationTime()
    {
        return isset($this->event_stream_expiration_time);
    }

    public function clearEventStreamExpirationTime()
    {
        unset($this->event_stream_expiration_time);
    }

    /**
     * Specifies the data and time at which Storage Transfer Service stops
     * listening for events from this stream. After this time, any transfers in
     * progress will complete, but no new transfers are initiated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_stream_expiration_time = 3;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventStreamExpirationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_stream_expiration_time = $var;

        return $this;
    }

}

