<?php

return [
    'interfaces' => [
        'google.firestore.admin.v1.FirestoreAdmin' => [
            'CreateBackupSchedule' => [
                'method' => 'post',
                'uriTemplate' => '/v1/{parent=projects/*/databases/*}/backupSchedules',
                'body' => 'backup_schedule',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'CreateDatabase' => [
                'method' => 'post',
                'uriTemplate' => '/v1/{parent=projects/*}/databases',
                'body' => 'database',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
                'queryParams' => [
                    'database_id',
                ],
            ],
            'CreateIndex' => [
                'method' => 'post',
                'uriTemplate' => '/v1/{parent=projects/*/databases/*/collectionGroups/*}/indexes',
                'body' => 'index',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'DeleteBackup' => [
                'method' => 'delete',
                'uriTemplate' => '/v1/{name=projects/*/locations/*/backups/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteBackupSchedule' => [
                'method' => 'delete',
                'uriTemplate' => '/v1/{name=projects/*/databases/*/backupSchedules/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteDatabase' => [
                'method' => 'delete',
                'uriTemplate' => '/v1/{name=projects/*/databases/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteIndex' => [
                'method' => 'delete',
                'uriTemplate' => '/v1/{name=projects/*/databases/*/collectionGroups/*/indexes/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'ExportDocuments' => [
                'method' => 'post',
                'uriTemplate' => '/v1/{name=projects/*/databases/*}:exportDocuments',
                'body' => '*',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetBackup' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{name=projects/*/locations/*/backups/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetBackupSchedule' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{name=projects/*/databases/*/backupSchedules/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetDatabase' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{name=projects/*/databases/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetField' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{name=projects/*/databases/*/collectionGroups/*/fields/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetIndex' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{name=projects/*/databases/*/collectionGroups/*/indexes/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'ImportDocuments' => [
                'method' => 'post',
                'uriTemplate' => '/v1/{name=projects/*/databases/*}:importDocuments',
                'body' => '*',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'ListBackupSchedules' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{parent=projects/*/databases/*}/backupSchedules',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListBackups' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{parent=projects/*/locations/*}/backups',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListDatabases' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{parent=projects/*}/databases',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListFields' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{parent=projects/*/databases/*/collectionGroups/*}/fields',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'ListIndexes' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{parent=projects/*/databases/*/collectionGroups/*}/indexes',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'RestoreDatabase' => [
                'method' => 'post',
                'uriTemplate' => '/v1/{parent=projects/*}/databases:restore',
                'body' => '*',
                'placeholders' => [
                    'parent' => [
                        'getters' => [
                            'getParent',
                        ],
                    ],
                ],
            ],
            'UpdateBackupSchedule' => [
                'method' => 'patch',
                'uriTemplate' => '/v1/{backup_schedule.name=projects/*/databases/*/backupSchedules/*}',
                'body' => 'backup_schedule',
                'placeholders' => [
                    'backup_schedule.name' => [
                        'getters' => [
                            'getBackupSchedule',
                            'getName',
                        ],
                    ],
                ],
            ],
            'UpdateDatabase' => [
                'method' => 'patch',
                'uriTemplate' => '/v1/{database.name=projects/*/databases/*}',
                'body' => 'database',
                'placeholders' => [
                    'database.name' => [
                        'getters' => [
                            'getDatabase',
                            'getName',
                        ],
                    ],
                ],
            ],
            'UpdateField' => [
                'method' => 'patch',
                'uriTemplate' => '/v1/{field.name=projects/*/databases/*/collectionGroups/*/fields/*}',
                'body' => 'field',
                'placeholders' => [
                    'field.name' => [
                        'getters' => [
                            'getField',
                            'getName',
                        ],
                    ],
                ],
            ],
        ],
        'google.longrunning.Operations' => [
            'CancelOperation' => [
                'method' => 'post',
                'uriTemplate' => '/v1/{name=projects/*/databases/*/operations/*}:cancel',
                'body' => '*',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'DeleteOperation' => [
                'method' => 'delete',
                'uriTemplate' => '/v1/{name=projects/*/databases/*/operations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'GetOperation' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{name=projects/*/databases/*/operations/*}',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
            'ListOperations' => [
                'method' => 'get',
                'uriTemplate' => '/v1/{name=projects/*/databases/*}/operations',
                'placeholders' => [
                    'name' => [
                        'getters' => [
                            'getName',
                        ],
                    ],
                ],
            ],
        ],
    ],
    'numericEnums' => true,
];
