<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Persistent Disk resource. Google Compute Engine has two Disk resources: * [Zonal](/compute/docs/reference/rest/v1/disks) * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/regionDisks) Persistent disks are required for running your VM instances. Create both boot and non-boot (data) persistent disks. For more information, read Persistent Disks. For more storage options, read Storage options. The disks resource represents a zonal persistent disk. For more information, read Zonal persistent disks. The regionDisks resource represents a regional persistent disk. For more information, read Regional resources.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Disk</code>
 */
class Disk extends \Google\Protobuf\Internal\Message
{
    /**
     * The architecture of the disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     */
    private $architecture = null;
    /**
     * Disk asynchronously replicated into this disk.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskAsyncReplication async_primary_disk = 180517533;</code>
     */
    private $async_primary_disk = null;
    /**
     * [Output Only] A list of disks this disk is asynchronously replicated to.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.compute.v1.DiskAsyncReplicationList> async_secondary_disks = 322925608;</code>
     */
    private $async_secondary_disks;
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = null;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    private $description = null;
    /**
     * Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;</code>
     */
    private $disk_encryption_key = null;
    /**
     * Whether this disk is using confidential compute mode.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     */
    private $enable_confidential_compute = null;
    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    private $guest_os_features;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    private $id = null;
    /**
     * [Output Only] Type of the resource. Always compute#disk for disks.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    private $kind = null;
    /**
     * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     */
    private $label_fingerprint = null;
    /**
     * Labels to apply to this disk. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     */
    private $labels;
    /**
     * [Output Only] Last attach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_attach_timestamp = 42159653;</code>
     */
    private $last_attach_timestamp = null;
    /**
     * [Output Only] Last detach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_detach_timestamp = 56471027;</code>
     */
    private $last_detach_timestamp = null;
    /**
     * Integer license codes indicating which licenses are attached to this disk.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     */
    private $license_codes;
    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     */
    private $licenses;
    /**
     * An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     */
    private $location_hint = null;
    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    private $name = null;
    /**
     * Internal use only.
     *
     * Generated from protobuf field <code>optional string options = 361137822;</code>
     */
    private $options = null;
    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskParams params = 78313862;</code>
     */
    private $params = null;
    /**
     * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
     *
     * Generated from protobuf field <code>optional int64 physical_block_size_bytes = 420007943;</code>
     */
    private $physical_block_size_bytes = null;
    /**
     * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
     *
     * Generated from protobuf field <code>optional int64 provisioned_iops = 186769108;</code>
     */
    private $provisioned_iops = null;
    /**
     * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be greater than or equal to 1.
     *
     * Generated from protobuf field <code>optional int64 provisioned_throughput = 526524181;</code>
     */
    private $provisioned_throughput = null;
    /**
     * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     */
    private $region = null;
    /**
     * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
     *
     * Generated from protobuf field <code>repeated string replica_zones = 48438272;</code>
     */
    private $replica_zones;
    /**
     * Resource policies applied to this disk for automatic snapshot creations.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     */
    private $resource_policies;
    /**
     * [Output Only] Status information for the disk resource.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskResourceStatus resource_status = 249429315;</code>
     */
    private $resource_status = null;
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     */
    private $satisfies_pzi = null;
    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     */
    private $satisfies_pzs = null;
    /**
     * [Output Only] Server-defined fully-qualified URL for this resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    private $self_link = null;
    /**
     * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are greater than 0.
     *
     * Generated from protobuf field <code>optional int64 size_gb = 494929369;</code>
     */
    private $size_gb = null;
    /**
     * [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
     *
     * Generated from protobuf field <code>optional string source_consistency_group_policy = 19616093;</code>
     */
    private $source_consistency_group_policy = null;
    /**
     * [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
     *
     * Generated from protobuf field <code>optional string source_consistency_group_policy_id = 267568957;</code>
     */
    private $source_consistency_group_policy_id = null;
    /**
     * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk 
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     */
    private $source_disk = null;
    /**
     * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     */
    private $source_disk_id = null;
    /**
     * The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family 
     *
     * Generated from protobuf field <code>optional string source_image = 50443319;</code>
     */
    private $source_image = null;
    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;</code>
     */
    private $source_image_encryption_key = null;
    /**
     * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
     *
     * Generated from protobuf field <code>optional string source_image_id = 55328291;</code>
     */
    private $source_image_id = null;
    /**
     * The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot 
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot = 219202054;</code>
     */
    private $source_instant_snapshot = null;
    /**
     * [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot_id = 287582708;</code>
     */
    private $source_instant_snapshot_id = null;
    /**
     * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot 
     *
     * Generated from protobuf field <code>optional string source_snapshot = 126061928;</code>
     */
    private $source_snapshot = null;
    /**
     * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;</code>
     */
    private $source_snapshot_encryption_key = null;
    /**
     * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_snapshot_id = 98962258;</code>
     */
    private $source_snapshot_id = null;
    /**
     * The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
     *
     * Generated from protobuf field <code>optional string source_storage_object = 233052711;</code>
     */
    private $source_storage_object = null;
    /**
     * [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     */
    private $status = null;
    /**
     * The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool 
     *
     * Generated from protobuf field <code>optional string storage_pool = 360473440;</code>
     */
    private $storage_pool = null;
    /**
     * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
     *
     * Generated from protobuf field <code>optional string type = 3575610;</code>
     */
    private $type = null;
    /**
     * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>repeated string users = 111578632;</code>
     */
    private $users;
    /**
     * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string zone = 3744684;</code>
     */
    private $zone = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $architecture
     *           The architecture of the disk. Valid values are ARM64 or X86_64.
     *           Check the Architecture enum for the list of possible values.
     *     @type \Google\Cloud\Compute\V1\DiskAsyncReplication $async_primary_disk
     *           Disk asynchronously replicated into this disk.
     *     @type array|\Google\Protobuf\Internal\MapField $async_secondary_disks
     *           [Output Only] A list of disks this disk is asynchronously replicated to.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $disk_encryption_key
     *           Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
     *     @type bool $enable_confidential_compute
     *           Whether this disk is using confidential compute mode.
     *     @type array<\Google\Cloud\Compute\V1\GuestOsFeature>|\Google\Protobuf\Internal\RepeatedField $guest_os_features
     *           A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     *     @type int|string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#disk for disks.
     *     @type string $label_fingerprint
     *           A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this disk. These can be later modified by the setLabels method.
     *     @type string $last_attach_timestamp
     *           [Output Only] Last attach timestamp in RFC3339 text format.
     *     @type string $last_detach_timestamp
     *           [Output Only] Last detach timestamp in RFC3339 text format.
     *     @type array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $license_codes
     *           Integer license codes indicating which licenses are attached to this disk.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $licenses
     *           A list of publicly visible licenses. Reserved for Google's use.
     *     @type string $location_hint
     *           An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $options
     *           Internal use only.
     *     @type \Google\Cloud\Compute\V1\DiskParams $params
     *           Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *     @type int|string $physical_block_size_bytes
     *           Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
     *     @type int|string $provisioned_iops
     *           Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
     *     @type int|string $provisioned_throughput
     *           Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be greater than or equal to 1.
     *     @type string $region
     *           [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $replica_zones
     *           URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $resource_policies
     *           Resource policies applied to this disk for automatic snapshot creations.
     *     @type \Google\Cloud\Compute\V1\DiskResourceStatus $resource_status
     *           [Output Only] Status information for the disk resource.
     *     @type bool $satisfies_pzi
     *           Output only. Reserved for future use.
     *     @type bool $satisfies_pzs
     *           [Output Only] Reserved for future use.
     *     @type string $self_link
     *           [Output Only] Server-defined fully-qualified URL for this resource.
     *     @type int|string $size_gb
     *           Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are greater than 0.
     *     @type string $source_consistency_group_policy
     *           [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
     *     @type string $source_consistency_group_policy_id
     *           [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
     *     @type string $source_disk
     *           The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk 
     *     @type string $source_disk_id
     *           [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
     *     @type string $source_image
     *           The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family 
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_image_encryption_key
     *           The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *     @type string $source_image_id
     *           [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
     *     @type string $source_instant_snapshot
     *           The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot 
     *     @type string $source_instant_snapshot_id
     *           [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
     *     @type string $source_snapshot
     *           The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot 
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_snapshot_encryption_key
     *           The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
     *     @type string $source_snapshot_id
     *           [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
     *     @type string $source_storage_object
     *           The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
     *     @type string $status
     *           [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
     *           Check the Status enum for the list of possible values.
     *     @type string $storage_pool
     *           The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool 
     *     @type string $type
     *           URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $users
     *           [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
     *     @type string $zone
     *           [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * The architecture of the disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     * @return string
     */
    public function getArchitecture()
    {
        return isset($this->architecture) ? $this->architecture : '';
    }

    public function hasArchitecture()
    {
        return isset($this->architecture);
    }

    public function clearArchitecture()
    {
        unset($this->architecture);
    }

    /**
     * The architecture of the disk. Valid values are ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     * @param string $var
     * @return $this
     */
    public function setArchitecture($var)
    {
        GPBUtil::checkString($var, True);
        $this->architecture = $var;

        return $this;
    }

    /**
     * Disk asynchronously replicated into this disk.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskAsyncReplication async_primary_disk = 180517533;</code>
     * @return \Google\Cloud\Compute\V1\DiskAsyncReplication|null
     */
    public function getAsyncPrimaryDisk()
    {
        return $this->async_primary_disk;
    }

    public function hasAsyncPrimaryDisk()
    {
        return isset($this->async_primary_disk);
    }

    public function clearAsyncPrimaryDisk()
    {
        unset($this->async_primary_disk);
    }

    /**
     * Disk asynchronously replicated into this disk.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskAsyncReplication async_primary_disk = 180517533;</code>
     * @param \Google\Cloud\Compute\V1\DiskAsyncReplication $var
     * @return $this
     */
    public function setAsyncPrimaryDisk($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\DiskAsyncReplication::class);
        $this->async_primary_disk = $var;

        return $this;
    }

    /**
     * [Output Only] A list of disks this disk is asynchronously replicated to.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.compute.v1.DiskAsyncReplicationList> async_secondary_disks = 322925608;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAsyncSecondaryDisks()
    {
        return $this->async_secondary_disks;
    }

    /**
     * [Output Only] A list of disks this disk is asynchronously replicated to.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.compute.v1.DiskAsyncReplicationList> async_secondary_disks = 322925608;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAsyncSecondaryDisks($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\DiskAsyncReplicationList::class);
        $this->async_secondary_disks = $arr;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getDiskEncryptionKey()
    {
        return $this->disk_encryption_key;
    }

    public function hasDiskEncryptionKey()
    {
        return isset($this->disk_encryption_key);
    }

    public function clearDiskEncryptionKey()
    {
        unset($this->disk_encryption_key);
    }

    /**
     * Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 271660677;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setDiskEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->disk_encryption_key = $var;

        return $this;
    }

    /**
     * Whether this disk is using confidential compute mode.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     * @return bool
     */
    public function getEnableConfidentialCompute()
    {
        return isset($this->enable_confidential_compute) ? $this->enable_confidential_compute : false;
    }

    public function hasEnableConfidentialCompute()
    {
        return isset($this->enable_confidential_compute);
    }

    public function clearEnableConfidentialCompute()
    {
        unset($this->enable_confidential_compute);
    }

    /**
     * Whether this disk is using confidential compute mode.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableConfidentialCompute($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_confidential_compute = $var;

        return $this;
    }

    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestOsFeatures()
    {
        return $this->guest_os_features;
    }

    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @param array<\Google\Cloud\Compute\V1\GuestOsFeature>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestOsFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\GuestOsFeature::class);
        $this->guest_os_features = $arr;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#disk for disks.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * [Output Only] Type of the resource. Always compute#disk for disks.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return isset($this->label_fingerprint) ? $this->label_fingerprint : '';
    }

    public function hasLabelFingerprint()
    {
        return isset($this->label_fingerprint);
    }

    public function clearLabelFingerprint()
    {
        unset($this->label_fingerprint);
    }

    /**
     * A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels to apply to this disk. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this disk. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * [Output Only] Last attach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_attach_timestamp = 42159653;</code>
     * @return string
     */
    public function getLastAttachTimestamp()
    {
        return isset($this->last_attach_timestamp) ? $this->last_attach_timestamp : '';
    }

    public function hasLastAttachTimestamp()
    {
        return isset($this->last_attach_timestamp);
    }

    public function clearLastAttachTimestamp()
    {
        unset($this->last_attach_timestamp);
    }

    /**
     * [Output Only] Last attach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_attach_timestamp = 42159653;</code>
     * @param string $var
     * @return $this
     */
    public function setLastAttachTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_attach_timestamp = $var;

        return $this;
    }

    /**
     * [Output Only] Last detach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_detach_timestamp = 56471027;</code>
     * @return string
     */
    public function getLastDetachTimestamp()
    {
        return isset($this->last_detach_timestamp) ? $this->last_detach_timestamp : '';
    }

    public function hasLastDetachTimestamp()
    {
        return isset($this->last_detach_timestamp);
    }

    public function clearLastDetachTimestamp()
    {
        unset($this->last_detach_timestamp);
    }

    /**
     * [Output Only] Last detach timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string last_detach_timestamp = 56471027;</code>
     * @param string $var
     * @return $this
     */
    public function setLastDetachTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_detach_timestamp = $var;

        return $this;
    }

    /**
     * Integer license codes indicating which licenses are attached to this disk.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenseCodes()
    {
        return $this->license_codes;
    }

    /**
     * Integer license codes indicating which licenses are attached to this disk.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     * @param array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenseCodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT64);
        $this->license_codes = $arr;

        return $this;
    }

    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenses()
    {
        return $this->licenses;
    }

    /**
     * A list of publicly visible licenses. Reserved for Google's use.
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->licenses = $arr;

        return $this;
    }

    /**
     * An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     * @return string
     */
    public function getLocationHint()
    {
        return isset($this->location_hint) ? $this->location_hint : '';
    }

    public function hasLocationHint()
    {
        return isset($this->location_hint);
    }

    public function clearLocationHint()
    {
        unset($this->location_hint);
    }

    /**
     * An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
     *
     * Generated from protobuf field <code>optional string location_hint = 350519505;</code>
     * @param string $var
     * @return $this
     */
    public function setLocationHint($var)
    {
        GPBUtil::checkString($var, True);
        $this->location_hint = $var;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Internal use only.
     *
     * Generated from protobuf field <code>optional string options = 361137822;</code>
     * @return string
     */
    public function getOptions()
    {
        return isset($this->options) ? $this->options : '';
    }

    public function hasOptions()
    {
        return isset($this->options);
    }

    public function clearOptions()
    {
        unset($this->options);
    }

    /**
     * Internal use only.
     *
     * Generated from protobuf field <code>optional string options = 361137822;</code>
     * @param string $var
     * @return $this
     */
    public function setOptions($var)
    {
        GPBUtil::checkString($var, True);
        $this->options = $var;

        return $this;
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskParams params = 78313862;</code>
     * @return \Google\Cloud\Compute\V1\DiskParams|null
     */
    public function getParams()
    {
        return $this->params;
    }

    public function hasParams()
    {
        return isset($this->params);
    }

    public function clearParams()
    {
        unset($this->params);
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskParams params = 78313862;</code>
     * @param \Google\Cloud\Compute\V1\DiskParams $var
     * @return $this
     */
    public function setParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\DiskParams::class);
        $this->params = $var;

        return $this;
    }

    /**
     * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
     *
     * Generated from protobuf field <code>optional int64 physical_block_size_bytes = 420007943;</code>
     * @return int|string
     */
    public function getPhysicalBlockSizeBytes()
    {
        return isset($this->physical_block_size_bytes) ? $this->physical_block_size_bytes : 0;
    }

    public function hasPhysicalBlockSizeBytes()
    {
        return isset($this->physical_block_size_bytes);
    }

    public function clearPhysicalBlockSizeBytes()
    {
        unset($this->physical_block_size_bytes);
    }

    /**
     * Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
     *
     * Generated from protobuf field <code>optional int64 physical_block_size_bytes = 420007943;</code>
     * @param int|string $var
     * @return $this
     */
    public function setPhysicalBlockSizeBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->physical_block_size_bytes = $var;

        return $this;
    }

    /**
     * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
     *
     * Generated from protobuf field <code>optional int64 provisioned_iops = 186769108;</code>
     * @return int|string
     */
    public function getProvisionedIops()
    {
        return isset($this->provisioned_iops) ? $this->provisioned_iops : 0;
    }

    public function hasProvisionedIops()
    {
        return isset($this->provisioned_iops);
    }

    public function clearProvisionedIops()
    {
        unset($this->provisioned_iops);
    }

    /**
     * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
     *
     * Generated from protobuf field <code>optional int64 provisioned_iops = 186769108;</code>
     * @param int|string $var
     * @return $this
     */
    public function setProvisionedIops($var)
    {
        GPBUtil::checkInt64($var);
        $this->provisioned_iops = $var;

        return $this;
    }

    /**
     * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be greater than or equal to 1.
     *
     * Generated from protobuf field <code>optional int64 provisioned_throughput = 526524181;</code>
     * @return int|string
     */
    public function getProvisionedThroughput()
    {
        return isset($this->provisioned_throughput) ? $this->provisioned_throughput : 0;
    }

    public function hasProvisionedThroughput()
    {
        return isset($this->provisioned_throughput);
    }

    public function clearProvisionedThroughput()
    {
        unset($this->provisioned_throughput);
    }

    /**
     * Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be greater than or equal to 1.
     *
     * Generated from protobuf field <code>optional int64 provisioned_throughput = 526524181;</code>
     * @param int|string $var
     * @return $this
     */
    public function setProvisionedThroughput($var)
    {
        GPBUtil::checkInt64($var);
        $this->provisioned_throughput = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : '';
    }

    public function hasRegion()
    {
        return isset($this->region);
    }

    public function clearRegion()
    {
        unset($this->region);
    }

    /**
     * [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
     *
     * Generated from protobuf field <code>repeated string replica_zones = 48438272;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReplicaZones()
    {
        return $this->replica_zones;
    }

    /**
     * URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
     *
     * Generated from protobuf field <code>repeated string replica_zones = 48438272;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReplicaZones($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->replica_zones = $arr;

        return $this;
    }

    /**
     * Resource policies applied to this disk for automatic snapshot creations.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourcePolicies()
    {
        return $this->resource_policies;
    }

    /**
     * Resource policies applied to this disk for automatic snapshot creations.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourcePolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_policies = $arr;

        return $this;
    }

    /**
     * [Output Only] Status information for the disk resource.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskResourceStatus resource_status = 249429315;</code>
     * @return \Google\Cloud\Compute\V1\DiskResourceStatus|null
     */
    public function getResourceStatus()
    {
        return $this->resource_status;
    }

    public function hasResourceStatus()
    {
        return isset($this->resource_status);
    }

    public function clearResourceStatus()
    {
        unset($this->resource_status);
    }

    /**
     * [Output Only] Status information for the disk resource.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DiskResourceStatus resource_status = 249429315;</code>
     * @param \Google\Cloud\Compute\V1\DiskResourceStatus $var
     * @return $this
     */
    public function setResourceStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\DiskResourceStatus::class);
        $this->resource_status = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return isset($this->satisfies_pzi) ? $this->satisfies_pzi : false;
    }

    public function hasSatisfiesPzi()
    {
        return isset($this->satisfies_pzi);
    }

    public function clearSatisfiesPzi()
    {
        unset($this->satisfies_pzi);
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : false;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined fully-qualified URL for this resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * [Output Only] Server-defined fully-qualified URL for this resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are greater than 0.
     *
     * Generated from protobuf field <code>optional int64 size_gb = 494929369;</code>
     * @return int|string
     */
    public function getSizeGb()
    {
        return isset($this->size_gb) ? $this->size_gb : 0;
    }

    public function hasSizeGb()
    {
        return isset($this->size_gb);
    }

    public function clearSizeGb()
    {
        unset($this->size_gb);
    }

    /**
     * Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are greater than 0.
     *
     * Generated from protobuf field <code>optional int64 size_gb = 494929369;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSizeGb($var)
    {
        GPBUtil::checkInt64($var);
        $this->size_gb = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
     *
     * Generated from protobuf field <code>optional string source_consistency_group_policy = 19616093;</code>
     * @return string
     */
    public function getSourceConsistencyGroupPolicy()
    {
        return isset($this->source_consistency_group_policy) ? $this->source_consistency_group_policy : '';
    }

    public function hasSourceConsistencyGroupPolicy()
    {
        return isset($this->source_consistency_group_policy);
    }

    public function clearSourceConsistencyGroupPolicy()
    {
        unset($this->source_consistency_group_policy);
    }

    /**
     * [Output Only] URL of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
     *
     * Generated from protobuf field <code>optional string source_consistency_group_policy = 19616093;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceConsistencyGroupPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_consistency_group_policy = $var;

        return $this;
    }

    /**
     * [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
     *
     * Generated from protobuf field <code>optional string source_consistency_group_policy_id = 267568957;</code>
     * @return string
     */
    public function getSourceConsistencyGroupPolicyId()
    {
        return isset($this->source_consistency_group_policy_id) ? $this->source_consistency_group_policy_id : '';
    }

    public function hasSourceConsistencyGroupPolicyId()
    {
        return isset($this->source_consistency_group_policy_id);
    }

    public function clearSourceConsistencyGroupPolicyId()
    {
        unset($this->source_consistency_group_policy_id);
    }

    /**
     * [Output Only] ID of the DiskConsistencyGroupPolicy for a secondary disk that was created using a consistency group.
     *
     * Generated from protobuf field <code>optional string source_consistency_group_policy_id = 267568957;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceConsistencyGroupPolicyId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_consistency_group_policy_id = $var;

        return $this;
    }

    /**
     * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk 
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     * @return string
     */
    public function getSourceDisk()
    {
        return isset($this->source_disk) ? $this->source_disk : '';
    }

    public function hasSourceDisk()
    {
        return isset($this->source_disk);
    }

    public function clearSourceDisk()
    {
        unset($this->source_disk);
    }

    /**
     * The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk 
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDisk($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk = $var;

        return $this;
    }

    /**
     * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     * @return string
     */
    public function getSourceDiskId()
    {
        return isset($this->source_disk_id) ? $this->source_disk_id : '';
    }

    public function hasSourceDiskId()
    {
        return isset($this->source_disk_id);
    }

    public function clearSourceDiskId()
    {
        unset($this->source_disk_id);
    }

    /**
     * [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDiskId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk_id = $var;

        return $this;
    }

    /**
     * The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family 
     *
     * Generated from protobuf field <code>optional string source_image = 50443319;</code>
     * @return string
     */
    public function getSourceImage()
    {
        return isset($this->source_image) ? $this->source_image : '';
    }

    public function hasSourceImage()
    {
        return isset($this->source_image);
    }

    public function clearSourceImage()
    {
        unset($this->source_image);
    }

    /**
     * The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family 
     *
     * Generated from protobuf field <code>optional string source_image = 50443319;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_image = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSourceImageEncryptionKey()
    {
        return $this->source_image_encryption_key;
    }

    public function hasSourceImageEncryptionKey()
    {
        return isset($this->source_image_encryption_key);
    }

    public function clearSourceImageEncryptionKey()
    {
        unset($this->source_image_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceImageEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_image_encryption_key = $var;

        return $this;
    }

    /**
     * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
     *
     * Generated from protobuf field <code>optional string source_image_id = 55328291;</code>
     * @return string
     */
    public function getSourceImageId()
    {
        return isset($this->source_image_id) ? $this->source_image_id : '';
    }

    public function hasSourceImageId()
    {
        return isset($this->source_image_id);
    }

    public function clearSourceImageId()
    {
        unset($this->source_image_id);
    }

    /**
     * [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
     *
     * Generated from protobuf field <code>optional string source_image_id = 55328291;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceImageId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_image_id = $var;

        return $this;
    }

    /**
     * The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot 
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot = 219202054;</code>
     * @return string
     */
    public function getSourceInstantSnapshot()
    {
        return isset($this->source_instant_snapshot) ? $this->source_instant_snapshot : '';
    }

    public function hasSourceInstantSnapshot()
    {
        return isset($this->source_instant_snapshot);
    }

    public function clearSourceInstantSnapshot()
    {
        unset($this->source_instant_snapshot);
    }

    /**
     * The source instant snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /instantSnapshots/instantSnapshot - projects/project/zones/zone/instantSnapshots/instantSnapshot - zones/zone/instantSnapshots/instantSnapshot 
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot = 219202054;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceInstantSnapshot($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_instant_snapshot = $var;

        return $this;
    }

    /**
     * [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot_id = 287582708;</code>
     * @return string
     */
    public function getSourceInstantSnapshotId()
    {
        return isset($this->source_instant_snapshot_id) ? $this->source_instant_snapshot_id : '';
    }

    public function hasSourceInstantSnapshotId()
    {
        return isset($this->source_instant_snapshot_id);
    }

    public function clearSourceInstantSnapshotId()
    {
        unset($this->source_instant_snapshot_id);
    }

    /**
     * [Output Only] The unique ID of the instant snapshot used to create this disk. This value identifies the exact instant snapshot that was used to create this persistent disk. For example, if you created the persistent disk from an instant snapshot that was later deleted and recreated under the same name, the source instant snapshot ID would identify the exact version of the instant snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_instant_snapshot_id = 287582708;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceInstantSnapshotId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_instant_snapshot_id = $var;

        return $this;
    }

    /**
     * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot 
     *
     * Generated from protobuf field <code>optional string source_snapshot = 126061928;</code>
     * @return string
     */
    public function getSourceSnapshot()
    {
        return isset($this->source_snapshot) ? $this->source_snapshot : '';
    }

    public function hasSourceSnapshot()
    {
        return isset($this->source_snapshot);
    }

    public function clearSourceSnapshot()
    {
        unset($this->source_snapshot);
    }

    /**
     * The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot 
     *
     * Generated from protobuf field <code>optional string source_snapshot = 126061928;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshot($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSourceSnapshotEncryptionKey()
    {
        return $this->source_snapshot_encryption_key;
    }

    public function hasSourceSnapshotEncryptionKey()
    {
        return isset($this->source_snapshot_encryption_key);
    }

    public function clearSourceSnapshotEncryptionKey()
    {
        unset($this->source_snapshot_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceSnapshotEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_snapshot_encryption_key = $var;

        return $this;
    }

    /**
     * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_snapshot_id = 98962258;</code>
     * @return string
     */
    public function getSourceSnapshotId()
    {
        return isset($this->source_snapshot_id) ? $this->source_snapshot_id : '';
    }

    public function hasSourceSnapshotId()
    {
        return isset($this->source_snapshot_id);
    }

    public function clearSourceSnapshotId()
    {
        unset($this->source_snapshot_id);
    }

    /**
     * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
     *
     * Generated from protobuf field <code>optional string source_snapshot_id = 98962258;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshotId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot_id = $var;

        return $this;
    }

    /**
     * The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
     *
     * Generated from protobuf field <code>optional string source_storage_object = 233052711;</code>
     * @return string
     */
    public function getSourceStorageObject()
    {
        return isset($this->source_storage_object) ? $this->source_storage_object : '';
    }

    public function hasSourceStorageObject()
    {
        return isset($this->source_storage_object);
    }

    public function clearSourceStorageObject()
    {
        unset($this->source_storage_object);
    }

    /**
     * The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
     *
     * Generated from protobuf field <code>optional string source_storage_object = 233052711;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceStorageObject($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_storage_object = $var;

        return $this;
    }

    /**
     * [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     * @return string
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : '';
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * [Output Only] The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     * @param string $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->status = $var;

        return $this;
    }

    /**
     * The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool 
     *
     * Generated from protobuf field <code>optional string storage_pool = 360473440;</code>
     * @return string
     */
    public function getStoragePool()
    {
        return isset($this->storage_pool) ? $this->storage_pool : '';
    }

    public function hasStoragePool()
    {
        return isset($this->storage_pool);
    }

    public function clearStoragePool()
    {
        unset($this->storage_pool);
    }

    /**
     * The storage pool in which the new disk is created. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /storagePools/storagePool - projects/project/zones/zone/storagePools/storagePool - zones/zone/storagePools/storagePool 
     *
     * Generated from protobuf field <code>optional string storage_pool = 360473440;</code>
     * @param string $var
     * @return $this
     */
    public function setStoragePool($var)
    {
        GPBUtil::checkString($var, True);
        $this->storage_pool = $var;

        return $this;
    }

    /**
     * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
     *
     * Generated from protobuf field <code>optional string type = 3575610;</code>
     * @return string
     */
    public function getType()
    {
        return isset($this->type) ? $this->type : '';
    }

    public function hasType()
    {
        return isset($this->type);
    }

    public function clearType()
    {
        unset($this->type);
    }

    /**
     * URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
     *
     * Generated from protobuf field <code>optional string type = 3575610;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>repeated string users = 111578632;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getUsers()
    {
        return $this->users;
    }

    /**
     * [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
     *
     * Generated from protobuf field <code>repeated string users = 111578632;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setUsers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->users = $arr;

        return $this;
    }

    /**
     * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string zone = 3744684;</code>
     * @return string
     */
    public function getZone()
    {
        return isset($this->zone) ? $this->zone : '';
    }

    public function hasZone()
    {
        return isset($this->zone);
    }

    public function clearZone()
    {
        unset($this->zone);
    }

    /**
     * [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string zone = 3744684;</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

}

