<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

namespace Google\Cloud\BigQuery\DataTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to update a transfer configuration. To update the user id of the
 * transfer configuration, authorization info needs to be provided.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest</code>
 */
class UpdateTransferConfigRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Data transfer configuration to create.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $transfer_config = null;
    /**
     * Deprecated: Authorization code was required when
     * `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
     * in any data sources. Use `version_info` instead.
     * Optional OAuth2 authorization code to use with this transfer configuration.
     * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     * and new credentials are needed, as indicated by `CheckValidCreds`. In order
     * to obtain authorization_code, make a request to the following URL:
     * <pre class="prettyprint" suppresswarning="true">
     * https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     * </pre>
     * * The <var>client_id</var> is the OAuth client_id of the data source as
     * returned by ListDataSources method.
     * * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     * method.
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     *
     * Generated from protobuf field <code>string authorization_code = 3 [deprecated = true];</code>
     * @deprecated
     */
    protected $authorization_code = '';
    /**
     * Required. Required list of fields to be updated in this request.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $update_mask = null;
    /**
     * Optional version info. This parameter replaces `authorization_code` which
     * is no longer used in any data sources. This is required only if
     * `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
     * are needed, as indicated by `CheckValidCreds`. In order to obtain version
     * info, make a request to the following URL:
     * <pre class="prettyprint" suppresswarning="true">
     * https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     * </pre>
     * * The <var>client_id</var> is the OAuth client_id of the data source as
     * returned by ListDataSources method.
     * * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     * method.
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     *
     * Generated from protobuf field <code>string version_info = 5;</code>
     */
    private $version_info = '';
    /**
     * Optional service account email. If this field is set, the transfer config
     * will be created with this service account's credentials. It requires that
     * the requesting user calling this API has permissions to act as this service
     * account.
     * Note that not all data sources support service account credentials when
     * creating a transfer config. For the latest list of data sources, read about
     * [using service
     * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     *
     * Generated from protobuf field <code>string service_account_name = 6;</code>
     */
    private $service_account_name = '';

    /**
     * @param \Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig $transferConfig Required. Data transfer configuration to create.
     * @param \Google\Protobuf\FieldMask                            $updateMask     Required. Required list of fields to be updated in this request.
     *
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\UpdateTransferConfigRequest
     *
     * @experimental
     */
    public static function build(\Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig $transferConfig, \Google\Protobuf\FieldMask $updateMask): self
    {
        return (new self())
            ->setTransferConfig($transferConfig)
            ->setUpdateMask($updateMask);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig $transfer_config
     *           Required. Data transfer configuration to create.
     *     @type string $authorization_code
     *           Deprecated: Authorization code was required when
     *           `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
     *           in any data sources. Use `version_info` instead.
     *           Optional OAuth2 authorization code to use with this transfer configuration.
     *           This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     *           and new credentials are needed, as indicated by `CheckValidCreds`. In order
     *           to obtain authorization_code, make a request to the following URL:
     *           <pre class="prettyprint" suppresswarning="true">
     *           https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     *           </pre>
     *           * The <var>client_id</var> is the OAuth client_id of the data source as
     *           returned by ListDataSources method.
     *           * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     *           method.
     *           Note that this should not be set when `service_account_name` is used to
     *           update the transfer config.
     *     @type \Google\Protobuf\FieldMask $update_mask
     *           Required. Required list of fields to be updated in this request.
     *     @type string $version_info
     *           Optional version info. This parameter replaces `authorization_code` which
     *           is no longer used in any data sources. This is required only if
     *           `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
     *           are needed, as indicated by `CheckValidCreds`. In order to obtain version
     *           info, make a request to the following URL:
     *           <pre class="prettyprint" suppresswarning="true">
     *           https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     *           </pre>
     *           * The <var>client_id</var> is the OAuth client_id of the data source as
     *           returned by ListDataSources method.
     *           * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     *           method.
     *           Note that this should not be set when `service_account_name` is used to
     *           update the transfer config.
     *     @type string $service_account_name
     *           Optional service account email. If this field is set, the transfer config
     *           will be created with this service account's credentials. It requires that
     *           the requesting user calling this API has permissions to act as this service
     *           account.
     *           Note that not all data sources support service account credentials when
     *           creating a transfer config. For the latest list of data sources, read about
     *           [using service
     *           accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Datatransfer\V1\Datatransfer::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Data transfer configuration to create.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig|null
     */
    public function getTransferConfig()
    {
        return $this->transfer_config;
    }

    public function hasTransferConfig()
    {
        return isset($this->transfer_config);
    }

    public function clearTransferConfig()
    {
        unset($this->transfer_config);
    }

    /**
     * Required. Data transfer configuration to create.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferConfig transfer_config = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig $var
     * @return $this
     */
    public function setTransferConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\DataTransfer\V1\TransferConfig::class);
        $this->transfer_config = $var;

        return $this;
    }

    /**
     * Deprecated: Authorization code was required when
     * `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
     * in any data sources. Use `version_info` instead.
     * Optional OAuth2 authorization code to use with this transfer configuration.
     * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     * and new credentials are needed, as indicated by `CheckValidCreds`. In order
     * to obtain authorization_code, make a request to the following URL:
     * <pre class="prettyprint" suppresswarning="true">
     * https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     * </pre>
     * * The <var>client_id</var> is the OAuth client_id of the data source as
     * returned by ListDataSources method.
     * * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     * method.
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     *
     * Generated from protobuf field <code>string authorization_code = 3 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getAuthorizationCode()
    {
        @trigger_error('authorization_code is deprecated.', E_USER_DEPRECATED);
        return $this->authorization_code;
    }

    /**
     * Deprecated: Authorization code was required when
     * `transferConfig.dataSourceId` is 'youtube_channel' but it is no longer used
     * in any data sources. Use `version_info` instead.
     * Optional OAuth2 authorization code to use with this transfer configuration.
     * This is required only if `transferConfig.dataSourceId` is 'youtube_channel'
     * and new credentials are needed, as indicated by `CheckValidCreds`. In order
     * to obtain authorization_code, make a request to the following URL:
     * <pre class="prettyprint" suppresswarning="true">
     * https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=authorization_code&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     * </pre>
     * * The <var>client_id</var> is the OAuth client_id of the data source as
     * returned by ListDataSources method.
     * * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     * method.
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     *
     * Generated from protobuf field <code>string authorization_code = 3 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setAuthorizationCode($var)
    {
        @trigger_error('authorization_code is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->authorization_code = $var;

        return $this;
    }

    /**
     * Required. Required list of fields to be updated in this request.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\FieldMask|null
     */
    public function getUpdateMask()
    {
        return $this->update_mask;
    }

    public function hasUpdateMask()
    {
        return isset($this->update_mask);
    }

    public function clearUpdateMask()
    {
        unset($this->update_mask);
    }

    /**
     * Required. Required list of fields to be updated in this request.
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\FieldMask $var
     * @return $this
     */
    public function setUpdateMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\FieldMask::class);
        $this->update_mask = $var;

        return $this;
    }

    /**
     * Optional version info. This parameter replaces `authorization_code` which
     * is no longer used in any data sources. This is required only if
     * `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
     * are needed, as indicated by `CheckValidCreds`. In order to obtain version
     * info, make a request to the following URL:
     * <pre class="prettyprint" suppresswarning="true">
     * https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     * </pre>
     * * The <var>client_id</var> is the OAuth client_id of the data source as
     * returned by ListDataSources method.
     * * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     * method.
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     *
     * Generated from protobuf field <code>string version_info = 5;</code>
     * @return string
     */
    public function getVersionInfo()
    {
        return $this->version_info;
    }

    /**
     * Optional version info. This parameter replaces `authorization_code` which
     * is no longer used in any data sources. This is required only if
     * `transferConfig.dataSourceId` is 'youtube_channel' *or* new credentials
     * are needed, as indicated by `CheckValidCreds`. In order to obtain version
     * info, make a request to the following URL:
     * <pre class="prettyprint" suppresswarning="true">
     * https://bigquery.cloud.google.com/datatransfer/oauthz/auth?redirect_uri=urn:ietf:wg:oauth:2.0:oob&response_type=version_info&client_id=<var>client_id</var>&scope=<var>data_source_scopes</var>
     * </pre>
     * * The <var>client_id</var> is the OAuth client_id of the data source as
     * returned by ListDataSources method.
     * * <var>data_source_scopes</var> are the scopes returned by ListDataSources
     * method.
     * Note that this should not be set when `service_account_name` is used to
     * update the transfer config.
     *
     * Generated from protobuf field <code>string version_info = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setVersionInfo($var)
    {
        GPBUtil::checkString($var, True);
        $this->version_info = $var;

        return $this;
    }

    /**
     * Optional service account email. If this field is set, the transfer config
     * will be created with this service account's credentials. It requires that
     * the requesting user calling this API has permissions to act as this service
     * account.
     * Note that not all data sources support service account credentials when
     * creating a transfer config. For the latest list of data sources, read about
     * [using service
     * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     *
     * Generated from protobuf field <code>string service_account_name = 6;</code>
     * @return string
     */
    public function getServiceAccountName()
    {
        return $this->service_account_name;
    }

    /**
     * Optional service account email. If this field is set, the transfer config
     * will be created with this service account's credentials. It requires that
     * the requesting user calling this API has permissions to act as this service
     * account.
     * Note that not all data sources support service account credentials when
     * creating a transfer config. For the latest list of data sources, read about
     * [using service
     * accounts](https://cloud.google.com/bigquery-transfer/docs/use-service-accounts).
     *
     * Generated from protobuf field <code>string service_account_name = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountName($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_name = $var;

        return $this;
    }

}

