<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/annotation.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Output only. Annotations associated with the plain-text body of the message.
 * To add basic formatting to a text message, see
 * [Format text
 * messages](https://developers.google.com/workspace/chat/format-messages).
 * Example plain-text message body:
 * ```
 * Hello &#64;FooBot how are you!"
 * ```
 * The corresponding annotations metadata:
 * ```
 * "annotations":[{
 *   "type":"USER_MENTION",
 *   "startIndex":6,
 *   "length":7,
 *   "userMention": {
 *     "user": {
 *       "name":"users/{user}",
 *       "displayName":"FooBot",
 *       "avatarUrl":"https://goo.gl/aeDtrS",
 *       "type":"BOT"
 *     },
 *     "type":"MENTION"
 *    }
 * }]
 * ```
 *
 * Generated from protobuf message <code>google.chat.v1.Annotation</code>
 */
class Annotation extends \Google\Protobuf\Internal\Message
{
    /**
     * The type of this annotation.
     *
     * Generated from protobuf field <code>.google.chat.v1.AnnotationType type = 1;</code>
     */
    protected $type = 0;
    /**
     * Start index (0-based, inclusive) in the plain-text message body this
     * annotation corresponds to.
     *
     * Generated from protobuf field <code>optional int32 start_index = 2;</code>
     */
    protected $start_index = null;
    /**
     * Length of the substring in the plain-text message body this annotation
     * corresponds to.
     *
     * Generated from protobuf field <code>int32 length = 3;</code>
     */
    protected $length = 0;
    protected $metadata;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $type
     *           The type of this annotation.
     *     @type int $start_index
     *           Start index (0-based, inclusive) in the plain-text message body this
     *           annotation corresponds to.
     *     @type int $length
     *           Length of the substring in the plain-text message body this annotation
     *           corresponds to.
     *     @type \Google\Apps\Chat\V1\UserMentionMetadata $user_mention
     *           The metadata of user mention.
     *     @type \Google\Apps\Chat\V1\SlashCommandMetadata $slash_command
     *           The metadata for a slash command.
     *     @type \Google\Apps\Chat\V1\RichLinkMetadata $rich_link_metadata
     *           The metadata for a rich link.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Annotation::initOnce();
        parent::__construct($data);
    }

    /**
     * The type of this annotation.
     *
     * Generated from protobuf field <code>.google.chat.v1.AnnotationType type = 1;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The type of this annotation.
     *
     * Generated from protobuf field <code>.google.chat.v1.AnnotationType type = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Chat\V1\AnnotationType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Start index (0-based, inclusive) in the plain-text message body this
     * annotation corresponds to.
     *
     * Generated from protobuf field <code>optional int32 start_index = 2;</code>
     * @return int
     */
    public function getStartIndex()
    {
        return isset($this->start_index) ? $this->start_index : 0;
    }

    public function hasStartIndex()
    {
        return isset($this->start_index);
    }

    public function clearStartIndex()
    {
        unset($this->start_index);
    }

    /**
     * Start index (0-based, inclusive) in the plain-text message body this
     * annotation corresponds to.
     *
     * Generated from protobuf field <code>optional int32 start_index = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setStartIndex($var)
    {
        GPBUtil::checkInt32($var);
        $this->start_index = $var;

        return $this;
    }

    /**
     * Length of the substring in the plain-text message body this annotation
     * corresponds to.
     *
     * Generated from protobuf field <code>int32 length = 3;</code>
     * @return int
     */
    public function getLength()
    {
        return $this->length;
    }

    /**
     * Length of the substring in the plain-text message body this annotation
     * corresponds to.
     *
     * Generated from protobuf field <code>int32 length = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setLength($var)
    {
        GPBUtil::checkInt32($var);
        $this->length = $var;

        return $this;
    }

    /**
     * The metadata of user mention.
     *
     * Generated from protobuf field <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     * @return \Google\Apps\Chat\V1\UserMentionMetadata|null
     */
    public function getUserMention()
    {
        return $this->readOneof(4);
    }

    public function hasUserMention()
    {
        return $this->hasOneof(4);
    }

    /**
     * The metadata of user mention.
     *
     * Generated from protobuf field <code>.google.chat.v1.UserMentionMetadata user_mention = 4;</code>
     * @param \Google\Apps\Chat\V1\UserMentionMetadata $var
     * @return $this
     */
    public function setUserMention($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\UserMentionMetadata::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * The metadata for a slash command.
     *
     * Generated from protobuf field <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     * @return \Google\Apps\Chat\V1\SlashCommandMetadata|null
     */
    public function getSlashCommand()
    {
        return $this->readOneof(5);
    }

    public function hasSlashCommand()
    {
        return $this->hasOneof(5);
    }

    /**
     * The metadata for a slash command.
     *
     * Generated from protobuf field <code>.google.chat.v1.SlashCommandMetadata slash_command = 5;</code>
     * @param \Google\Apps\Chat\V1\SlashCommandMetadata $var
     * @return $this
     */
    public function setSlashCommand($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\SlashCommandMetadata::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * The metadata for a rich link.
     *
     * Generated from protobuf field <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     * @return \Google\Apps\Chat\V1\RichLinkMetadata|null
     */
    public function getRichLinkMetadata()
    {
        return $this->readOneof(6);
    }

    public function hasRichLinkMetadata()
    {
        return $this->hasOneof(6);
    }

    /**
     * The metadata for a rich link.
     *
     * Generated from protobuf field <code>.google.chat.v1.RichLinkMetadata rich_link_metadata = 6;</code>
     * @param \Google\Apps\Chat\V1\RichLinkMetadata $var
     * @return $this
     */
    public function setRichLinkMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\RichLinkMetadata::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getMetadata()
    {
        return $this->whichOneof("metadata");
    }

}

