<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/model_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\BatchImportEvaluatedAnnotationsRequest;
use Google\Cloud\AIPlatform\V1\BatchImportEvaluatedAnnotationsResponse;
use Google\Cloud\AIPlatform\V1\BatchImportModelEvaluationSlicesRequest;
use Google\Cloud\AIPlatform\V1\BatchImportModelEvaluationSlicesResponse;
use Google\Cloud\AIPlatform\V1\CopyModelRequest;
use Google\Cloud\AIPlatform\V1\DeleteModelRequest;
use Google\Cloud\AIPlatform\V1\DeleteModelVersionRequest;
use Google\Cloud\AIPlatform\V1\ExportModelRequest;
use Google\Cloud\AIPlatform\V1\GetModelEvaluationRequest;
use Google\Cloud\AIPlatform\V1\GetModelEvaluationSliceRequest;
use Google\Cloud\AIPlatform\V1\GetModelRequest;
use Google\Cloud\AIPlatform\V1\ImportModelEvaluationRequest;
use Google\Cloud\AIPlatform\V1\ListModelEvaluationSlicesRequest;
use Google\Cloud\AIPlatform\V1\ListModelEvaluationsRequest;
use Google\Cloud\AIPlatform\V1\ListModelVersionsRequest;
use Google\Cloud\AIPlatform\V1\ListModelsRequest;
use Google\Cloud\AIPlatform\V1\MergeVersionAliasesRequest;
use Google\Cloud\AIPlatform\V1\Model;
use Google\Cloud\AIPlatform\V1\ModelEvaluation;
use Google\Cloud\AIPlatform\V1\ModelEvaluationSlice;
use Google\Cloud\AIPlatform\V1\UpdateExplanationDatasetRequest;
use Google\Cloud\AIPlatform\V1\UpdateModelRequest;
use Google\Cloud\AIPlatform\V1\UploadModelRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: A service for managing Vertex AI's machine learning Models.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface batchImportEvaluatedAnnotationsAsync(BatchImportEvaluatedAnnotationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface batchImportModelEvaluationSlicesAsync(BatchImportModelEvaluationSlicesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface copyModelAsync(CopyModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteModelAsync(DeleteModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteModelVersionAsync(DeleteModelVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface exportModelAsync(ExportModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getModelAsync(GetModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getModelEvaluationAsync(GetModelEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getModelEvaluationSliceAsync(GetModelEvaluationSliceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface importModelEvaluationAsync(ImportModelEvaluationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listModelEvaluationSlicesAsync(ListModelEvaluationSlicesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listModelEvaluationsAsync(ListModelEvaluationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listModelVersionsAsync(ListModelVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listModelsAsync(ListModelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface mergeVersionAliasesAsync(MergeVersionAliasesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateExplanationDatasetAsync(UpdateExplanationDatasetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateModelAsync(UpdateModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface uploadModelAsync(UploadModelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class ModelServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.aiplatform.v1.ModelService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'aiplatform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/model_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/model_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/model_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/model_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a endpoint
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpoint
     *
     * @return string The formatted endpoint resource.
     */
    public static function endpointName(string $project, string $location, string $endpoint): string
    {
        return self::getPathTemplate('endpoint')->render([
            'project' => $project,
            'location' => $location,
            'endpoint' => $endpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a model
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $model
     *
     * @return string The formatted model resource.
     */
    public static function modelName(string $project, string $location, string $model): string
    {
        return self::getPathTemplate('model')->render([
            'project' => $project,
            'location' => $location,
            'model' => $model,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * model_evaluation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $model
     * @param string $evaluation
     *
     * @return string The formatted model_evaluation resource.
     */
    public static function modelEvaluationName(
        string $project,
        string $location,
        string $model,
        string $evaluation
    ): string {
        return self::getPathTemplate('modelEvaluation')->render([
            'project' => $project,
            'location' => $location,
            'model' => $model,
            'evaluation' => $evaluation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * model_evaluation_slice resource.
     *
     * @param string $project
     * @param string $location
     * @param string $model
     * @param string $evaluation
     * @param string $slice
     *
     * @return string The formatted model_evaluation_slice resource.
     */
    public static function modelEvaluationSliceName(
        string $project,
        string $location,
        string $model,
        string $evaluation,
        string $slice
    ): string {
        return self::getPathTemplate('modelEvaluationSlice')->render([
            'project' => $project,
            'location' => $location,
            'model' => $model,
            'evaluation' => $evaluation,
            'slice' => $slice,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a pipeline_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $pipelineJob
     *
     * @return string The formatted pipeline_job resource.
     */
    public static function pipelineJobName(string $project, string $location, string $pipelineJob): string
    {
        return self::getPathTemplate('pipelineJob')->render([
            'project' => $project,
            'location' => $location,
            'pipeline_job' => $pipelineJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_endpoint resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpoint
     *
     * @return string The formatted project_location_endpoint resource.
     */
    public static function projectLocationEndpointName(string $project, string $location, string $endpoint): string
    {
        return self::getPathTemplate('projectLocationEndpoint')->render([
            'project' => $project,
            'location' => $location,
            'endpoint' => $endpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_publisher_model resource.
     *
     * @param string $project
     * @param string $location
     * @param string $publisher
     * @param string $model
     *
     * @return string The formatted project_location_publisher_model resource.
     */
    public static function projectLocationPublisherModelName(
        string $project,
        string $location,
        string $publisher,
        string $model
    ): string {
        return self::getPathTemplate('projectLocationPublisherModel')->render([
            'project' => $project,
            'location' => $location,
            'publisher' => $publisher,
            'model' => $model,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * training_pipeline resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trainingPipeline
     *
     * @return string The formatted training_pipeline resource.
     */
    public static function trainingPipelineName(string $project, string $location, string $trainingPipeline): string
    {
        return self::getPathTemplate('trainingPipeline')->render([
            'project' => $project,
            'location' => $location,
            'training_pipeline' => $trainingPipeline,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - endpoint: projects/{project}/locations/{location}/endpoints/{endpoint}
     * - location: projects/{project}/locations/{location}
     * - model: projects/{project}/locations/{location}/models/{model}
     * - modelEvaluation: projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}
     * - modelEvaluationSlice: projects/{project}/locations/{location}/models/{model}/evaluations/{evaluation}/slices/{slice}
     * - pipelineJob: projects/{project}/locations/{location}/pipelineJobs/{pipeline_job}
     * - projectLocationEndpoint: projects/{project}/locations/{location}/endpoints/{endpoint}
     * - projectLocationPublisherModel: projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
     * - trainingPipeline: projects/{project}/locations/{location}/trainingPipelines/{training_pipeline}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Imports a list of externally generated EvaluatedAnnotations.
     *
     * The async variant is
     * {@see ModelServiceClient::batchImportEvaluatedAnnotationsAsync()} .
     *
     * @example samples/V1/ModelServiceClient/batch_import_evaluated_annotations.php
     *
     * @param BatchImportEvaluatedAnnotationsRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchImportEvaluatedAnnotationsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchImportEvaluatedAnnotations(
        BatchImportEvaluatedAnnotationsRequest $request,
        array $callOptions = []
    ): BatchImportEvaluatedAnnotationsResponse {
        return $this->startApiCall('BatchImportEvaluatedAnnotations', $request, $callOptions)->wait();
    }

    /**
     * Imports a list of externally generated ModelEvaluationSlice.
     *
     * The async variant is
     * {@see ModelServiceClient::batchImportModelEvaluationSlicesAsync()} .
     *
     * @example samples/V1/ModelServiceClient/batch_import_model_evaluation_slices.php
     *
     * @param BatchImportModelEvaluationSlicesRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchImportModelEvaluationSlicesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchImportModelEvaluationSlices(
        BatchImportModelEvaluationSlicesRequest $request,
        array $callOptions = []
    ): BatchImportModelEvaluationSlicesResponse {
        return $this->startApiCall('BatchImportModelEvaluationSlices', $request, $callOptions)->wait();
    }

    /**
     * Copies an already existing Vertex AI Model into the specified Location.
     * The source Model must exist in the same Project.
     * When copying custom Models, the users themselves are responsible for
     * [Model.metadata][google.cloud.aiplatform.v1.Model.metadata] content to be
     * region-agnostic, as well as making sure that any resources (e.g. files) it
     * depends on remain accessible.
     *
     * The async variant is {@see ModelServiceClient::copyModelAsync()} .
     *
     * @example samples/V1/ModelServiceClient/copy_model.php
     *
     * @param CopyModelRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function copyModel(CopyModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CopyModel', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Model.
     *
     * A model cannot be deleted if any
     * [Endpoint][google.cloud.aiplatform.v1.Endpoint] resource has a
     * [DeployedModel][google.cloud.aiplatform.v1.DeployedModel] based on the
     * model in its
     * [deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
     * field.
     *
     * The async variant is {@see ModelServiceClient::deleteModelAsync()} .
     *
     * @example samples/V1/ModelServiceClient/delete_model.php
     *
     * @param DeleteModelRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteModel(DeleteModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteModel', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Model version.
     *
     * Model version can only be deleted if there are no
     * [DeployedModels][google.cloud.aiplatform.v1.DeployedModel] created from it.
     * Deleting the only version in the Model is not allowed. Use
     * [DeleteModel][google.cloud.aiplatform.v1.ModelService.DeleteModel] for
     * deleting the Model instead.
     *
     * The async variant is {@see ModelServiceClient::deleteModelVersionAsync()} .
     *
     * @example samples/V1/ModelServiceClient/delete_model_version.php
     *
     * @param DeleteModelVersionRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteModelVersion(DeleteModelVersionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteModelVersion', $request, $callOptions)->wait();
    }

    /**
     * Exports a trained, exportable Model to a location specified by the
     * user. A Model is considered to be exportable if it has at least one
     * [supported export
     * format][google.cloud.aiplatform.v1.Model.supported_export_formats].
     *
     * The async variant is {@see ModelServiceClient::exportModelAsync()} .
     *
     * @example samples/V1/ModelServiceClient/export_model.php
     *
     * @param ExportModelRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportModel(ExportModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportModel', $request, $callOptions)->wait();
    }

    /**
     * Gets a Model.
     *
     * The async variant is {@see ModelServiceClient::getModelAsync()} .
     *
     * @example samples/V1/ModelServiceClient/get_model.php
     *
     * @param GetModelRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Model
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getModel(GetModelRequest $request, array $callOptions = []): Model
    {
        return $this->startApiCall('GetModel', $request, $callOptions)->wait();
    }

    /**
     * Gets a ModelEvaluation.
     *
     * The async variant is {@see ModelServiceClient::getModelEvaluationAsync()} .
     *
     * @example samples/V1/ModelServiceClient/get_model_evaluation.php
     *
     * @param GetModelEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ModelEvaluation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getModelEvaluation(GetModelEvaluationRequest $request, array $callOptions = []): ModelEvaluation
    {
        return $this->startApiCall('GetModelEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Gets a ModelEvaluationSlice.
     *
     * The async variant is {@see ModelServiceClient::getModelEvaluationSliceAsync()} .
     *
     * @example samples/V1/ModelServiceClient/get_model_evaluation_slice.php
     *
     * @param GetModelEvaluationSliceRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ModelEvaluationSlice
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getModelEvaluationSlice(
        GetModelEvaluationSliceRequest $request,
        array $callOptions = []
    ): ModelEvaluationSlice {
        return $this->startApiCall('GetModelEvaluationSlice', $request, $callOptions)->wait();
    }

    /**
     * Imports an externally generated ModelEvaluation.
     *
     * The async variant is {@see ModelServiceClient::importModelEvaluationAsync()} .
     *
     * @example samples/V1/ModelServiceClient/import_model_evaluation.php
     *
     * @param ImportModelEvaluationRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ModelEvaluation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importModelEvaluation(
        ImportModelEvaluationRequest $request,
        array $callOptions = []
    ): ModelEvaluation {
        return $this->startApiCall('ImportModelEvaluation', $request, $callOptions)->wait();
    }

    /**
     * Lists ModelEvaluationSlices in a ModelEvaluation.
     *
     * The async variant is {@see ModelServiceClient::listModelEvaluationSlicesAsync()}
     * .
     *
     * @example samples/V1/ModelServiceClient/list_model_evaluation_slices.php
     *
     * @param ListModelEvaluationSlicesRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listModelEvaluationSlices(
        ListModelEvaluationSlicesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListModelEvaluationSlices', $request, $callOptions);
    }

    /**
     * Lists ModelEvaluations in a Model.
     *
     * The async variant is {@see ModelServiceClient::listModelEvaluationsAsync()} .
     *
     * @example samples/V1/ModelServiceClient/list_model_evaluations.php
     *
     * @param ListModelEvaluationsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listModelEvaluations(
        ListModelEvaluationsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListModelEvaluations', $request, $callOptions);
    }

    /**
     * Lists versions of the specified model.
     *
     * The async variant is {@see ModelServiceClient::listModelVersionsAsync()} .
     *
     * @example samples/V1/ModelServiceClient/list_model_versions.php
     *
     * @param ListModelVersionsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listModelVersions(ListModelVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListModelVersions', $request, $callOptions);
    }

    /**
     * Lists Models in a Location.
     *
     * The async variant is {@see ModelServiceClient::listModelsAsync()} .
     *
     * @example samples/V1/ModelServiceClient/list_models.php
     *
     * @param ListModelsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listModels(ListModelsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListModels', $request, $callOptions);
    }

    /**
     * Merges a set of aliases for a Model version.
     *
     * The async variant is {@see ModelServiceClient::mergeVersionAliasesAsync()} .
     *
     * @example samples/V1/ModelServiceClient/merge_version_aliases.php
     *
     * @param MergeVersionAliasesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Model
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function mergeVersionAliases(MergeVersionAliasesRequest $request, array $callOptions = []): Model
    {
        return $this->startApiCall('MergeVersionAliases', $request, $callOptions)->wait();
    }

    /**
     * Incrementally update the dataset used for an examples model.
     *
     * The async variant is {@see ModelServiceClient::updateExplanationDatasetAsync()}
     * .
     *
     * @example samples/V1/ModelServiceClient/update_explanation_dataset.php
     *
     * @param UpdateExplanationDatasetRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExplanationDataset(
        UpdateExplanationDatasetRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateExplanationDataset', $request, $callOptions)->wait();
    }

    /**
     * Updates a Model.
     *
     * The async variant is {@see ModelServiceClient::updateModelAsync()} .
     *
     * @example samples/V1/ModelServiceClient/update_model.php
     *
     * @param UpdateModelRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Model
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateModel(UpdateModelRequest $request, array $callOptions = []): Model
    {
        return $this->startApiCall('UpdateModel', $request, $callOptions)->wait();
    }

    /**
     * Uploads a Model artifact into Vertex AI.
     *
     * The async variant is {@see ModelServiceClient::uploadModelAsync()} .
     *
     * @example samples/V1/ModelServiceClient/upload_model.php
     *
     * @param UploadModelRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function uploadModel(UploadModelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UploadModel', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ModelServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/ModelServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ModelServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/ModelServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see ModelServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/ModelServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see ModelServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/ModelServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see ModelServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/ModelServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
