<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/developerconnect/v1/insights_config.proto

namespace Google\Cloud\DeveloperConnect\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The artifact config of the artifact that is deployed.
 *
 * Generated from protobuf message <code>google.cloud.developerconnect.v1.ArtifactConfig</code>
 */
class ArtifactConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Immutable. The URI of the artifact that is deployed.
     * e.g. `us-docker.pkg.dev/my-project/my-repo/image`.
     * The URI does not include the tag / digest because it captures a lineage of
     * artifacts.
     *
     * Generated from protobuf field <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $uri = '';
    protected $artifact_storage;
    protected $artifact_metadata_storage;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\DeveloperConnect\V1\GoogleArtifactRegistry $google_artifact_registry
     *           Optional. Set if the artifact is stored in Artifact regsitry.
     *     @type \Google\Cloud\DeveloperConnect\V1\GoogleArtifactAnalysis $google_artifact_analysis
     *           Optional. Set if the artifact metadata is stored in Artifact analysis.
     *     @type string $uri
     *           Required. Immutable. The URI of the artifact that is deployed.
     *           e.g. `us-docker.pkg.dev/my-project/my-repo/image`.
     *           The URI does not include the tag / digest because it captures a lineage of
     *           artifacts.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Developerconnect\V1\InsightsConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Set if the artifact is stored in Artifact regsitry.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.GoogleArtifactRegistry google_artifact_registry = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\GoogleArtifactRegistry|null
     */
    public function getGoogleArtifactRegistry()
    {
        return $this->readOneof(2);
    }

    public function hasGoogleArtifactRegistry()
    {
        return $this->hasOneof(2);
    }

    /**
     * Optional. Set if the artifact is stored in Artifact regsitry.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.GoogleArtifactRegistry google_artifact_registry = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\GoogleArtifactRegistry $var
     * @return $this
     */
    public function setGoogleArtifactRegistry($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\GoogleArtifactRegistry::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Optional. Set if the artifact metadata is stored in Artifact analysis.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.GoogleArtifactAnalysis google_artifact_analysis = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\GoogleArtifactAnalysis|null
     */
    public function getGoogleArtifactAnalysis()
    {
        return $this->readOneof(3);
    }

    public function hasGoogleArtifactAnalysis()
    {
        return $this->hasOneof(3);
    }

    /**
     * Optional. Set if the artifact metadata is stored in Artifact analysis.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.GoogleArtifactAnalysis google_artifact_analysis = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\GoogleArtifactAnalysis $var
     * @return $this
     */
    public function setGoogleArtifactAnalysis($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\GoogleArtifactAnalysis::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Required. Immutable. The URI of the artifact that is deployed.
     * e.g. `us-docker.pkg.dev/my-project/my-repo/image`.
     * The URI does not include the tag / digest because it captures a lineage of
     * artifacts.
     *
     * Generated from protobuf field <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Required. Immutable. The URI of the artifact that is deployed.
     * e.g. `us-docker.pkg.dev/my-project/my-repo/image`.
     * The URI does not include the tag / digest because it captures a lineage of
     * artifacts.
     *
     * Generated from protobuf field <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getArtifactStorage()
    {
        return $this->whichOneof("artifact_storage");
    }

    /**
     * @return string
     */
    public function getArtifactMetadataStorage()
    {
        return $this->whichOneof("artifact_metadata_storage");
    }

}

