<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataplex/v1/catalog.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dataplex\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataplex\V1\AspectType;
use Google\Cloud\Dataplex\V1\CancelMetadataJobRequest;
use Google\Cloud\Dataplex\V1\CreateAspectTypeRequest;
use Google\Cloud\Dataplex\V1\CreateEntryGroupRequest;
use Google\Cloud\Dataplex\V1\CreateEntryLinkRequest;
use Google\Cloud\Dataplex\V1\CreateEntryRequest;
use Google\Cloud\Dataplex\V1\CreateEntryTypeRequest;
use Google\Cloud\Dataplex\V1\CreateMetadataJobRequest;
use Google\Cloud\Dataplex\V1\DeleteAspectTypeRequest;
use Google\Cloud\Dataplex\V1\DeleteEntryGroupRequest;
use Google\Cloud\Dataplex\V1\DeleteEntryLinkRequest;
use Google\Cloud\Dataplex\V1\DeleteEntryRequest;
use Google\Cloud\Dataplex\V1\DeleteEntryTypeRequest;
use Google\Cloud\Dataplex\V1\Entry;
use Google\Cloud\Dataplex\V1\EntryGroup;
use Google\Cloud\Dataplex\V1\EntryLink;
use Google\Cloud\Dataplex\V1\EntryType;
use Google\Cloud\Dataplex\V1\GetAspectTypeRequest;
use Google\Cloud\Dataplex\V1\GetEntryGroupRequest;
use Google\Cloud\Dataplex\V1\GetEntryLinkRequest;
use Google\Cloud\Dataplex\V1\GetEntryRequest;
use Google\Cloud\Dataplex\V1\GetEntryTypeRequest;
use Google\Cloud\Dataplex\V1\GetMetadataJobRequest;
use Google\Cloud\Dataplex\V1\ListAspectTypesRequest;
use Google\Cloud\Dataplex\V1\ListEntriesRequest;
use Google\Cloud\Dataplex\V1\ListEntryGroupsRequest;
use Google\Cloud\Dataplex\V1\ListEntryTypesRequest;
use Google\Cloud\Dataplex\V1\ListMetadataJobsRequest;
use Google\Cloud\Dataplex\V1\LookupEntryRequest;
use Google\Cloud\Dataplex\V1\MetadataJob;
use Google\Cloud\Dataplex\V1\SearchEntriesRequest;
use Google\Cloud\Dataplex\V1\UpdateAspectTypeRequest;
use Google\Cloud\Dataplex\V1\UpdateEntryGroupRequest;
use Google\Cloud\Dataplex\V1\UpdateEntryRequest;
use Google\Cloud\Dataplex\V1\UpdateEntryTypeRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The primary resources offered by this service are EntryGroups, EntryTypes,
 * AspectTypes, Entries and EntryLinks. They collectively let data
 * administrators organize, manage, secure, and catalog data located across
 * cloud projects in their organization in a variety of storage systems,
 * including Cloud Storage and BigQuery.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<void> cancelMetadataJobAsync(CancelMetadataJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createAspectTypeAsync(CreateAspectTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entry> createEntryAsync(CreateEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createEntryGroupAsync(CreateEntryGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryLink> createEntryLinkAsync(CreateEntryLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createEntryTypeAsync(CreateEntryTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createMetadataJobAsync(CreateMetadataJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAspectTypeAsync(DeleteAspectTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entry> deleteEntryAsync(DeleteEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteEntryGroupAsync(DeleteEntryGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryLink> deleteEntryLinkAsync(DeleteEntryLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteEntryTypeAsync(DeleteEntryTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AspectType> getAspectTypeAsync(GetAspectTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entry> getEntryAsync(GetEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryGroup> getEntryGroupAsync(GetEntryGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryLink> getEntryLinkAsync(GetEntryLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryType> getEntryTypeAsync(GetEntryTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MetadataJob> getMetadataJobAsync(GetMetadataJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAspectTypesAsync(ListAspectTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEntriesAsync(ListEntriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEntryGroupsAsync(ListEntryGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEntryTypesAsync(ListEntryTypesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMetadataJobsAsync(ListMetadataJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entry> lookupEntryAsync(LookupEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchEntriesAsync(SearchEntriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAspectTypeAsync(UpdateAspectTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entry> updateEntryAsync(UpdateEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateEntryGroupAsync(UpdateEntryGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateEntryTypeAsync(UpdateEntryTypeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class CatalogServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dataplex.v1.CatalogService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dataplex.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dataplex.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/catalog_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/catalog_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/catalog_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/catalog_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a aspect_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $aspectType
     *
     * @return string The formatted aspect_type resource.
     */
    public static function aspectTypeName(string $project, string $location, string $aspectType): string
    {
        return self::getPathTemplate('aspectType')->render([
            'project' => $project,
            'location' => $location,
            'aspect_type' => $aspectType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     * @param string $entry
     *
     * @return string The formatted entry resource.
     */
    public static function entryName(string $project, string $location, string $entryGroup, string $entry): string
    {
        return self::getPathTemplate('entry')->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
            'entry' => $entry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry_group
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     *
     * @return string The formatted entry_group resource.
     */
    public static function entryGroupName(string $project, string $location, string $entryGroup): string
    {
        return self::getPathTemplate('entryGroup')->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry_link
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     * @param string $entryLink
     *
     * @return string The formatted entry_link resource.
     */
    public static function entryLinkName(
        string $project,
        string $location,
        string $entryGroup,
        string $entryLink
    ): string {
        return self::getPathTemplate('entryLink')->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
            'entry_link' => $entryLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryType
     *
     * @return string The formatted entry_type resource.
     */
    public static function entryTypeName(string $project, string $location, string $entryType): string
    {
        return self::getPathTemplate('entryType')->render([
            'project' => $project,
            'location' => $location,
            'entry_type' => $entryType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a glossary
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $glossary
     *
     * @return string The formatted glossary resource.
     */
    public static function glossaryName(string $project, string $location, string $glossary): string
    {
        return self::getPathTemplate('glossary')->render([
            'project' => $project,
            'location' => $location,
            'glossary' => $glossary,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a metadata_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataJob
     *
     * @return string The formatted metadata_job resource.
     */
    public static function metadataJobName(string $project, string $location, string $metadataJob): string
    {
        return self::getPathTemplate('metadataJob')->render([
            'project' => $project,
            'location' => $location,
            'metadataJob' => $metadataJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - aspectType: projects/{project}/locations/{location}/aspectTypes/{aspect_type}
     * - entry: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}
     * - entryGroup: projects/{project}/locations/{location}/entryGroups/{entry_group}
     * - entryLink: projects/{project}/locations/{location}/entryGroups/{entry_group}/entryLinks/{entry_link}
     * - entryType: projects/{project}/locations/{location}/entryTypes/{entry_type}
     * - glossary: projects/{project}/locations/{location}/glossaries/{glossary}
     * - location: projects/{project}/locations/{location}
     * - metadataJob: projects/{project}/locations/{location}/metadataJobs/{metadataJob}
     * - project: projects/{project}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataplex.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Cancels a metadata job.
     *
     * If you cancel a metadata import job that is in progress, the changes in the
     * job might be partially applied. We recommend that you reset the state of
     * the entry groups in your project by running another metadata job that
     * reverts the changes from the canceled job.
     *
     * The async variant is {@see CatalogServiceClient::cancelMetadataJobAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/cancel_metadata_job.php
     *
     * @param CancelMetadataJobRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelMetadataJob(CancelMetadataJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelMetadataJob', $request, $callOptions)->wait();
    }

    /**
     * Creates an AspectType.
     *
     * The async variant is {@see CatalogServiceClient::createAspectTypeAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/create_aspect_type.php
     *
     * @param CreateAspectTypeRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAspectType(CreateAspectTypeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAspectType', $request, $callOptions)->wait();
    }

    /**
     * Creates an Entry.
     *
     * The async variant is {@see CatalogServiceClient::createEntryAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/create_entry.php
     *
     * @param CreateEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEntry(CreateEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('CreateEntry', $request, $callOptions)->wait();
    }

    /**
     * Creates an EntryGroup.
     *
     * The async variant is {@see CatalogServiceClient::createEntryGroupAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/create_entry_group.php
     *
     * @param CreateEntryGroupRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEntryGroup(CreateEntryGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEntryGroup', $request, $callOptions)->wait();
    }

    /**
     * Creates an Entry Link.
     *
     * The async variant is {@see CatalogServiceClient::createEntryLinkAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/create_entry_link.php
     *
     * @param CreateEntryLinkRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryLink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEntryLink(CreateEntryLinkRequest $request, array $callOptions = []): EntryLink
    {
        return $this->startApiCall('CreateEntryLink', $request, $callOptions)->wait();
    }

    /**
     * Creates an EntryType.
     *
     * The async variant is {@see CatalogServiceClient::createEntryTypeAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/create_entry_type.php
     *
     * @param CreateEntryTypeRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEntryType(CreateEntryTypeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEntryType', $request, $callOptions)->wait();
    }

    /**
     * Creates a metadata job. For example, use a metadata job to import metadata
     * from a third-party system into Dataplex Universal Catalog.
     *
     * The async variant is {@see CatalogServiceClient::createMetadataJobAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/create_metadata_job.php
     *
     * @param CreateMetadataJobRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMetadataJob(CreateMetadataJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateMetadataJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes an AspectType.
     *
     * The async variant is {@see CatalogServiceClient::deleteAspectTypeAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/delete_aspect_type.php
     *
     * @param DeleteAspectTypeRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAspectType(DeleteAspectTypeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAspectType', $request, $callOptions)->wait();
    }

    /**
     * Deletes an Entry.
     *
     * The async variant is {@see CatalogServiceClient::deleteEntryAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/delete_entry.php
     *
     * @param DeleteEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEntry(DeleteEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('DeleteEntry', $request, $callOptions)->wait();
    }

    /**
     * Deletes an EntryGroup.
     *
     * The async variant is {@see CatalogServiceClient::deleteEntryGroupAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/delete_entry_group.php
     *
     * @param DeleteEntryGroupRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEntryGroup(DeleteEntryGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEntryGroup', $request, $callOptions)->wait();
    }

    /**
     * Deletes an Entry Link.
     *
     * The async variant is {@see CatalogServiceClient::deleteEntryLinkAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/delete_entry_link.php
     *
     * @param DeleteEntryLinkRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryLink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEntryLink(DeleteEntryLinkRequest $request, array $callOptions = []): EntryLink
    {
        return $this->startApiCall('DeleteEntryLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes an EntryType.
     *
     * The async variant is {@see CatalogServiceClient::deleteEntryTypeAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/delete_entry_type.php
     *
     * @param DeleteEntryTypeRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEntryType(DeleteEntryTypeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEntryType', $request, $callOptions)->wait();
    }

    /**
     * Gets an AspectType.
     *
     * The async variant is {@see CatalogServiceClient::getAspectTypeAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/get_aspect_type.php
     *
     * @param GetAspectTypeRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AspectType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAspectType(GetAspectTypeRequest $request, array $callOptions = []): AspectType
    {
        return $this->startApiCall('GetAspectType', $request, $callOptions)->wait();
    }

    /**
     * Gets an Entry.
     *
     * The async variant is {@see CatalogServiceClient::getEntryAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/get_entry.php
     *
     * @param GetEntryRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEntry(GetEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('GetEntry', $request, $callOptions)->wait();
    }

    /**
     * Gets an EntryGroup.
     *
     * The async variant is {@see CatalogServiceClient::getEntryGroupAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/get_entry_group.php
     *
     * @param GetEntryGroupRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryGroup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEntryGroup(GetEntryGroupRequest $request, array $callOptions = []): EntryGroup
    {
        return $this->startApiCall('GetEntryGroup', $request, $callOptions)->wait();
    }

    /**
     * Gets an Entry Link.
     *
     * The async variant is {@see CatalogServiceClient::getEntryLinkAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/get_entry_link.php
     *
     * @param GetEntryLinkRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryLink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEntryLink(GetEntryLinkRequest $request, array $callOptions = []): EntryLink
    {
        return $this->startApiCall('GetEntryLink', $request, $callOptions)->wait();
    }

    /**
     * Gets an EntryType.
     *
     * The async variant is {@see CatalogServiceClient::getEntryTypeAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/get_entry_type.php
     *
     * @param GetEntryTypeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryType
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEntryType(GetEntryTypeRequest $request, array $callOptions = []): EntryType
    {
        return $this->startApiCall('GetEntryType', $request, $callOptions)->wait();
    }

    /**
     * Gets a metadata job.
     *
     * The async variant is {@see CatalogServiceClient::getMetadataJobAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/get_metadata_job.php
     *
     * @param GetMetadataJobRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MetadataJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMetadataJob(GetMetadataJobRequest $request, array $callOptions = []): MetadataJob
    {
        return $this->startApiCall('GetMetadataJob', $request, $callOptions)->wait();
    }

    /**
     * Lists AspectType resources in a project and location.
     *
     * The async variant is {@see CatalogServiceClient::listAspectTypesAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/list_aspect_types.php
     *
     * @param ListAspectTypesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAspectTypes(ListAspectTypesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAspectTypes', $request, $callOptions);
    }

    /**
     * Lists Entries within an EntryGroup.
     *
     * The async variant is {@see CatalogServiceClient::listEntriesAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/list_entries.php
     *
     * @param ListEntriesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntries(ListEntriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEntries', $request, $callOptions);
    }

    /**
     * Lists EntryGroup resources in a project and location.
     *
     * The async variant is {@see CatalogServiceClient::listEntryGroupsAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/list_entry_groups.php
     *
     * @param ListEntryGroupsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntryGroups(ListEntryGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEntryGroups', $request, $callOptions);
    }

    /**
     * Lists EntryType resources in a project and location.
     *
     * The async variant is {@see CatalogServiceClient::listEntryTypesAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/list_entry_types.php
     *
     * @param ListEntryTypesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntryTypes(ListEntryTypesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEntryTypes', $request, $callOptions);
    }

    /**
     * Lists metadata jobs.
     *
     * The async variant is {@see CatalogServiceClient::listMetadataJobsAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/list_metadata_jobs.php
     *
     * @param ListMetadataJobsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMetadataJobs(ListMetadataJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMetadataJobs', $request, $callOptions);
    }

    /**
     * Looks up an entry by name using the permission on the source system.
     *
     * The async variant is {@see CatalogServiceClient::lookupEntryAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/lookup_entry.php
     *
     * @param LookupEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupEntry(LookupEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('LookupEntry', $request, $callOptions)->wait();
    }

    /**
     * Searches for Entries matching the given query and scope.
     *
     * The async variant is {@see CatalogServiceClient::searchEntriesAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/search_entries.php
     *
     * @param SearchEntriesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchEntries(SearchEntriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchEntries', $request, $callOptions);
    }

    /**
     * Updates an AspectType.
     *
     * The async variant is {@see CatalogServiceClient::updateAspectTypeAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/update_aspect_type.php
     *
     * @param UpdateAspectTypeRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAspectType(UpdateAspectTypeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAspectType', $request, $callOptions)->wait();
    }

    /**
     * Updates an Entry.
     *
     * The async variant is {@see CatalogServiceClient::updateEntryAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/update_entry.php
     *
     * @param UpdateEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEntry(UpdateEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('UpdateEntry', $request, $callOptions)->wait();
    }

    /**
     * Updates an EntryGroup.
     *
     * The async variant is {@see CatalogServiceClient::updateEntryGroupAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/update_entry_group.php
     *
     * @param UpdateEntryGroupRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEntryGroup(UpdateEntryGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateEntryGroup', $request, $callOptions)->wait();
    }

    /**
     * Updates an EntryType.
     *
     * The async variant is {@see CatalogServiceClient::updateEntryTypeAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/update_entry_type.php
     *
     * @param UpdateEntryTypeRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEntryType(UpdateEntryTypeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateEntryType', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see CatalogServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see CatalogServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see CatalogServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see CatalogServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see CatalogServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/CatalogServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
