<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Backend Service resource. A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly. Backend services in Google Compute Engine can be either regionally or globally scoped. * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/backendServices) * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/regionBackendServices) For more information, see Backend Services.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.BackendService</code>
 */
class BackendService extends \Google\Protobuf\Internal\Message
{
    /**
     * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
     */
    private $affinity_cookie_ttl_sec = null;
    /**
     * The list of backends that serve this BackendService.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     */
    private $backends;
    /**
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
     */
    private $cdn_policy = null;
    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     */
    private $circuit_breakers = null;
    /**
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string compression_mode = 95520988;</code>
     */
    private $compression_mode = null;
    /**
     * connectionDraining cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;</code>
     */
    private $connection_draining = null;
    /**
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;</code>
     */
    private $connection_tracking_policy = null;
    /**
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. 
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;</code>
     */
    private $consistent_hash = null;
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = null;
    /**
     * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceCustomMetric custom_metrics = 429453813;</code>
     */
    private $custom_metrics;
    /**
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     *
     * Generated from protobuf field <code>repeated string custom_request_headers = 27977992;</code>
     */
    private $custom_request_headers;
    /**
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     *
     * Generated from protobuf field <code>repeated string custom_response_headers = 387539094;</code>
     */
    private $custom_response_headers;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    private $description = null;
    /**
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     *
     * Generated from protobuf field <code>optional string edge_security_policy = 41036943;</code>
     */
    private $edge_security_policy = null;
    /**
     * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
     *
     * Generated from protobuf field <code>optional bool enable_c_d_n = 250733499;</code>
     */
    private $enable_c_d_n = null;
    /**
     * Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
     * Check the ExternalManagedMigrationState enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string external_managed_migration_state = 66947020;</code>
     */
    private $external_managed_migration_state = null;
    /**
     * Determines the fraction of requests that should be processed by the Global external Application Load Balancer. The value of this field must be in the range [0, 100]. Session affinity options will slightly affect this routing behavior, for more details, see: Session Affinity. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
     *
     * Generated from protobuf field <code>optional float external_managed_migration_testing_percentage = 507232462;</code>
     */
    private $external_managed_migration_testing_percentage = null;
    /**
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;</code>
     */
    private $failover_policy = null;
    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     *
     * Generated from protobuf field <code>optional string fingerprint = 234678500;</code>
     */
    private $fingerprint = null;
    /**
     * Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceHAPolicy ha_policy = 519879480;</code>
     */
    private $ha_policy = null;
    /**
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>repeated string health_checks = 448370606;</code>
     */
    private $health_checks;
    /**
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     */
    private $iap = null;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    private $id = null;
    /**
     * Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
     * Check the IpAddressSelectionPolicy enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string ip_address_selection_policy = 77600840;</code>
     */
    private $ip_address_selection_policy = null;
    /**
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    private $kind = null;
    /**
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string load_balancing_scheme = 363890244;</code>
     */
    private $load_balancing_scheme = null;
    /**
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;</code>
     */
    private $locality_lb_policies;
    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
     * Check the LocalityLbPolicy enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string locality_lb_policy = 131431487;</code>
     */
    private $locality_lb_policy = null;
    /**
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
     */
    private $log_config = null;
    /**
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     */
    private $max_stream_duration = null;
    /**
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     *
     * Generated from protobuf field <code>map<string, string> metadatas = 8514340;</code>
     */
    private $metadatas;
    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    private $name = null;
    /**
     * The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
     *
     * Generated from protobuf field <code>optional string network = 232872494;</code>
     */
    private $network = null;
    /**
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
     */
    private $outlier_detection = null;
    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceParams params = 78313862;</code>
     */
    private $params = null;
    /**
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
     *
     * Generated from protobuf field <code>optional int32 port = 3446913;</code>
     */
    private $port = null;
    /**
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     *
     * Generated from protobuf field <code>optional string port_name = 41534345;</code>
     */
    private $port_name = null;
    /**
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string protocol = 84577944;</code>
     */
    private $protocol = null;
    /**
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     */
    private $region = null;
    /**
     * [Output Only] The resource URL for the security policy associated with this backend service.
     *
     * Generated from protobuf field <code>optional string security_policy = 171082513;</code>
     */
    private $security_policy = null;
    /**
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
     */
    private $security_settings = null;
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    private $self_link = null;
    /**
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     *
     * Generated from protobuf field <code>repeated string service_bindings = 133581016;</code>
     */
    private $service_bindings;
    /**
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     *
     * Generated from protobuf field <code>optional string service_lb_policy = 94848785;</code>
     */
    private $service_lb_policy = null;
    /**
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
     * Check the SessionAffinity enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string session_affinity = 463888561;</code>
     */
    private $session_affinity = null;
    /**
     * Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceHttpCookie strong_session_affinity_cookie = 238195722;</code>
     */
    private $strong_session_affinity_cookie = null;
    /**
     * subsetting cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
     */
    private $subsetting = null;
    /**
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
     *
     * Generated from protobuf field <code>optional int32 timeout_sec = 79994995;</code>
     */
    private $timeout_sec = null;
    /**
     * Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceTlsSettings tls_settings = 81794791;</code>
     */
    private $tls_settings = null;
    /**
     * [Output Only] List of resources referencing given backend service.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code>
     */
    private $used_by;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $affinity_cookie_ttl_sec
     *           Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *     @type array<\Google\Cloud\Compute\V1\Backend>|\Google\Protobuf\Internal\RepeatedField $backends
     *           The list of backends that serve this BackendService.
     *     @type \Google\Cloud\Compute\V1\BackendServiceCdnPolicy $cdn_policy
     *           Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     *     @type \Google\Cloud\Compute\V1\CircuitBreakers $circuit_breakers
     *     @type string $compression_mode
     *           Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     *           Check the CompressionMode enum for the list of possible values.
     *     @type \Google\Cloud\Compute\V1\ConnectionDraining $connection_draining
     *           connectionDraining cannot be specified with haPolicy.
     *     @type \Google\Cloud\Compute\V1\BackendServiceConnectionTrackingPolicy $connection_tracking_policy
     *           Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
     *     @type \Google\Cloud\Compute\V1\ConsistentHashLoadBalancerSettings $consistent_hash
     *           Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. 
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type array<\Google\Cloud\Compute\V1\BackendServiceCustomMetric>|\Google\Protobuf\Internal\RepeatedField $custom_metrics
     *           List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $custom_request_headers
     *           Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $custom_response_headers
     *           Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type string $edge_security_policy
     *           [Output Only] The resource URL for the edge security policy associated with this backend service.
     *     @type bool $enable_c_d_n
     *           If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
     *     @type string $external_managed_migration_state
     *           Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
     *           Check the ExternalManagedMigrationState enum for the list of possible values.
     *     @type float $external_managed_migration_testing_percentage
     *           Determines the fraction of requests that should be processed by the Global external Application Load Balancer. The value of this field must be in the range [0, 100]. Session affinity options will slightly affect this routing behavior, for more details, see: Session Affinity. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
     *     @type \Google\Cloud\Compute\V1\BackendServiceFailoverPolicy $failover_policy
     *           Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
     *     @type string $fingerprint
     *           Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     *     @type \Google\Cloud\Compute\V1\BackendServiceHAPolicy $ha_policy
     *           Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $health_checks
     *           The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
     *     @type \Google\Cloud\Compute\V1\BackendServiceIAP $iap
     *           The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     *     @type int|string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $ip_address_selection_policy
     *           Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
     *           Check the IpAddressSelectionPolicy enum for the list of possible values.
     *     @type string $kind
     *           [Output Only] Type of resource. Always compute#backendService for backend services.
     *     @type string $load_balancing_scheme
     *           Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     *           Check the LoadBalancingScheme enum for the list of possible values.
     *     @type array<\Google\Cloud\Compute\V1\BackendServiceLocalityLoadBalancingPolicyConfig>|\Google\Protobuf\Internal\RepeatedField $locality_lb_policies
     *           A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     *     @type string $locality_lb_policy
     *           The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
     *           Check the LocalityLbPolicy enum for the list of possible values.
     *     @type \Google\Cloud\Compute\V1\BackendServiceLogConfig $log_config
     *           This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     *     @type \Google\Cloud\Compute\V1\Duration $max_stream_duration
     *           Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     *     @type array|\Google\Protobuf\Internal\MapField $metadatas
     *           Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $network
     *           The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
     *     @type \Google\Cloud\Compute\V1\OutlierDetection $outlier_detection
     *           Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *     @type \Google\Cloud\Compute\V1\BackendServiceParams $params
     *           Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *     @type int $port
     *           Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
     *     @type string $port_name
     *           A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     *     @type string $protocol
     *           The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     *           Check the Protocol enum for the list of possible values.
     *     @type string $region
     *           [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *     @type string $security_policy
     *           [Output Only] The resource URL for the security policy associated with this backend service.
     *     @type \Google\Cloud\Compute\V1\SecuritySettings $security_settings
     *           This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $service_bindings
     *           URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     *     @type string $service_lb_policy
     *           URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     *     @type string $session_affinity
     *           Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
     *           Check the SessionAffinity enum for the list of possible values.
     *     @type \Google\Cloud\Compute\V1\BackendServiceHttpCookie $strong_session_affinity_cookie
     *           Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
     *     @type \Google\Cloud\Compute\V1\Subsetting $subsetting
     *           subsetting cannot be specified with haPolicy.
     *     @type int $timeout_sec
     *           The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
     *     @type \Google\Cloud\Compute\V1\BackendServiceTlsSettings $tls_settings
     *           Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
     *     @type array<\Google\Cloud\Compute\V1\BackendServiceUsedBy>|\Google\Protobuf\Internal\RepeatedField $used_by
     *           [Output Only] List of resources referencing given backend service.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
     * @return int
     */
    public function getAffinityCookieTtlSec()
    {
        return isset($this->affinity_cookie_ttl_sec) ? $this->affinity_cookie_ttl_sec : 0;
    }

    public function hasAffinityCookieTtlSec()
    {
        return isset($this->affinity_cookie_ttl_sec);
    }

    public function clearAffinityCookieTtlSec()
    {
        unset($this->affinity_cookie_ttl_sec);
    }

    /**
     * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
     * @param int $var
     * @return $this
     */
    public function setAffinityCookieTtlSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->affinity_cookie_ttl_sec = $var;

        return $this;
    }

    /**
     * The list of backends that serve this BackendService.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBackends()
    {
        return $this->backends;
    }

    /**
     * The list of backends that serve this BackendService.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
     * @param array<\Google\Cloud\Compute\V1\Backend>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBackends($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\Backend::class);
        $this->backends = $arr;

        return $this;
    }

    /**
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceCdnPolicy|null
     */
    public function getCdnPolicy()
    {
        return $this->cdn_policy;
    }

    public function hasCdnPolicy()
    {
        return isset($this->cdn_policy);
    }

    public function clearCdnPolicy()
    {
        unset($this->cdn_policy);
    }

    /**
     * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceCdnPolicy $var
     * @return $this
     */
    public function setCdnPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceCdnPolicy::class);
        $this->cdn_policy = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     * @return \Google\Cloud\Compute\V1\CircuitBreakers|null
     */
    public function getCircuitBreakers()
    {
        return $this->circuit_breakers;
    }

    public function hasCircuitBreakers()
    {
        return isset($this->circuit_breakers);
    }

    public function clearCircuitBreakers()
    {
        unset($this->circuit_breakers);
    }

    /**
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
     * @param \Google\Cloud\Compute\V1\CircuitBreakers $var
     * @return $this
     */
    public function setCircuitBreakers($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CircuitBreakers::class);
        $this->circuit_breakers = $var;

        return $this;
    }

    /**
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string compression_mode = 95520988;</code>
     * @return string
     */
    public function getCompressionMode()
    {
        return isset($this->compression_mode) ? $this->compression_mode : '';
    }

    public function hasCompressionMode()
    {
        return isset($this->compression_mode);
    }

    public function clearCompressionMode()
    {
        unset($this->compression_mode);
    }

    /**
     * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
     * Check the CompressionMode enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string compression_mode = 95520988;</code>
     * @param string $var
     * @return $this
     */
    public function setCompressionMode($var)
    {
        GPBUtil::checkString($var, True);
        $this->compression_mode = $var;

        return $this;
    }

    /**
     * connectionDraining cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;</code>
     * @return \Google\Cloud\Compute\V1\ConnectionDraining|null
     */
    public function getConnectionDraining()
    {
        return $this->connection_draining;
    }

    public function hasConnectionDraining()
    {
        return isset($this->connection_draining);
    }

    public function clearConnectionDraining()
    {
        unset($this->connection_draining);
    }

    /**
     * connectionDraining cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;</code>
     * @param \Google\Cloud\Compute\V1\ConnectionDraining $var
     * @return $this
     */
    public function setConnectionDraining($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ConnectionDraining::class);
        $this->connection_draining = $var;

        return $this;
    }

    /**
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceConnectionTrackingPolicy|null
     */
    public function getConnectionTrackingPolicy()
    {
        return $this->connection_tracking_policy;
    }

    public function hasConnectionTrackingPolicy()
    {
        return isset($this->connection_tracking_policy);
    }

    public function clearConnectionTrackingPolicy()
    {
        unset($this->connection_tracking_policy);
    }

    /**
     * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceConnectionTrackingPolicy $var
     * @return $this
     */
    public function setConnectionTrackingPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceConnectionTrackingPolicy::class);
        $this->connection_tracking_policy = $var;

        return $this;
    }

    /**
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. 
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;</code>
     * @return \Google\Cloud\Compute\V1\ConsistentHashLoadBalancerSettings|null
     */
    public function getConsistentHash()
    {
        return $this->consistent_hash;
    }

    public function hasConsistentHash()
    {
        return isset($this->consistent_hash);
    }

    public function clearConsistentHash()
    {
        unset($this->consistent_hash);
    }

    /**
     * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED. 
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;</code>
     * @param \Google\Cloud\Compute\V1\ConsistentHashLoadBalancerSettings $var
     * @return $this
     */
    public function setConsistentHash($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ConsistentHashLoadBalancerSettings::class);
        $this->consistent_hash = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceCustomMetric custom_metrics = 429453813;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomMetrics()
    {
        return $this->custom_metrics;
    }

    /**
     * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceCustomMetric custom_metrics = 429453813;</code>
     * @param array<\Google\Cloud\Compute\V1\BackendServiceCustomMetric>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomMetrics($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\BackendServiceCustomMetric::class);
        $this->custom_metrics = $arr;

        return $this;
    }

    /**
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     *
     * Generated from protobuf field <code>repeated string custom_request_headers = 27977992;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomRequestHeaders()
    {
        return $this->custom_request_headers;
    }

    /**
     * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     *
     * Generated from protobuf field <code>repeated string custom_request_headers = 27977992;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomRequestHeaders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->custom_request_headers = $arr;

        return $this;
    }

    /**
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     *
     * Generated from protobuf field <code>repeated string custom_response_headers = 387539094;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomResponseHeaders()
    {
        return $this->custom_response_headers;
    }

    /**
     * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
     *
     * Generated from protobuf field <code>repeated string custom_response_headers = 387539094;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomResponseHeaders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->custom_response_headers = $arr;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     *
     * Generated from protobuf field <code>optional string edge_security_policy = 41036943;</code>
     * @return string
     */
    public function getEdgeSecurityPolicy()
    {
        return isset($this->edge_security_policy) ? $this->edge_security_policy : '';
    }

    public function hasEdgeSecurityPolicy()
    {
        return isset($this->edge_security_policy);
    }

    public function clearEdgeSecurityPolicy()
    {
        unset($this->edge_security_policy);
    }

    /**
     * [Output Only] The resource URL for the edge security policy associated with this backend service.
     *
     * Generated from protobuf field <code>optional string edge_security_policy = 41036943;</code>
     * @param string $var
     * @return $this
     */
    public function setEdgeSecurityPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->edge_security_policy = $var;

        return $this;
    }

    /**
     * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
     *
     * Generated from protobuf field <code>optional bool enable_c_d_n = 250733499;</code>
     * @return bool
     */
    public function getEnableCDN()
    {
        return isset($this->enable_c_d_n) ? $this->enable_c_d_n : false;
    }

    public function hasEnableCDN()
    {
        return isset($this->enable_c_d_n);
    }

    public function clearEnableCDN()
    {
        unset($this->enable_c_d_n);
    }

    /**
     * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
     *
     * Generated from protobuf field <code>optional bool enable_c_d_n = 250733499;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableCDN($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_c_d_n = $var;

        return $this;
    }

    /**
     * Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
     * Check the ExternalManagedMigrationState enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string external_managed_migration_state = 66947020;</code>
     * @return string
     */
    public function getExternalManagedMigrationState()
    {
        return isset($this->external_managed_migration_state) ? $this->external_managed_migration_state : '';
    }

    public function hasExternalManagedMigrationState()
    {
        return isset($this->external_managed_migration_state);
    }

    public function clearExternalManagedMigrationState()
    {
        unset($this->external_managed_migration_state);
    }

    /**
     * Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
     * Check the ExternalManagedMigrationState enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string external_managed_migration_state = 66947020;</code>
     * @param string $var
     * @return $this
     */
    public function setExternalManagedMigrationState($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_managed_migration_state = $var;

        return $this;
    }

    /**
     * Determines the fraction of requests that should be processed by the Global external Application Load Balancer. The value of this field must be in the range [0, 100]. Session affinity options will slightly affect this routing behavior, for more details, see: Session Affinity. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
     *
     * Generated from protobuf field <code>optional float external_managed_migration_testing_percentage = 507232462;</code>
     * @return float
     */
    public function getExternalManagedMigrationTestingPercentage()
    {
        return isset($this->external_managed_migration_testing_percentage) ? $this->external_managed_migration_testing_percentage : 0.0;
    }

    public function hasExternalManagedMigrationTestingPercentage()
    {
        return isset($this->external_managed_migration_testing_percentage);
    }

    public function clearExternalManagedMigrationTestingPercentage()
    {
        unset($this->external_managed_migration_testing_percentage);
    }

    /**
     * Determines the fraction of requests that should be processed by the Global external Application Load Balancer. The value of this field must be in the range [0, 100]. Session affinity options will slightly affect this routing behavior, for more details, see: Session Affinity. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
     *
     * Generated from protobuf field <code>optional float external_managed_migration_testing_percentage = 507232462;</code>
     * @param float $var
     * @return $this
     */
    public function setExternalManagedMigrationTestingPercentage($var)
    {
        GPBUtil::checkFloat($var);
        $this->external_managed_migration_testing_percentage = $var;

        return $this;
    }

    /**
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceFailoverPolicy|null
     */
    public function getFailoverPolicy()
    {
        return $this->failover_policy;
    }

    public function hasFailoverPolicy()
    {
        return isset($this->failover_policy);
    }

    public function clearFailoverPolicy()
    {
        unset($this->failover_policy);
    }

    /**
     * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceFailoverPolicy $var
     * @return $this
     */
    public function setFailoverPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceFailoverPolicy::class);
        $this->failover_policy = $var;

        return $this;
    }

    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     *
     * Generated from protobuf field <code>optional string fingerprint = 234678500;</code>
     * @return string
     */
    public function getFingerprint()
    {
        return isset($this->fingerprint) ? $this->fingerprint : '';
    }

    public function hasFingerprint()
    {
        return isset($this->fingerprint);
    }

    public function clearFingerprint()
    {
        unset($this->fingerprint);
    }

    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
     *
     * Generated from protobuf field <code>optional string fingerprint = 234678500;</code>
     * @param string $var
     * @return $this
     */
    public function setFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->fingerprint = $var;

        return $this;
    }

    /**
     * Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceHAPolicy ha_policy = 519879480;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceHAPolicy|null
     */
    public function getHaPolicy()
    {
        return $this->ha_policy;
    }

    public function hasHaPolicy()
    {
        return isset($this->ha_policy);
    }

    public function clearHaPolicy()
    {
        unset($this->ha_policy);
    }

    /**
     * Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceHAPolicy ha_policy = 519879480;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceHAPolicy $var
     * @return $this
     */
    public function setHaPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceHAPolicy::class);
        $this->ha_policy = $var;

        return $this;
    }

    /**
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>repeated string health_checks = 448370606;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHealthChecks()
    {
        return $this->health_checks;
    }

    /**
     * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>repeated string health_checks = 448370606;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHealthChecks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->health_checks = $arr;

        return $this;
    }

    /**
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceIAP|null
     */
    public function getIap()
    {
        return $this->iap;
    }

    public function hasIap()
    {
        return isset($this->iap);
    }

    public function clearIap()
    {
        unset($this->iap);
    }

    /**
     * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceIAP $var
     * @return $this
     */
    public function setIap($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceIAP::class);
        $this->iap = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
     * Check the IpAddressSelectionPolicy enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string ip_address_selection_policy = 77600840;</code>
     * @return string
     */
    public function getIpAddressSelectionPolicy()
    {
        return isset($this->ip_address_selection_policy) ? $this->ip_address_selection_policy : '';
    }

    public function hasIpAddressSelectionPolicy()
    {
        return isset($this->ip_address_selection_policy);
    }

    public function clearIpAddressSelectionPolicy()
    {
        unset($this->ip_address_selection_policy);
    }

    /**
     * Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
     * Check the IpAddressSelectionPolicy enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string ip_address_selection_policy = 77600840;</code>
     * @param string $var
     * @return $this
     */
    public function setIpAddressSelectionPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->ip_address_selection_policy = $var;

        return $this;
    }

    /**
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * [Output Only] Type of resource. Always compute#backendService for backend services.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string load_balancing_scheme = 363890244;</code>
     * @return string
     */
    public function getLoadBalancingScheme()
    {
        return isset($this->load_balancing_scheme) ? $this->load_balancing_scheme : '';
    }

    public function hasLoadBalancingScheme()
    {
        return isset($this->load_balancing_scheme);
    }

    public function clearLoadBalancingScheme()
    {
        unset($this->load_balancing_scheme);
    }

    /**
     * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
     * Check the LoadBalancingScheme enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string load_balancing_scheme = 363890244;</code>
     * @param string $var
     * @return $this
     */
    public function setLoadBalancingScheme($var)
    {
        GPBUtil::checkString($var, True);
        $this->load_balancing_scheme = $var;

        return $this;
    }

    /**
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLocalityLbPolicies()
    {
        return $this->locality_lb_policies;
    }

    /**
     * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;</code>
     * @param array<\Google\Cloud\Compute\V1\BackendServiceLocalityLoadBalancingPolicyConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLocalityLbPolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\BackendServiceLocalityLoadBalancingPolicyConfig::class);
        $this->locality_lb_policies = $arr;

        return $this;
    }

    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
     * Check the LocalityLbPolicy enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string locality_lb_policy = 131431487;</code>
     * @return string
     */
    public function getLocalityLbPolicy()
    {
        return isset($this->locality_lb_policy) ? $this->locality_lb_policy : '';
    }

    public function hasLocalityLbPolicy()
    {
        return isset($this->locality_lb_policy);
    }

    public function clearLocalityLbPolicy()
    {
        unset($this->locality_lb_policy);
    }

    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
     * Check the LocalityLbPolicy enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string locality_lb_policy = 131431487;</code>
     * @param string $var
     * @return $this
     */
    public function setLocalityLbPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->locality_lb_policy = $var;

        return $this;
    }

    /**
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceLogConfig|null
     */
    public function getLogConfig()
    {
        return $this->log_config;
    }

    public function hasLogConfig()
    {
        return isset($this->log_config);
    }

    public function clearLogConfig()
    {
        unset($this->log_config);
    }

    /**
     * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceLogConfig $var
     * @return $this
     */
    public function setLogConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceLogConfig::class);
        $this->log_config = $var;

        return $this;
    }

    /**
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     * @return \Google\Cloud\Compute\V1\Duration|null
     */
    public function getMaxStreamDuration()
    {
        return $this->max_stream_duration;
    }

    public function hasMaxStreamDuration()
    {
        return isset($this->max_stream_duration);
    }

    public function clearMaxStreamDuration()
    {
        unset($this->max_stream_duration);
    }

    /**
     * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
     * @param \Google\Cloud\Compute\V1\Duration $var
     * @return $this
     */
    public function setMaxStreamDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Duration::class);
        $this->max_stream_duration = $var;

        return $this;
    }

    /**
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     *
     * Generated from protobuf field <code>map<string, string> metadatas = 8514340;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadatas()
    {
        return $this->metadatas;
    }

    /**
     * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
     *
     * Generated from protobuf field <code>map<string, string> metadatas = 8514340;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadatas($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadatas = $arr;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
     *
     * Generated from protobuf field <code>optional string network = 232872494;</code>
     * @return string
     */
    public function getNetwork()
    {
        return isset($this->network) ? $this->network : '';
    }

    public function hasNetwork()
    {
        return isset($this->network);
    }

    public function clearNetwork()
    {
        unset($this->network);
    }

    /**
     * The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
     *
     * Generated from protobuf field <code>optional string network = 232872494;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
     * @return \Google\Cloud\Compute\V1\OutlierDetection|null
     */
    public function getOutlierDetection()
    {
        return $this->outlier_detection;
    }

    public function hasOutlierDetection()
    {
        return isset($this->outlier_detection);
    }

    public function clearOutlierDetection()
    {
        unset($this->outlier_detection);
    }

    /**
     * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
     * @param \Google\Cloud\Compute\V1\OutlierDetection $var
     * @return $this
     */
    public function setOutlierDetection($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\OutlierDetection::class);
        $this->outlier_detection = $var;

        return $this;
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceParams params = 78313862;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceParams|null
     */
    public function getParams()
    {
        return $this->params;
    }

    public function hasParams()
    {
        return isset($this->params);
    }

    public function clearParams()
    {
        unset($this->params);
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceParams params = 78313862;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceParams $var
     * @return $this
     */
    public function setParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceParams::class);
        $this->params = $var;

        return $this;
    }

    /**
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
     *
     * Generated from protobuf field <code>optional int32 port = 3446913;</code>
     * @return int
     */
    public function getPort()
    {
        return isset($this->port) ? $this->port : 0;
    }

    public function hasPort()
    {
        return isset($this->port);
    }

    public function clearPort()
    {
        unset($this->port);
    }

    /**
     * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
     *
     * Generated from protobuf field <code>optional int32 port = 3446913;</code>
     * @param int $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->port = $var;

        return $this;
    }

    /**
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     *
     * Generated from protobuf field <code>optional string port_name = 41534345;</code>
     * @return string
     */
    public function getPortName()
    {
        return isset($this->port_name) ? $this->port_name : '';
    }

    public function hasPortName()
    {
        return isset($this->port_name);
    }

    public function clearPortName()
    {
        unset($this->port_name);
    }

    /**
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
     *
     * Generated from protobuf field <code>optional string port_name = 41534345;</code>
     * @param string $var
     * @return $this
     */
    public function setPortName($var)
    {
        GPBUtil::checkString($var, True);
        $this->port_name = $var;

        return $this;
    }

    /**
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string protocol = 84577944;</code>
     * @return string
     */
    public function getProtocol()
    {
        return isset($this->protocol) ? $this->protocol : '';
    }

    public function hasProtocol()
    {
        return isset($this->protocol);
    }

    public function clearProtocol()
    {
        unset($this->protocol);
    }

    /**
     * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
     * Check the Protocol enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string protocol = 84577944;</code>
     * @param string $var
     * @return $this
     */
    public function setProtocol($var)
    {
        GPBUtil::checkString($var, True);
        $this->protocol = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : '';
    }

    public function hasRegion()
    {
        return isset($this->region);
    }

    public function clearRegion()
    {
        unset($this->region);
    }

    /**
     * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>optional string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * [Output Only] The resource URL for the security policy associated with this backend service.
     *
     * Generated from protobuf field <code>optional string security_policy = 171082513;</code>
     * @return string
     */
    public function getSecurityPolicy()
    {
        return isset($this->security_policy) ? $this->security_policy : '';
    }

    public function hasSecurityPolicy()
    {
        return isset($this->security_policy);
    }

    public function clearSecurityPolicy()
    {
        unset($this->security_policy);
    }

    /**
     * [Output Only] The resource URL for the security policy associated with this backend service.
     *
     * Generated from protobuf field <code>optional string security_policy = 171082513;</code>
     * @param string $var
     * @return $this
     */
    public function setSecurityPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->security_policy = $var;

        return $this;
    }

    /**
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
     * @return \Google\Cloud\Compute\V1\SecuritySettings|null
     */
    public function getSecuritySettings()
    {
        return $this->security_settings;
    }

    public function hasSecuritySettings()
    {
        return isset($this->security_settings);
    }

    public function clearSecuritySettings()
    {
        unset($this->security_settings);
    }

    /**
     * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
     * @param \Google\Cloud\Compute\V1\SecuritySettings $var
     * @return $this
     */
    public function setSecuritySettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\SecuritySettings::class);
        $this->security_settings = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     *
     * Generated from protobuf field <code>repeated string service_bindings = 133581016;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceBindings()
    {
        return $this->service_bindings;
    }

    /**
     * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
     *
     * Generated from protobuf field <code>repeated string service_bindings = 133581016;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceBindings($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->service_bindings = $arr;

        return $this;
    }

    /**
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     *
     * Generated from protobuf field <code>optional string service_lb_policy = 94848785;</code>
     * @return string
     */
    public function getServiceLbPolicy()
    {
        return isset($this->service_lb_policy) ? $this->service_lb_policy : '';
    }

    public function hasServiceLbPolicy()
    {
        return isset($this->service_lb_policy);
    }

    public function clearServiceLbPolicy()
    {
        unset($this->service_lb_policy);
    }

    /**
     * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
     *
     * Generated from protobuf field <code>optional string service_lb_policy = 94848785;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceLbPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_lb_policy = $var;

        return $this;
    }

    /**
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
     * Check the SessionAffinity enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string session_affinity = 463888561;</code>
     * @return string
     */
    public function getSessionAffinity()
    {
        return isset($this->session_affinity) ? $this->session_affinity : '';
    }

    public function hasSessionAffinity()
    {
        return isset($this->session_affinity);
    }

    public function clearSessionAffinity()
    {
        unset($this->session_affinity);
    }

    /**
     * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
     * Check the SessionAffinity enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string session_affinity = 463888561;</code>
     * @param string $var
     * @return $this
     */
    public function setSessionAffinity($var)
    {
        GPBUtil::checkString($var, True);
        $this->session_affinity = $var;

        return $this;
    }

    /**
     * Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceHttpCookie strong_session_affinity_cookie = 238195722;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceHttpCookie|null
     */
    public function getStrongSessionAffinityCookie()
    {
        return $this->strong_session_affinity_cookie;
    }

    public function hasStrongSessionAffinityCookie()
    {
        return isset($this->strong_session_affinity_cookie);
    }

    public function clearStrongSessionAffinityCookie()
    {
        unset($this->strong_session_affinity_cookie);
    }

    /**
     * Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceHttpCookie strong_session_affinity_cookie = 238195722;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceHttpCookie $var
     * @return $this
     */
    public function setStrongSessionAffinityCookie($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceHttpCookie::class);
        $this->strong_session_affinity_cookie = $var;

        return $this;
    }

    /**
     * subsetting cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
     * @return \Google\Cloud\Compute\V1\Subsetting|null
     */
    public function getSubsetting()
    {
        return $this->subsetting;
    }

    public function hasSubsetting()
    {
        return isset($this->subsetting);
    }

    public function clearSubsetting()
    {
        unset($this->subsetting);
    }

    /**
     * subsetting cannot be specified with haPolicy.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
     * @param \Google\Cloud\Compute\V1\Subsetting $var
     * @return $this
     */
    public function setSubsetting($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Subsetting::class);
        $this->subsetting = $var;

        return $this;
    }

    /**
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
     *
     * Generated from protobuf field <code>optional int32 timeout_sec = 79994995;</code>
     * @return int
     */
    public function getTimeoutSec()
    {
        return isset($this->timeout_sec) ? $this->timeout_sec : 0;
    }

    public function hasTimeoutSec()
    {
        return isset($this->timeout_sec);
    }

    public function clearTimeoutSec()
    {
        unset($this->timeout_sec);
    }

    /**
     * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
     *
     * Generated from protobuf field <code>optional int32 timeout_sec = 79994995;</code>
     * @param int $var
     * @return $this
     */
    public function setTimeoutSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->timeout_sec = $var;

        return $this;
    }

    /**
     * Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceTlsSettings tls_settings = 81794791;</code>
     * @return \Google\Cloud\Compute\V1\BackendServiceTlsSettings|null
     */
    public function getTlsSettings()
    {
        return $this->tls_settings;
    }

    public function hasTlsSettings()
    {
        return isset($this->tls_settings);
    }

    public function clearTlsSettings()
    {
        unset($this->tls_settings);
    }

    /**
     * Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.BackendServiceTlsSettings tls_settings = 81794791;</code>
     * @param \Google\Cloud\Compute\V1\BackendServiceTlsSettings $var
     * @return $this
     */
    public function setTlsSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\BackendServiceTlsSettings::class);
        $this->tls_settings = $var;

        return $this;
    }

    /**
     * [Output Only] List of resources referencing given backend service.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getUsedBy()
    {
        return $this->used_by;
    }

    /**
     * [Output Only] List of resources referencing given backend service.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code>
     * @param array<\Google\Cloud\Compute\V1\BackendServiceUsedBy>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setUsedBy($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\BackendServiceUsedBy::class);
        $this->used_by = $arr;

        return $this;
    }

}

