<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.AdvancedMachineFeatures</code>
 */
class AdvancedMachineFeatures extends \Google\Protobuf\Internal\Message
{
    /**
     * Whether to enable nested virtualization or not (default is false).
     *
     * Generated from protobuf field <code>optional bool enable_nested_virtualization = 16639365;</code>
     */
    private $enable_nested_virtualization = null;
    /**
     * Whether to enable UEFI networking for instance creation.
     *
     * Generated from protobuf field <code>optional bool enable_uefi_networking = 334485668;</code>
     */
    private $enable_uefi_networking = null;
    /**
     * Type of Performance Monitoring Unit requested on instance.
     * Check the PerformanceMonitoringUnit enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string performance_monitoring_unit = 533618956;</code>
     */
    private $performance_monitoring_unit = null;
    /**
     * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *
     * Generated from protobuf field <code>optional int32 threads_per_core = 352611671;</code>
     */
    private $threads_per_core = null;
    /**
     * Turbo frequency mode to use for the instance. Supported modes include: * ALL_CORE_MAX Using empty string or not setting this field will use the platform-specific default turbo mode.
     *
     * Generated from protobuf field <code>optional string turbo_mode = 432965412;</code>
     */
    private $turbo_mode = null;
    /**
     * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance's nominal CPU count and the underlying platform's SMT width.
     *
     * Generated from protobuf field <code>optional int32 visible_core_count = 193198684;</code>
     */
    private $visible_core_count = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enable_nested_virtualization
     *           Whether to enable nested virtualization or not (default is false).
     *     @type bool $enable_uefi_networking
     *           Whether to enable UEFI networking for instance creation.
     *     @type string $performance_monitoring_unit
     *           Type of Performance Monitoring Unit requested on instance.
     *           Check the PerformanceMonitoringUnit enum for the list of possible values.
     *     @type int $threads_per_core
     *           The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *     @type string $turbo_mode
     *           Turbo frequency mode to use for the instance. Supported modes include: * ALL_CORE_MAX Using empty string or not setting this field will use the platform-specific default turbo mode.
     *     @type int $visible_core_count
     *           The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance's nominal CPU count and the underlying platform's SMT width.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Whether to enable nested virtualization or not (default is false).
     *
     * Generated from protobuf field <code>optional bool enable_nested_virtualization = 16639365;</code>
     * @return bool
     */
    public function getEnableNestedVirtualization()
    {
        return isset($this->enable_nested_virtualization) ? $this->enable_nested_virtualization : false;
    }

    public function hasEnableNestedVirtualization()
    {
        return isset($this->enable_nested_virtualization);
    }

    public function clearEnableNestedVirtualization()
    {
        unset($this->enable_nested_virtualization);
    }

    /**
     * Whether to enable nested virtualization or not (default is false).
     *
     * Generated from protobuf field <code>optional bool enable_nested_virtualization = 16639365;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableNestedVirtualization($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_nested_virtualization = $var;

        return $this;
    }

    /**
     * Whether to enable UEFI networking for instance creation.
     *
     * Generated from protobuf field <code>optional bool enable_uefi_networking = 334485668;</code>
     * @return bool
     */
    public function getEnableUefiNetworking()
    {
        return isset($this->enable_uefi_networking) ? $this->enable_uefi_networking : false;
    }

    public function hasEnableUefiNetworking()
    {
        return isset($this->enable_uefi_networking);
    }

    public function clearEnableUefiNetworking()
    {
        unset($this->enable_uefi_networking);
    }

    /**
     * Whether to enable UEFI networking for instance creation.
     *
     * Generated from protobuf field <code>optional bool enable_uefi_networking = 334485668;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableUefiNetworking($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_uefi_networking = $var;

        return $this;
    }

    /**
     * Type of Performance Monitoring Unit requested on instance.
     * Check the PerformanceMonitoringUnit enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string performance_monitoring_unit = 533618956;</code>
     * @return string
     */
    public function getPerformanceMonitoringUnit()
    {
        return isset($this->performance_monitoring_unit) ? $this->performance_monitoring_unit : '';
    }

    public function hasPerformanceMonitoringUnit()
    {
        return isset($this->performance_monitoring_unit);
    }

    public function clearPerformanceMonitoringUnit()
    {
        unset($this->performance_monitoring_unit);
    }

    /**
     * Type of Performance Monitoring Unit requested on instance.
     * Check the PerformanceMonitoringUnit enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string performance_monitoring_unit = 533618956;</code>
     * @param string $var
     * @return $this
     */
    public function setPerformanceMonitoringUnit($var)
    {
        GPBUtil::checkString($var, True);
        $this->performance_monitoring_unit = $var;

        return $this;
    }

    /**
     * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *
     * Generated from protobuf field <code>optional int32 threads_per_core = 352611671;</code>
     * @return int
     */
    public function getThreadsPerCore()
    {
        return isset($this->threads_per_core) ? $this->threads_per_core : 0;
    }

    public function hasThreadsPerCore()
    {
        return isset($this->threads_per_core);
    }

    public function clearThreadsPerCore()
    {
        unset($this->threads_per_core);
    }

    /**
     * The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *
     * Generated from protobuf field <code>optional int32 threads_per_core = 352611671;</code>
     * @param int $var
     * @return $this
     */
    public function setThreadsPerCore($var)
    {
        GPBUtil::checkInt32($var);
        $this->threads_per_core = $var;

        return $this;
    }

    /**
     * Turbo frequency mode to use for the instance. Supported modes include: * ALL_CORE_MAX Using empty string or not setting this field will use the platform-specific default turbo mode.
     *
     * Generated from protobuf field <code>optional string turbo_mode = 432965412;</code>
     * @return string
     */
    public function getTurboMode()
    {
        return isset($this->turbo_mode) ? $this->turbo_mode : '';
    }

    public function hasTurboMode()
    {
        return isset($this->turbo_mode);
    }

    public function clearTurboMode()
    {
        unset($this->turbo_mode);
    }

    /**
     * Turbo frequency mode to use for the instance. Supported modes include: * ALL_CORE_MAX Using empty string or not setting this field will use the platform-specific default turbo mode.
     *
     * Generated from protobuf field <code>optional string turbo_mode = 432965412;</code>
     * @param string $var
     * @return $this
     */
    public function setTurboMode($var)
    {
        GPBUtil::checkString($var, True);
        $this->turbo_mode = $var;

        return $this;
    }

    /**
     * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance's nominal CPU count and the underlying platform's SMT width.
     *
     * Generated from protobuf field <code>optional int32 visible_core_count = 193198684;</code>
     * @return int
     */
    public function getVisibleCoreCount()
    {
        return isset($this->visible_core_count) ? $this->visible_core_count : 0;
    }

    public function hasVisibleCoreCount()
    {
        return isset($this->visible_core_count);
    }

    public function clearVisibleCoreCount()
    {
        unset($this->visible_core_count);
    }

    /**
     * The number of physical cores to expose to an instance. Multiply by the number of threads per core to compute the total number of virtual CPUs to expose to the instance. If unset, the number of cores is inferred from the instance's nominal CPU count and the underlying platform's SMT width.
     *
     * Generated from protobuf field <code>optional int32 visible_core_count = 193198684;</code>
     * @param int $var
     * @return $this
     */
    public function setVisibleCoreCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->visible_core_count = $var;

        return $this;
    }

}

