<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/apihub/v1/plugin_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ApiHub\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ApiHub\V1\CreatePluginInstanceRequest;
use Google\Cloud\ApiHub\V1\CreatePluginRequest;
use Google\Cloud\ApiHub\V1\DeletePluginInstanceRequest;
use Google\Cloud\ApiHub\V1\DeletePluginRequest;
use Google\Cloud\ApiHub\V1\DisablePluginInstanceActionRequest;
use Google\Cloud\ApiHub\V1\DisablePluginRequest;
use Google\Cloud\ApiHub\V1\EnablePluginInstanceActionRequest;
use Google\Cloud\ApiHub\V1\EnablePluginRequest;
use Google\Cloud\ApiHub\V1\ExecutePluginInstanceActionRequest;
use Google\Cloud\ApiHub\V1\GetPluginInstanceRequest;
use Google\Cloud\ApiHub\V1\GetPluginRequest;
use Google\Cloud\ApiHub\V1\ListPluginInstancesRequest;
use Google\Cloud\ApiHub\V1\ListPluginsRequest;
use Google\Cloud\ApiHub\V1\Plugin;
use Google\Cloud\ApiHub\V1\PluginInstance;
use Google\Cloud\ApiHub\V1\UpdatePluginInstanceRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: This service is used for managing plugins inside the API Hub.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Plugin> createPluginAsync(CreatePluginRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createPluginInstanceAsync(CreatePluginInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deletePluginAsync(DeletePluginRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deletePluginInstanceAsync(DeletePluginInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Plugin> disablePluginAsync(DisablePluginRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> disablePluginInstanceActionAsync(DisablePluginInstanceActionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Plugin> enablePluginAsync(EnablePluginRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> enablePluginInstanceActionAsync(EnablePluginInstanceActionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> executePluginInstanceActionAsync(ExecutePluginInstanceActionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Plugin> getPluginAsync(GetPluginRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PluginInstance> getPluginInstanceAsync(GetPluginInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPluginInstancesAsync(ListPluginInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listPluginsAsync(ListPluginsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PluginInstance> updatePluginInstanceAsync(UpdatePluginInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ApiHubPluginClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.apihub.v1.ApiHubPlugin';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'apihub.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'apihub.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/api_hub_plugin_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/api_hub_plugin_descriptor_config.php',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
                'useJwtAccessWithScope' => false,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/api_hub_plugin_rest_client_config.php',
                ],
            ],
        ];
    }

    /** Implements GapicClientTrait::defaultTransport. */
    private static function defaultTransport()
    {
        return 'rest';
    }

    /** Implements ClientOptionsTrait::supportedTransports. */
    private static function supportedTransports()
    {
        return ['rest'];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a attribute
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $attribute
     *
     * @return string The formatted attribute resource.
     */
    public static function attributeName(string $project, string $location, string $attribute): string
    {
        return self::getPathTemplate('attribute')->render([
            'project' => $project,
            'location' => $location,
            'attribute' => $attribute,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a plugin
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $plugin
     *
     * @return string The formatted plugin resource.
     */
    public static function pluginName(string $project, string $location, string $plugin): string
    {
        return self::getPathTemplate('plugin')->render([
            'project' => $project,
            'location' => $location,
            'plugin' => $plugin,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * plugin_instance resource.
     *
     * @param string $project
     * @param string $location
     * @param string $plugin
     * @param string $instance
     *
     * @return string The formatted plugin_instance resource.
     */
    public static function pluginInstanceName(
        string $project,
        string $location,
        string $plugin,
        string $instance
    ): string {
        return self::getPathTemplate('pluginInstance')->render([
            'project' => $project,
            'location' => $location,
            'plugin' => $plugin,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_account resource.
     *
     * @param string $project
     * @param string $serviceAccount
     *
     * @return string The formatted service_account resource.
     */
    public static function serviceAccountName(string $project, string $serviceAccount): string
    {
        return self::getPathTemplate('serviceAccount')->render([
            'project' => $project,
            'service_account' => $serviceAccount,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - attribute: projects/{project}/locations/{location}/attributes/{attribute}
     * - location: projects/{project}/locations/{location}
     * - plugin: projects/{project}/locations/{location}/plugins/{plugin}
     * - pluginInstance: projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}
     * - serviceAccount: projects/{project}/serviceAccounts/{service_account}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'apihub.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. At the moment, supports only
     *           `rest`. *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\RestTransport::build()} method for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create an API Hub plugin resource in the API hub.
     * Once a plugin is created, it can be used to create plugin instances.
     *
     * The async variant is {@see ApiHubPluginClient::createPluginAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/create_plugin.php
     *
     * @param CreatePluginRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Plugin
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPlugin(CreatePluginRequest $request, array $callOptions = []): Plugin
    {
        return $this->startApiCall('CreatePlugin', $request, $callOptions)->wait();
    }

    /**
     * Creates a Plugin instance in the API hub.
     *
     * The async variant is {@see ApiHubPluginClient::createPluginInstanceAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/create_plugin_instance.php
     *
     * @param CreatePluginInstanceRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPluginInstance(
        CreatePluginInstanceRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreatePluginInstance', $request, $callOptions)->wait();
    }

    /**
     * Delete a Plugin in API hub.
     * Note, only user owned plugins can be deleted via this method.
     *
     * The async variant is {@see ApiHubPluginClient::deletePluginAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/delete_plugin.php
     *
     * @param DeletePluginRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePlugin(DeletePluginRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePlugin', $request, $callOptions)->wait();
    }

    /**
     * Deletes a plugin instance in the API hub.
     *
     * The async variant is {@see ApiHubPluginClient::deletePluginInstanceAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/delete_plugin_instance.php
     *
     * @param DeletePluginInstanceRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePluginInstance(
        DeletePluginInstanceRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeletePluginInstance', $request, $callOptions)->wait();
    }

    /**
     * Disables a plugin.
     * The `state` of the plugin after disabling is `DISABLED`
     *
     * The async variant is {@see ApiHubPluginClient::disablePluginAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/disable_plugin.php
     *
     * @param DisablePluginRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Plugin
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function disablePlugin(DisablePluginRequest $request, array $callOptions = []): Plugin
    {
        return $this->startApiCall('DisablePlugin', $request, $callOptions)->wait();
    }

    /**
     * Disables a plugin instance in the API hub.
     *
     * The async variant is
     * {@see ApiHubPluginClient::disablePluginInstanceActionAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/disable_plugin_instance_action.php
     *
     * @param DisablePluginInstanceActionRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function disablePluginInstanceAction(
        DisablePluginInstanceActionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DisablePluginInstanceAction', $request, $callOptions)->wait();
    }

    /**
     * Enables a plugin.
     * The `state` of the plugin after enabling is `ENABLED`
     *
     * The async variant is {@see ApiHubPluginClient::enablePluginAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/enable_plugin.php
     *
     * @param EnablePluginRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Plugin
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enablePlugin(EnablePluginRequest $request, array $callOptions = []): Plugin
    {
        return $this->startApiCall('EnablePlugin', $request, $callOptions)->wait();
    }

    /**
     * Enables a plugin instance in the API hub.
     *
     * The async variant is
     * {@see ApiHubPluginClient::enablePluginInstanceActionAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/enable_plugin_instance_action.php
     *
     * @param EnablePluginInstanceActionRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enablePluginInstanceAction(
        EnablePluginInstanceActionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('EnablePluginInstanceAction', $request, $callOptions)->wait();
    }

    /**
     * Executes a plugin instance in the API hub.
     *
     * The async variant is
     * {@see ApiHubPluginClient::executePluginInstanceActionAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/execute_plugin_instance_action.php
     *
     * @param ExecutePluginInstanceActionRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function executePluginInstanceAction(
        ExecutePluginInstanceActionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ExecutePluginInstanceAction', $request, $callOptions)->wait();
    }

    /**
     * Get an API Hub plugin.
     *
     * The async variant is {@see ApiHubPluginClient::getPluginAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/get_plugin.php
     *
     * @param GetPluginRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Plugin
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPlugin(GetPluginRequest $request, array $callOptions = []): Plugin
    {
        return $this->startApiCall('GetPlugin', $request, $callOptions)->wait();
    }

    /**
     * Get an API Hub plugin instance.
     *
     * The async variant is {@see ApiHubPluginClient::getPluginInstanceAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/get_plugin_instance.php
     *
     * @param GetPluginInstanceRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PluginInstance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPluginInstance(GetPluginInstanceRequest $request, array $callOptions = []): PluginInstance
    {
        return $this->startApiCall('GetPluginInstance', $request, $callOptions)->wait();
    }

    /**
     * List all the plugins in a given project and location.
     * `-` can be used as wildcard value for {plugin_id}
     *
     * The async variant is {@see ApiHubPluginClient::listPluginInstancesAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/list_plugin_instances.php
     *
     * @param ListPluginInstancesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPluginInstances(ListPluginInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPluginInstances', $request, $callOptions);
    }

    /**
     * List all the plugins in a given project and location.
     *
     * The async variant is {@see ApiHubPluginClient::listPluginsAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/list_plugins.php
     *
     * @param ListPluginsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPlugins(ListPluginsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPlugins', $request, $callOptions);
    }

    /**
     * Updates a plugin instance in the API hub.
     * The following fields in the
     * [plugin_instance][google.cloud.apihub.v1.PluginInstance] can be updated
     * currently:
     *
     * * [display_name][google.cloud.apihub.v1.PluginInstance.display_name]
     * * [schedule_cron_expression][PluginInstance.actions.schedule_cron_expression]
     *
     * The
     * [update_mask][google.cloud.apihub.v1.UpdatePluginInstanceRequest.update_mask]
     * should be used to specify the fields being updated.
     *
     * To update the
     * [auth_config][google.cloud.apihub.v1.PluginInstance.auth_config] and
     * [additional_config][google.cloud.apihub.v1.PluginInstance.additional_config]
     * of the plugin instance, use the
     * [ApplyPluginInstanceConfig][google.cloud.apihub.v1.ApiHubPlugin.ApplyPluginInstanceConfig]
     * method.
     *
     * The async variant is {@see ApiHubPluginClient::updatePluginInstanceAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/update_plugin_instance.php
     *
     * @param UpdatePluginInstanceRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PluginInstance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePluginInstance(UpdatePluginInstanceRequest $request, array $callOptions = []): PluginInstance
    {
        return $this->startApiCall('UpdatePluginInstance', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ApiHubPluginClient::getLocationAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ApiHubPluginClient::listLocationsAsync()} .
     *
     * @example samples/V1/ApiHubPluginClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
