<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/apihub/v1/apihub_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ApiHub\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ApiHub\V1\Api;
use Google\Cloud\ApiHub\V1\ApiOperation;
use Google\Cloud\ApiHub\V1\Attribute;
use Google\Cloud\ApiHub\V1\CreateApiOperationRequest;
use Google\Cloud\ApiHub\V1\CreateApiRequest;
use Google\Cloud\ApiHub\V1\CreateAttributeRequest;
use Google\Cloud\ApiHub\V1\CreateDeploymentRequest;
use Google\Cloud\ApiHub\V1\CreateExternalApiRequest;
use Google\Cloud\ApiHub\V1\CreateSpecRequest;
use Google\Cloud\ApiHub\V1\CreateVersionRequest;
use Google\Cloud\ApiHub\V1\Definition;
use Google\Cloud\ApiHub\V1\DeleteApiOperationRequest;
use Google\Cloud\ApiHub\V1\DeleteApiRequest;
use Google\Cloud\ApiHub\V1\DeleteAttributeRequest;
use Google\Cloud\ApiHub\V1\DeleteDeploymentRequest;
use Google\Cloud\ApiHub\V1\DeleteExternalApiRequest;
use Google\Cloud\ApiHub\V1\DeleteSpecRequest;
use Google\Cloud\ApiHub\V1\DeleteVersionRequest;
use Google\Cloud\ApiHub\V1\Deployment;
use Google\Cloud\ApiHub\V1\ExternalApi;
use Google\Cloud\ApiHub\V1\GetApiOperationRequest;
use Google\Cloud\ApiHub\V1\GetApiRequest;
use Google\Cloud\ApiHub\V1\GetAttributeRequest;
use Google\Cloud\ApiHub\V1\GetDefinitionRequest;
use Google\Cloud\ApiHub\V1\GetDeploymentRequest;
use Google\Cloud\ApiHub\V1\GetExternalApiRequest;
use Google\Cloud\ApiHub\V1\GetSpecContentsRequest;
use Google\Cloud\ApiHub\V1\GetSpecRequest;
use Google\Cloud\ApiHub\V1\GetVersionRequest;
use Google\Cloud\ApiHub\V1\ListApiOperationsRequest;
use Google\Cloud\ApiHub\V1\ListApisRequest;
use Google\Cloud\ApiHub\V1\ListAttributesRequest;
use Google\Cloud\ApiHub\V1\ListDeploymentsRequest;
use Google\Cloud\ApiHub\V1\ListExternalApisRequest;
use Google\Cloud\ApiHub\V1\ListSpecsRequest;
use Google\Cloud\ApiHub\V1\ListVersionsRequest;
use Google\Cloud\ApiHub\V1\SearchResourcesRequest;
use Google\Cloud\ApiHub\V1\Spec;
use Google\Cloud\ApiHub\V1\SpecContents;
use Google\Cloud\ApiHub\V1\UpdateApiOperationRequest;
use Google\Cloud\ApiHub\V1\UpdateApiRequest;
use Google\Cloud\ApiHub\V1\UpdateAttributeRequest;
use Google\Cloud\ApiHub\V1\UpdateDeploymentRequest;
use Google\Cloud\ApiHub\V1\UpdateExternalApiRequest;
use Google\Cloud\ApiHub\V1\UpdateSpecRequest;
use Google\Cloud\ApiHub\V1\UpdateVersionRequest;
use Google\Cloud\ApiHub\V1\Version;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: This service provides all methods related to the API hub.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Api> createApiAsync(CreateApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiOperation> createApiOperationAsync(CreateApiOperationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Attribute> createAttributeAsync(CreateAttributeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Deployment> createDeploymentAsync(CreateDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ExternalApi> createExternalApiAsync(CreateExternalApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Spec> createSpecAsync(CreateSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Version> createVersionAsync(CreateVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteApiAsync(DeleteApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteApiOperationAsync(DeleteApiOperationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAttributeAsync(DeleteAttributeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteDeploymentAsync(DeleteDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteExternalApiAsync(DeleteExternalApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSpecAsync(DeleteSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteVersionAsync(DeleteVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Api> getApiAsync(GetApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiOperation> getApiOperationAsync(GetApiOperationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Attribute> getAttributeAsync(GetAttributeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Definition> getDefinitionAsync(GetDefinitionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Deployment> getDeploymentAsync(GetDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ExternalApi> getExternalApiAsync(GetExternalApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Spec> getSpecAsync(GetSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SpecContents> getSpecContentsAsync(GetSpecContentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Version> getVersionAsync(GetVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApiOperationsAsync(ListApiOperationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApisAsync(ListApisRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAttributesAsync(ListAttributesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDeploymentsAsync(ListDeploymentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listExternalApisAsync(ListExternalApisRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSpecsAsync(ListSpecsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listVersionsAsync(ListVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchResourcesAsync(SearchResourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Api> updateApiAsync(UpdateApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ApiOperation> updateApiOperationAsync(UpdateApiOperationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Attribute> updateAttributeAsync(UpdateAttributeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Deployment> updateDeploymentAsync(UpdateDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ExternalApi> updateExternalApiAsync(UpdateExternalApiRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Spec> updateSpecAsync(UpdateSpecRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Version> updateVersionAsync(UpdateVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ApiHubClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.apihub.v1.ApiHub';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'apihub.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'apihub.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/api_hub_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/api_hub_descriptor_config.php',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
                'useJwtAccessWithScope' => false,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/api_hub_rest_client_config.php',
                ],
            ],
        ];
    }

    /** Implements GapicClientTrait::defaultTransport. */
    private static function defaultTransport()
    {
        return 'rest';
    }

    /** Implements ClientOptionsTrait::supportedTransports. */
    private static function supportedTransports()
    {
        return ['rest'];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a api
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     *
     * @return string The formatted api resource.
     */
    public static function apiName(string $project, string $location, string $api): string
    {
        return self::getPathTemplate('api')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * api_operation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $operation
     *
     * @return string The formatted api_operation resource.
     */
    public static function apiOperationName(
        string $project,
        string $location,
        string $api,
        string $version,
        string $operation
    ): string {
        return self::getPathTemplate('apiOperation')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
            'operation' => $operation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a attribute
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $attribute
     *
     * @return string The formatted attribute resource.
     */
    public static function attributeName(string $project, string $location, string $attribute): string
    {
        return self::getPathTemplate('attribute')->render([
            'project' => $project,
            'location' => $location,
            'attribute' => $attribute,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a definition
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $definition
     *
     * @return string The formatted definition resource.
     */
    public static function definitionName(
        string $project,
        string $location,
        string $api,
        string $version,
        string $definition
    ): string {
        return self::getPathTemplate('definition')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
            'definition' => $definition,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a deployment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $deployment
     *
     * @return string The formatted deployment resource.
     */
    public static function deploymentName(string $project, string $location, string $deployment): string
    {
        return self::getPathTemplate('deployment')->render([
            'project' => $project,
            'location' => $location,
            'deployment' => $deployment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a external_api
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $externalApi
     *
     * @return string The formatted external_api resource.
     */
    public static function externalApiName(string $project, string $location, string $externalApi): string
    {
        return self::getPathTemplate('externalApi')->render([
            'project' => $project,
            'location' => $location,
            'external_api' => $externalApi,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * plugin_instance resource.
     *
     * @param string $project
     * @param string $location
     * @param string $plugin
     * @param string $instance
     *
     * @return string The formatted plugin_instance resource.
     */
    public static function pluginInstanceName(
        string $project,
        string $location,
        string $plugin,
        string $instance
    ): string {
        return self::getPathTemplate('pluginInstance')->render([
            'project' => $project,
            'location' => $location,
            'plugin' => $plugin,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a spec
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     * @param string $spec
     *
     * @return string The formatted spec resource.
     */
    public static function specName(
        string $project,
        string $location,
        string $api,
        string $version,
        string $spec
    ): string {
        return self::getPathTemplate('spec')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
            'spec' => $spec,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $api
     * @param string $version
     *
     * @return string The formatted version resource.
     */
    public static function versionName(string $project, string $location, string $api, string $version): string
    {
        return self::getPathTemplate('version')->render([
            'project' => $project,
            'location' => $location,
            'api' => $api,
            'version' => $version,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - api: projects/{project}/locations/{location}/apis/{api}
     * - apiOperation: projects/{project}/locations/{location}/apis/{api}/versions/{version}/operations/{operation}
     * - attribute: projects/{project}/locations/{location}/attributes/{attribute}
     * - definition: projects/{project}/locations/{location}/apis/{api}/versions/{version}/definitions/{definition}
     * - deployment: projects/{project}/locations/{location}/deployments/{deployment}
     * - externalApi: projects/{project}/locations/{location}/externalApis/{external_api}
     * - location: projects/{project}/locations/{location}
     * - pluginInstance: projects/{project}/locations/{location}/plugins/{plugin}/instances/{instance}
     * - spec: projects/{project}/locations/{location}/apis/{api}/versions/{version}/specs/{spec}
     * - version: projects/{project}/locations/{location}/apis/{api}/versions/{version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'apihub.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. At the moment, supports only
     *           `rest`. *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\RestTransport::build()} method for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create an API resource in the API hub.
     * Once an API resource is created, versions can be added to it.
     *
     * The async variant is {@see ApiHubClient::createApiAsync()} .
     *
     * @example samples/V1/ApiHubClient/create_api.php
     *
     * @param CreateApiRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Api
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createApi(CreateApiRequest $request, array $callOptions = []): Api
    {
        return $this->startApiCall('CreateApi', $request, $callOptions)->wait();
    }

    /**
     * Create an apiOperation in an API version.
     * An apiOperation can be created only if the version has no apiOperations
     * which were created by parsing a spec.
     *
     * The async variant is {@see ApiHubClient::createApiOperationAsync()} .
     *
     * @example samples/V1/ApiHubClient/create_api_operation.php
     *
     * @param CreateApiOperationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiOperation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createApiOperation(CreateApiOperationRequest $request, array $callOptions = []): ApiOperation
    {
        return $this->startApiCall('CreateApiOperation', $request, $callOptions)->wait();
    }

    /**
     * Create a user defined attribute.
     *
     * Certain pre defined attributes are already created by the API hub. These
     * attributes will have type as `SYSTEM_DEFINED` and can be listed via
     * [ListAttributes][google.cloud.apihub.v1.ApiHub.ListAttributes] method.
     * Allowed values for the same can be updated via
     * [UpdateAttribute][google.cloud.apihub.v1.ApiHub.UpdateAttribute] method.
     *
     * The async variant is {@see ApiHubClient::createAttributeAsync()} .
     *
     * @example samples/V1/ApiHubClient/create_attribute.php
     *
     * @param CreateAttributeRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Attribute
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAttribute(CreateAttributeRequest $request, array $callOptions = []): Attribute
    {
        return $this->startApiCall('CreateAttribute', $request, $callOptions)->wait();
    }

    /**
     * Create a deployment resource in the API hub.
     * Once a deployment resource is created, it can be associated with API
     * versions.
     *
     * The async variant is {@see ApiHubClient::createDeploymentAsync()} .
     *
     * @example samples/V1/ApiHubClient/create_deployment.php
     *
     * @param CreateDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDeployment(CreateDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('CreateDeployment', $request, $callOptions)->wait();
    }

    /**
     * Create an External API resource in the API hub.
     *
     * The async variant is {@see ApiHubClient::createExternalApiAsync()} .
     *
     * @example samples/V1/ApiHubClient/create_external_api.php
     *
     * @param CreateExternalApiRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExternalApi
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createExternalApi(CreateExternalApiRequest $request, array $callOptions = []): ExternalApi
    {
        return $this->startApiCall('CreateExternalApi', $request, $callOptions)->wait();
    }

    /**
     * Add a spec to an API version in the API hub.
     * Multiple specs can be added to an API version.
     * Note, while adding a spec, at least one of `contents` or `source_uri` must
     * be provided. If `contents` is provided, then `spec_type` must also be
     * provided.
     *
     * On adding a spec with contents to the version, the operations present in it
     * will be added to the version.Note that the file contents in the spec should
     * be of the same type as defined in the
     * `projects/{project}/locations/{location}/attributes/system-spec-type`
     * attribute associated with spec resource. Note that specs of various types
     * can be uploaded, however parsing of details is supported for OpenAPI spec
     * currently.
     *
     * In order to access the information parsed from the spec, use the
     * [GetSpec][google.cloud.apihub.v1.ApiHub.GetSpec] method.
     * In order to access the raw contents for a particular spec, use the
     * [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method.
     * In order to access the operations parsed from the spec, use the
     * [ListAPIOperations][google.cloud.apihub.v1.ApiHub.ListApiOperations]
     * method.
     *
     * The async variant is {@see ApiHubClient::createSpecAsync()} .
     *
     * @example samples/V1/ApiHubClient/create_spec.php
     *
     * @param CreateSpecRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Spec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSpec(CreateSpecRequest $request, array $callOptions = []): Spec
    {
        return $this->startApiCall('CreateSpec', $request, $callOptions)->wait();
    }

    /**
     * Create an API version for an API resource in the API hub.
     *
     * The async variant is {@see ApiHubClient::createVersionAsync()} .
     *
     * @example samples/V1/ApiHubClient/create_version.php
     *
     * @param CreateVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Version
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createVersion(CreateVersionRequest $request, array $callOptions = []): Version
    {
        return $this->startApiCall('CreateVersion', $request, $callOptions)->wait();
    }

    /**
     * Delete an API resource in the API hub. API can only be deleted if all
     * underlying versions are deleted.
     *
     * The async variant is {@see ApiHubClient::deleteApiAsync()} .
     *
     * @example samples/V1/ApiHubClient/delete_api.php
     *
     * @param DeleteApiRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApi(DeleteApiRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteApi', $request, $callOptions)->wait();
    }

    /**
     * Delete an operation in an API version and we can delete only the
     * operations created via create API. If the operation was created by parsing
     * the spec, then it can be deleted by editing or deleting the spec.
     *
     * The async variant is {@see ApiHubClient::deleteApiOperationAsync()} .
     *
     * @example samples/V1/ApiHubClient/delete_api_operation.php
     *
     * @param DeleteApiOperationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApiOperation(DeleteApiOperationRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteApiOperation', $request, $callOptions)->wait();
    }

    /**
     * Delete an attribute.
     *
     * Note: System defined attributes cannot be deleted. All
     * associations of the attribute being deleted with any API hub resource will
     * also get deleted.
     *
     * The async variant is {@see ApiHubClient::deleteAttributeAsync()} .
     *
     * @example samples/V1/ApiHubClient/delete_attribute.php
     *
     * @param DeleteAttributeRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAttribute(DeleteAttributeRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAttribute', $request, $callOptions)->wait();
    }

    /**
     * Delete a deployment resource in the API hub.
     *
     * The async variant is {@see ApiHubClient::deleteDeploymentAsync()} .
     *
     * @example samples/V1/ApiHubClient/delete_deployment.php
     *
     * @param DeleteDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDeployment(DeleteDeploymentRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteDeployment', $request, $callOptions)->wait();
    }

    /**
     * Delete an External API resource in the API hub.
     *
     * The async variant is {@see ApiHubClient::deleteExternalApiAsync()} .
     *
     * @example samples/V1/ApiHubClient/delete_external_api.php
     *
     * @param DeleteExternalApiRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteExternalApi(DeleteExternalApiRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteExternalApi', $request, $callOptions)->wait();
    }

    /**
     * Delete a spec.
     * Deleting a spec will also delete the associated operations from the
     * version.
     *
     * The async variant is {@see ApiHubClient::deleteSpecAsync()} .
     *
     * @example samples/V1/ApiHubClient/delete_spec.php
     *
     * @param DeleteSpecRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSpec(DeleteSpecRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSpec', $request, $callOptions)->wait();
    }

    /**
     * Delete an API version. Version can only be deleted if all underlying specs,
     * operations, definitions and linked deployments are deleted.
     *
     * The async variant is {@see ApiHubClient::deleteVersionAsync()} .
     *
     * @example samples/V1/ApiHubClient/delete_version.php
     *
     * @param DeleteVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteVersion(DeleteVersionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteVersion', $request, $callOptions)->wait();
    }

    /**
     * Get API resource details including the API versions contained in it.
     *
     * The async variant is {@see ApiHubClient::getApiAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_api.php
     *
     * @param GetApiRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Api
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getApi(GetApiRequest $request, array $callOptions = []): Api
    {
        return $this->startApiCall('GetApi', $request, $callOptions)->wait();
    }

    /**
     * Get details about a particular operation in API version.
     *
     * The async variant is {@see ApiHubClient::getApiOperationAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_api_operation.php
     *
     * @param GetApiOperationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiOperation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getApiOperation(GetApiOperationRequest $request, array $callOptions = []): ApiOperation
    {
        return $this->startApiCall('GetApiOperation', $request, $callOptions)->wait();
    }

    /**
     * Get details about the attribute.
     *
     * The async variant is {@see ApiHubClient::getAttributeAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_attribute.php
     *
     * @param GetAttributeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Attribute
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAttribute(GetAttributeRequest $request, array $callOptions = []): Attribute
    {
        return $this->startApiCall('GetAttribute', $request, $callOptions)->wait();
    }

    /**
     * Get details about a definition in an API version.
     *
     * The async variant is {@see ApiHubClient::getDefinitionAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_definition.php
     *
     * @param GetDefinitionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Definition
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDefinition(GetDefinitionRequest $request, array $callOptions = []): Definition
    {
        return $this->startApiCall('GetDefinition', $request, $callOptions)->wait();
    }

    /**
     * Get details about a deployment and the API versions linked to it.
     *
     * The async variant is {@see ApiHubClient::getDeploymentAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_deployment.php
     *
     * @param GetDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDeployment(GetDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('GetDeployment', $request, $callOptions)->wait();
    }

    /**
     * Get details about an External API resource in the API hub.
     *
     * The async variant is {@see ApiHubClient::getExternalApiAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_external_api.php
     *
     * @param GetExternalApiRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExternalApi
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getExternalApi(GetExternalApiRequest $request, array $callOptions = []): ExternalApi
    {
        return $this->startApiCall('GetExternalApi', $request, $callOptions)->wait();
    }

    /**
     * Get details about the information parsed from a spec.
     * Note that this method does not return the raw spec contents.
     * Use [GetSpecContents][google.cloud.apihub.v1.ApiHub.GetSpecContents] method
     * to retrieve the same.
     *
     * The async variant is {@see ApiHubClient::getSpecAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_spec.php
     *
     * @param GetSpecRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Spec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSpec(GetSpecRequest $request, array $callOptions = []): Spec
    {
        return $this->startApiCall('GetSpec', $request, $callOptions)->wait();
    }

    /**
     * Get spec contents.
     *
     * The async variant is {@see ApiHubClient::getSpecContentsAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_spec_contents.php
     *
     * @param GetSpecContentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SpecContents
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSpecContents(GetSpecContentsRequest $request, array $callOptions = []): SpecContents
    {
        return $this->startApiCall('GetSpecContents', $request, $callOptions)->wait();
    }

    /**
     * Get details about the API version of an API resource. This will include
     * information about the specs and operations present in the API
     * version as well as the deployments linked to it.
     *
     * The async variant is {@see ApiHubClient::getVersionAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_version.php
     *
     * @param GetVersionRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Version
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVersion(GetVersionRequest $request, array $callOptions = []): Version
    {
        return $this->startApiCall('GetVersion', $request, $callOptions)->wait();
    }

    /**
     * List operations in an API version.
     *
     * The async variant is {@see ApiHubClient::listApiOperationsAsync()} .
     *
     * @example samples/V1/ApiHubClient/list_api_operations.php
     *
     * @param ListApiOperationsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApiOperations(ListApiOperationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListApiOperations', $request, $callOptions);
    }

    /**
     * List API resources in the API hub.
     *
     * The async variant is {@see ApiHubClient::listApisAsync()} .
     *
     * @example samples/V1/ApiHubClient/list_apis.php
     *
     * @param ListApisRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApis(ListApisRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListApis', $request, $callOptions);
    }

    /**
     * List all attributes.
     *
     * The async variant is {@see ApiHubClient::listAttributesAsync()} .
     *
     * @example samples/V1/ApiHubClient/list_attributes.php
     *
     * @param ListAttributesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAttributes(ListAttributesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAttributes', $request, $callOptions);
    }

    /**
     * List deployment resources in the API hub.
     *
     * The async variant is {@see ApiHubClient::listDeploymentsAsync()} .
     *
     * @example samples/V1/ApiHubClient/list_deployments.php
     *
     * @param ListDeploymentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDeployments(ListDeploymentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDeployments', $request, $callOptions);
    }

    /**
     * List External API resources in the API hub.
     *
     * The async variant is {@see ApiHubClient::listExternalApisAsync()} .
     *
     * @example samples/V1/ApiHubClient/list_external_apis.php
     *
     * @param ListExternalApisRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listExternalApis(ListExternalApisRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListExternalApis', $request, $callOptions);
    }

    /**
     * List specs corresponding to a particular API resource.
     *
     * The async variant is {@see ApiHubClient::listSpecsAsync()} .
     *
     * @example samples/V1/ApiHubClient/list_specs.php
     *
     * @param ListSpecsRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSpecs(ListSpecsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSpecs', $request, $callOptions);
    }

    /**
     * List API versions of an API resource in the API hub.
     *
     * The async variant is {@see ApiHubClient::listVersionsAsync()} .
     *
     * @example samples/V1/ApiHubClient/list_versions.php
     *
     * @param ListVersionsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVersions(ListVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVersions', $request, $callOptions);
    }

    /**
     * Search across API-Hub resources.
     *
     * The async variant is {@see ApiHubClient::searchResourcesAsync()} .
     *
     * @example samples/V1/ApiHubClient/search_resources.php
     *
     * @param SearchResourcesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchResources(SearchResourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchResources', $request, $callOptions);
    }

    /**
     * Update an API resource in the API hub. The following fields in the
     * [API][google.cloud.apihub.v1.Api] can be updated:
     *
     * * [display_name][google.cloud.apihub.v1.Api.display_name]
     * * [description][google.cloud.apihub.v1.Api.description]
     * * [owner][google.cloud.apihub.v1.Api.owner]
     * * [documentation][google.cloud.apihub.v1.Api.documentation]
     * * [target_user][google.cloud.apihub.v1.Api.target_user]
     * * [team][google.cloud.apihub.v1.Api.team]
     * * [business_unit][google.cloud.apihub.v1.Api.business_unit]
     * * [maturity_level][google.cloud.apihub.v1.Api.maturity_level]
     * * [api_style][google.cloud.apihub.v1.Api.api_style]
     * * [attributes][google.cloud.apihub.v1.Api.attributes]
     *
     * The
     * [update_mask][google.cloud.apihub.v1.UpdateApiRequest.update_mask]
     * should be used to specify the fields being updated.
     *
     * Updating the owner field requires complete owner message
     * and updates both owner and email fields.
     *
     * The async variant is {@see ApiHubClient::updateApiAsync()} .
     *
     * @example samples/V1/ApiHubClient/update_api.php
     *
     * @param UpdateApiRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Api
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateApi(UpdateApiRequest $request, array $callOptions = []): Api
    {
        return $this->startApiCall('UpdateApi', $request, $callOptions)->wait();
    }

    /**
     * Update an operation in an API version. The following fields in the
     * [ApiOperation resource][google.cloud.apihub.v1.ApiOperation] can be
     * updated:
     *
     * * [details.description][ApiOperation.details.description]
     * * [details.documentation][ApiOperation.details.documentation]
     * * [details.http_operation.path][ApiOperation.details.http_operation.path.path]
     * * [details.http_operation.method][ApiOperation.details.http_operation.method]
     * * [details.deprecated][ApiOperation.details.deprecated]
     * * [attributes][google.cloud.apihub.v1.ApiOperation.attributes]
     *
     * The
     * [update_mask][google.cloud.apihub.v1.UpdateApiOperationRequest.update_mask]
     * should be used to specify the fields being updated.
     *
     * An operation can be updated only if the operation was created via
     * [CreateApiOperation][google.cloud.apihub.v1.ApiHub.CreateApiOperation] API.
     * If the operation was created by parsing the spec, then it can be edited by
     * updating the spec.
     *
     * The async variant is {@see ApiHubClient::updateApiOperationAsync()} .
     *
     * @example samples/V1/ApiHubClient/update_api_operation.php
     *
     * @param UpdateApiOperationRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ApiOperation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateApiOperation(UpdateApiOperationRequest $request, array $callOptions = []): ApiOperation
    {
        return $this->startApiCall('UpdateApiOperation', $request, $callOptions)->wait();
    }

    /**
     * Update the attribute.  The following fields in the
     * [Attribute resource][google.cloud.apihub.v1.Attribute] can be updated:
     *
     * * [display_name][google.cloud.apihub.v1.Attribute.display_name]
     * The display name can be updated for user defined attributes only.
     * * [description][google.cloud.apihub.v1.Attribute.description]
     * The description can be updated for user defined attributes only.
     * * [allowed_values][google.cloud.apihub.v1.Attribute.allowed_values]
     * To update the list of allowed values, clients need to use the fetched list
     * of allowed values and add or remove values to or from the same list.
     * The mutable allowed values can be updated for both user defined and System
     * defined attributes. The immutable allowed values cannot be updated or
     * deleted. The updated list of allowed values cannot be empty. If an allowed
     * value that is already used by some resource's attribute is deleted, then
     * the association between the resource and the attribute value will also be
     * deleted.
     * * [cardinality][google.cloud.apihub.v1.Attribute.cardinality]
     * The cardinality can be updated for user defined attributes only.
     * Cardinality can only be increased during an update.
     *
     * The
     * [update_mask][google.cloud.apihub.v1.UpdateAttributeRequest.update_mask]
     * should be used to specify the fields being updated.
     *
     * The async variant is {@see ApiHubClient::updateAttributeAsync()} .
     *
     * @example samples/V1/ApiHubClient/update_attribute.php
     *
     * @param UpdateAttributeRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Attribute
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAttribute(UpdateAttributeRequest $request, array $callOptions = []): Attribute
    {
        return $this->startApiCall('UpdateAttribute', $request, $callOptions)->wait();
    }

    /**
     * Update a deployment resource in the API hub. The following fields in the
     * [deployment resource][google.cloud.apihub.v1.Deployment] can be
     * updated:
     *
     * * [display_name][google.cloud.apihub.v1.Deployment.display_name]
     * * [description][google.cloud.apihub.v1.Deployment.description]
     * * [documentation][google.cloud.apihub.v1.Deployment.documentation]
     * * [deployment_type][google.cloud.apihub.v1.Deployment.deployment_type]
     * * [resource_uri][google.cloud.apihub.v1.Deployment.resource_uri]
     * * [endpoints][google.cloud.apihub.v1.Deployment.endpoints]
     * * [slo][google.cloud.apihub.v1.Deployment.slo]
     * * [environment][google.cloud.apihub.v1.Deployment.environment]
     * * [attributes][google.cloud.apihub.v1.Deployment.attributes]
     * * [source_project] [google.cloud.apihub.v1.Deployment.source_project]
     * * [source_environment]
     * [google.cloud.apihub.v1.Deployment.source_environment]
     * * [management_url][google.cloud.apihub.v1.Deployment.management_url]
     * * [source_uri][google.cloud.apihub.v1.Deployment.source_uri]
     * The
     * [update_mask][google.cloud.apihub.v1.UpdateDeploymentRequest.update_mask]
     * should be used to specify the fields being updated.
     *
     * The async variant is {@see ApiHubClient::updateDeploymentAsync()} .
     *
     * @example samples/V1/ApiHubClient/update_deployment.php
     *
     * @param UpdateDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Deployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDeployment(UpdateDeploymentRequest $request, array $callOptions = []): Deployment
    {
        return $this->startApiCall('UpdateDeployment', $request, $callOptions)->wait();
    }

    /**
     * Update an External API resource in the API hub. The following fields can be
     * updated:
     *
     * * [display_name][google.cloud.apihub.v1.ExternalApi.display_name]
     * * [description][google.cloud.apihub.v1.ExternalApi.description]
     * * [documentation][google.cloud.apihub.v1.ExternalApi.documentation]
     * * [endpoints][google.cloud.apihub.v1.ExternalApi.endpoints]
     * * [paths][google.cloud.apihub.v1.ExternalApi.paths]
     *
     * The
     * [update_mask][google.cloud.apihub.v1.UpdateExternalApiRequest.update_mask]
     * should be used to specify the fields being updated.
     *
     * The async variant is {@see ApiHubClient::updateExternalApiAsync()} .
     *
     * @example samples/V1/ApiHubClient/update_external_api.php
     *
     * @param UpdateExternalApiRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExternalApi
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExternalApi(UpdateExternalApiRequest $request, array $callOptions = []): ExternalApi
    {
        return $this->startApiCall('UpdateExternalApi', $request, $callOptions)->wait();
    }

    /**
     * Update spec. The following fields in the
     * [spec][google.cloud.apihub.v1.Spec] can be updated:
     *
     * * [display_name][google.cloud.apihub.v1.Spec.display_name]
     * * [source_uri][google.cloud.apihub.v1.Spec.source_uri]
     * * [lint_response][google.cloud.apihub.v1.Spec.lint_response]
     * * [attributes][google.cloud.apihub.v1.Spec.attributes]
     * * [contents][google.cloud.apihub.v1.Spec.contents]
     * * [spec_type][google.cloud.apihub.v1.Spec.spec_type]
     *
     * In case of an OAS spec, updating spec contents can lead to:
     * 1. Creation, deletion and update of operations.
     * 2. Creation, deletion and update of definitions.
     * 3. Update of other info parsed out from the new spec.
     *
     * In case of contents or source_uri being present in update mask, spec_type
     * must also be present. Also, spec_type can not be present in update mask if
     * contents or source_uri is not present.
     *
     * The
     * [update_mask][google.cloud.apihub.v1.UpdateSpecRequest.update_mask]
     * should be used to specify the fields being updated.
     *
     * The async variant is {@see ApiHubClient::updateSpecAsync()} .
     *
     * @example samples/V1/ApiHubClient/update_spec.php
     *
     * @param UpdateSpecRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Spec
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSpec(UpdateSpecRequest $request, array $callOptions = []): Spec
    {
        return $this->startApiCall('UpdateSpec', $request, $callOptions)->wait();
    }

    /**
     * Update API version. The following fields in the
     * [version][google.cloud.apihub.v1.Version] can be updated currently:
     *
     * * [display_name][google.cloud.apihub.v1.Version.display_name]
     * * [description][google.cloud.apihub.v1.Version.description]
     * * [documentation][google.cloud.apihub.v1.Version.documentation]
     * * [deployments][google.cloud.apihub.v1.Version.deployments]
     * * [lifecycle][google.cloud.apihub.v1.Version.lifecycle]
     * * [compliance][google.cloud.apihub.v1.Version.compliance]
     * * [accreditation][google.cloud.apihub.v1.Version.accreditation]
     * * [attributes][google.cloud.apihub.v1.Version.attributes]
     *
     * The
     * [update_mask][google.cloud.apihub.v1.UpdateVersionRequest.update_mask]
     * should be used to specify the fields being updated.
     *
     * The async variant is {@see ApiHubClient::updateVersionAsync()} .
     *
     * @example samples/V1/ApiHubClient/update_version.php
     *
     * @param UpdateVersionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Version
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateVersion(UpdateVersionRequest $request, array $callOptions = []): Version
    {
        return $this->startApiCall('UpdateVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ApiHubClient::getLocationAsync()} .
     *
     * @example samples/V1/ApiHubClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ApiHubClient::listLocationsAsync()} .
     *
     * @example samples/V1/ApiHubClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
