<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datastream/v1/datastream_resources.proto

namespace Google\Cloud\Datastream\V1\Stream;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Backfill strategy to automatically backfill the Stream's objects.
 * Specific objects can be excluded.
 *
 * Generated from protobuf message <code>google.cloud.datastream.v1.Stream.BackfillAllStrategy</code>
 */
class BackfillAllStrategy extends \Google\Protobuf\Internal\Message
{
    protected $excluded_objects;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Datastream\V1\OracleRdbms $oracle_excluded_objects
     *           Oracle data source objects to avoid backfilling.
     *     @type \Google\Cloud\Datastream\V1\MysqlRdbms $mysql_excluded_objects
     *           MySQL data source objects to avoid backfilling.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datastream\V1\DatastreamResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Oracle data source objects to avoid backfilling.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleRdbms oracle_excluded_objects = 1;</code>
     * @return \Google\Cloud\Datastream\V1\OracleRdbms|null
     */
    public function getOracleExcludedObjects()
    {
        return $this->readOneof(1);
    }

    public function hasOracleExcludedObjects()
    {
        return $this->hasOneof(1);
    }

    /**
     * Oracle data source objects to avoid backfilling.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleRdbms oracle_excluded_objects = 1;</code>
     * @param \Google\Cloud\Datastream\V1\OracleRdbms $var
     * @return $this
     */
    public function setOracleExcludedObjects($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastream\V1\OracleRdbms::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * MySQL data source objects to avoid backfilling.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.MysqlRdbms mysql_excluded_objects = 2;</code>
     * @return \Google\Cloud\Datastream\V1\MysqlRdbms|null
     */
    public function getMysqlExcludedObjects()
    {
        return $this->readOneof(2);
    }

    public function hasMysqlExcludedObjects()
    {
        return $this->hasOneof(2);
    }

    /**
     * MySQL data source objects to avoid backfilling.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.MysqlRdbms mysql_excluded_objects = 2;</code>
     * @param \Google\Cloud\Datastream\V1\MysqlRdbms $var
     * @return $this
     */
    public function setMysqlExcludedObjects($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastream\V1\MysqlRdbms::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getExcludedObjects()
    {
        return $this->whichOneof("excluded_objects");
    }

}


