<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v1/cloudbuild.proto

namespace Google\Cloud\Build\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * WorkerConfig defines the configuration to be used for a creating workers in
 * the pool.
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v1.WorkerConfig</code>
 */
class WorkerConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Machine Type of the worker, such as n1-standard-1.
     * See https://cloud.google.com/compute/docs/machine-types.
     * If left blank, Cloud Build will use a standard unspecified machine to
     * create the worker pool.
     * `machine_type` is overridden if you specify a different machine type in
     * `build_options`. In this case, the VM specified in the `build_options`
     * will be created on demand at build time. For more information see
     * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     */
    private $machine_type = '';
    /**
     * Size of the disk attached to the worker, in GB.
     * See https://cloud.google.com/compute/docs/disks/
     * If `0` is specified, Cloud Build will use a standard disk size.
     * `disk_size` is overridden if you specify a different disk size in
     * `build_options`. In this case, a VM with a disk size specified in the
     * `build_options` will be created on demand at build time. For more
     * information see
     * https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
     *
     * Generated from protobuf field <code>int64 disk_size_gb = 2;</code>
     */
    private $disk_size_gb = 0;
    /**
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     */
    private $network = null;
    /**
     * The tag applied to the worker, and the same tag used by the firewall rule.
     * It is used to identify the Cloud Build workers among other VMs.
     * The default value for tag is `worker`.
     *
     * Generated from protobuf field <code>string tag = 4;</code>
     */
    private $tag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $machine_type
     *           Machine Type of the worker, such as n1-standard-1.
     *           See https://cloud.google.com/compute/docs/machine-types.
     *           If left blank, Cloud Build will use a standard unspecified machine to
     *           create the worker pool.
     *           `machine_type` is overridden if you specify a different machine type in
     *           `build_options`. In this case, the VM specified in the `build_options`
     *           will be created on demand at build time. For more information see
     *           https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     *     @type int|string $disk_size_gb
     *           Size of the disk attached to the worker, in GB.
     *           See https://cloud.google.com/compute/docs/disks/
     *           If `0` is specified, Cloud Build will use a standard disk size.
     *           `disk_size` is overridden if you specify a different disk size in
     *           `build_options`. In this case, a VM with a disk size specified in the
     *           `build_options` will be created on demand at build time. For more
     *           information see
     *           https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
     *     @type \Google\Cloud\Build\V1\Network $network
     *           The network definition used to create the worker.
     *           If this section is left empty, the workers will be created in
     *           WorkerPool.project_id on the default network.
     *     @type string $tag
     *           The tag applied to the worker, and the same tag used by the firewall rule.
     *           It is used to identify the Cloud Build workers among other VMs.
     *           The default value for tag is `worker`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudbuild\V1\Cloudbuild::initOnce();
        parent::__construct($data);
    }

    /**
     * Machine Type of the worker, such as n1-standard-1.
     * See https://cloud.google.com/compute/docs/machine-types.
     * If left blank, Cloud Build will use a standard unspecified machine to
     * create the worker pool.
     * `machine_type` is overridden if you specify a different machine type in
     * `build_options`. In this case, the VM specified in the `build_options`
     * will be created on demand at build time. For more information see
     * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * Machine Type of the worker, such as n1-standard-1.
     * See https://cloud.google.com/compute/docs/machine-types.
     * If left blank, Cloud Build will use a standard unspecified machine to
     * create the worker pool.
     * `machine_type` is overridden if you specify a different machine type in
     * `build_options`. In this case, the VM specified in the `build_options`
     * will be created on demand at build time. For more information see
     * https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
     *
     * Generated from protobuf field <code>string machine_type = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * Size of the disk attached to the worker, in GB.
     * See https://cloud.google.com/compute/docs/disks/
     * If `0` is specified, Cloud Build will use a standard disk size.
     * `disk_size` is overridden if you specify a different disk size in
     * `build_options`. In this case, a VM with a disk size specified in the
     * `build_options` will be created on demand at build time. For more
     * information see
     * https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
     *
     * Generated from protobuf field <code>int64 disk_size_gb = 2;</code>
     * @return int|string
     */
    public function getDiskSizeGb()
    {
        return $this->disk_size_gb;
    }

    /**
     * Size of the disk attached to the worker, in GB.
     * See https://cloud.google.com/compute/docs/disks/
     * If `0` is specified, Cloud Build will use a standard disk size.
     * `disk_size` is overridden if you specify a different disk size in
     * `build_options`. In this case, a VM with a disk size specified in the
     * `build_options` will be created on demand at build time. For more
     * information see
     * https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
     *
     * Generated from protobuf field <code>int64 disk_size_gb = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkInt64($var);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     * @return \Google\Cloud\Build\V1\Network|null
     */
    public function getNetwork()
    {
        return isset($this->network) ? $this->network : null;
    }

    public function hasNetwork()
    {
        return isset($this->network);
    }

    public function clearNetwork()
    {
        unset($this->network);
    }

    /**
     * The network definition used to create the worker.
     * If this section is left empty, the workers will be created in
     * WorkerPool.project_id on the default network.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v1.Network network = 3;</code>
     * @param \Google\Cloud\Build\V1\Network $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V1\Network::class);
        $this->network = $var;

        return $this;
    }

    /**
     * The tag applied to the worker, and the same tag used by the firewall rule.
     * It is used to identify the Cloud Build workers among other VMs.
     * The default value for tag is `worker`.
     *
     * Generated from protobuf field <code>string tag = 4;</code>
     * @return string
     */
    public function getTag()
    {
        return $this->tag;
    }

    /**
     * The tag applied to the worker, and the same tag used by the firewall rule.
     * It is used to identify the Cloud Build workers among other VMs.
     * The default value for tag is `worker`.
     *
     * Generated from protobuf field <code>string tag = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setTag($var)
    {
        GPBUtil::checkString($var, True);
        $this->tag = $var;

        return $this;
    }

}

