<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/baremetalsolution/v2/baremetalsolution.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\BaremetalSolution\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;

use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\BaremetalSolution\V2\CreateSnapshotSchedulePolicyRequest;
use Google\Cloud\BaremetalSolution\V2\CreateVolumeSnapshotRequest;
use Google\Cloud\BaremetalSolution\V2\DeleteSnapshotSchedulePolicyRequest;
use Google\Cloud\BaremetalSolution\V2\DeleteVolumeSnapshotRequest;
use Google\Cloud\BaremetalSolution\V2\GetInstanceRequest;
use Google\Cloud\BaremetalSolution\V2\GetLunRequest;
use Google\Cloud\BaremetalSolution\V2\GetNetworkRequest;
use Google\Cloud\BaremetalSolution\V2\GetSnapshotSchedulePolicyRequest;
use Google\Cloud\BaremetalSolution\V2\GetVolumeRequest;
use Google\Cloud\BaremetalSolution\V2\GetVolumeSnapshotRequest;
use Google\Cloud\BaremetalSolution\V2\Instance;
use Google\Cloud\BaremetalSolution\V2\ListInstancesRequest;
use Google\Cloud\BaremetalSolution\V2\ListInstancesResponse;
use Google\Cloud\BaremetalSolution\V2\ListLunsRequest;
use Google\Cloud\BaremetalSolution\V2\ListLunsResponse;
use Google\Cloud\BaremetalSolution\V2\ListNetworksRequest;
use Google\Cloud\BaremetalSolution\V2\ListNetworksResponse;
use Google\Cloud\BaremetalSolution\V2\ListSnapshotSchedulePoliciesRequest;
use Google\Cloud\BaremetalSolution\V2\ListSnapshotSchedulePoliciesResponse;
use Google\Cloud\BaremetalSolution\V2\ListVolumeSnapshotsRequest;
use Google\Cloud\BaremetalSolution\V2\ListVolumeSnapshotsResponse;
use Google\Cloud\BaremetalSolution\V2\ListVolumesRequest;
use Google\Cloud\BaremetalSolution\V2\ListVolumesResponse;
use Google\Cloud\BaremetalSolution\V2\Lun;
use Google\Cloud\BaremetalSolution\V2\Network;
use Google\Cloud\BaremetalSolution\V2\ResetInstanceRequest;
use Google\Cloud\BaremetalSolution\V2\RestoreVolumeSnapshotRequest;
use Google\Cloud\BaremetalSolution\V2\SnapshotSchedulePolicy;
use Google\Cloud\BaremetalSolution\V2\UpdateSnapshotSchedulePolicyRequest;
use Google\Cloud\BaremetalSolution\V2\UpdateVolumeRequest;
use Google\Cloud\BaremetalSolution\V2\Volume;
use Google\Cloud\BaremetalSolution\V2\VolumeSnapshot;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Performs management operations on Bare Metal Solution servers.
 *
 * The `baremetalsolution.googleapis.com` service provides management
 * capabilities for Bare Metal Solution servers. To access the API methods, you
 * must assign Bare Metal Solution IAM roles containing the desired permissions
 * to your staff in your Google Cloud project. You must also enable the Bare
 * Metal Solution API. Once enabled, the methods act
 * upon specific servers in your Bare Metal Solution environment.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $bareMetalSolutionClient = new BareMetalSolutionClient();
 * try {
 *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
 *     $snapshotSchedulePolicy = new SnapshotSchedulePolicy();
 *     $snapshotSchedulePolicyId = 'snapshot_schedule_policy_id';
 *     $response = $bareMetalSolutionClient->createSnapshotSchedulePolicy($formattedParent, $snapshotSchedulePolicy, $snapshotSchedulePolicyId);
 * } finally {
 *     $bareMetalSolutionClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class BareMetalSolutionGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.baremetalsolution.v2.BareMetalSolution';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'baremetalsolution.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $instanceNameTemplate;

    private static $locationNameTemplate;

    private static $lunNameTemplate;

    private static $networkNameTemplate;

    private static $snapshotSchedulePolicyNameTemplate;

    private static $volumeNameTemplate;

    private static $volumeSnapshotNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/bare_metal_solution_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/bare_metal_solution_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/bare_metal_solution_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/bare_metal_solution_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getInstanceNameTemplate()
    {
        if (self::$instanceNameTemplate == null) {
            self::$instanceNameTemplate = new PathTemplate('projects/{project}/locations/{location}/instances/{instance}');
        }

        return self::$instanceNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getLunNameTemplate()
    {
        if (self::$lunNameTemplate == null) {
            self::$lunNameTemplate = new PathTemplate('projects/{project}/locations/{location}/volumes/{volume}/luns/{lun}');
        }

        return self::$lunNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate('projects/{project}/locations/{location}/networks/{network}');
        }

        return self::$networkNameTemplate;
    }

    private static function getSnapshotSchedulePolicyNameTemplate()
    {
        if (self::$snapshotSchedulePolicyNameTemplate == null) {
            self::$snapshotSchedulePolicyNameTemplate = new PathTemplate('projects/{project}/locations/{location}/snapshotSchedulePolicies/{snapshot_schedule_policy}');
        }

        return self::$snapshotSchedulePolicyNameTemplate;
    }

    private static function getVolumeNameTemplate()
    {
        if (self::$volumeNameTemplate == null) {
            self::$volumeNameTemplate = new PathTemplate('projects/{project}/locations/{location}/volumes/{volume}');
        }

        return self::$volumeNameTemplate;
    }

    private static function getVolumeSnapshotNameTemplate()
    {
        if (self::$volumeSnapshotNameTemplate == null) {
            self::$volumeSnapshotNameTemplate = new PathTemplate('projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}');
        }

        return self::$volumeSnapshotNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'instance' => self::getInstanceNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'lun' => self::getLunNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'snapshotSchedulePolicy' => self::getSnapshotSchedulePolicyNameTemplate(),
                'volume' => self::getVolumeNameTemplate(),
                'volumeSnapshot' => self::getVolumeSnapshotNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName($project, $location, $instance)
    {
        return self::getInstanceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a lun
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     * @param string $lun
     *
     * @return string The formatted lun resource.
     */
    public static function lunName($project, $location, $volume, $lun)
    {
        return self::getLunNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
            'lun' => $lun,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $location, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * snapshot_schedule_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $snapshotSchedulePolicy
     *
     * @return string The formatted snapshot_schedule_policy resource.
     */
    public static function snapshotSchedulePolicyName($project, $location, $snapshotSchedulePolicy)
    {
        return self::getSnapshotSchedulePolicyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'snapshot_schedule_policy' => $snapshotSchedulePolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a volume
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     *
     * @return string The formatted volume resource.
     */
    public static function volumeName($project, $location, $volume)
    {
        return self::getVolumeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * volume_snapshot resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     * @param string $snapshot
     *
     * @return string The formatted volume_snapshot resource.
     */
    public static function volumeSnapshotName($project, $location, $volume, $snapshot)
    {
        return self::getVolumeSnapshotNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
            'snapshot' => $snapshot,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     * - location: projects/{project}/locations/{location}
     * - lun: projects/{project}/locations/{location}/volumes/{volume}/luns/{lun}
     * - network: projects/{project}/locations/{location}/networks/{network}
     * - snapshotSchedulePolicy: projects/{project}/locations/{location}/snapshotSchedulePolicies/{snapshot_schedule_policy}
     * - volume: projects/{project}/locations/{location}/volumes/{volume}
     * - volumeSnapshot: projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'baremetalsolution.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Create a snapshot schedule policy in the specified project.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     $snapshotSchedulePolicy = new SnapshotSchedulePolicy();
     *     $snapshotSchedulePolicyId = 'snapshot_schedule_policy_id';
     *     $response = $bareMetalSolutionClient->createSnapshotSchedulePolicy($formattedParent, $snapshotSchedulePolicy, $snapshotSchedulePolicyId);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string                 $parent                   Required. The parent project and location containing the SnapshotSchedulePolicy.
     * @param SnapshotSchedulePolicy $snapshotSchedulePolicy   Required. The SnapshotSchedulePolicy to create.
     * @param string                 $snapshotSchedulePolicyId Required. Snapshot policy ID
     * @param array                  $optionalArgs             {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\SnapshotSchedulePolicy
     *
     * @throws ApiException if the remote call fails
     */
    public function createSnapshotSchedulePolicy($parent, $snapshotSchedulePolicy, $snapshotSchedulePolicyId, array $optionalArgs = [])
    {
        $request = new CreateSnapshotSchedulePolicyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSnapshotSchedulePolicy($snapshotSchedulePolicy);
        $request->setSnapshotSchedulePolicyId($snapshotSchedulePolicyId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSnapshotSchedulePolicy', SnapshotSchedulePolicy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Create a storage volume snapshot in a containing volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     $volumeSnapshot = new VolumeSnapshot();
     *     $response = $bareMetalSolutionClient->createVolumeSnapshot($formattedParent, $volumeSnapshot);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string         $parent         Required. The volume to snapshot.
     * @param VolumeSnapshot $volumeSnapshot Required. The volume snapshot to create. Only the description field may be specified.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\VolumeSnapshot
     *
     * @throws ApiException if the remote call fails
     */
    public function createVolumeSnapshot($parent, $volumeSnapshot, array $optionalArgs = [])
    {
        $request = new CreateVolumeSnapshotRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setVolumeSnapshot($volumeSnapshot);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateVolumeSnapshot', VolumeSnapshot::class, $optionalArgs, $request)->wait();
    }

    /**
     * Delete a named snapshot schedule policy.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->snapshotSchedulePolicyName('[PROJECT]', '[LOCATION]', '[SNAPSHOT_SCHEDULE_POLICY]');
     *     $bareMetalSolutionClient->deleteSnapshotSchedulePolicy($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the snapshot schedule policy to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSnapshotSchedulePolicy($name, array $optionalArgs = [])
    {
        $request = new DeleteSnapshotSchedulePolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteSnapshotSchedulePolicy', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a storage volume snapshot for a given volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->volumeSnapshotName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[SNAPSHOT]');
     *     $bareMetalSolutionClient->deleteVolumeSnapshot($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the snapshot to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteVolumeSnapshot($name, array $optionalArgs = [])
    {
        $request = new DeleteVolumeSnapshotRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteVolumeSnapshot', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get details about a single server.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $response = $bareMetalSolutionClient->getInstance($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\Instance
     *
     * @throws ApiException if the remote call fails
     */
    public function getInstance($name, array $optionalArgs = [])
    {
        $request = new GetInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetInstance', Instance::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get details of a single storage logical unit number(LUN).
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->lunName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[LUN]');
     *     $response = $bareMetalSolutionClient->getLun($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\Lun
     *
     * @throws ApiException if the remote call fails
     */
    public function getLun($name, array $optionalArgs = [])
    {
        $request = new GetLunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLun', Lun::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get details of a single network.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->networkName('[PROJECT]', '[LOCATION]', '[NETWORK]');
     *     $response = $bareMetalSolutionClient->getNetwork($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\Network
     *
     * @throws ApiException if the remote call fails
     */
    public function getNetwork($name, array $optionalArgs = [])
    {
        $request = new GetNetworkRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetNetwork', Network::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get details of a single snapshot schedule policy.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->snapshotSchedulePolicyName('[PROJECT]', '[LOCATION]', '[SNAPSHOT_SCHEDULE_POLICY]');
     *     $response = $bareMetalSolutionClient->getSnapshotSchedulePolicy($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\SnapshotSchedulePolicy
     *
     * @throws ApiException if the remote call fails
     */
    public function getSnapshotSchedulePolicy($name, array $optionalArgs = [])
    {
        $request = new GetSnapshotSchedulePolicyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSnapshotSchedulePolicy', SnapshotSchedulePolicy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get details of a single storage volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     $response = $bareMetalSolutionClient->getVolume($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\Volume
     *
     * @throws ApiException if the remote call fails
     */
    public function getVolume($name, array $optionalArgs = [])
    {
        $request = new GetVolumeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetVolume', Volume::class, $optionalArgs, $request)->wait();
    }

    /**
     * Get details of a single storage volume snapshot.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->volumeSnapshotName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[SNAPSHOT]');
     *     $response = $bareMetalSolutionClient->getVolumeSnapshot($formattedName);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\VolumeSnapshot
     *
     * @throws ApiException if the remote call fails
     */
    public function getVolumeSnapshot($name, array $optionalArgs = [])
    {
        $request = new GetVolumeSnapshotRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetVolumeSnapshot', VolumeSnapshot::class, $optionalArgs, $request)->wait();
    }

    /**
     * List servers in a given project and location.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listInstances($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listInstances($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListInstancesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listInstances($parent, array $optionalArgs = [])
    {
        $request = new ListInstancesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListInstances', $optionalArgs, ListInstancesResponse::class, $request);
    }

    /**
     * List storage volume luns for given storage volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listLuns($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listLuns($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListLunsRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLuns($parent, array $optionalArgs = [])
    {
        $request = new ListLunsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLuns', $optionalArgs, ListLunsResponse::class, $request);
    }

    /**
     * List network in a given project and location.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listNetworks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listNetworks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListNetworksRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNetworks($parent, array $optionalArgs = [])
    {
        $request = new ListNetworksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListNetworks', $optionalArgs, ListNetworksResponse::class, $request);
    }

    /**
     * List snapshot schedule policies in a given project and location.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listSnapshotSchedulePolicies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listSnapshotSchedulePolicies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent project containing the Snapshot Schedule Policies.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSnapshotSchedulePolicies($parent, array $optionalArgs = [])
    {
        $request = new ListSnapshotSchedulePoliciesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSnapshotSchedulePolicies', $optionalArgs, ListSnapshotSchedulePoliciesResponse::class, $request);
    }

    /**
     * List storage volume snapshots for given storage volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->volumeName('[PROJECT]', '[LOCATION]', '[VOLUME]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listVolumeSnapshots($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listVolumeSnapshots($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListVolumesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVolumeSnapshots($parent, array $optionalArgs = [])
    {
        $request = new ListVolumeSnapshotsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListVolumeSnapshots', $optionalArgs, ListVolumeSnapshotsResponse::class, $request);
    }

    /**
     * List storage volumes in a given project and location.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedParent = $bareMetalSolutionClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $bareMetalSolutionClient->listVolumes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $bareMetalSolutionClient->listVolumes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. Parent value for ListVolumesRequest.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listVolumes($parent, array $optionalArgs = [])
    {
        $request = new ListVolumesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListVolumes', $optionalArgs, ListVolumesResponse::class, $request);
    }

    /**
     * Perform an ungraceful, hard reset on a server. Equivalent to shutting the
     * power off and then turning it back on.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedName = $bareMetalSolutionClient->instanceName('[PROJECT]', '[LOCATION]', '[INSTANCE]');
     *     $operationResponse = $bareMetalSolutionClient->resetInstance($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->resetInstance($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'resetInstance');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resetInstance($name, array $optionalArgs = [])
    {
        $request = new ResetInstanceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ResetInstance', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Restore a storage volume snapshot to its containing volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $formattedVolumeSnapshot = $bareMetalSolutionClient->volumeSnapshotName('[PROJECT]', '[LOCATION]', '[VOLUME]', '[SNAPSHOT]');
     *     $operationResponse = $bareMetalSolutionClient->restoreVolumeSnapshot($formattedVolumeSnapshot);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->restoreVolumeSnapshot($formattedVolumeSnapshot);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'restoreVolumeSnapshot');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param string $volumeSnapshot Required. Name of the resource.
     * @param array  $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function restoreVolumeSnapshot($volumeSnapshot, array $optionalArgs = [])
    {
        $request = new RestoreVolumeSnapshotRequest();
        $requestParamHeaders = [];
        $request->setVolumeSnapshot($volumeSnapshot);
        $requestParamHeaders['volume_snapshot'] = $volumeSnapshot;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RestoreVolumeSnapshot', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Update a snapshot schedule policy in the specified project.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $snapshotSchedulePolicy = new SnapshotSchedulePolicy();
     *     $updateMask = new FieldMask();
     *     $response = $bareMetalSolutionClient->updateSnapshotSchedulePolicy($snapshotSchedulePolicy, $updateMask);
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param SnapshotSchedulePolicy $snapshotSchedulePolicy Required. The snapshot schedule policy to update.
     *
     *                                                       The `name` field is used to identify the snapshot schedule policy to
     *                                                       update. Format:
     *                                                       projects/{project}/locations/global/snapshotSchedulePolicies/{policy}
     * @param FieldMask              $updateMask             Required. The list of fields to update.
     * @param array                  $optionalArgs           {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\BaremetalSolution\V2\SnapshotSchedulePolicy
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSnapshotSchedulePolicy($snapshotSchedulePolicy, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateSnapshotSchedulePolicyRequest();
        $requestParamHeaders = [];
        $request->setSnapshotSchedulePolicy($snapshotSchedulePolicy);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['snapshot_schedule_policy.name'] = $snapshotSchedulePolicy->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSnapshotSchedulePolicy', SnapshotSchedulePolicy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Update details of a single storage volume.
     *
     * Sample code:
     * ```
     * $bareMetalSolutionClient = new BareMetalSolutionClient();
     * try {
     *     $volume = new Volume();
     *     $operationResponse = $bareMetalSolutionClient->updateVolume($volume);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $bareMetalSolutionClient->updateVolume($volume);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $bareMetalSolutionClient->resumeOperation($operationName, 'updateVolume');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $bareMetalSolutionClient->close();
     * }
     * ```
     *
     * @param Volume $volume       Required. The volume to update.
     *
     *                             The `name` field is used to identify the volume to update.
     *                             Format: projects/{project}/locations/{location}/volumes/{volume}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to update.
     *           The only currently supported fields are:
     *           `snapshot_auto_delete_behavior`
     *           `snapshot_schedule_policy_name`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateVolume($volume, array $optionalArgs = [])
    {
        $request = new UpdateVolumeRequest();
        $requestParamHeaders = [];
        $request->setVolume($volume);
        $requestParamHeaders['volume.name'] = $volume->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateVolume', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }
}
