<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v1/securitycenter_service.proto

namespace Google\Cloud\SecurityCenter\V1\ListFindingsResponse\ListFindingsResult;

use UnexpectedValueException;

/**
 * The change in state of the finding.
 * When querying across two points in time this describes
 * the change in the finding between the two points: CHANGED, UNCHANGED,
 * ADDED, or REMOVED. Findings can not be deleted, so REMOVED implies that
 * the finding at timestamp does not match the filter specified, but it did
 * at timestamp - compare_duration. If there was no compare_duration
 * supplied in the request the state change will be: UNUSED
 *
 * Protobuf type <code>google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult.StateChange</code>
 */
class StateChange
{
    /**
     * State change is unused, this is the canonical default for this enum.
     *
     * Generated from protobuf enum <code>UNUSED = 0;</code>
     */
    const UNUSED = 0;
    /**
     * The finding has changed state in some way between the points in time
     * and existed at both points.
     *
     * Generated from protobuf enum <code>CHANGED = 1;</code>
     */
    const CHANGED = 1;
    /**
     * The finding has not changed state between the points in time and
     * existed at both points.
     *
     * Generated from protobuf enum <code>UNCHANGED = 2;</code>
     */
    const UNCHANGED = 2;
    /**
     * The finding was created between the points in time.
     *
     * Generated from protobuf enum <code>ADDED = 3;</code>
     */
    const ADDED = 3;
    /**
     * The finding at timestamp does not match the filter specified, but it
     * did at timestamp - compare_duration.
     *
     * Generated from protobuf enum <code>REMOVED = 4;</code>
     */
    const REMOVED = 4;

    private static $valueToName = [
        self::UNUSED => 'UNUSED',
        self::CHANGED => 'CHANGED',
        self::UNCHANGED => 'UNCHANGED',
        self::ADDED => 'ADDED',
        self::REMOVED => 'REMOVED',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


