<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/parametermanager/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ParameterManager\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\ParameterManager\V1\CreateParameterRequest;
use Google\Cloud\ParameterManager\V1\CreateParameterVersionRequest;
use Google\Cloud\ParameterManager\V1\DeleteParameterRequest;
use Google\Cloud\ParameterManager\V1\DeleteParameterVersionRequest;
use Google\Cloud\ParameterManager\V1\GetParameterRequest;
use Google\Cloud\ParameterManager\V1\GetParameterVersionRequest;
use Google\Cloud\ParameterManager\V1\ListParameterVersionsRequest;
use Google\Cloud\ParameterManager\V1\ListParametersRequest;
use Google\Cloud\ParameterManager\V1\Parameter;
use Google\Cloud\ParameterManager\V1\ParameterVersion;
use Google\Cloud\ParameterManager\V1\RenderParameterVersionRequest;
use Google\Cloud\ParameterManager\V1\RenderParameterVersionResponse;
use Google\Cloud\ParameterManager\V1\UpdateParameterRequest;
use Google\Cloud\ParameterManager\V1\UpdateParameterVersionRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service describing handlers for resources
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Parameter> createParameterAsync(CreateParameterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ParameterVersion> createParameterVersionAsync(CreateParameterVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteParameterAsync(DeleteParameterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteParameterVersionAsync(DeleteParameterVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Parameter> getParameterAsync(GetParameterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ParameterVersion> getParameterVersionAsync(GetParameterVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listParameterVersionsAsync(ListParameterVersionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listParametersAsync(ListParametersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RenderParameterVersionResponse> renderParameterVersionAsync(RenderParameterVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Parameter> updateParameterAsync(UpdateParameterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ParameterVersion> updateParameterVersionAsync(UpdateParameterVersionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ParameterManagerClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.parametermanager.v1.ParameterManager';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'parametermanager.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'parametermanager.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/parameter_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/parameter_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/parameter_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/parameter_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a parameter
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $parameter
     *
     * @return string The formatted parameter resource.
     */
    public static function parameterName(string $project, string $location, string $parameter): string
    {
        return self::getPathTemplate('parameter')->render([
            'project' => $project,
            'location' => $location,
            'parameter' => $parameter,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * parameter_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $parameter
     * @param string $parameterVersion
     *
     * @return string The formatted parameter_version resource.
     */
    public static function parameterVersionName(string $project, string $location, string $parameter, string $parameterVersion): string
    {
        return self::getPathTemplate('parameterVersion')->render([
            'project' => $project,
            'location' => $location,
            'parameter' => $parameter,
            'parameter_version' => $parameterVersion,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - location: projects/{project}/locations/{location}
     * - parameter: projects/{project}/locations/{location}/parameters/{parameter}
     * - parameterVersion: projects/{project}/locations/{location}/parameters/{parameter}/versions/{parameter_version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'parametermanager.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\ParameterManager\V1\ParameterManagerClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ParameterManagerClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new Parameter in a given project and location.
     *
     * The async variant is {@see ParameterManagerClient::createParameterAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/create_parameter.php
     *
     * @param CreateParameterRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Parameter
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createParameter(CreateParameterRequest $request, array $callOptions = []): Parameter
    {
        return $this->startApiCall('CreateParameter', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ParameterVersion in a given project, location, and parameter.
     *
     * The async variant is
     * {@see ParameterManagerClient::createParameterVersionAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/create_parameter_version.php
     *
     * @param CreateParameterVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ParameterVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createParameterVersion(CreateParameterVersionRequest $request, array $callOptions = []): ParameterVersion
    {
        return $this->startApiCall('CreateParameterVersion', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Parameter.
     *
     * The async variant is {@see ParameterManagerClient::deleteParameterAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/delete_parameter.php
     *
     * @param DeleteParameterRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteParameter(DeleteParameterRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteParameter', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ParameterVersion.
     *
     * The async variant is
     * {@see ParameterManagerClient::deleteParameterVersionAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/delete_parameter_version.php
     *
     * @param DeleteParameterVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteParameterVersion(DeleteParameterVersionRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteParameterVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Parameter.
     *
     * The async variant is {@see ParameterManagerClient::getParameterAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/get_parameter.php
     *
     * @param GetParameterRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Parameter
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getParameter(GetParameterRequest $request, array $callOptions = []): Parameter
    {
        return $this->startApiCall('GetParameter', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ParameterVersion.
     *
     * The async variant is {@see ParameterManagerClient::getParameterVersionAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/get_parameter_version.php
     *
     * @param GetParameterVersionRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ParameterVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getParameterVersion(GetParameterVersionRequest $request, array $callOptions = []): ParameterVersion
    {
        return $this->startApiCall('GetParameterVersion', $request, $callOptions)->wait();
    }

    /**
     * Lists ParameterVersions in a given project, location, and parameter.
     *
     * The async variant is {@see ParameterManagerClient::listParameterVersionsAsync()}
     * .
     *
     * @example samples/V1/ParameterManagerClient/list_parameter_versions.php
     *
     * @param ListParameterVersionsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listParameterVersions(ListParameterVersionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListParameterVersions', $request, $callOptions);
    }

    /**
     * Lists Parameters in a given project and location.
     *
     * The async variant is {@see ParameterManagerClient::listParametersAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/list_parameters.php
     *
     * @param ListParametersRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listParameters(ListParametersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListParameters', $request, $callOptions);
    }

    /**
     * Gets rendered version of a ParameterVersion.
     *
     * The async variant is
     * {@see ParameterManagerClient::renderParameterVersionAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/render_parameter_version.php
     *
     * @param RenderParameterVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RenderParameterVersionResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function renderParameterVersion(RenderParameterVersionRequest $request, array $callOptions = []): RenderParameterVersionResponse
    {
        return $this->startApiCall('RenderParameterVersion', $request, $callOptions)->wait();
    }

    /**
     * Updates a single Parameter.
     *
     * The async variant is {@see ParameterManagerClient::updateParameterAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/update_parameter.php
     *
     * @param UpdateParameterRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Parameter
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateParameter(UpdateParameterRequest $request, array $callOptions = []): Parameter
    {
        return $this->startApiCall('UpdateParameter', $request, $callOptions)->wait();
    }

    /**
     * Updates a single ParameterVersion.
     *
     * The async variant is
     * {@see ParameterManagerClient::updateParameterVersionAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/update_parameter_version.php
     *
     * @param UpdateParameterVersionRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ParameterVersion
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateParameterVersion(UpdateParameterVersionRequest $request, array $callOptions = []): ParameterVersion
    {
        return $this->startApiCall('UpdateParameterVersion', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ParameterManagerClient::getLocationAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see ParameterManagerClient::listLocationsAsync()} .
     *
     * @example samples/V1/ParameterManagerClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
