<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/netapp/v1/backup.proto

namespace Google\Cloud\NetApp\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A NetApp Backup.
 *
 * Generated from protobuf message <code>google.cloud.netapp.v1.Backup</code>
 */
class Backup extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the backup.
     * Format:
     * `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The backup state.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.Backup.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * A description of the backup with 2048 characters or less.
     * Requests with longer descriptions will be rejected.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    protected $description = '';
    /**
     * Output only. Size of the file system when the backup was created. When
     * creating a new volume from the backup, the volume capacity will have to be
     * at least as big.
     *
     * Generated from protobuf field <code>int64 volume_usage_bytes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $volume_usage_bytes = 0;
    /**
     * Output only. Type of backup, manually created or created by a backup
     * policy.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.Backup.Type backup_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $backup_type = 0;
    /**
     * Volume full name of this backup belongs to.
     * Format:
     * `projects/{projects_id}/locations/{location}/volumes/{volume_id}`
     *
     * Generated from protobuf field <code>string source_volume = 6 [(.google.api.resource_reference) = {</code>
     */
    protected $source_volume = '';
    /**
     * If specified, backup will be created from the given snapshot.
     * If not specified, there will be a new snapshot taken to initiate the backup
     * creation. Format:
     * `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{snapshot_id}`
     *
     * Generated from protobuf field <code>optional string source_snapshot = 7 [(.google.api.resource_reference) = {</code>
     */
    protected $source_snapshot = null;
    /**
     * Output only. The time when the backup was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Resource labels to represent user provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     */
    private $labels;
    /**
     * Output only. Total size of all backups in a chain in bytes = baseline
     * backup size + sum(incremental backup size)
     *
     * Generated from protobuf field <code>int64 chain_storage_bytes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $chain_storage_bytes = 0;
    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzi = false;
    /**
     * Output only. Region of the volume from which the backup was created.
     * Format: `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string volume_region = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $volume_region = '';
    /**
     * Output only. Region in which backup is stored.
     * Format: `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string backup_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $backup_region = '';
    /**
     * Output only. The time until which the backup is not deletable.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp enforced_retention_end_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $enforced_retention_end_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the backup.
     *           Format:
     *           `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup_id}`.
     *     @type int $state
     *           Output only. The backup state.
     *     @type string $description
     *           A description of the backup with 2048 characters or less.
     *           Requests with longer descriptions will be rejected.
     *     @type int|string $volume_usage_bytes
     *           Output only. Size of the file system when the backup was created. When
     *           creating a new volume from the backup, the volume capacity will have to be
     *           at least as big.
     *     @type int $backup_type
     *           Output only. Type of backup, manually created or created by a backup
     *           policy.
     *     @type string $source_volume
     *           Volume full name of this backup belongs to.
     *           Format:
     *           `projects/{projects_id}/locations/{location}/volumes/{volume_id}`
     *     @type string $source_snapshot
     *           If specified, backup will be created from the given snapshot.
     *           If not specified, there will be a new snapshot taken to initiate the backup
     *           creation. Format:
     *           `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{snapshot_id}`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the backup was created.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Resource labels to represent user provided metadata.
     *     @type int|string $chain_storage_bytes
     *           Output only. Total size of all backups in a chain in bytes = baseline
     *           backup size + sum(incremental backup size)
     *     @type bool $satisfies_pzs
     *           Output only. Reserved for future use
     *     @type bool $satisfies_pzi
     *           Output only. Reserved for future use
     *     @type string $volume_region
     *           Output only. Region of the volume from which the backup was created.
     *           Format: `projects/{project_id}/locations/{location}`
     *     @type string $backup_region
     *           Output only. Region in which backup is stored.
     *           Format: `projects/{project_id}/locations/{location}`
     *     @type \Google\Protobuf\Timestamp $enforced_retention_end_time
     *           Output only. The time until which the backup is not deletable.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Netapp\V1\Backup::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the backup.
     * Format:
     * `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the backup.
     * Format:
     * `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The backup state.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.Backup.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The backup state.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.Backup.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\Backup\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * A description of the backup with 2048 characters or less.
     * Requests with longer descriptions will be rejected.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * A description of the backup with 2048 characters or less.
     * Requests with longer descriptions will be rejected.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. Size of the file system when the backup was created. When
     * creating a new volume from the backup, the volume capacity will have to be
     * at least as big.
     *
     * Generated from protobuf field <code>int64 volume_usage_bytes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getVolumeUsageBytes()
    {
        return $this->volume_usage_bytes;
    }

    /**
     * Output only. Size of the file system when the backup was created. When
     * creating a new volume from the backup, the volume capacity will have to be
     * at least as big.
     *
     * Generated from protobuf field <code>int64 volume_usage_bytes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setVolumeUsageBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->volume_usage_bytes = $var;

        return $this;
    }

    /**
     * Output only. Type of backup, manually created or created by a backup
     * policy.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.Backup.Type backup_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getBackupType()
    {
        return $this->backup_type;
    }

    /**
     * Output only. Type of backup, manually created or created by a backup
     * policy.
     *
     * Generated from protobuf field <code>.google.cloud.netapp.v1.Backup.Type backup_type = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setBackupType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetApp\V1\Backup\Type::class);
        $this->backup_type = $var;

        return $this;
    }

    /**
     * Volume full name of this backup belongs to.
     * Format:
     * `projects/{projects_id}/locations/{location}/volumes/{volume_id}`
     *
     * Generated from protobuf field <code>string source_volume = 6 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSourceVolume()
    {
        return $this->source_volume;
    }

    /**
     * Volume full name of this backup belongs to.
     * Format:
     * `projects/{projects_id}/locations/{location}/volumes/{volume_id}`
     *
     * Generated from protobuf field <code>string source_volume = 6 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSourceVolume($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_volume = $var;

        return $this;
    }

    /**
     * If specified, backup will be created from the given snapshot.
     * If not specified, there will be a new snapshot taken to initiate the backup
     * creation. Format:
     * `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{snapshot_id}`
     *
     * Generated from protobuf field <code>optional string source_snapshot = 7 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSourceSnapshot()
    {
        return isset($this->source_snapshot) ? $this->source_snapshot : '';
    }

    public function hasSourceSnapshot()
    {
        return isset($this->source_snapshot);
    }

    public function clearSourceSnapshot()
    {
        unset($this->source_snapshot);
    }

    /**
     * If specified, backup will be created from the given snapshot.
     * If not specified, there will be a new snapshot taken to initiate the backup
     * creation. Format:
     * `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{snapshot_id}`
     *
     * Generated from protobuf field <code>optional string source_snapshot = 7 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshot($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot = $var;

        return $this;
    }

    /**
     * Output only. The time when the backup was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the backup was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Resource labels to represent user provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Resource labels to represent user provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Total size of all backups in a chain in bytes = baseline
     * backup size + sum(incremental backup size)
     *
     * Generated from protobuf field <code>int64 chain_storage_bytes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getChainStorageBytes()
    {
        return $this->chain_storage_bytes;
    }

    /**
     * Output only. Total size of all backups in a chain in bytes = baseline
     * backup size + sum(incremental backup size)
     *
     * Generated from protobuf field <code>int64 chain_storage_bytes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setChainStorageBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->chain_storage_bytes = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return $this->satisfies_pzi;
    }

    /**
     * Output only. Reserved for future use
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * Output only. Region of the volume from which the backup was created.
     * Format: `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string volume_region = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getVolumeRegion()
    {
        return $this->volume_region;
    }

    /**
     * Output only. Region of the volume from which the backup was created.
     * Format: `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string volume_region = 13 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setVolumeRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->volume_region = $var;

        return $this;
    }

    /**
     * Output only. Region in which backup is stored.
     * Format: `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string backup_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBackupRegion()
    {
        return $this->backup_region;
    }

    /**
     * Output only. Region in which backup is stored.
     * Format: `projects/{project_id}/locations/{location}`
     *
     * Generated from protobuf field <code>string backup_region = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBackupRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_region = $var;

        return $this;
    }

    /**
     * Output only. The time until which the backup is not deletable.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp enforced_retention_end_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEnforcedRetentionEndTime()
    {
        return $this->enforced_retention_end_time;
    }

    public function hasEnforcedRetentionEndTime()
    {
        return isset($this->enforced_retention_end_time);
    }

    public function clearEnforcedRetentionEndTime()
    {
        unset($this->enforced_retention_end_time);
    }

    /**
     * Output only. The time until which the backup is not deletable.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp enforced_retention_end_time = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEnforcedRetentionEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->enforced_retention_end_time = $var;

        return $this;
    }

}

