<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/discoveryengine/v1/common.proto

namespace Google\Cloud\DiscoveryEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Principal identifier of a user or a group.
 *
 * Generated from protobuf message <code>google.cloud.discoveryengine.v1.Principal</code>
 */
class Principal extends \Google\Protobuf\Internal\Message
{
    protected $principal;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $user_id
     *           User identifier.
     *           For Google Workspace user account, user_id should be the google workspace
     *           user email.
     *           For non-google identity provider user account, user_id is the mapped user
     *           identifier configured during the workforcepool config.
     *     @type string $group_id
     *           Group identifier.
     *           For Google Workspace user account, group_id should be the google
     *           workspace group email.
     *           For non-google identity provider user account, group_id is the mapped
     *           group identifier configured during the workforcepool config.
     *     @type string $external_entity_id
     *           For 3P application identities which are not present in the customer
     *           identity provider.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Discoveryengine\V1\Common::initOnce();
        parent::__construct($data);
    }

    /**
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider user account, user_id is the mapped user
     * identifier configured during the workforcepool config.
     *
     * Generated from protobuf field <code>string user_id = 1;</code>
     * @return string
     */
    public function getUserId()
    {
        return $this->readOneof(1);
    }

    public function hasUserId()
    {
        return $this->hasOneof(1);
    }

    /**
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider user account, user_id is the mapped user
     * identifier configured during the workforcepool config.
     *
     * Generated from protobuf field <code>string user_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setUserId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider user account, group_id is the mapped
     * group identifier configured during the workforcepool config.
     *
     * Generated from protobuf field <code>string group_id = 2;</code>
     * @return string
     */
    public function getGroupId()
    {
        return $this->readOneof(2);
    }

    public function hasGroupId()
    {
        return $this->hasOneof(2);
    }

    /**
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider user account, group_id is the mapped
     * group identifier configured during the workforcepool config.
     *
     * Generated from protobuf field <code>string group_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * For 3P application identities which are not present in the customer
     * identity provider.
     *
     * Generated from protobuf field <code>string external_entity_id = 3;</code>
     * @return string
     */
    public function getExternalEntityId()
    {
        return $this->readOneof(3);
    }

    public function hasExternalEntityId()
    {
        return $this->hasOneof(3);
    }

    /**
     * For 3P application identities which are not present in the customer
     * identity provider.
     *
     * Generated from protobuf field <code>string external_entity_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setExternalEntityId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getPrincipal()
    {
        return $this->whichOneof("principal");
    }

}

