<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/metastore/v1beta/metastore.proto

namespace Google\Cloud\Metastore\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies configuration information specific to running Hive metastore
 * software as the metastore service.
 *
 * Generated from protobuf message <code>google.cloud.metastore.v1beta.HiveMetastoreConfig</code>
 */
class HiveMetastoreConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. The Hive metastore schema version.
     *
     * Generated from protobuf field <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $version = '';
    /**
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     *
     * Generated from protobuf field <code>map<string, string> config_overrides = 2;</code>
     */
    private $config_overrides;
    /**
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     */
    protected $kerberos_config = null;
    /**
     * The protocol to use for the metastore service endpoint. If unspecified,
     * defaults to `THRIFT`.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;</code>
     */
    protected $endpoint_protocol = 0;
    /**
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig> auxiliary_versions = 5;</code>
     */
    private $auxiliary_versions;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $version
     *           Immutable. The Hive metastore schema version.
     *     @type array|\Google\Protobuf\Internal\MapField $config_overrides
     *           A mapping of Hive metastore configuration key-value pairs to apply to the
     *           Hive metastore (configured in `hive-site.xml`). The mappings
     *           override system defaults (some keys cannot be overridden). These
     *           overrides are also applied to auxiliary versions and can be further
     *           customized in the auxiliary version's `AuxiliaryVersionConfig`.
     *     @type \Google\Cloud\Metastore\V1beta\KerberosConfig $kerberos_config
     *           Information used to configure the Hive metastore service as a service
     *           principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     *           method and specify this field's path
     *           (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     *           while omitting this field from the request's `service`.
     *     @type int $endpoint_protocol
     *           The protocol to use for the metastore service endpoint. If unspecified,
     *           defaults to `THRIFT`.
     *     @type array|\Google\Protobuf\Internal\MapField $auxiliary_versions
     *           A mapping of Hive metastore version to the auxiliary version
     *           configuration. When specified, a secondary Hive metastore service is
     *           created along with the primary service. All auxiliary versions must be less
     *           than the service's primary version. The key is the auxiliary service name
     *           and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     *           means that the first character must be a lowercase letter, and all the
     *           following characters must be hyphens, lowercase letters, or digits, except
     *           the last character, which cannot be a hyphen.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Metastore\V1Beta\Metastore::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. The Hive metastore schema version.
     *
     * Generated from protobuf field <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * Immutable. The Hive metastore schema version.
     *
     * Generated from protobuf field <code>string version = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->version = $var;

        return $this;
    }

    /**
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     *
     * Generated from protobuf field <code>map<string, string> config_overrides = 2;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getConfigOverrides()
    {
        return $this->config_overrides;
    }

    /**
     * A mapping of Hive metastore configuration key-value pairs to apply to the
     * Hive metastore (configured in `hive-site.xml`). The mappings
     * override system defaults (some keys cannot be overridden). These
     * overrides are also applied to auxiliary versions and can be further
     * customized in the auxiliary version's `AuxiliaryVersionConfig`.
     *
     * Generated from protobuf field <code>map<string, string> config_overrides = 2;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setConfigOverrides($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->config_overrides = $arr;

        return $this;
    }

    /**
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     * @return \Google\Cloud\Metastore\V1beta\KerberosConfig|null
     */
    public function getKerberosConfig()
    {
        return $this->kerberos_config;
    }

    public function hasKerberosConfig()
    {
        return isset($this->kerberos_config);
    }

    public function clearKerberosConfig()
    {
        unset($this->kerberos_config);
    }

    /**
     * Information used to configure the Hive metastore service as a service
     * principal in a Kerberos realm. To disable Kerberos, use the `UpdateService`
     * method and specify this field's path
     * (`hive_metastore_config.kerberos_config`) in the request's `update_mask`
     * while omitting this field from the request's `service`.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1beta.KerberosConfig kerberos_config = 3;</code>
     * @param \Google\Cloud\Metastore\V1beta\KerberosConfig $var
     * @return $this
     */
    public function setKerberosConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Metastore\V1beta\KerberosConfig::class);
        $this->kerberos_config = $var;

        return $this;
    }

    /**
     * The protocol to use for the metastore service endpoint. If unspecified,
     * defaults to `THRIFT`.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;</code>
     * @return int
     */
    public function getEndpointProtocol()
    {
        return $this->endpoint_protocol;
    }

    /**
     * The protocol to use for the metastore service endpoint. If unspecified,
     * defaults to `THRIFT`.
     *
     * Generated from protobuf field <code>.google.cloud.metastore.v1beta.HiveMetastoreConfig.EndpointProtocol endpoint_protocol = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setEndpointProtocol($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Metastore\V1beta\HiveMetastoreConfig\EndpointProtocol::class);
        $this->endpoint_protocol = $var;

        return $this;
    }

    /**
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig> auxiliary_versions = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAuxiliaryVersions()
    {
        return $this->auxiliary_versions;
    }

    /**
     * A mapping of Hive metastore version to the auxiliary version
     * configuration. When specified, a secondary Hive metastore service is
     * created along with the primary service. All auxiliary versions must be less
     * than the service's primary version. The key is the auxiliary service name
     * and it must match the regular expression [a-z]([-a-z0-9]*[a-z0-9])?. This
     * means that the first character must be a lowercase letter, and all the
     * following characters must be hyphens, lowercase letters, or digits, except
     * the last character, which cannot be a hyphen.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.metastore.v1beta.AuxiliaryVersionConfig> auxiliary_versions = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAuxiliaryVersions($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Metastore\V1beta\AuxiliaryVersionConfig::class);
        $this->auxiliary_versions = $arr;

        return $this;
    }

}

