<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a License resource. A License represents billing and aggregate usage data for public and marketplace images. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.License</code>
 */
class License extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     *
     * Generated from protobuf field <code>repeated string allowed_replacement_licenses = 195677718;</code>
     */
    private $allowed_replacement_licenses;
    /**
     * If true, this license can be appended to an existing disk's set of licenses.
     *
     * Generated from protobuf field <code>optional bool appendable_to_disk = 16959254;</code>
     */
    protected $appendable_to_disk = null;
    /**
     * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
     *
     * Generated from protobuf field <code>optional bool charges_use_fee = 372412622;</code>
     */
    protected $charges_use_fee = null;
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    protected $creation_timestamp = null;
    /**
     * An optional textual description of the resource; provided by the client when the resource is created.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    protected $description = null;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    protected $id = null;
    /**
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     *
     * Generated from protobuf field <code>repeated string incompatible_licenses = 334239768;</code>
     */
    private $incompatible_licenses;
    /**
     * [Output Only] Type of resource. Always compute#license for licenses.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    protected $kind = null;
    /**
     * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
     *
     * Generated from protobuf field <code>optional uint64 license_code = 1467179;</code>
     */
    protected $license_code = null;
    /**
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     */
    protected $minimum_retention = null;
    /**
     * If true, this license can only be used on VMs on multi tenant nodes.
     *
     * Generated from protobuf field <code>optional bool multi_tenant_only = 274395163;</code>
     */
    protected $multi_tenant_only = null;
    /**
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    protected $name = null;
    /**
     * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
     *
     * Generated from protobuf field <code>optional bool os_license = 487986406;</code>
     */
    protected $os_license = null;
    /**
     * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
     *
     * Generated from protobuf field <code>optional bool removable_from_disk = 25854638;</code>
     */
    protected $removable_from_disk = null;
    /**
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     *
     * Generated from protobuf field <code>repeated string required_coattached_licenses = 129195265;</code>
     */
    private $required_coattached_licenses;
    /**
     * [Input Only] Deprecated.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;</code>
     */
    protected $resource_requirements = null;
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    protected $self_link = null;
    /**
     * [Output Only] Server-defined URL for this resource with the resource id.
     *
     * Generated from protobuf field <code>optional string self_link_with_id = 44520962;</code>
     */
    protected $self_link_with_id = null;
    /**
     * If true, this license can only be used on VMs on sole tenant nodes.
     *
     * Generated from protobuf field <code>optional bool sole_tenant_only = 427525559;</code>
     */
    protected $sole_tenant_only = null;
    /**
     * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
     *
     * Generated from protobuf field <code>optional bool transferable = 4349893;</code>
     */
    protected $transferable = null;
    /**
     * [Output Only] Last update timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string update_timestamp = 120894752;</code>
     */
    protected $update_timestamp = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowed_replacement_licenses
     *           Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     *     @type bool $appendable_to_disk
     *           If true, this license can be appended to an existing disk's set of licenses.
     *     @type bool $charges_use_fee
     *           [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $description
     *           An optional textual description of the resource; provided by the client when the resource is created.
     *     @type int|string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $incompatible_licenses
     *           Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     *     @type string $kind
     *           [Output Only] Type of resource. Always compute#license for licenses.
     *     @type int|string $license_code
     *           [Output Only] The unique code used to attach this license to images, snapshots, and disks.
     *     @type \Google\Cloud\Compute\V1\Duration $minimum_retention
     *           If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     *     @type bool $multi_tenant_only
     *           If true, this license can only be used on VMs on multi tenant nodes.
     *     @type string $name
     *           Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     *     @type bool $os_license
     *           If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
     *     @type bool $removable_from_disk
     *           If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $required_coattached_licenses
     *           Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     *     @type \Google\Cloud\Compute\V1\LicenseResourceRequirements $resource_requirements
     *           [Input Only] Deprecated.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type string $self_link_with_id
     *           [Output Only] Server-defined URL for this resource with the resource id.
     *     @type bool $sole_tenant_only
     *           If true, this license can only be used on VMs on sole tenant nodes.
     *     @type bool $transferable
     *           If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
     *     @type string $update_timestamp
     *           [Output Only] Last update timestamp in RFC3339 text format.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     *
     * Generated from protobuf field <code>repeated string allowed_replacement_licenses = 195677718;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedReplacementLicenses()
    {
        return $this->allowed_replacement_licenses;
    }

    /**
     * Specifies licenseCodes of licenses that can replace this license. Note: such replacements are allowed even if removable_from_disk is false.
     *
     * Generated from protobuf field <code>repeated string allowed_replacement_licenses = 195677718;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedReplacementLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowed_replacement_licenses = $arr;

        return $this;
    }

    /**
     * If true, this license can be appended to an existing disk's set of licenses.
     *
     * Generated from protobuf field <code>optional bool appendable_to_disk = 16959254;</code>
     * @return bool
     */
    public function getAppendableToDisk()
    {
        return isset($this->appendable_to_disk) ? $this->appendable_to_disk : false;
    }

    public function hasAppendableToDisk()
    {
        return isset($this->appendable_to_disk);
    }

    public function clearAppendableToDisk()
    {
        unset($this->appendable_to_disk);
    }

    /**
     * If true, this license can be appended to an existing disk's set of licenses.
     *
     * Generated from protobuf field <code>optional bool appendable_to_disk = 16959254;</code>
     * @param bool $var
     * @return $this
     */
    public function setAppendableToDisk($var)
    {
        GPBUtil::checkBool($var);
        $this->appendable_to_disk = $var;

        return $this;
    }

    /**
     * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
     *
     * Generated from protobuf field <code>optional bool charges_use_fee = 372412622;</code>
     * @return bool
     */
    public function getChargesUseFee()
    {
        return isset($this->charges_use_fee) ? $this->charges_use_fee : false;
    }

    public function hasChargesUseFee()
    {
        return isset($this->charges_use_fee);
    }

    public function clearChargesUseFee()
    {
        unset($this->charges_use_fee);
    }

    /**
     * [Output Only] Deprecated. This field no longer reflects whether a license charges a usage fee.
     *
     * Generated from protobuf field <code>optional bool charges_use_fee = 372412622;</code>
     * @param bool $var
     * @return $this
     */
    public function setChargesUseFee($var)
    {
        GPBUtil::checkBool($var);
        $this->charges_use_fee = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * An optional textual description of the resource; provided by the client when the resource is created.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional textual description of the resource; provided by the client when the resource is created.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     *
     * Generated from protobuf field <code>repeated string incompatible_licenses = 334239768;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIncompatibleLicenses()
    {
        return $this->incompatible_licenses;
    }

    /**
     * Specifies licenseCodes of licenses that are incompatible with this license. If a license is incompatible with this license, it cannot be attached to the same disk or image.
     *
     * Generated from protobuf field <code>repeated string incompatible_licenses = 334239768;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIncompatibleLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->incompatible_licenses = $arr;

        return $this;
    }

    /**
     * [Output Only] Type of resource. Always compute#license for licenses.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * [Output Only] Type of resource. Always compute#license for licenses.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
     *
     * Generated from protobuf field <code>optional uint64 license_code = 1467179;</code>
     * @return int|string
     */
    public function getLicenseCode()
    {
        return isset($this->license_code) ? $this->license_code : 0;
    }

    public function hasLicenseCode()
    {
        return isset($this->license_code);
    }

    public function clearLicenseCode()
    {
        unset($this->license_code);
    }

    /**
     * [Output Only] The unique code used to attach this license to images, snapshots, and disks.
     *
     * Generated from protobuf field <code>optional uint64 license_code = 1467179;</code>
     * @param int|string $var
     * @return $this
     */
    public function setLicenseCode($var)
    {
        GPBUtil::checkUint64($var);
        $this->license_code = $var;

        return $this;
    }

    /**
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     * @return \Google\Cloud\Compute\V1\Duration|null
     */
    public function getMinimumRetention()
    {
        return $this->minimum_retention;
    }

    public function hasMinimumRetention()
    {
        return isset($this->minimum_retention);
    }

    public function clearMinimumRetention()
    {
        unset($this->minimum_retention);
    }

    /**
     * If set, this license will be unable to be removed or replaced once attached to a disk until the minimum_retention period has passed.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.Duration minimum_retention = 155398189;</code>
     * @param \Google\Cloud\Compute\V1\Duration $var
     * @return $this
     */
    public function setMinimumRetention($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Duration::class);
        $this->minimum_retention = $var;

        return $this;
    }

    /**
     * If true, this license can only be used on VMs on multi tenant nodes.
     *
     * Generated from protobuf field <code>optional bool multi_tenant_only = 274395163;</code>
     * @return bool
     */
    public function getMultiTenantOnly()
    {
        return isset($this->multi_tenant_only) ? $this->multi_tenant_only : false;
    }

    public function hasMultiTenantOnly()
    {
        return isset($this->multi_tenant_only);
    }

    public function clearMultiTenantOnly()
    {
        unset($this->multi_tenant_only);
    }

    /**
     * If true, this license can only be used on VMs on multi tenant nodes.
     *
     * Generated from protobuf field <code>optional bool multi_tenant_only = 274395163;</code>
     * @param bool $var
     * @return $this
     */
    public function setMultiTenantOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->multi_tenant_only = $var;

        return $this;
    }

    /**
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource. The name must be 1-63 characters long and comply with RFC1035.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
     *
     * Generated from protobuf field <code>optional bool os_license = 487986406;</code>
     * @return bool
     */
    public function getOsLicense()
    {
        return isset($this->os_license) ? $this->os_license : false;
    }

    public function hasOsLicense()
    {
        return isset($this->os_license);
    }

    public function clearOsLicense()
    {
        unset($this->os_license);
    }

    /**
     * If true, indicates this is an OS license. Only one OS license can be attached to a disk or image at a time.
     *
     * Generated from protobuf field <code>optional bool os_license = 487986406;</code>
     * @param bool $var
     * @return $this
     */
    public function setOsLicense($var)
    {
        GPBUtil::checkBool($var);
        $this->os_license = $var;

        return $this;
    }

    /**
     * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
     *
     * Generated from protobuf field <code>optional bool removable_from_disk = 25854638;</code>
     * @return bool
     */
    public function getRemovableFromDisk()
    {
        return isset($this->removable_from_disk) ? $this->removable_from_disk : false;
    }

    public function hasRemovableFromDisk()
    {
        return isset($this->removable_from_disk);
    }

    public function clearRemovableFromDisk()
    {
        unset($this->removable_from_disk);
    }

    /**
     * If true, this license can be removed from a disk's set of licenses, with no replacement license needed.
     *
     * Generated from protobuf field <code>optional bool removable_from_disk = 25854638;</code>
     * @param bool $var
     * @return $this
     */
    public function setRemovableFromDisk($var)
    {
        GPBUtil::checkBool($var);
        $this->removable_from_disk = $var;

        return $this;
    }

    /**
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     *
     * Generated from protobuf field <code>repeated string required_coattached_licenses = 129195265;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRequiredCoattachedLicenses()
    {
        return $this->required_coattached_licenses;
    }

    /**
     * Specifies the set of permissible coattached licenseCodes of licenses that satisfy the coattachment requirement of this license. At least one license from the set must be attached to the same disk or image as this license.
     *
     * Generated from protobuf field <code>repeated string required_coattached_licenses = 129195265;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRequiredCoattachedLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->required_coattached_licenses = $arr;

        return $this;
    }

    /**
     * [Input Only] Deprecated.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;</code>
     * @return \Google\Cloud\Compute\V1\LicenseResourceRequirements|null
     */
    public function getResourceRequirements()
    {
        return $this->resource_requirements;
    }

    public function hasResourceRequirements()
    {
        return isset($this->resource_requirements);
    }

    public function clearResourceRequirements()
    {
        unset($this->resource_requirements);
    }

    /**
     * [Input Only] Deprecated.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.LicenseResourceRequirements resource_requirements = 214292769;</code>
     * @param \Google\Cloud\Compute\V1\LicenseResourceRequirements $var
     * @return $this
     */
    public function setResourceRequirements($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\LicenseResourceRequirements::class);
        $this->resource_requirements = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for this resource with the resource id.
     *
     * Generated from protobuf field <code>optional string self_link_with_id = 44520962;</code>
     * @return string
     */
    public function getSelfLinkWithId()
    {
        return isset($this->self_link_with_id) ? $this->self_link_with_id : '';
    }

    public function hasSelfLinkWithId()
    {
        return isset($this->self_link_with_id);
    }

    public function clearSelfLinkWithId()
    {
        unset($this->self_link_with_id);
    }

    /**
     * [Output Only] Server-defined URL for this resource with the resource id.
     *
     * Generated from protobuf field <code>optional string self_link_with_id = 44520962;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLinkWithId($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link_with_id = $var;

        return $this;
    }

    /**
     * If true, this license can only be used on VMs on sole tenant nodes.
     *
     * Generated from protobuf field <code>optional bool sole_tenant_only = 427525559;</code>
     * @return bool
     */
    public function getSoleTenantOnly()
    {
        return isset($this->sole_tenant_only) ? $this->sole_tenant_only : false;
    }

    public function hasSoleTenantOnly()
    {
        return isset($this->sole_tenant_only);
    }

    public function clearSoleTenantOnly()
    {
        unset($this->sole_tenant_only);
    }

    /**
     * If true, this license can only be used on VMs on sole tenant nodes.
     *
     * Generated from protobuf field <code>optional bool sole_tenant_only = 427525559;</code>
     * @param bool $var
     * @return $this
     */
    public function setSoleTenantOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->sole_tenant_only = $var;

        return $this;
    }

    /**
     * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
     *
     * Generated from protobuf field <code>optional bool transferable = 4349893;</code>
     * @return bool
     */
    public function getTransferable()
    {
        return isset($this->transferable) ? $this->transferable : false;
    }

    public function hasTransferable()
    {
        return isset($this->transferable);
    }

    public function clearTransferable()
    {
        unset($this->transferable);
    }

    /**
     * If false, licenses will not be copied from the source resource when creating an image from a disk, disk from snapshot, or snapshot from disk.
     *
     * Generated from protobuf field <code>optional bool transferable = 4349893;</code>
     * @param bool $var
     * @return $this
     */
    public function setTransferable($var)
    {
        GPBUtil::checkBool($var);
        $this->transferable = $var;

        return $this;
    }

    /**
     * [Output Only] Last update timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string update_timestamp = 120894752;</code>
     * @return string
     */
    public function getUpdateTimestamp()
    {
        return isset($this->update_timestamp) ? $this->update_timestamp : '';
    }

    public function hasUpdateTimestamp()
    {
        return isset($this->update_timestamp);
    }

    public function clearUpdateTimestamp()
    {
        unset($this->update_timestamp);
    }

    /**
     * [Output Only] Last update timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>optional string update_timestamp = 120894752;</code>
     * @param string $var
     * @return $this
     */
    public function setUpdateTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->update_timestamp = $var;

        return $this;
    }

}

