<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/card/v1/card.proto

namespace Google\Apps\Card\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Lets users input a date, a time, or both a date and a time.
 * Supports form submission validation. When `Action.all_widgets_are_required`
 * is set to `true` or this widget is specified in `Action.required_widgets`,
 * the submission action is blocked unless a value is selected. For an example
 * in Google Chat apps, see [Let a user pick a date and
 * time](https://developers.google.com/workspace/chat/design-interactive-card-dialog#let_a_user_pick_a_date_and_time).
 * Users can input text or use the picker to select dates and times. If users
 * input an invalid date or time, the picker shows an error that prompts users
 * to input the information correctly.
 * [Google Workspace
 * add-ons and Chat apps](https://developers.google.com/workspace/extend):
 *
 * Generated from protobuf message <code>google.apps.card.v1.DateTimePicker</code>
 */
class DateTimePicker extends \Google\Protobuf\Internal\Message
{
    /**
     * The name by which the `DateTimePicker` is identified in a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The text that prompts users to input a date, a time, or a date and time.
     * For example, if users are scheduling an appointment, use a label such as
     * `Appointment date` or `Appointment date and time`.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     */
    protected $label = '';
    /**
     * Whether the widget supports inputting a date, a time, or the date and time.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
     */
    protected $type = 0;
    /**
     * Optional. The default value displayed in the widget, in milliseconds since
     * [Unix epoch time](https://en.wikipedia.org/wiki/Unix_time).
     * Specify the value based on the type of picker (`DateTimePickerType`):
     * * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
     *   represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
     * * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
     *   January 1, 2023, use `1672531200000`.
     * * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
     *   `43200000` (or `12 * 60 * 60 * 1000`).
     *
     * Generated from protobuf field <code>optional int64 value_ms_epoch = 4;</code>
     */
    protected $value_ms_epoch = null;
    /**
     * The number representing the time zone offset from UTC, in minutes.
     * If set, the `value_ms_epoch` is displayed in the specified time zone.
     * If unset, the value defaults to the user's time zone setting.
     *
     * Generated from protobuf field <code>int32 timezone_offset_date = 5;</code>
     */
    protected $timezone_offset_date = 0;
    /**
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     */
    protected $on_change_action = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The name by which the `DateTimePicker` is identified in a form input event.
     *           For details about working with form inputs, see [Receive form
     *           data](https://developers.google.com/workspace/chat/read-form-data).
     *     @type string $label
     *           The text that prompts users to input a date, a time, or a date and time.
     *           For example, if users are scheduling an appointment, use a label such as
     *           `Appointment date` or `Appointment date and time`.
     *     @type int $type
     *           Whether the widget supports inputting a date, a time, or the date and time.
     *     @type int|string $value_ms_epoch
     *           Optional. The default value displayed in the widget, in milliseconds since
     *           [Unix epoch time](https://en.wikipedia.org/wiki/Unix_time).
     *           Specify the value based on the type of picker (`DateTimePickerType`):
     *           * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
     *             represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
     *           * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
     *             January 1, 2023, use `1672531200000`.
     *           * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
     *             `43200000` (or `12 * 60 * 60 * 1000`).
     *     @type int $timezone_offset_date
     *           The number representing the time zone offset from UTC, in minutes.
     *           If set, the `value_ms_epoch` is displayed in the specified time zone.
     *           If unset, the value defaults to the user's time zone setting.
     *     @type \Google\Apps\Card\V1\Action $on_change_action
     *           Triggered when the user clicks **Save** or **Clear** from the
     *           `DateTimePicker` interface.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Card\V1\Card::initOnce();
        parent::__construct($data);
    }

    /**
     * The name by which the `DateTimePicker` is identified in a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name by which the `DateTimePicker` is identified in a form input event.
     * For details about working with form inputs, see [Receive form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The text that prompts users to input a date, a time, or a date and time.
     * For example, if users are scheduling an appointment, use a label such as
     * `Appointment date` or `Appointment date and time`.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * The text that prompts users to input a date, a time, or a date and time.
     * For example, if users are scheduling an appointment, use a label such as
     * `Appointment date` or `Appointment date and time`.
     *
     * Generated from protobuf field <code>string label = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->label = $var;

        return $this;
    }

    /**
     * Whether the widget supports inputting a date, a time, or the date and time.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Whether the widget supports inputting a date, a time, or the date and time.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.DateTimePicker.DateTimePickerType type = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Apps\Card\V1\DateTimePicker\DateTimePickerType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Optional. The default value displayed in the widget, in milliseconds since
     * [Unix epoch time](https://en.wikipedia.org/wiki/Unix_time).
     * Specify the value based on the type of picker (`DateTimePickerType`):
     * * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
     *   represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
     * * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
     *   January 1, 2023, use `1672531200000`.
     * * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
     *   `43200000` (or `12 * 60 * 60 * 1000`).
     *
     * Generated from protobuf field <code>optional int64 value_ms_epoch = 4;</code>
     * @return int|string
     */
    public function getValueMsEpoch()
    {
        return isset($this->value_ms_epoch) ? $this->value_ms_epoch : 0;
    }

    public function hasValueMsEpoch()
    {
        return isset($this->value_ms_epoch);
    }

    public function clearValueMsEpoch()
    {
        unset($this->value_ms_epoch);
    }

    /**
     * Optional. The default value displayed in the widget, in milliseconds since
     * [Unix epoch time](https://en.wikipedia.org/wiki/Unix_time).
     * Specify the value based on the type of picker (`DateTimePickerType`):
     * * `DATE_AND_TIME`: a calendar date and time in UTC. For example, to
     *   represent January 1, 2023 at 12:00 PM UTC, use `1672574400000`.
     * * `DATE_ONLY`: a calendar date at 00:00:00 UTC. For example, to represent
     *   January 1, 2023, use `1672531200000`.
     * * `TIME_ONLY`: a time in UTC. For example, to represent 12:00 PM, use
     *   `43200000` (or `12 * 60 * 60 * 1000`).
     *
     * Generated from protobuf field <code>optional int64 value_ms_epoch = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setValueMsEpoch($var)
    {
        GPBUtil::checkInt64($var);
        $this->value_ms_epoch = $var;

        return $this;
    }

    /**
     * The number representing the time zone offset from UTC, in minutes.
     * If set, the `value_ms_epoch` is displayed in the specified time zone.
     * If unset, the value defaults to the user's time zone setting.
     *
     * Generated from protobuf field <code>int32 timezone_offset_date = 5;</code>
     * @return int
     */
    public function getTimezoneOffsetDate()
    {
        return $this->timezone_offset_date;
    }

    /**
     * The number representing the time zone offset from UTC, in minutes.
     * If set, the `value_ms_epoch` is displayed in the specified time zone.
     * If unset, the value defaults to the user's time zone setting.
     *
     * Generated from protobuf field <code>int32 timezone_offset_date = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setTimezoneOffsetDate($var)
    {
        GPBUtil::checkInt32($var);
        $this->timezone_offset_date = $var;

        return $this;
    }

    /**
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     * @return \Google\Apps\Card\V1\Action|null
     */
    public function getOnChangeAction()
    {
        return $this->on_change_action;
    }

    public function hasOnChangeAction()
    {
        return isset($this->on_change_action);
    }

    public function clearOnChangeAction()
    {
        unset($this->on_change_action);
    }

    /**
     * Triggered when the user clicks **Save** or **Clear** from the
     * `DateTimePicker` interface.
     *
     * Generated from protobuf field <code>.google.apps.card.v1.Action on_change_action = 6;</code>
     * @param \Google\Apps\Card\V1\Action $var
     * @return $this
     */
    public function setOnChangeAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Card\V1\Action::class);
        $this->on_change_action = $var;

        return $this;
    }

}

