<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1/resources.proto

namespace Google\Cloud\AlloyDb\V1\Instance;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for setting up PSC service automation. Consumer projects in
 * the configs will be allowlisted automatically for the instance.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1.Instance.PscAutoConnectionConfig</code>
 */
class PscAutoConnectionConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The consumer project to which the PSC service automation endpoint will
     * be created.
     *
     * Generated from protobuf field <code>string consumer_project = 1;</code>
     */
    protected $consumer_project = '';
    /**
     * The consumer network for the PSC service automation, example:
     * "projects/vpc-host-project/global/networks/default".
     * The consumer network might be hosted a different project than the
     * consumer project.
     *
     * Generated from protobuf field <code>string consumer_network = 2;</code>
     */
    protected $consumer_network = '';
    /**
     * Output only. The IP address of the PSC service automation endpoint.
     *
     * Generated from protobuf field <code>string ip_address = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     */
    protected $ip_address = '';
    /**
     * Output only. The status of the PSC service automation connection.
     * Possible values:
     *   "STATE_UNSPECIFIED" - An invalid state as the default case.
     *   "ACTIVE" - The connection has been created successfully.
     *   "FAILED" - The connection is not functional since some resources on the
     * connection fail to be created.
     *   "CREATING" - The connection is being created.
     *   "DELETING" - The connection is being deleted.
     *   "CREATE_REPAIRING" - The connection is being repaired to complete
     * creation.
     *   "DELETE_REPAIRING" - The connection is being repaired to complete
     * deletion.
     *
     * Generated from protobuf field <code>string status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $status = '';
    /**
     * Output only. The status of the service connection policy.
     * Possible values:
     *   "STATE_UNSPECIFIED" - Default state, when Connection Map is created
     * initially.
     *   "VALID" - Set when policy and map configuration is valid, and their
     * matching can lead to allowing creation of PSC Connections subject to
     * other constraints like connections limit.
     *   "CONNECTION_POLICY_MISSING" - No Service Connection Policy found for
     * this network and Service Class
     *   "POLICY_LIMIT_REACHED" - Service Connection Policy limit reached for
     *   this network and Service Class
     *   "CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED" - The consumer instance
     * project is not in AllowedGoogleProducersResourceHierarchyLevels of the
     * matching ServiceConnectionPolicy.
     *
     * Generated from protobuf field <code>string consumer_network_status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $consumer_network_status = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $consumer_project
     *           The consumer project to which the PSC service automation endpoint will
     *           be created.
     *     @type string $consumer_network
     *           The consumer network for the PSC service automation, example:
     *           "projects/vpc-host-project/global/networks/default".
     *           The consumer network might be hosted a different project than the
     *           consumer project.
     *     @type string $ip_address
     *           Output only. The IP address of the PSC service automation endpoint.
     *     @type string $status
     *           Output only. The status of the PSC service automation connection.
     *           Possible values:
     *             "STATE_UNSPECIFIED" - An invalid state as the default case.
     *             "ACTIVE" - The connection has been created successfully.
     *             "FAILED" - The connection is not functional since some resources on the
     *           connection fail to be created.
     *             "CREATING" - The connection is being created.
     *             "DELETING" - The connection is being deleted.
     *             "CREATE_REPAIRING" - The connection is being repaired to complete
     *           creation.
     *             "DELETE_REPAIRING" - The connection is being repaired to complete
     *           deletion.
     *     @type string $consumer_network_status
     *           Output only. The status of the service connection policy.
     *           Possible values:
     *             "STATE_UNSPECIFIED" - Default state, when Connection Map is created
     *           initially.
     *             "VALID" - Set when policy and map configuration is valid, and their
     *           matching can lead to allowing creation of PSC Connections subject to
     *           other constraints like connections limit.
     *             "CONNECTION_POLICY_MISSING" - No Service Connection Policy found for
     *           this network and Service Class
     *             "POLICY_LIMIT_REACHED" - Service Connection Policy limit reached for
     *             this network and Service Class
     *             "CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED" - The consumer instance
     *           project is not in AllowedGoogleProducersResourceHierarchyLevels of the
     *           matching ServiceConnectionPolicy.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The consumer project to which the PSC service automation endpoint will
     * be created.
     *
     * Generated from protobuf field <code>string consumer_project = 1;</code>
     * @return string
     */
    public function getConsumerProject()
    {
        return $this->consumer_project;
    }

    /**
     * The consumer project to which the PSC service automation endpoint will
     * be created.
     *
     * Generated from protobuf field <code>string consumer_project = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setConsumerProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->consumer_project = $var;

        return $this;
    }

    /**
     * The consumer network for the PSC service automation, example:
     * "projects/vpc-host-project/global/networks/default".
     * The consumer network might be hosted a different project than the
     * consumer project.
     *
     * Generated from protobuf field <code>string consumer_network = 2;</code>
     * @return string
     */
    public function getConsumerNetwork()
    {
        return $this->consumer_network;
    }

    /**
     * The consumer network for the PSC service automation, example:
     * "projects/vpc-host-project/global/networks/default".
     * The consumer network might be hosted a different project than the
     * consumer project.
     *
     * Generated from protobuf field <code>string consumer_network = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setConsumerNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->consumer_network = $var;

        return $this;
    }

    /**
     * Output only. The IP address of the PSC service automation endpoint.
     *
     * Generated from protobuf field <code>string ip_address = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ip_address;
    }

    /**
     * Output only. The IP address of the PSC service automation endpoint.
     *
     * Generated from protobuf field <code>string ip_address = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_info) = {</code>
     * @param string $var
     * @return $this
     */
    public function setIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->ip_address = $var;

        return $this;
    }

    /**
     * Output only. The status of the PSC service automation connection.
     * Possible values:
     *   "STATE_UNSPECIFIED" - An invalid state as the default case.
     *   "ACTIVE" - The connection has been created successfully.
     *   "FAILED" - The connection is not functional since some resources on the
     * connection fail to be created.
     *   "CREATING" - The connection is being created.
     *   "DELETING" - The connection is being deleted.
     *   "CREATE_REPAIRING" - The connection is being repaired to complete
     * creation.
     *   "DELETE_REPAIRING" - The connection is being repaired to complete
     * deletion.
     *
     * Generated from protobuf field <code>string status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Output only. The status of the PSC service automation connection.
     * Possible values:
     *   "STATE_UNSPECIFIED" - An invalid state as the default case.
     *   "ACTIVE" - The connection has been created successfully.
     *   "FAILED" - The connection is not functional since some resources on the
     * connection fail to be created.
     *   "CREATING" - The connection is being created.
     *   "DELETING" - The connection is being deleted.
     *   "CREATE_REPAIRING" - The connection is being repaired to complete
     * creation.
     *   "DELETE_REPAIRING" - The connection is being repaired to complete
     * deletion.
     *
     * Generated from protobuf field <code>string status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->status = $var;

        return $this;
    }

    /**
     * Output only. The status of the service connection policy.
     * Possible values:
     *   "STATE_UNSPECIFIED" - Default state, when Connection Map is created
     * initially.
     *   "VALID" - Set when policy and map configuration is valid, and their
     * matching can lead to allowing creation of PSC Connections subject to
     * other constraints like connections limit.
     *   "CONNECTION_POLICY_MISSING" - No Service Connection Policy found for
     * this network and Service Class
     *   "POLICY_LIMIT_REACHED" - Service Connection Policy limit reached for
     *   this network and Service Class
     *   "CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED" - The consumer instance
     * project is not in AllowedGoogleProducersResourceHierarchyLevels of the
     * matching ServiceConnectionPolicy.
     *
     * Generated from protobuf field <code>string consumer_network_status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getConsumerNetworkStatus()
    {
        return $this->consumer_network_status;
    }

    /**
     * Output only. The status of the service connection policy.
     * Possible values:
     *   "STATE_UNSPECIFIED" - Default state, when Connection Map is created
     * initially.
     *   "VALID" - Set when policy and map configuration is valid, and their
     * matching can lead to allowing creation of PSC Connections subject to
     * other constraints like connections limit.
     *   "CONNECTION_POLICY_MISSING" - No Service Connection Policy found for
     * this network and Service Class
     *   "POLICY_LIMIT_REACHED" - Service Connection Policy limit reached for
     *   this network and Service Class
     *   "CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED" - The consumer instance
     * project is not in AllowedGoogleProducersResourceHierarchyLevels of the
     * matching ServiceConnectionPolicy.
     *
     * Generated from protobuf field <code>string consumer_network_status = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setConsumerNetworkStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->consumer_network_status = $var;

        return $this;
    }

}


