<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/ad_break_messages.proto

namespace Google\Ads\AdManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `AdBreak` resource.
 *
 * Generated from protobuf message <code>google.ads.admanager.v1.AdBreak</code>
 */
class AdBreak extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the `AdBreak`.
     * This field uses the `LiveStreamEvent` resource's asset key in the
     * URI, even if the ad break was created, updated, or queried using the custom
     * asset key.
     * Format:
     * `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}/adBreaks/{ad_break_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. Immutable. `AdBreak` ID.
     * Must consist only of lowercase letters, digits, and hyphens. Ad break IDs
     * have a maximum length of 63 characters.
     * If not set, an ad break ID is generated as a UUID string.
     *
     * Generated from protobuf field <code>optional string ad_break_id = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $ad_break_id = null;
    /**
     * Optional. Immutable. The asset key of the `LiveStreamEvent` that the ad
     * break belongs to. Either an asset key or a custom asset key must be
     * provided for creation.
     *
     * Generated from protobuf field <code>optional string asset_key = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $asset_key = null;
    /**
     * Optional. Immutable. The custom asset key of the `LiveStreamEvent` that the
     * ad break belongs to. Either an asset key or a custom asset key must be
     * provided for creation.
     *
     * Generated from protobuf field <code>optional string custom_asset_key = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $custom_asset_key = null;
    /**
     * Optional. The expected start time of the ad break.
     * When set, the scheduled ad break will be decisioned shortly before the
     * expected start time.
     * If this field is not set, ad decisioning begins immediately.
     * An ad break can be created up to six hours before the expected start time.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp expected_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $expected_start_time = null;
    /**
     * Required. The duration of the `AdBreak`.
     * An expected duration in seconds with up to nine fractional digits, ending
     * with `s`, for example, `3.5s`. This value will be updated to match the
     * actual duration from the manifest or pod request after the ad break's state
     * is
     * [`COMPLETE`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.COMPLETE].
     *
     * Generated from protobuf field <code>optional .google.protobuf.Duration duration = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $duration = null;
    /**
     * Output only. The state of the `AdBreak`.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.AdBreakStateEnum.AdBreakState break_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $break_state = null;
    /**
     * Output only. The sequence id of the `AdBreak`.
     * The unique sequence number of the created ad break. This value is only set
     * after the `AdBreak` starts decisioning indicated by the ad break state's
     * being
     * [`DECISIONED`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.DECISIONED]
     * .
     *
     * Generated from protobuf field <code>optional int64 break_sequence = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $break_sequence = null;
    /**
     * Optional. The pod template name of the `AdBreak`.
     * This field is the required unique name across all pod templates in the
     * network, not the display name.
     *
     * Generated from protobuf field <code>optional string pod_template_name = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $pod_template_name = null;
    /**
     * Optional. The key-value pairs to be included on the ad requests for this
     * `AdBreak`. Key-value pairs to include on ad requests for this break for
     * custom criteria targeting in Google Ad Manager, separated by `=` and joined
     * by
     * `&`.
     * Format:"key1=value&key2=value"
     *
     * Generated from protobuf field <code>optional string custom_params = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $custom_params = null;
    /**
     * Optional. The Base64-encoded SCTE-35 command associated with the `AdBreak`.
     * This field can include the `splice_insert()` or `time_signal()` command.
     * **Examples**
     * * `time_signal()`
     *   ```
     *   /DA0AAAAAAAA///wBQb+cr0AUAAeAhxDVUVJSAAAjn/PAAGlmbAICAAAAAAsoKGKNAIAmsnRfg==
     *   ```
     * * `splice_insert()`
     *   ```
     *   /DAvAAAAAAAA///wFAVIAACPf+/+c2nALv4AUsz1AAAAAAAKAAhDVUVJAAABNWLbowo=
     *   ```
     *
     * Generated from protobuf field <code>optional string scte_35_cue_out = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $scte_35_cue_out = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the `AdBreak`.
     *           This field uses the `LiveStreamEvent` resource's asset key in the
     *           URI, even if the ad break was created, updated, or queried using the custom
     *           asset key.
     *           Format:
     *           `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}/adBreaks/{ad_break_id}`
     *     @type string $ad_break_id
     *           Optional. Immutable. `AdBreak` ID.
     *           Must consist only of lowercase letters, digits, and hyphens. Ad break IDs
     *           have a maximum length of 63 characters.
     *           If not set, an ad break ID is generated as a UUID string.
     *     @type string $asset_key
     *           Optional. Immutable. The asset key of the `LiveStreamEvent` that the ad
     *           break belongs to. Either an asset key or a custom asset key must be
     *           provided for creation.
     *     @type string $custom_asset_key
     *           Optional. Immutable. The custom asset key of the `LiveStreamEvent` that the
     *           ad break belongs to. Either an asset key or a custom asset key must be
     *           provided for creation.
     *     @type \Google\Protobuf\Timestamp $expected_start_time
     *           Optional. The expected start time of the ad break.
     *           When set, the scheduled ad break will be decisioned shortly before the
     *           expected start time.
     *           If this field is not set, ad decisioning begins immediately.
     *           An ad break can be created up to six hours before the expected start time.
     *     @type \Google\Protobuf\Duration $duration
     *           Required. The duration of the `AdBreak`.
     *           An expected duration in seconds with up to nine fractional digits, ending
     *           with `s`, for example, `3.5s`. This value will be updated to match the
     *           actual duration from the manifest or pod request after the ad break's state
     *           is
     *           [`COMPLETE`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.COMPLETE].
     *     @type int $break_state
     *           Output only. The state of the `AdBreak`.
     *     @type int|string $break_sequence
     *           Output only. The sequence id of the `AdBreak`.
     *           The unique sequence number of the created ad break. This value is only set
     *           after the `AdBreak` starts decisioning indicated by the ad break state's
     *           being
     *           [`DECISIONED`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.DECISIONED]
     *           .
     *     @type string $pod_template_name
     *           Optional. The pod template name of the `AdBreak`.
     *           This field is the required unique name across all pod templates in the
     *           network, not the display name.
     *     @type string $custom_params
     *           Optional. The key-value pairs to be included on the ad requests for this
     *           `AdBreak`. Key-value pairs to include on ad requests for this break for
     *           custom criteria targeting in Google Ad Manager, separated by `=` and joined
     *           by
     *           `&`.
     *           Format:"key1=value&key2=value"
     *     @type string $scte_35_cue_out
     *           Optional. The Base64-encoded SCTE-35 command associated with the `AdBreak`.
     *           This field can include the `splice_insert()` or `time_signal()` command.
     *           **Examples**
     *           * `time_signal()`
     *             ```
     *             /DA0AAAAAAAA///wBQb+cr0AUAAeAhxDVUVJSAAAjn/PAAGlmbAICAAAAAAsoKGKNAIAmsnRfg==
     *             ```
     *           * `splice_insert()`
     *             ```
     *             /DAvAAAAAAAA///wFAVIAACPf+/+c2nALv4AUsz1AAAAAAAKAAhDVUVJAAABNWLbowo=
     *             ```
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\Admanager\V1\AdBreakMessages::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the `AdBreak`.
     * This field uses the `LiveStreamEvent` resource's asset key in the
     * URI, even if the ad break was created, updated, or queried using the custom
     * asset key.
     * Format:
     * `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}/adBreaks/{ad_break_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the `AdBreak`.
     * This field uses the `LiveStreamEvent` resource's asset key in the
     * URI, even if the ad break was created, updated, or queried using the custom
     * asset key.
     * Format:
     * `networks/{network_code}/liveStreamEventsByAssetKey/{asset_key}/adBreaks/{ad_break_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. Immutable. `AdBreak` ID.
     * Must consist only of lowercase letters, digits, and hyphens. Ad break IDs
     * have a maximum length of 63 characters.
     * If not set, an ad break ID is generated as a UUID string.
     *
     * Generated from protobuf field <code>optional string ad_break_id = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getAdBreakId()
    {
        return isset($this->ad_break_id) ? $this->ad_break_id : '';
    }

    public function hasAdBreakId()
    {
        return isset($this->ad_break_id);
    }

    public function clearAdBreakId()
    {
        unset($this->ad_break_id);
    }

    /**
     * Optional. Immutable. `AdBreak` ID.
     * Must consist only of lowercase letters, digits, and hyphens. Ad break IDs
     * have a maximum length of 63 characters.
     * If not set, an ad break ID is generated as a UUID string.
     *
     * Generated from protobuf field <code>optional string ad_break_id = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setAdBreakId($var)
    {
        GPBUtil::checkString($var, True);
        $this->ad_break_id = $var;

        return $this;
    }

    /**
     * Optional. Immutable. The asset key of the `LiveStreamEvent` that the ad
     * break belongs to. Either an asset key or a custom asset key must be
     * provided for creation.
     *
     * Generated from protobuf field <code>optional string asset_key = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getAssetKey()
    {
        return isset($this->asset_key) ? $this->asset_key : '';
    }

    public function hasAssetKey()
    {
        return isset($this->asset_key);
    }

    public function clearAssetKey()
    {
        unset($this->asset_key);
    }

    /**
     * Optional. Immutable. The asset key of the `LiveStreamEvent` that the ad
     * break belongs to. Either an asset key or a custom asset key must be
     * provided for creation.
     *
     * Generated from protobuf field <code>optional string asset_key = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setAssetKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->asset_key = $var;

        return $this;
    }

    /**
     * Optional. Immutable. The custom asset key of the `LiveStreamEvent` that the
     * ad break belongs to. Either an asset key or a custom asset key must be
     * provided for creation.
     *
     * Generated from protobuf field <code>optional string custom_asset_key = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getCustomAssetKey()
    {
        return isset($this->custom_asset_key) ? $this->custom_asset_key : '';
    }

    public function hasCustomAssetKey()
    {
        return isset($this->custom_asset_key);
    }

    public function clearCustomAssetKey()
    {
        unset($this->custom_asset_key);
    }

    /**
     * Optional. Immutable. The custom asset key of the `LiveStreamEvent` that the
     * ad break belongs to. Either an asset key or a custom asset key must be
     * provided for creation.
     *
     * Generated from protobuf field <code>optional string custom_asset_key = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomAssetKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_asset_key = $var;

        return $this;
    }

    /**
     * Optional. The expected start time of the ad break.
     * When set, the scheduled ad break will be decisioned shortly before the
     * expected start time.
     * If this field is not set, ad decisioning begins immediately.
     * An ad break can be created up to six hours before the expected start time.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp expected_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpectedStartTime()
    {
        return $this->expected_start_time;
    }

    public function hasExpectedStartTime()
    {
        return isset($this->expected_start_time);
    }

    public function clearExpectedStartTime()
    {
        unset($this->expected_start_time);
    }

    /**
     * Optional. The expected start time of the ad break.
     * When set, the scheduled ad break will be decisioned shortly before the
     * expected start time.
     * If this field is not set, ad decisioning begins immediately.
     * An ad break can be created up to six hours before the expected start time.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Timestamp expected_start_time = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpectedStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expected_start_time = $var;

        return $this;
    }

    /**
     * Required. The duration of the `AdBreak`.
     * An expected duration in seconds with up to nine fractional digits, ending
     * with `s`, for example, `3.5s`. This value will be updated to match the
     * actual duration from the manifest or pod request after the ad break's state
     * is
     * [`COMPLETE`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.COMPLETE].
     *
     * Generated from protobuf field <code>optional .google.protobuf.Duration duration = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getDuration()
    {
        return $this->duration;
    }

    public function hasDuration()
    {
        return isset($this->duration);
    }

    public function clearDuration()
    {
        unset($this->duration);
    }

    /**
     * Required. The duration of the `AdBreak`.
     * An expected duration in seconds with up to nine fractional digits, ending
     * with `s`, for example, `3.5s`. This value will be updated to match the
     * actual duration from the manifest or pod request after the ad break's state
     * is
     * [`COMPLETE`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.COMPLETE].
     *
     * Generated from protobuf field <code>optional .google.protobuf.Duration duration = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->duration = $var;

        return $this;
    }

    /**
     * Output only. The state of the `AdBreak`.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.AdBreakStateEnum.AdBreakState break_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getBreakState()
    {
        return isset($this->break_state) ? $this->break_state : 0;
    }

    public function hasBreakState()
    {
        return isset($this->break_state);
    }

    public function clearBreakState()
    {
        unset($this->break_state);
    }

    /**
     * Output only. The state of the `AdBreak`.
     *
     * Generated from protobuf field <code>optional .google.ads.admanager.v1.AdBreakStateEnum.AdBreakState break_state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setBreakState($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\AdManager\V1\AdBreakStateEnum\AdBreakState::class);
        $this->break_state = $var;

        return $this;
    }

    /**
     * Output only. The sequence id of the `AdBreak`.
     * The unique sequence number of the created ad break. This value is only set
     * after the `AdBreak` starts decisioning indicated by the ad break state's
     * being
     * [`DECISIONED`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.DECISIONED]
     * .
     *
     * Generated from protobuf field <code>optional int64 break_sequence = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getBreakSequence()
    {
        return isset($this->break_sequence) ? $this->break_sequence : 0;
    }

    public function hasBreakSequence()
    {
        return isset($this->break_sequence);
    }

    public function clearBreakSequence()
    {
        unset($this->break_sequence);
    }

    /**
     * Output only. The sequence id of the `AdBreak`.
     * The unique sequence number of the created ad break. This value is only set
     * after the `AdBreak` starts decisioning indicated by the ad break state's
     * being
     * [`DECISIONED`][google.ads.admanager.v1.AdBreakStateEnum.AdBreakState.DECISIONED]
     * .
     *
     * Generated from protobuf field <code>optional int64 break_sequence = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setBreakSequence($var)
    {
        GPBUtil::checkInt64($var);
        $this->break_sequence = $var;

        return $this;
    }

    /**
     * Optional. The pod template name of the `AdBreak`.
     * This field is the required unique name across all pod templates in the
     * network, not the display name.
     *
     * Generated from protobuf field <code>optional string pod_template_name = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPodTemplateName()
    {
        return isset($this->pod_template_name) ? $this->pod_template_name : '';
    }

    public function hasPodTemplateName()
    {
        return isset($this->pod_template_name);
    }

    public function clearPodTemplateName()
    {
        unset($this->pod_template_name);
    }

    /**
     * Optional. The pod template name of the `AdBreak`.
     * This field is the required unique name across all pod templates in the
     * network, not the display name.
     *
     * Generated from protobuf field <code>optional string pod_template_name = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPodTemplateName($var)
    {
        GPBUtil::checkString($var, True);
        $this->pod_template_name = $var;

        return $this;
    }

    /**
     * Optional. The key-value pairs to be included on the ad requests for this
     * `AdBreak`. Key-value pairs to include on ad requests for this break for
     * custom criteria targeting in Google Ad Manager, separated by `=` and joined
     * by
     * `&`.
     * Format:"key1=value&key2=value"
     *
     * Generated from protobuf field <code>optional string custom_params = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getCustomParams()
    {
        return isset($this->custom_params) ? $this->custom_params : '';
    }

    public function hasCustomParams()
    {
        return isset($this->custom_params);
    }

    public function clearCustomParams()
    {
        unset($this->custom_params);
    }

    /**
     * Optional. The key-value pairs to be included on the ad requests for this
     * `AdBreak`. Key-value pairs to include on ad requests for this break for
     * custom criteria targeting in Google Ad Manager, separated by `=` and joined
     * by
     * `&`.
     * Format:"key1=value&key2=value"
     *
     * Generated from protobuf field <code>optional string custom_params = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomParams($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_params = $var;

        return $this;
    }

    /**
     * Optional. The Base64-encoded SCTE-35 command associated with the `AdBreak`.
     * This field can include the `splice_insert()` or `time_signal()` command.
     * **Examples**
     * * `time_signal()`
     *   ```
     *   /DA0AAAAAAAA///wBQb+cr0AUAAeAhxDVUVJSAAAjn/PAAGlmbAICAAAAAAsoKGKNAIAmsnRfg==
     *   ```
     * * `splice_insert()`
     *   ```
     *   /DAvAAAAAAAA///wFAVIAACPf+/+c2nALv4AUsz1AAAAAAAKAAhDVUVJAAABNWLbowo=
     *   ```
     *
     * Generated from protobuf field <code>optional string scte_35_cue_out = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getScte35CueOut()
    {
        return isset($this->scte_35_cue_out) ? $this->scte_35_cue_out : '';
    }

    public function hasScte35CueOut()
    {
        return isset($this->scte_35_cue_out);
    }

    public function clearScte35CueOut()
    {
        unset($this->scte_35_cue_out);
    }

    /**
     * Optional. The Base64-encoded SCTE-35 command associated with the `AdBreak`.
     * This field can include the `splice_insert()` or `time_signal()` command.
     * **Examples**
     * * `time_signal()`
     *   ```
     *   /DA0AAAAAAAA///wBQb+cr0AUAAeAhxDVUVJSAAAjn/PAAGlmbAICAAAAAAsoKGKNAIAmsnRfg==
     *   ```
     * * `splice_insert()`
     *   ```
     *   /DAvAAAAAAAA///wFAVIAACPf+/+c2nALv4AUsz1AAAAAAAKAAhDVUVJAAABNWLbowo=
     *   ```
     *
     * Generated from protobuf field <code>optional string scte_35_cue_out = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setScte35CueOut($var)
    {
        GPBUtil::checkString($var, True);
        $this->scte_35_cue_out = $var;

        return $this;
    }

}

