<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4/job.proto

namespace Google\Cloud\Talent\V4;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Job resource represents a job posting (also referred to as a "job listing"
 * or "job requisition"). A job belongs to a [Company][google.cloud.talent.v4.Company], which is the hiring
 * entity responsible for the job.
 *
 * Generated from protobuf message <code>google.cloud.talent.v4.Job</code>
 */
class Job extends \Google\Protobuf\Internal\Message
{
    /**
     * Required during job update.
     * The resource name for the job. This is generated by the service when a
     * job is created.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     * example, "projects/foo/tenants/bar/jobs/baz".
     * Use of this field in job queries and API calls is preferred over the use of
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this value is unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Required. The resource name of the company listing the job.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * Generated from protobuf field <code>string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $company = '';
    /**
     * Required. The requisition ID, also referred to as the posting ID, is assigned by the
     * client to identify a job. This field is intended to be used by clients
     * for client identification and tracking of postings. A job isn't allowed
     * to be created if there is another job with the same [company][google.cloud.talent.v4.Job.name],
     * [language_code][google.cloud.talent.v4.Job.language_code] and [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $requisition_id = '';
    /**
     * Required. The title of the job, such as "Software Engineer"
     * The maximum number of allowed characters is 500.
     *
     * Generated from protobuf field <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $title = '';
    /**
     * Required. The description of the job, which typically includes a multi-paragraph
     * description of the company and related information. Separate fields are
     * provided on the job object for [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job characteristics. Use of
     * these separate job fields is recommended.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 100,000.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $description = '';
    /**
     * Strongly recommended for the best service experience.
     * Location(s) where the employer is looking to hire for this job posting.
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', and so on.) as
     * multiple jobs with the same [company][google.cloud.talent.v4.Job.company], [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not allowed. If the original [requisition_id][google.cloud.talent.v4.Job.requisition_id] must
     * be preserved, a custom field should be used for storage. It is also
     * suggested to group the locations that close to each other in the same job
     * for better search experience.
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     * The maximum number of allowed characters is 500.
     *
     * Generated from protobuf field <code>repeated string addresses = 6;</code>
     */
    private $addresses;
    /**
     * Job application information.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     */
    private $application_info = null;
    /**
     * The benefits included with the job.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     */
    private $job_benefits;
    /**
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     */
    private $compensation_info = null;
    /**
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: [a-zA-Z][a-zA-Z0-9_]*. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4.CustomAttribute> custom_attributes = 10;</code>
     */
    private $custom_attributes;
    /**
     * The desired education degrees for the job, such as Bachelors, Masters.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     */
    private $degree_types;
    /**
     * The department or functional area within the company with the open
     * position.
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string department = 12;</code>
     */
    private $department = '';
    /**
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     */
    private $employment_types;
    /**
     * A description of bonus, commission, and other compensation
     * incentives associated with the job not including salary or pay.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string incentives = 14;</code>
     */
    private $incentives = '';
    /**
     * The language of the posting. This field is distinct from
     * any requirements for fluency that are associated with the job.
     * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     * class="external" target="_blank" }.
     * If this field is unspecified and [Job.description][google.cloud.talent.v4.Job.description] is present, detected
     * language code based on [Job.description][google.cloud.talent.v4.Job.description] is assigned, otherwise
     * defaults to 'en_US'.
     *
     * Generated from protobuf field <code>string language_code = 15;</code>
     */
    private $language_code = '';
    /**
     * The experience level associated with the job, such as "Entry Level".
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
     */
    private $job_level = 0;
    /**
     * A promotion value of the job, as determined by the client.
     * The value determines the sort order of the jobs returned when searching for
     * jobs using the featured jobs search call, with higher promotional values
     * being returned first and ties being resolved by relevance sort. Only the
     * jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH.
     * Default value is 0, and negative values are treated as 0.
     *
     * Generated from protobuf field <code>int32 promotion_value = 17;</code>
     */
    private $promotion_value = 0;
    /**
     * A description of the qualifications required to perform the
     * job. The use of this field is recommended
     * as an alternative to using the more general [description][google.cloud.talent.v4.Job.description] field.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string qualifications = 18;</code>
     */
    private $qualifications = '';
    /**
     * A description of job responsibilities. The use of this field is
     * recommended as an alternative to using the more general [description][google.cloud.talent.v4.Job.description]
     * field.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string responsibilities = 19;</code>
     */
    private $responsibilities = '';
    /**
     * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example, state, country) throughout
     * which the job is available. If this field is set, a [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * in a search query within the job region finds this job posting if an
     * exact location match isn't specified. If this field is set to
     * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the same location level as this field
     * is strongly recommended.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
     */
    private $posting_region = 0;
    /**
     * Deprecated. The job is only visible to the owner.
     * The visibility of the job.
     * Defaults to [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY] if not specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
     * @deprecated
     */
    protected $visibility = 0;
    /**
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     */
    private $job_start_time = null;
    /**
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     */
    private $job_end_time = null;
    /**
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     */
    private $posting_publish_time = null;
    /**
     * Strongly recommended for the best service experience.
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API,
     * but it can be retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API or
     * updated with the [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted with
     * the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An expired job can
     * be updated and opened again by using a future expiration timestamp.
     * Updating an expired job fails if there is another existing open job with
     * same [company][google.cloud.talent.v4.Job.company], [language_code][google.cloud.talent.v4.Job.language_code] and [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     * Invalid timestamps are ignored, and treated as expire time not provided.
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time] must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The purpose of this feature is
     * to allow other objects, such as [Application][], to refer a job
     * that didn't exist in the system prior to becoming expired. If you
     * want to modify a job that was expired on creation,
     * delete it and create a new one.
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     * If this value isn't provided on job update, it depends on the field masks
     * set by [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask]. If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are empty meaning that every field is
     * updated, the job posting expires after 30 days from the job's last
     * update time. Otherwise the expiration date isn't updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     */
    private $posting_expire_time = null;
    /**
     * Output only. The timestamp when this job posting was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $posting_create_time = null;
    /**
     * Output only. The timestamp when this job posting was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $posting_update_time = null;
    /**
     * Output only. Display name of the company listing the job.
     *
     * Generated from protobuf field <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $company_display_name = '';
    /**
     * Output only. Derived details about the job posting.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $derived_info = null;
    /**
     * Options for job processing.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     */
    private $processing_options = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required during job update.
     *           The resource name for the job. This is generated by the service when a
     *           job is created.
     *           The format is
     *           "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     *           example, "projects/foo/tenants/bar/jobs/baz".
     *           Use of this field in job queries and API calls is preferred over the use of
     *           [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this value is unique.
     *     @type string $company
     *           Required. The resource name of the company listing the job.
     *           The format is
     *           "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     *           example, "projects/foo/tenants/bar/companies/baz".
     *     @type string $requisition_id
     *           Required. The requisition ID, also referred to as the posting ID, is assigned by the
     *           client to identify a job. This field is intended to be used by clients
     *           for client identification and tracking of postings. A job isn't allowed
     *           to be created if there is another job with the same [company][google.cloud.talent.v4.Job.name],
     *           [language_code][google.cloud.talent.v4.Job.language_code] and [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *           The maximum number of allowed characters is 255.
     *     @type string $title
     *           Required. The title of the job, such as "Software Engineer"
     *           The maximum number of allowed characters is 500.
     *     @type string $description
     *           Required. The description of the job, which typically includes a multi-paragraph
     *           description of the company and related information. Separate fields are
     *           provided on the job object for [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     *           [qualifications][google.cloud.talent.v4.Job.qualifications], and other job characteristics. Use of
     *           these separate job fields is recommended.
     *           This field accepts and sanitizes HTML input, and also accepts
     *           bold, italic, ordered list, and unordered list markup tags.
     *           The maximum number of allowed characters is 100,000.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $addresses
     *           Strongly recommended for the best service experience.
     *           Location(s) where the employer is looking to hire for this job posting.
     *           Specifying the full street address(es) of the hiring location enables
     *           better API results, especially job searches by commute time.
     *           At most 50 locations are allowed for best search performance. If a job has
     *           more locations, it is suggested to split it into multiple jobs with unique
     *           [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', and so on.) as
     *           multiple jobs with the same [company][google.cloud.talent.v4.Job.company], [language_code][google.cloud.talent.v4.Job.language_code] and
     *           [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not allowed. If the original [requisition_id][google.cloud.talent.v4.Job.requisition_id] must
     *           be preserved, a custom field should be used for storage. It is also
     *           suggested to group the locations that close to each other in the same job
     *           for better search experience.
     *           Jobs with multiple addresses must have their addresses with the same
     *           [LocationType][] to allow location filtering to work properly. (For
     *           example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     *           CA, USA" and "London, UK" may not have location filters applied correctly
     *           at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     *           second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     *           addresses, it is suggested to split it into multiple jobs with same
     *           LocationTypes.
     *           The maximum number of allowed characters is 500.
     *     @type \Google\Cloud\Talent\V4\Job\ApplicationInfo $application_info
     *           Job application information.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $job_benefits
     *           The benefits included with the job.
     *     @type \Google\Cloud\Talent\V4\CompensationInfo $compensation_info
     *           Job compensation information (a.k.a. "pay rate") i.e., the compensation
     *           that will paid to the employee.
     *     @type array|\Google\Protobuf\Internal\MapField $custom_attributes
     *           A map of fields to hold both filterable and non-filterable custom job
     *           attributes that are not covered by the provided structured fields.
     *           The keys of the map are strings up to 64 bytes and must match the
     *           pattern: [a-zA-Z][a-zA-Z0-9_]*. For example, key0LikeThis or
     *           KEY_1_LIKE_THIS.
     *           At most 100 filterable and at most 100 unfilterable keys are supported.
     *           For filterable `string_values`, across all keys at most 200 values are
     *           allowed, with each string no more than 255 characters. For unfilterable
     *           `string_values`, the maximum total size of `string_values` across all keys
     *           is 50KB.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $degree_types
     *           The desired education degrees for the job, such as Bachelors, Masters.
     *     @type string $department
     *           The department or functional area within the company with the open
     *           position.
     *           The maximum number of allowed characters is 255.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $employment_types
     *           The employment type(s) of a job, for example,
     *           [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     *           [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     *     @type string $incentives
     *           A description of bonus, commission, and other compensation
     *           incentives associated with the job not including salary or pay.
     *           The maximum number of allowed characters is 10,000.
     *     @type string $language_code
     *           The language of the posting. This field is distinct from
     *           any requirements for fluency that are associated with the job.
     *           Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     *           For more information, see
     *           [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     *           class="external" target="_blank" }.
     *           If this field is unspecified and [Job.description][google.cloud.talent.v4.Job.description] is present, detected
     *           language code based on [Job.description][google.cloud.talent.v4.Job.description] is assigned, otherwise
     *           defaults to 'en_US'.
     *     @type int $job_level
     *           The experience level associated with the job, such as "Entry Level".
     *     @type int $promotion_value
     *           A promotion value of the job, as determined by the client.
     *           The value determines the sort order of the jobs returned when searching for
     *           jobs using the featured jobs search call, with higher promotional values
     *           being returned first and ties being resolved by relevance sort. Only the
     *           jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH.
     *           Default value is 0, and negative values are treated as 0.
     *     @type string $qualifications
     *           A description of the qualifications required to perform the
     *           job. The use of this field is recommended
     *           as an alternative to using the more general [description][google.cloud.talent.v4.Job.description] field.
     *           This field accepts and sanitizes HTML input, and also accepts
     *           bold, italic, ordered list, and unordered list markup tags.
     *           The maximum number of allowed characters is 10,000.
     *     @type string $responsibilities
     *           A description of job responsibilities. The use of this field is
     *           recommended as an alternative to using the more general [description][google.cloud.talent.v4.Job.description]
     *           field.
     *           This field accepts and sanitizes HTML input, and also accepts
     *           bold, italic, ordered list, and unordered list markup tags.
     *           The maximum number of allowed characters is 10,000.
     *     @type int $posting_region
     *           The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example, state, country) throughout
     *           which the job is available. If this field is set, a [LocationFilter][google.cloud.talent.v4.LocationFilter]
     *           in a search query within the job region finds this job posting if an
     *           exact location match isn't specified. If this field is set to
     *           [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     *           setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the same location level as this field
     *           is strongly recommended.
     *     @type int $visibility
     *           Deprecated. The job is only visible to the owner.
     *           The visibility of the job.
     *           Defaults to [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY] if not specified.
     *     @type \Google\Protobuf\Timestamp $job_start_time
     *           The start timestamp of the job in UTC time zone. Typically this field
     *           is used for contracting engagements. Invalid timestamps are ignored.
     *     @type \Google\Protobuf\Timestamp $job_end_time
     *           The end timestamp of the job. Typically this field is used for contracting
     *           engagements. Invalid timestamps are ignored.
     *     @type \Google\Protobuf\Timestamp $posting_publish_time
     *           The timestamp this job posting was most recently published. The default
     *           value is the time the request arrives at the server. Invalid timestamps are
     *           ignored.
     *     @type \Google\Protobuf\Timestamp $posting_expire_time
     *           Strongly recommended for the best service experience.
     *           The expiration timestamp of the job. After this timestamp, the
     *           job is marked as expired, and it no longer appears in search results. The
     *           expired job can't be listed by the [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API,
     *           but it can be retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API or
     *           updated with the [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted with
     *           the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An expired job can
     *           be updated and opened again by using a future expiration timestamp.
     *           Updating an expired job fails if there is another existing open job with
     *           same [company][google.cloud.talent.v4.Job.company], [language_code][google.cloud.talent.v4.Job.language_code] and [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *           The expired jobs are retained in our system for 90 days. However, the
     *           overall expired job count cannot exceed 3 times the maximum number of
     *           open jobs over previous 7 days. If this threshold is exceeded,
     *           expired jobs are cleaned out in order of earliest expire time.
     *           Expired jobs are no longer accessible after they are cleaned
     *           out.
     *           Invalid timestamps are ignored, and treated as expire time not provided.
     *           If the timestamp is before the instant request is made, the job
     *           is treated as expired immediately on creation. This kind of job can
     *           not be updated. And when creating a job with past timestamp, the
     *           [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time] must be set before
     *           [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The purpose of this feature is
     *           to allow other objects, such as [Application][], to refer a job
     *           that didn't exist in the system prior to becoming expired. If you
     *           want to modify a job that was expired on creation,
     *           delete it and create a new one.
     *           If this value isn't provided at the time of job creation or is invalid,
     *           the job posting expires after 30 days from the job's creation time. For
     *           example, if the job was created on 2017/01/01 13:00AM UTC with an
     *           unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *           If this value isn't provided on job update, it depends on the field masks
     *           set by [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask]. If the field masks include
     *           [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are empty meaning that every field is
     *           updated, the job posting expires after 30 days from the job's last
     *           update time. Otherwise the expiration date isn't updated.
     *     @type \Google\Protobuf\Timestamp $posting_create_time
     *           Output only. The timestamp when this job posting was created.
     *     @type \Google\Protobuf\Timestamp $posting_update_time
     *           Output only. The timestamp when this job posting was last updated.
     *     @type string $company_display_name
     *           Output only. Display name of the company listing the job.
     *     @type \Google\Cloud\Talent\V4\Job\DerivedInfo $derived_info
     *           Output only. Derived details about the job posting.
     *     @type \Google\Cloud\Talent\V4\Job\ProcessingOptions $processing_options
     *           Options for job processing.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4\Job::initOnce();
        parent::__construct($data);
    }

    /**
     * Required during job update.
     * The resource name for the job. This is generated by the service when a
     * job is created.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     * example, "projects/foo/tenants/bar/jobs/baz".
     * Use of this field in job queries and API calls is preferred over the use of
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this value is unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required during job update.
     * The resource name for the job. This is generated by the service when a
     * job is created.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     * example, "projects/foo/tenants/bar/jobs/baz".
     * Use of this field in job queries and API calls is preferred over the use of
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this value is unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The resource name of the company listing the job.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * Generated from protobuf field <code>string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Required. The resource name of the company listing the job.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * Generated from protobuf field <code>string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCompany($var)
    {
        GPBUtil::checkString($var, True);
        $this->company = $var;

        return $this;
    }

    /**
     * Required. The requisition ID, also referred to as the posting ID, is assigned by the
     * client to identify a job. This field is intended to be used by clients
     * for client identification and tracking of postings. A job isn't allowed
     * to be created if there is another job with the same [company][google.cloud.talent.v4.Job.name],
     * [language_code][google.cloud.talent.v4.Job.language_code] and [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getRequisitionId()
    {
        return $this->requisition_id;
    }

    /**
     * Required. The requisition ID, also referred to as the posting ID, is assigned by the
     * client to identify a job. This field is intended to be used by clients
     * for client identification and tracking of postings. A job isn't allowed
     * to be created if there is another job with the same [company][google.cloud.talent.v4.Job.name],
     * [language_code][google.cloud.talent.v4.Job.language_code] and [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setRequisitionId($var)
    {
        GPBUtil::checkString($var, True);
        $this->requisition_id = $var;

        return $this;
    }

    /**
     * Required. The title of the job, such as "Software Engineer"
     * The maximum number of allowed characters is 500.
     *
     * Generated from protobuf field <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Required. The title of the job, such as "Software Engineer"
     * The maximum number of allowed characters is 500.
     *
     * Generated from protobuf field <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * Required. The description of the job, which typically includes a multi-paragraph
     * description of the company and related information. Separate fields are
     * provided on the job object for [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job characteristics. Use of
     * these separate job fields is recommended.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 100,000.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Required. The description of the job, which typically includes a multi-paragraph
     * description of the company and related information. Separate fields are
     * provided on the job object for [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job characteristics. Use of
     * these separate job fields is recommended.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 100,000.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Strongly recommended for the best service experience.
     * Location(s) where the employer is looking to hire for this job posting.
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', and so on.) as
     * multiple jobs with the same [company][google.cloud.talent.v4.Job.company], [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not allowed. If the original [requisition_id][google.cloud.talent.v4.Job.requisition_id] must
     * be preserved, a custom field should be used for storage. It is also
     * suggested to group the locations that close to each other in the same job
     * for better search experience.
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     * The maximum number of allowed characters is 500.
     *
     * Generated from protobuf field <code>repeated string addresses = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAddresses()
    {
        return $this->addresses;
    }

    /**
     * Strongly recommended for the best service experience.
     * Location(s) where the employer is looking to hire for this job posting.
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA' becomes 'ReqA-1', 'ReqA-2', and so on.) as
     * multiple jobs with the same [company][google.cloud.talent.v4.Job.company], [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not allowed. If the original [requisition_id][google.cloud.talent.v4.Job.requisition_id] must
     * be preserved, a custom field should be used for storage. It is also
     * suggested to group the locations that close to each other in the same job
     * for better search experience.
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     * The maximum number of allowed characters is 500.
     *
     * Generated from protobuf field <code>repeated string addresses = 6;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->addresses = $arr;

        return $this;
    }

    /**
     * Job application information.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     * @return \Google\Cloud\Talent\V4\Job\ApplicationInfo|null
     */
    public function getApplicationInfo()
    {
        return isset($this->application_info) ? $this->application_info : null;
    }

    public function hasApplicationInfo()
    {
        return isset($this->application_info);
    }

    public function clearApplicationInfo()
    {
        unset($this->application_info);
    }

    /**
     * Job application information.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     * @param \Google\Cloud\Talent\V4\Job\ApplicationInfo $var
     * @return $this
     */
    public function setApplicationInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4\Job\ApplicationInfo::class);
        $this->application_info = $var;

        return $this;
    }

    /**
     * The benefits included with the job.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getJobBenefits()
    {
        return $this->job_benefits;
    }

    /**
     * The benefits included with the job.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setJobBenefits($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Talent\V4\JobBenefit::class);
        $this->job_benefits = $arr;

        return $this;
    }

    /**
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     * @return \Google\Cloud\Talent\V4\CompensationInfo|null
     */
    public function getCompensationInfo()
    {
        return isset($this->compensation_info) ? $this->compensation_info : null;
    }

    public function hasCompensationInfo()
    {
        return isset($this->compensation_info);
    }

    public function clearCompensationInfo()
    {
        unset($this->compensation_info);
    }

    /**
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     * @param \Google\Cloud\Talent\V4\CompensationInfo $var
     * @return $this
     */
    public function setCompensationInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4\CompensationInfo::class);
        $this->compensation_info = $var;

        return $this;
    }

    /**
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: [a-zA-Z][a-zA-Z0-9_]*. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4.CustomAttribute> custom_attributes = 10;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getCustomAttributes()
    {
        return $this->custom_attributes;
    }

    /**
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: [a-zA-Z][a-zA-Z0-9_]*. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4.CustomAttribute> custom_attributes = 10;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setCustomAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4\CustomAttribute::class);
        $this->custom_attributes = $arr;

        return $this;
    }

    /**
     * The desired education degrees for the job, such as Bachelors, Masters.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDegreeTypes()
    {
        return $this->degree_types;
    }

    /**
     * The desired education degrees for the job, such as Bachelors, Masters.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDegreeTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Talent\V4\DegreeType::class);
        $this->degree_types = $arr;

        return $this;
    }

    /**
     * The department or functional area within the company with the open
     * position.
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string department = 12;</code>
     * @return string
     */
    public function getDepartment()
    {
        return $this->department;
    }

    /**
     * The department or functional area within the company with the open
     * position.
     * The maximum number of allowed characters is 255.
     *
     * Generated from protobuf field <code>string department = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setDepartment($var)
    {
        GPBUtil::checkString($var, True);
        $this->department = $var;

        return $this;
    }

    /**
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEmploymentTypes()
    {
        return $this->employment_types;
    }

    /**
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEmploymentTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Talent\V4\EmploymentType::class);
        $this->employment_types = $arr;

        return $this;
    }

    /**
     * A description of bonus, commission, and other compensation
     * incentives associated with the job not including salary or pay.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string incentives = 14;</code>
     * @return string
     */
    public function getIncentives()
    {
        return $this->incentives;
    }

    /**
     * A description of bonus, commission, and other compensation
     * incentives associated with the job not including salary or pay.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string incentives = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setIncentives($var)
    {
        GPBUtil::checkString($var, True);
        $this->incentives = $var;

        return $this;
    }

    /**
     * The language of the posting. This field is distinct from
     * any requirements for fluency that are associated with the job.
     * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     * class="external" target="_blank" }.
     * If this field is unspecified and [Job.description][google.cloud.talent.v4.Job.description] is present, detected
     * language code based on [Job.description][google.cloud.talent.v4.Job.description] is assigned, otherwise
     * defaults to 'en_US'.
     *
     * Generated from protobuf field <code>string language_code = 15;</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * The language of the posting. This field is distinct from
     * any requirements for fluency that are associated with the job.
     * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     * class="external" target="_blank" }.
     * If this field is unspecified and [Job.description][google.cloud.talent.v4.Job.description] is present, detected
     * language code based on [Job.description][google.cloud.talent.v4.Job.description] is assigned, otherwise
     * defaults to 'en_US'.
     *
     * Generated from protobuf field <code>string language_code = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * The experience level associated with the job, such as "Entry Level".
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
     * @return int
     */
    public function getJobLevel()
    {
        return $this->job_level;
    }

    /**
     * The experience level associated with the job, such as "Entry Level".
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
     * @param int $var
     * @return $this
     */
    public function setJobLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Talent\V4\JobLevel::class);
        $this->job_level = $var;

        return $this;
    }

    /**
     * A promotion value of the job, as determined by the client.
     * The value determines the sort order of the jobs returned when searching for
     * jobs using the featured jobs search call, with higher promotional values
     * being returned first and ties being resolved by relevance sort. Only the
     * jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH.
     * Default value is 0, and negative values are treated as 0.
     *
     * Generated from protobuf field <code>int32 promotion_value = 17;</code>
     * @return int
     */
    public function getPromotionValue()
    {
        return $this->promotion_value;
    }

    /**
     * A promotion value of the job, as determined by the client.
     * The value determines the sort order of the jobs returned when searching for
     * jobs using the featured jobs search call, with higher promotional values
     * being returned first and ties being resolved by relevance sort. Only the
     * jobs with a promotionValue >0 are returned in a FEATURED_JOB_SEARCH.
     * Default value is 0, and negative values are treated as 0.
     *
     * Generated from protobuf field <code>int32 promotion_value = 17;</code>
     * @param int $var
     * @return $this
     */
    public function setPromotionValue($var)
    {
        GPBUtil::checkInt32($var);
        $this->promotion_value = $var;

        return $this;
    }

    /**
     * A description of the qualifications required to perform the
     * job. The use of this field is recommended
     * as an alternative to using the more general [description][google.cloud.talent.v4.Job.description] field.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string qualifications = 18;</code>
     * @return string
     */
    public function getQualifications()
    {
        return $this->qualifications;
    }

    /**
     * A description of the qualifications required to perform the
     * job. The use of this field is recommended
     * as an alternative to using the more general [description][google.cloud.talent.v4.Job.description] field.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string qualifications = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setQualifications($var)
    {
        GPBUtil::checkString($var, True);
        $this->qualifications = $var;

        return $this;
    }

    /**
     * A description of job responsibilities. The use of this field is
     * recommended as an alternative to using the more general [description][google.cloud.talent.v4.Job.description]
     * field.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string responsibilities = 19;</code>
     * @return string
     */
    public function getResponsibilities()
    {
        return $this->responsibilities;
    }

    /**
     * A description of job responsibilities. The use of this field is
     * recommended as an alternative to using the more general [description][google.cloud.talent.v4.Job.description]
     * field.
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     * The maximum number of allowed characters is 10,000.
     *
     * Generated from protobuf field <code>string responsibilities = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setResponsibilities($var)
    {
        GPBUtil::checkString($var, True);
        $this->responsibilities = $var;

        return $this;
    }

    /**
     * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example, state, country) throughout
     * which the job is available. If this field is set, a [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * in a search query within the job region finds this job posting if an
     * exact location match isn't specified. If this field is set to
     * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the same location level as this field
     * is strongly recommended.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
     * @return int
     */
    public function getPostingRegion()
    {
        return $this->posting_region;
    }

    /**
     * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example, state, country) throughout
     * which the job is available. If this field is set, a [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * in a search query within the job region finds this job posting if an
     * exact location match isn't specified. If this field is set to
     * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the same location level as this field
     * is strongly recommended.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
     * @param int $var
     * @return $this
     */
    public function setPostingRegion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Talent\V4\PostingRegion::class);
        $this->posting_region = $var;

        return $this;
    }

    /**
     * Deprecated. The job is only visible to the owner.
     * The visibility of the job.
     * Defaults to [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY] if not specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
     * @return int
     * @deprecated
     */
    public function getVisibility()
    {
        @trigger_error('visibility is deprecated.', E_USER_DEPRECATED);
        return $this->visibility;
    }

    /**
     * Deprecated. The job is only visible to the owner.
     * The visibility of the job.
     * Defaults to [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY] if not specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setVisibility($var)
    {
        @trigger_error('visibility is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkEnum($var, \Google\Cloud\Talent\V4\Visibility::class);
        $this->visibility = $var;

        return $this;
    }

    /**
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getJobStartTime()
    {
        return isset($this->job_start_time) ? $this->job_start_time : null;
    }

    public function hasJobStartTime()
    {
        return isset($this->job_start_time);
    }

    public function clearJobStartTime()
    {
        unset($this->job_start_time);
    }

    /**
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setJobStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->job_start_time = $var;

        return $this;
    }

    /**
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getJobEndTime()
    {
        return isset($this->job_end_time) ? $this->job_end_time : null;
    }

    public function hasJobEndTime()
    {
        return isset($this->job_end_time);
    }

    public function clearJobEndTime()
    {
        unset($this->job_end_time);
    }

    /**
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setJobEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->job_end_time = $var;

        return $this;
    }

    /**
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getPostingPublishTime()
    {
        return isset($this->posting_publish_time) ? $this->posting_publish_time : null;
    }

    public function hasPostingPublishTime()
    {
        return isset($this->posting_publish_time);
    }

    public function clearPostingPublishTime()
    {
        unset($this->posting_publish_time);
    }

    /**
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setPostingPublishTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->posting_publish_time = $var;

        return $this;
    }

    /**
     * Strongly recommended for the best service experience.
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API,
     * but it can be retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API or
     * updated with the [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted with
     * the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An expired job can
     * be updated and opened again by using a future expiration timestamp.
     * Updating an expired job fails if there is another existing open job with
     * same [company][google.cloud.talent.v4.Job.company], [language_code][google.cloud.talent.v4.Job.language_code] and [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     * Invalid timestamps are ignored, and treated as expire time not provided.
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time] must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The purpose of this feature is
     * to allow other objects, such as [Application][], to refer a job
     * that didn't exist in the system prior to becoming expired. If you
     * want to modify a job that was expired on creation,
     * delete it and create a new one.
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     * If this value isn't provided on job update, it depends on the field masks
     * set by [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask]. If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are empty meaning that every field is
     * updated, the job posting expires after 30 days from the job's last
     * update time. Otherwise the expiration date isn't updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getPostingExpireTime()
    {
        return isset($this->posting_expire_time) ? $this->posting_expire_time : null;
    }

    public function hasPostingExpireTime()
    {
        return isset($this->posting_expire_time);
    }

    public function clearPostingExpireTime()
    {
        unset($this->posting_expire_time);
    }

    /**
     * Strongly recommended for the best service experience.
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API,
     * but it can be retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API or
     * updated with the [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted with
     * the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An expired job can
     * be updated and opened again by using a future expiration timestamp.
     * Updating an expired job fails if there is another existing open job with
     * same [company][google.cloud.talent.v4.Job.company], [language_code][google.cloud.talent.v4.Job.language_code] and [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     * Invalid timestamps are ignored, and treated as expire time not provided.
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time] must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The purpose of this feature is
     * to allow other objects, such as [Application][], to refer a job
     * that didn't exist in the system prior to becoming expired. If you
     * want to modify a job that was expired on creation,
     * delete it and create a new one.
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     * If this value isn't provided on job update, it depends on the field masks
     * set by [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask]. If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are empty meaning that every field is
     * updated, the job posting expires after 30 days from the job's last
     * update time. Otherwise the expiration date isn't updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setPostingExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->posting_expire_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when this job posting was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getPostingCreateTime()
    {
        return isset($this->posting_create_time) ? $this->posting_create_time : null;
    }

    public function hasPostingCreateTime()
    {
        return isset($this->posting_create_time);
    }

    public function clearPostingCreateTime()
    {
        unset($this->posting_create_time);
    }

    /**
     * Output only. The timestamp when this job posting was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setPostingCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->posting_create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when this job posting was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getPostingUpdateTime()
    {
        return isset($this->posting_update_time) ? $this->posting_update_time : null;
    }

    public function hasPostingUpdateTime()
    {
        return isset($this->posting_update_time);
    }

    public function clearPostingUpdateTime()
    {
        unset($this->posting_update_time);
    }

    /**
     * Output only. The timestamp when this job posting was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setPostingUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->posting_update_time = $var;

        return $this;
    }

    /**
     * Output only. Display name of the company listing the job.
     *
     * Generated from protobuf field <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCompanyDisplayName()
    {
        return $this->company_display_name;
    }

    /**
     * Output only. Display name of the company listing the job.
     *
     * Generated from protobuf field <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCompanyDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->company_display_name = $var;

        return $this;
    }

    /**
     * Output only. Derived details about the job posting.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Talent\V4\Job\DerivedInfo|null
     */
    public function getDerivedInfo()
    {
        return isset($this->derived_info) ? $this->derived_info : null;
    }

    public function hasDerivedInfo()
    {
        return isset($this->derived_info);
    }

    public function clearDerivedInfo()
    {
        unset($this->derived_info);
    }

    /**
     * Output only. Derived details about the job posting.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Talent\V4\Job\DerivedInfo $var
     * @return $this
     */
    public function setDerivedInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4\Job\DerivedInfo::class);
        $this->derived_info = $var;

        return $this;
    }

    /**
     * Options for job processing.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     * @return \Google\Cloud\Talent\V4\Job\ProcessingOptions|null
     */
    public function getProcessingOptions()
    {
        return isset($this->processing_options) ? $this->processing_options : null;
    }

    public function hasProcessingOptions()
    {
        return isset($this->processing_options);
    }

    public function clearProcessingOptions()
    {
        unset($this->processing_options);
    }

    /**
     * Options for job processing.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     * @param \Google\Cloud\Talent\V4\Job\ProcessingOptions $var
     * @return $this
     */
    public function setProcessingOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4\Job\ProcessingOptions::class);
        $this->processing_options = $var;

        return $this;
    }

}

