<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An AwsS3Data resource can be a data source, but not a data sink.
 * In an AwsS3Data resource, an object's name is the S3 object's key name.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.AwsS3Data</code>
 */
class AwsS3Data extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. S3 Bucket name (see
     * [Creating a
     * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
     *
     * Generated from protobuf field <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $bucket_name = '';
    /**
     * Input only. AWS access key used to sign the API requests to the AWS S3
     * bucket. Permissions on the bucket must be granted to the access ID of the
     * AWS access key. This field is required.
     * For information on our data retention policy for user credentials, see
     * [User credentials](https://cloud.google.com/storage-transfer/docs/data-retention#user-credentials).
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $aws_access_key = null;
    /**
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     *
     * Generated from protobuf field <code>string path = 3;</code>
     */
    private $path = '';
    /**
     * Input only. Role arn to support temporary credentials via
     * AssumeRoleWithWebIdentity.
     * When role arn is provided, transfer service will fetch temporary
     * credentials for the session using AssumeRoleWithWebIdentity call for the
     * provided role using the [GoogleServiceAccount] for this project.
     *
     * Generated from protobuf field <code>string role_arn = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $role_arn = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $bucket_name
     *           Required. S3 Bucket name (see
     *           [Creating a
     *           bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
     *     @type \Google\Cloud\StorageTransfer\V1\AwsAccessKey $aws_access_key
     *           Input only. AWS access key used to sign the API requests to the AWS S3
     *           bucket. Permissions on the bucket must be granted to the access ID of the
     *           AWS access key. This field is required.
     *           For information on our data retention policy for user credentials, see
     *           [User credentials](https://cloud.google.com/storage-transfer/docs/data-retention#user-credentials).
     *     @type string $path
     *           Root path to transfer objects.
     *           Must be an empty string or full path name that ends with a '/'. This field
     *           is treated as an object prefix. As such, it should generally not begin with
     *           a '/'.
     *     @type string $role_arn
     *           Input only. Role arn to support temporary credentials via
     *           AssumeRoleWithWebIdentity.
     *           When role arn is provided, transfer service will fetch temporary
     *           credentials for the session using AssumeRoleWithWebIdentity call for the
     *           provided role using the [GoogleServiceAccount] for this project.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. S3 Bucket name (see
     * [Creating a
     * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
     *
     * Generated from protobuf field <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getBucketName()
    {
        return $this->bucket_name;
    }

    /**
     * Required. S3 Bucket name (see
     * [Creating a
     * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
     *
     * Generated from protobuf field <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setBucketName($var)
    {
        GPBUtil::checkString($var, True);
        $this->bucket_name = $var;

        return $this;
    }

    /**
     * Input only. AWS access key used to sign the API requests to the AWS S3
     * bucket. Permissions on the bucket must be granted to the access ID of the
     * AWS access key. This field is required.
     * For information on our data retention policy for user credentials, see
     * [User credentials](https://cloud.google.com/storage-transfer/docs/data-retention#user-credentials).
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Cloud\StorageTransfer\V1\AwsAccessKey|null
     */
    public function getAwsAccessKey()
    {
        return isset($this->aws_access_key) ? $this->aws_access_key : null;
    }

    public function hasAwsAccessKey()
    {
        return isset($this->aws_access_key);
    }

    public function clearAwsAccessKey()
    {
        unset($this->aws_access_key);
    }

    /**
     * Input only. AWS access key used to sign the API requests to the AWS S3
     * bucket. Permissions on the bucket must be granted to the access ID of the
     * AWS access key. This field is required.
     * For information on our data retention policy for user credentials, see
     * [User credentials](https://cloud.google.com/storage-transfer/docs/data-retention#user-credentials).
     *
     * Generated from protobuf field <code>.google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Cloud\StorageTransfer\V1\AwsAccessKey $var
     * @return $this
     */
    public function setAwsAccessKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\StorageTransfer\V1\AwsAccessKey::class);
        $this->aws_access_key = $var;

        return $this;
    }

    /**
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     *
     * Generated from protobuf field <code>string path = 3;</code>
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     *
     * Generated from protobuf field <code>string path = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->path = $var;

        return $this;
    }

    /**
     * Input only. Role arn to support temporary credentials via
     * AssumeRoleWithWebIdentity.
     * When role arn is provided, transfer service will fetch temporary
     * credentials for the session using AssumeRoleWithWebIdentity call for the
     * provided role using the [GoogleServiceAccount] for this project.
     *
     * Generated from protobuf field <code>string role_arn = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return string
     */
    public function getRoleArn()
    {
        return $this->role_arn;
    }

    /**
     * Input only. Role arn to support temporary credentials via
     * AssumeRoleWithWebIdentity.
     * When role arn is provided, transfer service will fetch temporary
     * credentials for the session using AssumeRoleWithWebIdentity call for the
     * provided role using the [GoogleServiceAccount] for this project.
     *
     * Generated from protobuf field <code>string role_arn = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setRoleArn($var)
    {
        GPBUtil::checkString($var, True);
        $this->role_arn = $var;

        return $this;
    }

}

