<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/api/servicecontrol/v1/quota_controller.proto

namespace Google\Cloud\ServiceControl\V1\QuotaOperation;

use UnexpectedValueException;

/**
 * Supported quota modes.
 *
 * Protobuf type <code>google.api.servicecontrol.v1.QuotaOperation.QuotaMode</code>
 */
class QuotaMode
{
    /**
     * Guard against implicit default. Must not be used.
     *
     * Generated from protobuf enum <code>UNSPECIFIED = 0;</code>
     */
    const UNSPECIFIED = 0;
    /**
     * For AllocateQuota request, allocates quota for the amount specified in
     * the service configuration or specified using the quota metrics. If the
     * amount is higher than the available quota, allocation error will be
     * returned and no quota will be allocated.
     * If multiple quotas are part of the request, and one fails, none of the
     * quotas are allocated or released.
     *
     * Generated from protobuf enum <code>NORMAL = 1;</code>
     */
    const NORMAL = 1;
    /**
     * The operation allocates quota for the amount specified in the service
     * configuration or specified using the quota metrics. If the amount is
     * higher than the available quota, request does not fail but all available
     * quota will be allocated.
     * For rate quota, BEST_EFFORT will continue to deduct from other groups
     * even if one does not have enough quota. For allocation, it will find the
     * minimum available amount across all groups and deduct that amount from
     * all the affected groups.
     *
     * Generated from protobuf enum <code>BEST_EFFORT = 2;</code>
     */
    const BEST_EFFORT = 2;
    /**
     * For AllocateQuota request, only checks if there is enough quota
     * available and does not change the available quota. No lock is placed on
     * the available quota either.
     *
     * Generated from protobuf enum <code>CHECK_ONLY = 3;</code>
     */
    const CHECK_ONLY = 3;
    /**
     * Unimplemented. When used in AllocateQuotaRequest, this returns the
     * effective quota limit(s) in the response, and no quota check will be
     * performed. Not supported for other requests, and even for
     * AllocateQuotaRequest, this is currently supported only for allowlisted
     * services.
     *
     * Generated from protobuf enum <code>QUERY_ONLY = 4;</code>
     */
    const QUERY_ONLY = 4;
    /**
     * The operation allocates quota for the amount specified in the service
     * configuration or specified using the quota metrics. If the requested
     * amount is higher than the available quota, request does not fail and
     * remaining quota would become negative (going over the limit).
     * Not supported for Rate Quota.
     *
     * Generated from protobuf enum <code>ADJUST_ONLY = 5;</code>
     */
    const ADJUST_ONLY = 5;

    private static $valueToName = [
        self::UNSPECIFIED => 'UNSPECIFIED',
        self::NORMAL => 'NORMAL',
        self::BEST_EFFORT => 'BEST_EFFORT',
        self::CHECK_ONLY => 'CHECK_ONLY',
        self::QUERY_ONLY => 'QUERY_ONLY',
        self::ADJUST_ONLY => 'ADJUST_ONLY',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(QuotaMode::class, \Google\Cloud\ServiceControl\V1\QuotaOperation_QuotaMode::class);

