<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/resourcemanager/v3/folders.proto

namespace Google\Cloud\ResourceManager\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A folder in an organization's resource hierarchy, used to
 * organize that organization's resources.
 *
 * Generated from protobuf message <code>google.cloud.resourcemanager.v3.Folder</code>
 */
class Folder extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the folder.
     * Its format is `folders/{folder_id}`, for example: "folders/1234".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Required. The folder's parent's resource name.
     * Updates to the folder's parent must be performed using
     * [MoveFolder][google.cloud.resourcemanager.v3.Folders.MoveFolder].
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $parent = '';
    /**
     * The folder's display name.
     * A folder's display name must be unique amongst its siblings. For example,
     * no two folders with the same parent can share the same display name.
     * The display name must start and end with a letter or digit, may contain
     * letters, digits, spaces, hyphens and underscores and can be no longer
     * than 30 characters. This is captured by the regular expression:
     * `[\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?`.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     */
    private $display_name = '';
    /**
     * Output only. The lifecycle state of the folder.
     * Updates to the state must be performed using
     * [DeleteFolder][google.cloud.resourcemanager.v3.Folders.DeleteFolder] and
     * [UndeleteFolder][google.cloud.resourcemanager.v3.Folders.UndeleteFolder].
     *
     * Generated from protobuf field <code>.google.cloud.resourcemanager.v3.Folder.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Timestamp when the folder was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. Timestamp when the folder was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Output only. Timestamp when the folder was requested to be deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $delete_time = null;
    /**
     * Output only. A checksum computed by the server based on the current value of the folder
     * resource. This may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the folder.
     *           Its format is `folders/{folder_id}`, for example: "folders/1234".
     *     @type string $parent
     *           Required. The folder's parent's resource name.
     *           Updates to the folder's parent must be performed using
     *           [MoveFolder][google.cloud.resourcemanager.v3.Folders.MoveFolder].
     *     @type string $display_name
     *           The folder's display name.
     *           A folder's display name must be unique amongst its siblings. For example,
     *           no two folders with the same parent can share the same display name.
     *           The display name must start and end with a letter or digit, may contain
     *           letters, digits, spaces, hyphens and underscores and can be no longer
     *           than 30 characters. This is captured by the regular expression:
     *           `[\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?`.
     *     @type int $state
     *           Output only. The lifecycle state of the folder.
     *           Updates to the state must be performed using
     *           [DeleteFolder][google.cloud.resourcemanager.v3.Folders.DeleteFolder] and
     *           [UndeleteFolder][google.cloud.resourcemanager.v3.Folders.UndeleteFolder].
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when the folder was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Timestamp when the folder was last modified.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. Timestamp when the folder was requested to be deleted.
     *     @type string $etag
     *           Output only. A checksum computed by the server based on the current value of the folder
     *           resource. This may be sent on update and delete requests to ensure the
     *           client has an up-to-date value before proceeding.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Resourcemanager\V3\Folders::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the folder.
     * Its format is `folders/{folder_id}`, for example: "folders/1234".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the folder.
     * Its format is `folders/{folder_id}`, for example: "folders/1234".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The folder's parent's resource name.
     * Updates to the folder's parent must be performed using
     * [MoveFolder][google.cloud.resourcemanager.v3.Folders.MoveFolder].
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The folder's parent's resource name.
     * Updates to the folder's parent must be performed using
     * [MoveFolder][google.cloud.resourcemanager.v3.Folders.MoveFolder].
     *
     * Generated from protobuf field <code>string parent = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The folder's display name.
     * A folder's display name must be unique amongst its siblings. For example,
     * no two folders with the same parent can share the same display name.
     * The display name must start and end with a letter or digit, may contain
     * letters, digits, spaces, hyphens and underscores and can be no longer
     * than 30 characters. This is captured by the regular expression:
     * `[\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?`.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The folder's display name.
     * A folder's display name must be unique amongst its siblings. For example,
     * no two folders with the same parent can share the same display name.
     * The display name must start and end with a letter or digit, may contain
     * letters, digits, spaces, hyphens and underscores and can be no longer
     * than 30 characters. This is captured by the regular expression:
     * `[\p{L}\p{N}]([\p{L}\p{N}_- ]{0,28}[\p{L}\p{N}])?`.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The lifecycle state of the folder.
     * Updates to the state must be performed using
     * [DeleteFolder][google.cloud.resourcemanager.v3.Folders.DeleteFolder] and
     * [UndeleteFolder][google.cloud.resourcemanager.v3.Folders.UndeleteFolder].
     *
     * Generated from protobuf field <code>.google.cloud.resourcemanager.v3.Folder.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The lifecycle state of the folder.
     * Updates to the state must be performed using
     * [DeleteFolder][google.cloud.resourcemanager.v3.Folders.DeleteFolder] and
     * [UndeleteFolder][google.cloud.resourcemanager.v3.Folders.UndeleteFolder].
     *
     * Generated from protobuf field <code>.google.cloud.resourcemanager.v3.Folder.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ResourceManager\V3\Folder\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when the folder was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return isset($this->create_time) ? $this->create_time : null;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when the folder was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when the folder was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return isset($this->update_time) ? $this->update_time : null;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Timestamp when the folder was last modified.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when the folder was requested to be deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return isset($this->delete_time) ? $this->delete_time : null;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. Timestamp when the folder was requested to be deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Output only. A checksum computed by the server based on the current value of the folder
     * resource. This may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. A checksum computed by the server based on the current value of the folder
     * resource. This may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

