<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: grafeas/v1/attestation.proto

namespace Grafeas\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Occurrence that represents a single "attestation". The authenticity of an
 * attestation can be verified using the attached signature. If the verifier
 * trusts the public key of the signer, then verifying the signature is
 * sufficient to establish trust. In this circumstance, the authority to which
 * this attestation is attached is primarily useful for lookup (how to find
 * this attestation if you already know the authority and artifact to be
 * verified) and intent (for which authority this attestation was intended to
 * sign.
 *
 * Generated from protobuf message <code>grafeas.v1.AttestationOccurrence</code>
 */
class AttestationOccurrence extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The serialized payload that is verified by one or more
     * `signatures`.
     *
     * Generated from protobuf field <code>bytes serialized_payload = 1;</code>
     */
    private $serialized_payload = '';
    /**
     * One or more signatures over `serialized_payload`.  Verifier implementations
     * should consider this attestation message verified if at least one
     * `signature` verifies `serialized_payload`.  See `Signature` in common.proto
     * for more details on signature structure and verification.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Signature signatures = 2;</code>
     */
    private $signatures;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $serialized_payload
     *           Required. The serialized payload that is verified by one or more
     *           `signatures`.
     *     @type \Grafeas\V1\Signature[]|\Google\Protobuf\Internal\RepeatedField $signatures
     *           One or more signatures over `serialized_payload`.  Verifier implementations
     *           should consider this attestation message verified if at least one
     *           `signature` verifies `serialized_payload`.  See `Signature` in common.proto
     *           for more details on signature structure and verification.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Grafeas\V1\Attestation::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The serialized payload that is verified by one or more
     * `signatures`.
     *
     * Generated from protobuf field <code>bytes serialized_payload = 1;</code>
     * @return string
     */
    public function getSerializedPayload()
    {
        return $this->serialized_payload;
    }

    /**
     * Required. The serialized payload that is verified by one or more
     * `signatures`.
     *
     * Generated from protobuf field <code>bytes serialized_payload = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setSerializedPayload($var)
    {
        GPBUtil::checkString($var, False);
        $this->serialized_payload = $var;

        return $this;
    }

    /**
     * One or more signatures over `serialized_payload`.  Verifier implementations
     * should consider this attestation message verified if at least one
     * `signature` verifies `serialized_payload`.  See `Signature` in common.proto
     * for more details on signature structure and verification.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Signature signatures = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSignatures()
    {
        return $this->signatures;
    }

    /**
     * One or more signatures over `serialized_payload`.  Verifier implementations
     * should consider this attestation message verified if at least one
     * `signature` verifies `serialized_payload`.  See `Signature` in common.proto
     * for more details on signature structure and verification.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Signature signatures = 2;</code>
     * @param \Grafeas\V1\Signature[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSignatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Grafeas\V1\Signature::class);
        $this->signatures = $arr;

        return $this;
    }

}

