<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/environment.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes the environment in which a Dataflow Job runs.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.Environment</code>
 */
class Environment extends \Google\Protobuf\Internal\Message
{
    /**
     * The prefix of the resources the system should use for temporary
     * storage.  The system will append the suffix "/temp-{JOBNAME} to
     * this resource prefix, where {JOBNAME} is the value of the
     * job_name field.  The resulting bucket and object prefix is used
     * as the prefix of the resources used to store temporary data
     * needed during the job execution.  NOTE: This will override the
     * value in taskrunner_settings.
     * The supported resource type is:
     * Google Cloud Storage:
     *   storage.googleapis.com/{bucket}/{object}
     *   bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>string temp_storage_prefix = 1;</code>
     */
    private $temp_storage_prefix = '';
    /**
     * The type of cluster manager API to use.  If unknown or
     * unspecified, the service will attempt to choose a reasonable
     * default.  This should be in the form of the API service name,
     * e.g. "compute.googleapis.com".
     *
     * Generated from protobuf field <code>string cluster_manager_api_service = 2;</code>
     */
    private $cluster_manager_api_service = '';
    /**
     * The list of experiments to enable. This field should be used for SDK
     * related experiments and not for service related experiments. The proper
     * field for service related experiments is service_options.
     *
     * Generated from protobuf field <code>repeated string experiments = 3;</code>
     */
    private $experiments;
    /**
     * The list of service options to enable. This field should be used for
     * service related experiments only. These experiments, when graduating to GA,
     * should be replaced by dedicated fields or become default (i.e. always on).
     *
     * Generated from protobuf field <code>repeated string service_options = 16;</code>
     */
    private $service_options;
    /**
     * If set, contains the Cloud KMS key identifier used to encrypt data
     * at rest, AKA a Customer Managed Encryption Key (CMEK).
     * Format:
     *   projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
     *
     * Generated from protobuf field <code>string service_kms_key_name = 12;</code>
     */
    private $service_kms_key_name = '';
    /**
     * The worker pools. At least one "harness" worker pool must be
     * specified in order for the job to have workers.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.WorkerPool worker_pools = 4;</code>
     */
    private $worker_pools;
    /**
     * A description of the process that generated the request.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct user_agent = 5;</code>
     */
    private $user_agent = null;
    /**
     * A structure describing which components and their versions of the service
     * are required in order to run the job.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct version = 6;</code>
     */
    private $version = null;
    /**
     * The dataset for the current project where various workflow
     * related tables are stored.
     * The supported resource type is:
     * Google BigQuery:
     *   bigquery.googleapis.com/{dataset}
     *
     * Generated from protobuf field <code>string dataset = 7;</code>
     */
    private $dataset = '';
    /**
     * The Cloud Dataflow SDK pipeline options specified by the user. These
     * options are passed through the service and are used to recreate the
     * SDK pipeline options on the worker in a language agnostic and platform
     * independent way.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct sdk_pipeline_options = 8;</code>
     */
    private $sdk_pipeline_options = null;
    /**
     * Experimental settings.
     *
     * Generated from protobuf field <code>.google.protobuf.Any internal_experiments = 9;</code>
     */
    private $internal_experiments = null;
    /**
     * Identity to run virtual machines as. Defaults to the default account.
     *
     * Generated from protobuf field <code>string service_account_email = 10;</code>
     */
    private $service_account_email = '';
    /**
     * Which Flexible Resource Scheduling mode to run in.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.FlexResourceSchedulingGoal flex_resource_scheduling_goal = 11;</code>
     */
    private $flex_resource_scheduling_goal = 0;
    /**
     * The Compute Engine region
     * (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
     * which worker processing should occur, e.g. "us-west1". Mutually exclusive
     * with worker_zone. If neither worker_region nor worker_zone is specified,
     * default to the control plane's region.
     *
     * Generated from protobuf field <code>string worker_region = 13;</code>
     */
    private $worker_region = '';
    /**
     * The Compute Engine zone
     * (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
     * which worker processing should occur, e.g. "us-west1-a". Mutually exclusive
     * with worker_region. If neither worker_region nor worker_zone is specified,
     * a zone in the control plane's region is chosen based on available capacity.
     *
     * Generated from protobuf field <code>string worker_zone = 14;</code>
     */
    private $worker_zone = '';
    /**
     * Output only. The shuffle mode used for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.ShuffleMode shuffle_mode = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $shuffle_mode = 0;
    /**
     * Any debugging options to be supplied to the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.DebugOptions debug_options = 17;</code>
     */
    private $debug_options = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $temp_storage_prefix
     *           The prefix of the resources the system should use for temporary
     *           storage.  The system will append the suffix "/temp-{JOBNAME} to
     *           this resource prefix, where {JOBNAME} is the value of the
     *           job_name field.  The resulting bucket and object prefix is used
     *           as the prefix of the resources used to store temporary data
     *           needed during the job execution.  NOTE: This will override the
     *           value in taskrunner_settings.
     *           The supported resource type is:
     *           Google Cloud Storage:
     *             storage.googleapis.com/{bucket}/{object}
     *             bucket.storage.googleapis.com/{object}
     *     @type string $cluster_manager_api_service
     *           The type of cluster manager API to use.  If unknown or
     *           unspecified, the service will attempt to choose a reasonable
     *           default.  This should be in the form of the API service name,
     *           e.g. "compute.googleapis.com".
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $experiments
     *           The list of experiments to enable. This field should be used for SDK
     *           related experiments and not for service related experiments. The proper
     *           field for service related experiments is service_options.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $service_options
     *           The list of service options to enable. This field should be used for
     *           service related experiments only. These experiments, when graduating to GA,
     *           should be replaced by dedicated fields or become default (i.e. always on).
     *     @type string $service_kms_key_name
     *           If set, contains the Cloud KMS key identifier used to encrypt data
     *           at rest, AKA a Customer Managed Encryption Key (CMEK).
     *           Format:
     *             projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
     *     @type \Google\Cloud\Dataflow\V1beta3\WorkerPool[]|\Google\Protobuf\Internal\RepeatedField $worker_pools
     *           The worker pools. At least one "harness" worker pool must be
     *           specified in order for the job to have workers.
     *     @type \Google\Protobuf\Struct $user_agent
     *           A description of the process that generated the request.
     *     @type \Google\Protobuf\Struct $version
     *           A structure describing which components and their versions of the service
     *           are required in order to run the job.
     *     @type string $dataset
     *           The dataset for the current project where various workflow
     *           related tables are stored.
     *           The supported resource type is:
     *           Google BigQuery:
     *             bigquery.googleapis.com/{dataset}
     *     @type \Google\Protobuf\Struct $sdk_pipeline_options
     *           The Cloud Dataflow SDK pipeline options specified by the user. These
     *           options are passed through the service and are used to recreate the
     *           SDK pipeline options on the worker in a language agnostic and platform
     *           independent way.
     *     @type \Google\Protobuf\Any $internal_experiments
     *           Experimental settings.
     *     @type string $service_account_email
     *           Identity to run virtual machines as. Defaults to the default account.
     *     @type int $flex_resource_scheduling_goal
     *           Which Flexible Resource Scheduling mode to run in.
     *     @type string $worker_region
     *           The Compute Engine region
     *           (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
     *           which worker processing should occur, e.g. "us-west1". Mutually exclusive
     *           with worker_zone. If neither worker_region nor worker_zone is specified,
     *           default to the control plane's region.
     *     @type string $worker_zone
     *           The Compute Engine zone
     *           (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
     *           which worker processing should occur, e.g. "us-west1-a". Mutually exclusive
     *           with worker_region. If neither worker_region nor worker_zone is specified,
     *           a zone in the control plane's region is chosen based on available capacity.
     *     @type int $shuffle_mode
     *           Output only. The shuffle mode used for the job.
     *     @type \Google\Cloud\Dataflow\V1beta3\DebugOptions $debug_options
     *           Any debugging options to be supplied to the job.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Environment::initOnce();
        parent::__construct($data);
    }

    /**
     * The prefix of the resources the system should use for temporary
     * storage.  The system will append the suffix "/temp-{JOBNAME} to
     * this resource prefix, where {JOBNAME} is the value of the
     * job_name field.  The resulting bucket and object prefix is used
     * as the prefix of the resources used to store temporary data
     * needed during the job execution.  NOTE: This will override the
     * value in taskrunner_settings.
     * The supported resource type is:
     * Google Cloud Storage:
     *   storage.googleapis.com/{bucket}/{object}
     *   bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>string temp_storage_prefix = 1;</code>
     * @return string
     */
    public function getTempStoragePrefix()
    {
        return $this->temp_storage_prefix;
    }

    /**
     * The prefix of the resources the system should use for temporary
     * storage.  The system will append the suffix "/temp-{JOBNAME} to
     * this resource prefix, where {JOBNAME} is the value of the
     * job_name field.  The resulting bucket and object prefix is used
     * as the prefix of the resources used to store temporary data
     * needed during the job execution.  NOTE: This will override the
     * value in taskrunner_settings.
     * The supported resource type is:
     * Google Cloud Storage:
     *   storage.googleapis.com/{bucket}/{object}
     *   bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>string temp_storage_prefix = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setTempStoragePrefix($var)
    {
        GPBUtil::checkString($var, True);
        $this->temp_storage_prefix = $var;

        return $this;
    }

    /**
     * The type of cluster manager API to use.  If unknown or
     * unspecified, the service will attempt to choose a reasonable
     * default.  This should be in the form of the API service name,
     * e.g. "compute.googleapis.com".
     *
     * Generated from protobuf field <code>string cluster_manager_api_service = 2;</code>
     * @return string
     */
    public function getClusterManagerApiService()
    {
        return $this->cluster_manager_api_service;
    }

    /**
     * The type of cluster manager API to use.  If unknown or
     * unspecified, the service will attempt to choose a reasonable
     * default.  This should be in the form of the API service name,
     * e.g. "compute.googleapis.com".
     *
     * Generated from protobuf field <code>string cluster_manager_api_service = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setClusterManagerApiService($var)
    {
        GPBUtil::checkString($var, True);
        $this->cluster_manager_api_service = $var;

        return $this;
    }

    /**
     * The list of experiments to enable. This field should be used for SDK
     * related experiments and not for service related experiments. The proper
     * field for service related experiments is service_options.
     *
     * Generated from protobuf field <code>repeated string experiments = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExperiments()
    {
        return $this->experiments;
    }

    /**
     * The list of experiments to enable. This field should be used for SDK
     * related experiments and not for service related experiments. The proper
     * field for service related experiments is service_options.
     *
     * Generated from protobuf field <code>repeated string experiments = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExperiments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->experiments = $arr;

        return $this;
    }

    /**
     * The list of service options to enable. This field should be used for
     * service related experiments only. These experiments, when graduating to GA,
     * should be replaced by dedicated fields or become default (i.e. always on).
     *
     * Generated from protobuf field <code>repeated string service_options = 16;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceOptions()
    {
        return $this->service_options;
    }

    /**
     * The list of service options to enable. This field should be used for
     * service related experiments only. These experiments, when graduating to GA,
     * should be replaced by dedicated fields or become default (i.e. always on).
     *
     * Generated from protobuf field <code>repeated string service_options = 16;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceOptions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->service_options = $arr;

        return $this;
    }

    /**
     * If set, contains the Cloud KMS key identifier used to encrypt data
     * at rest, AKA a Customer Managed Encryption Key (CMEK).
     * Format:
     *   projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
     *
     * Generated from protobuf field <code>string service_kms_key_name = 12;</code>
     * @return string
     */
    public function getServiceKmsKeyName()
    {
        return $this->service_kms_key_name;
    }

    /**
     * If set, contains the Cloud KMS key identifier used to encrypt data
     * at rest, AKA a Customer Managed Encryption Key (CMEK).
     * Format:
     *   projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
     *
     * Generated from protobuf field <code>string service_kms_key_name = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_kms_key_name = $var;

        return $this;
    }

    /**
     * The worker pools. At least one "harness" worker pool must be
     * specified in order for the job to have workers.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.WorkerPool worker_pools = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getWorkerPools()
    {
        return $this->worker_pools;
    }

    /**
     * The worker pools. At least one "harness" worker pool must be
     * specified in order for the job to have workers.
     *
     * Generated from protobuf field <code>repeated .google.dataflow.v1beta3.WorkerPool worker_pools = 4;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\WorkerPool[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setWorkerPools($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dataflow\V1beta3\WorkerPool::class);
        $this->worker_pools = $arr;

        return $this;
    }

    /**
     * A description of the process that generated the request.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct user_agent = 5;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getUserAgent()
    {
        return isset($this->user_agent) ? $this->user_agent : null;
    }

    public function hasUserAgent()
    {
        return isset($this->user_agent);
    }

    public function clearUserAgent()
    {
        unset($this->user_agent);
    }

    /**
     * A description of the process that generated the request.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct user_agent = 5;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setUserAgent($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->user_agent = $var;

        return $this;
    }

    /**
     * A structure describing which components and their versions of the service
     * are required in order to run the job.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct version = 6;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getVersion()
    {
        return isset($this->version) ? $this->version : null;
    }

    public function hasVersion()
    {
        return isset($this->version);
    }

    public function clearVersion()
    {
        unset($this->version);
    }

    /**
     * A structure describing which components and their versions of the service
     * are required in order to run the job.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct version = 6;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->version = $var;

        return $this;
    }

    /**
     * The dataset for the current project where various workflow
     * related tables are stored.
     * The supported resource type is:
     * Google BigQuery:
     *   bigquery.googleapis.com/{dataset}
     *
     * Generated from protobuf field <code>string dataset = 7;</code>
     * @return string
     */
    public function getDataset()
    {
        return $this->dataset;
    }

    /**
     * The dataset for the current project where various workflow
     * related tables are stored.
     * The supported resource type is:
     * Google BigQuery:
     *   bigquery.googleapis.com/{dataset}
     *
     * Generated from protobuf field <code>string dataset = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDataset($var)
    {
        GPBUtil::checkString($var, True);
        $this->dataset = $var;

        return $this;
    }

    /**
     * The Cloud Dataflow SDK pipeline options specified by the user. These
     * options are passed through the service and are used to recreate the
     * SDK pipeline options on the worker in a language agnostic and platform
     * independent way.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct sdk_pipeline_options = 8;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getSdkPipelineOptions()
    {
        return isset($this->sdk_pipeline_options) ? $this->sdk_pipeline_options : null;
    }

    public function hasSdkPipelineOptions()
    {
        return isset($this->sdk_pipeline_options);
    }

    public function clearSdkPipelineOptions()
    {
        unset($this->sdk_pipeline_options);
    }

    /**
     * The Cloud Dataflow SDK pipeline options specified by the user. These
     * options are passed through the service and are used to recreate the
     * SDK pipeline options on the worker in a language agnostic and platform
     * independent way.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct sdk_pipeline_options = 8;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setSdkPipelineOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->sdk_pipeline_options = $var;

        return $this;
    }

    /**
     * Experimental settings.
     *
     * Generated from protobuf field <code>.google.protobuf.Any internal_experiments = 9;</code>
     * @return \Google\Protobuf\Any|null
     */
    public function getInternalExperiments()
    {
        return isset($this->internal_experiments) ? $this->internal_experiments : null;
    }

    public function hasInternalExperiments()
    {
        return isset($this->internal_experiments);
    }

    public function clearInternalExperiments()
    {
        unset($this->internal_experiments);
    }

    /**
     * Experimental settings.
     *
     * Generated from protobuf field <code>.google.protobuf.Any internal_experiments = 9;</code>
     * @param \Google\Protobuf\Any $var
     * @return $this
     */
    public function setInternalExperiments($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Any::class);
        $this->internal_experiments = $var;

        return $this;
    }

    /**
     * Identity to run virtual machines as. Defaults to the default account.
     *
     * Generated from protobuf field <code>string service_account_email = 10;</code>
     * @return string
     */
    public function getServiceAccountEmail()
    {
        return $this->service_account_email;
    }

    /**
     * Identity to run virtual machines as. Defaults to the default account.
     *
     * Generated from protobuf field <code>string service_account_email = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_email = $var;

        return $this;
    }

    /**
     * Which Flexible Resource Scheduling mode to run in.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.FlexResourceSchedulingGoal flex_resource_scheduling_goal = 11;</code>
     * @return int
     */
    public function getFlexResourceSchedulingGoal()
    {
        return $this->flex_resource_scheduling_goal;
    }

    /**
     * Which Flexible Resource Scheduling mode to run in.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.FlexResourceSchedulingGoal flex_resource_scheduling_goal = 11;</code>
     * @param int $var
     * @return $this
     */
    public function setFlexResourceSchedulingGoal($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataflow\V1beta3\FlexResourceSchedulingGoal::class);
        $this->flex_resource_scheduling_goal = $var;

        return $this;
    }

    /**
     * The Compute Engine region
     * (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
     * which worker processing should occur, e.g. "us-west1". Mutually exclusive
     * with worker_zone. If neither worker_region nor worker_zone is specified,
     * default to the control plane's region.
     *
     * Generated from protobuf field <code>string worker_region = 13;</code>
     * @return string
     */
    public function getWorkerRegion()
    {
        return $this->worker_region;
    }

    /**
     * The Compute Engine region
     * (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
     * which worker processing should occur, e.g. "us-west1". Mutually exclusive
     * with worker_zone. If neither worker_region nor worker_zone is specified,
     * default to the control plane's region.
     *
     * Generated from protobuf field <code>string worker_region = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setWorkerRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->worker_region = $var;

        return $this;
    }

    /**
     * The Compute Engine zone
     * (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
     * which worker processing should occur, e.g. "us-west1-a". Mutually exclusive
     * with worker_region. If neither worker_region nor worker_zone is specified,
     * a zone in the control plane's region is chosen based on available capacity.
     *
     * Generated from protobuf field <code>string worker_zone = 14;</code>
     * @return string
     */
    public function getWorkerZone()
    {
        return $this->worker_zone;
    }

    /**
     * The Compute Engine zone
     * (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in
     * which worker processing should occur, e.g. "us-west1-a". Mutually exclusive
     * with worker_region. If neither worker_region nor worker_zone is specified,
     * a zone in the control plane's region is chosen based on available capacity.
     *
     * Generated from protobuf field <code>string worker_zone = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setWorkerZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->worker_zone = $var;

        return $this;
    }

    /**
     * Output only. The shuffle mode used for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.ShuffleMode shuffle_mode = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getShuffleMode()
    {
        return $this->shuffle_mode;
    }

    /**
     * Output only. The shuffle mode used for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.ShuffleMode shuffle_mode = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setShuffleMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dataflow\V1beta3\ShuffleMode::class);
        $this->shuffle_mode = $var;

        return $this;
    }

    /**
     * Any debugging options to be supplied to the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.DebugOptions debug_options = 17;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\DebugOptions|null
     */
    public function getDebugOptions()
    {
        return isset($this->debug_options) ? $this->debug_options : null;
    }

    public function hasDebugOptions()
    {
        return isset($this->debug_options);
    }

    public function clearDebugOptions()
    {
        unset($this->debug_options);
    }

    /**
     * Any debugging options to be supplied to the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.DebugOptions debug_options = 17;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\DebugOptions $var
     * @return $this
     */
    public function setDebugOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\DebugOptions::class);
        $this->debug_options = $var;

        return $this;
    }

}

