<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/google/googleapis/blob/master/google/cloud/channel/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Channel\V1\ImportCustomerRequest;

/**
 * Wrapper class for the oneof customer_identity defined in message
 * ImportCustomerRequest. Only one item should be set on an instance of this class.
 * If multiple items are set on the instance, the last one is used.
 */
class CustomerIdentityOneof
{
    /**
     * The value for the field domain, if set.
     */
    private $domain;

    /**
     * The value for the field cloud_identity_id, if set.
     */
    private $cloudIdentityId;

    /**
     * Name of the field for which the oneof is set, as it appears in the protobuf in
     * lower_camel_case.
     */
    private $selectedOneofFieldName = '';

    /**
     * Sets this oneof to domain and updates its value.
     *
     * @param string $domain The new value of this oneof.
     *
     * @return CustomerIdentityOneof The modified object.
     */
    public function setDomain($domain)
    {
        $this->domain = $domain;
        $this->selectedOneofFieldName = 'domain';
        return $this;
    }

    /**
     * Sets this oneof to cloud_identity_id and updates its value.
     *
     * @param string $cloudIdentityId The new value of this oneof.
     *
     * @return CustomerIdentityOneof The modified object.
     */
    public function setCloudIdentityId($cloudIdentityId)
    {
        $this->cloudIdentityId = $cloudIdentityId;
        $this->selectedOneofFieldName = 'cloud_identity_id';
        return $this;
    }

    /**
     * Returns true if this oneof is set to the field domain.
     *
     * @return bool
     */
    public function isDomain()
    {
        return $this->selectedOneofFieldName === 'domain';
    }

    /**
     * Returns true if this oneof is set to the field cloud_identity_id.
     *
     * @return bool
     */
    public function isCloudIdentityId()
    {
        return $this->selectedOneofFieldName === 'cloud_identity_id';
    }

    /**
     * Returns domain if this oneof is set to the field domain, null otherwise.
     *
     * @return string|null
     */
    public function getDomain()
    {
        return $this->isDomain() ? $this->domain : null;
    }

    /**
     * Returns cloudIdentityId if this oneof is set to the field cloud_identity_id,
     * null otherwise.
     *
     * @return string|null
     */
    public function getCloudIdentityId()
    {
        return $this->isCloudIdentityId() ? $this->cloudIdentityId : null;
    }
}
