<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/appengine/v1/app_yaml.proto

namespace Google\Cloud\AppEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Files served directly to the user for a given URL, such as images, CSS
 * stylesheets, or JavaScript source files. Static file handlers describe which
 * files in the application directory are static files, and which URLs serve
 * them.
 *
 * Generated from protobuf message <code>google.appengine.v1.StaticFilesHandler</code>
 */
class StaticFilesHandler extends \Google\Protobuf\Internal\Message
{
    /**
     * Path to the static files matched by the URL pattern, from the
     * application root directory. The path can refer to text matched in groupings
     * in the URL pattern.
     *
     * Generated from protobuf field <code>string path = 1;</code>
     */
    private $path = '';
    /**
     * Regular expression that matches the file paths for all files that should be
     * referenced by this handler.
     *
     * Generated from protobuf field <code>string upload_path_regex = 2;</code>
     */
    private $upload_path_regex = '';
    /**
     * HTTP headers to use for all responses from these URLs.
     *
     * Generated from protobuf field <code>map<string, string> http_headers = 3;</code>
     */
    private $http_headers;
    /**
     * MIME type used to serve all files served by this handler.
     * Defaults to file-specific MIME types, which are derived from each file's
     * filename extension.
     *
     * Generated from protobuf field <code>string mime_type = 4;</code>
     */
    private $mime_type = '';
    /**
     * Time a static file served by this handler should be cached
     * by web proxies and browsers.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration expiration = 5;</code>
     */
    private $expiration = null;
    /**
     * Whether this handler should match the request if the file
     * referenced by the handler does not exist.
     *
     * Generated from protobuf field <code>bool require_matching_file = 6;</code>
     */
    private $require_matching_file = false;
    /**
     * Whether files should also be uploaded as code data. By default, files
     * declared in static file handlers are uploaded as static
     * data and are only served to end users; they cannot be read by the
     * application. If enabled, uploads are charged against both your code and
     * static data storage resource quotas.
     *
     * Generated from protobuf field <code>bool application_readable = 7;</code>
     */
    private $application_readable = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $path
     *           Path to the static files matched by the URL pattern, from the
     *           application root directory. The path can refer to text matched in groupings
     *           in the URL pattern.
     *     @type string $upload_path_regex
     *           Regular expression that matches the file paths for all files that should be
     *           referenced by this handler.
     *     @type array|\Google\Protobuf\Internal\MapField $http_headers
     *           HTTP headers to use for all responses from these URLs.
     *     @type string $mime_type
     *           MIME type used to serve all files served by this handler.
     *           Defaults to file-specific MIME types, which are derived from each file's
     *           filename extension.
     *     @type \Google\Protobuf\Duration $expiration
     *           Time a static file served by this handler should be cached
     *           by web proxies and browsers.
     *     @type bool $require_matching_file
     *           Whether this handler should match the request if the file
     *           referenced by the handler does not exist.
     *     @type bool $application_readable
     *           Whether files should also be uploaded as code data. By default, files
     *           declared in static file handlers are uploaded as static
     *           data and are only served to end users; they cannot be read by the
     *           application. If enabled, uploads are charged against both your code and
     *           static data storage resource quotas.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Appengine\V1\AppYaml::initOnce();
        parent::__construct($data);
    }

    /**
     * Path to the static files matched by the URL pattern, from the
     * application root directory. The path can refer to text matched in groupings
     * in the URL pattern.
     *
     * Generated from protobuf field <code>string path = 1;</code>
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Path to the static files matched by the URL pattern, from the
     * application root directory. The path can refer to text matched in groupings
     * in the URL pattern.
     *
     * Generated from protobuf field <code>string path = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->path = $var;

        return $this;
    }

    /**
     * Regular expression that matches the file paths for all files that should be
     * referenced by this handler.
     *
     * Generated from protobuf field <code>string upload_path_regex = 2;</code>
     * @return string
     */
    public function getUploadPathRegex()
    {
        return $this->upload_path_regex;
    }

    /**
     * Regular expression that matches the file paths for all files that should be
     * referenced by this handler.
     *
     * Generated from protobuf field <code>string upload_path_regex = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setUploadPathRegex($var)
    {
        GPBUtil::checkString($var, True);
        $this->upload_path_regex = $var;

        return $this;
    }

    /**
     * HTTP headers to use for all responses from these URLs.
     *
     * Generated from protobuf field <code>map<string, string> http_headers = 3;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getHttpHeaders()
    {
        return $this->http_headers;
    }

    /**
     * HTTP headers to use for all responses from these URLs.
     *
     * Generated from protobuf field <code>map<string, string> http_headers = 3;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setHttpHeaders($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->http_headers = $arr;

        return $this;
    }

    /**
     * MIME type used to serve all files served by this handler.
     * Defaults to file-specific MIME types, which are derived from each file's
     * filename extension.
     *
     * Generated from protobuf field <code>string mime_type = 4;</code>
     * @return string
     */
    public function getMimeType()
    {
        return $this->mime_type;
    }

    /**
     * MIME type used to serve all files served by this handler.
     * Defaults to file-specific MIME types, which are derived from each file's
     * filename extension.
     *
     * Generated from protobuf field <code>string mime_type = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setMimeType($var)
    {
        GPBUtil::checkString($var, True);
        $this->mime_type = $var;

        return $this;
    }

    /**
     * Time a static file served by this handler should be cached
     * by web proxies and browsers.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration expiration = 5;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getExpiration()
    {
        return isset($this->expiration) ? $this->expiration : null;
    }

    public function hasExpiration()
    {
        return isset($this->expiration);
    }

    public function clearExpiration()
    {
        unset($this->expiration);
    }

    /**
     * Time a static file served by this handler should be cached
     * by web proxies and browsers.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration expiration = 5;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setExpiration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->expiration = $var;

        return $this;
    }

    /**
     * Whether this handler should match the request if the file
     * referenced by the handler does not exist.
     *
     * Generated from protobuf field <code>bool require_matching_file = 6;</code>
     * @return bool
     */
    public function getRequireMatchingFile()
    {
        return $this->require_matching_file;
    }

    /**
     * Whether this handler should match the request if the file
     * referenced by the handler does not exist.
     *
     * Generated from protobuf field <code>bool require_matching_file = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setRequireMatchingFile($var)
    {
        GPBUtil::checkBool($var);
        $this->require_matching_file = $var;

        return $this;
    }

    /**
     * Whether files should also be uploaded as code data. By default, files
     * declared in static file handlers are uploaded as static
     * data and are only served to end users; they cannot be read by the
     * application. If enabled, uploads are charged against both your code and
     * static data storage resource quotas.
     *
     * Generated from protobuf field <code>bool application_readable = 7;</code>
     * @return bool
     */
    public function getApplicationReadable()
    {
        return $this->application_readable;
    }

    /**
     * Whether files should also be uploaded as code data. By default, files
     * declared in static file handlers are uploaded as static
     * data and are only served to end users; they cannot be read by the
     * application. If enabled, uploads are charged against both your code and
     * static data storage resource quotas.
     *
     * Generated from protobuf field <code>bool application_readable = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setApplicationReadable($var)
    {
        GPBUtil::checkBool($var);
        $this->application_readable = $var;

        return $this;
    }

}

