<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/identity/accesscontextmanager/v1/service_perimeter.proto

namespace Google\Identity\AccessContextManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * `ServicePerimeter` describes a set of Google Cloud resources which can freely
 * import and export data amongst themselves, but not export outside of the
 * `ServicePerimeter`. If a request with a source within this `ServicePerimeter`
 * has a target outside of the `ServicePerimeter`, the request will be blocked.
 * Otherwise the request is allowed. There are two types of Service Perimeter -
 * Regular and Bridge. Regular Service Perimeters cannot overlap, a single
 * Google Cloud project can only belong to a single regular Service Perimeter.
 * Service Perimeter Bridges can contain only Google Cloud projects as members,
 * a single Google Cloud project may belong to multiple Service Perimeter
 * Bridges.
 *
 * Generated from protobuf message <code>google.identity.accesscontextmanager.v1.ServicePerimeter</code>
 */
class ServicePerimeter extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Resource name for the ServicePerimeter.  The `short_name`
     * component must begin with a letter and only include alphanumeric and '_'.
     * Format:
     * `accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Generated from protobuf field <code>string title = 2;</code>
     */
    private $title = '';
    /**
     * Description of the `ServicePerimeter` and its use. Does not affect
     * behavior.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    private $description = '';
    /**
     * Output only. Time the `ServicePerimeter` was created in UTC.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private $create_time = null;
    /**
     * Output only. Time the `ServicePerimeter` was updated in UTC.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    private $update_time = null;
    /**
     * Perimeter type indicator. A single project is
     * allowed to be a member of single regular perimeter, but multiple service
     * perimeter bridges. A project cannot be a included in a perimeter bridge
     * without being included in regular perimeter. For perimeter bridges,
     * the restricted service list as well as access level lists must be
     * empty.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType perimeter_type = 6;</code>
     */
    private $perimeter_type = 0;
    /**
     * Current ServicePerimeter configuration. Specifies sets of resources,
     * restricted services and access levels that determine perimeter
     * content and boundaries.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeterConfig status = 7;</code>
     */
    private $status = null;
    /**
     * Proposed (or dry run) ServicePerimeter configuration. This configuration
     * allows to specify and test ServicePerimeter configuration without enforcing
     * actual access restrictions. Only allowed to be set when the
     * "use_explicit_dry_run_spec" flag is set.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeterConfig spec = 8;</code>
     */
    private $spec = null;
    /**
     * Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly
     * exists  for all Service Perimeters, and that spec is identical to the
     * status for those Service Perimeters. When this flag is set, it inhibits the
     * generation of the implicit spec, thereby allowing the user to explicitly
     * provide a configuration ("spec") to use in a dry-run version of the Service
     * Perimeter. This allows the user to test changes to the enforced config
     * ("status") without actually enforcing them. This testing is done through
     * analyzing the differences between currently enforced and suggested
     * restrictions. use_explicit_dry_run_spec must bet set to True if any of the
     * fields in the spec are set to non-default values.
     *
     * Generated from protobuf field <code>bool use_explicit_dry_run_spec = 9;</code>
     */
    private $use_explicit_dry_run_spec = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Resource name for the ServicePerimeter.  The `short_name`
     *           component must begin with a letter and only include alphanumeric and '_'.
     *           Format:
     *           `accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}`
     *     @type string $title
     *           Human readable title. Must be unique within the Policy.
     *     @type string $description
     *           Description of the `ServicePerimeter` and its use. Does not affect
     *           behavior.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Time the `ServicePerimeter` was created in UTC.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Time the `ServicePerimeter` was updated in UTC.
     *     @type int $perimeter_type
     *           Perimeter type indicator. A single project is
     *           allowed to be a member of single regular perimeter, but multiple service
     *           perimeter bridges. A project cannot be a included in a perimeter bridge
     *           without being included in regular perimeter. For perimeter bridges,
     *           the restricted service list as well as access level lists must be
     *           empty.
     *     @type \Google\Identity\AccessContextManager\V1\ServicePerimeterConfig $status
     *           Current ServicePerimeter configuration. Specifies sets of resources,
     *           restricted services and access levels that determine perimeter
     *           content and boundaries.
     *     @type \Google\Identity\AccessContextManager\V1\ServicePerimeterConfig $spec
     *           Proposed (or dry run) ServicePerimeter configuration. This configuration
     *           allows to specify and test ServicePerimeter configuration without enforcing
     *           actual access restrictions. Only allowed to be set when the
     *           "use_explicit_dry_run_spec" flag is set.
     *     @type bool $use_explicit_dry_run_spec
     *           Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly
     *           exists  for all Service Perimeters, and that spec is identical to the
     *           status for those Service Perimeters. When this flag is set, it inhibits the
     *           generation of the implicit spec, thereby allowing the user to explicitly
     *           provide a configuration ("spec") to use in a dry-run version of the Service
     *           Perimeter. This allows the user to test changes to the enforced config
     *           ("status") without actually enforcing them. This testing is done through
     *           analyzing the differences between currently enforced and suggested
     *           restrictions. use_explicit_dry_run_spec must bet set to True if any of the
     *           fields in the spec are set to non-default values.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Identity\Accesscontextmanager\V1\ServicePerimeter::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Resource name for the ServicePerimeter.  The `short_name`
     * component must begin with a letter and only include alphanumeric and '_'.
     * Format:
     * `accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Resource name for the ServicePerimeter.  The `short_name`
     * component must begin with a letter and only include alphanumeric and '_'.
     * Format:
     * `accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Generated from protobuf field <code>string title = 2;</code>
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Generated from protobuf field <code>string title = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * Description of the `ServicePerimeter` and its use. Does not affect
     * behavior.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Description of the `ServicePerimeter` and its use. Does not affect
     * behavior.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. Time the `ServicePerimeter` was created in UTC.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return isset($this->create_time) ? $this->create_time : null;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Time the `ServicePerimeter` was created in UTC.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Time the `ServicePerimeter` was updated in UTC.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return isset($this->update_time) ? $this->update_time : null;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Time the `ServicePerimeter` was updated in UTC.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Perimeter type indicator. A single project is
     * allowed to be a member of single regular perimeter, but multiple service
     * perimeter bridges. A project cannot be a included in a perimeter bridge
     * without being included in regular perimeter. For perimeter bridges,
     * the restricted service list as well as access level lists must be
     * empty.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType perimeter_type = 6;</code>
     * @return int
     */
    public function getPerimeterType()
    {
        return $this->perimeter_type;
    }

    /**
     * Perimeter type indicator. A single project is
     * allowed to be a member of single regular perimeter, but multiple service
     * perimeter bridges. A project cannot be a included in a perimeter bridge
     * without being included in regular perimeter. For perimeter bridges,
     * the restricted service list as well as access level lists must be
     * empty.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType perimeter_type = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setPerimeterType($var)
    {
        GPBUtil::checkEnum($var, \Google\Identity\AccessContextManager\V1\ServicePerimeter\PerimeterType::class);
        $this->perimeter_type = $var;

        return $this;
    }

    /**
     * Current ServicePerimeter configuration. Specifies sets of resources,
     * restricted services and access levels that determine perimeter
     * content and boundaries.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeterConfig status = 7;</code>
     * @return \Google\Identity\AccessContextManager\V1\ServicePerimeterConfig|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * Current ServicePerimeter configuration. Specifies sets of resources,
     * restricted services and access levels that determine perimeter
     * content and boundaries.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeterConfig status = 7;</code>
     * @param \Google\Identity\AccessContextManager\V1\ServicePerimeterConfig $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Identity\AccessContextManager\V1\ServicePerimeterConfig::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Proposed (or dry run) ServicePerimeter configuration. This configuration
     * allows to specify and test ServicePerimeter configuration without enforcing
     * actual access restrictions. Only allowed to be set when the
     * "use_explicit_dry_run_spec" flag is set.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeterConfig spec = 8;</code>
     * @return \Google\Identity\AccessContextManager\V1\ServicePerimeterConfig|null
     */
    public function getSpec()
    {
        return isset($this->spec) ? $this->spec : null;
    }

    public function hasSpec()
    {
        return isset($this->spec);
    }

    public function clearSpec()
    {
        unset($this->spec);
    }

    /**
     * Proposed (or dry run) ServicePerimeter configuration. This configuration
     * allows to specify and test ServicePerimeter configuration without enforcing
     * actual access restrictions. Only allowed to be set when the
     * "use_explicit_dry_run_spec" flag is set.
     *
     * Generated from protobuf field <code>.google.identity.accesscontextmanager.v1.ServicePerimeterConfig spec = 8;</code>
     * @param \Google\Identity\AccessContextManager\V1\ServicePerimeterConfig $var
     * @return $this
     */
    public function setSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Identity\AccessContextManager\V1\ServicePerimeterConfig::class);
        $this->spec = $var;

        return $this;
    }

    /**
     * Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly
     * exists  for all Service Perimeters, and that spec is identical to the
     * status for those Service Perimeters. When this flag is set, it inhibits the
     * generation of the implicit spec, thereby allowing the user to explicitly
     * provide a configuration ("spec") to use in a dry-run version of the Service
     * Perimeter. This allows the user to test changes to the enforced config
     * ("status") without actually enforcing them. This testing is done through
     * analyzing the differences between currently enforced and suggested
     * restrictions. use_explicit_dry_run_spec must bet set to True if any of the
     * fields in the spec are set to non-default values.
     *
     * Generated from protobuf field <code>bool use_explicit_dry_run_spec = 9;</code>
     * @return bool
     */
    public function getUseExplicitDryRunSpec()
    {
        return $this->use_explicit_dry_run_spec;
    }

    /**
     * Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly
     * exists  for all Service Perimeters, and that spec is identical to the
     * status for those Service Perimeters. When this flag is set, it inhibits the
     * generation of the implicit spec, thereby allowing the user to explicitly
     * provide a configuration ("spec") to use in a dry-run version of the Service
     * Perimeter. This allows the user to test changes to the enforced config
     * ("status") without actually enforcing them. This testing is done through
     * analyzing the differences between currently enforced and suggested
     * restrictions. use_explicit_dry_run_spec must bet set to True if any of the
     * fields in the spec are set to non-default values.
     *
     * Generated from protobuf field <code>bool use_explicit_dry_run_spec = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseExplicitDryRunSpec($var)
    {
        GPBUtil::checkBool($var);
        $this->use_explicit_dry_run_spec = $var;

        return $this;
    }

}

