<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/sql/v1/cloud_sql_instances.proto

namespace Google\Cloud\Sql\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Cloud SQL instance resource.
 *
 * Generated from protobuf message <code>google.cloud.sql.v1.DatabaseInstance</code>
 */
class DatabaseInstance extends \Google\Protobuf\Internal\Message
{
    /**
     * This is always `sql#instance`.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     */
    private $kind = '';
    /**
     * The current serving state of the Cloud SQL instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlInstanceState state = 2;</code>
     */
    private $state = 0;
    /**
     * The database engine type and version. The `databaseVersion` field cannot
     * be changed after instance creation.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDatabaseVersion database_version = 3;</code>
     */
    private $database_version = 0;
    /**
     * The user settings.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings settings = 4;</code>
     */
    private $settings = null;
    /**
     * This field is deprecated and will be removed from a future version of the
     * API. Use the `settings.settingsVersion` field instead.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     */
    private $etag = '';
    /**
     * The name and status of the failover replica.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlFailoverReplica failover_replica = 6;</code>
     */
    private $failover_replica = null;
    /**
     * The name of the instance which will act as primary in the replication
     * setup.
     *
     * Generated from protobuf field <code>string master_instance_name = 7;</code>
     */
    private $master_instance_name = '';
    /**
     * The replicas of the instance.
     *
     * Generated from protobuf field <code>repeated string replica_names = 8;</code>
     */
    private $replica_names;
    /**
     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @deprecated
     */
    protected $max_disk_size = null;
    /**
     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see [this
     * announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
     * for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @deprecated
     */
    protected $current_disk_size = null;
    /**
     * The assigned IP addresses for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.IpMapping ip_addresses = 11;</code>
     */
    private $ip_addresses;
    /**
     * SSL configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SslCert server_ca_cert = 12;</code>
     */
    private $server_ca_cert = null;
    /**
     * The instance type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlInstanceType instance_type = 13;</code>
     */
    private $instance_type = 0;
    /**
     * The project ID of the project containing the Cloud SQL instance. The Google
     * apps domain is prefixed if applicable.
     *
     * Generated from protobuf field <code>string project = 14;</code>
     */
    private $project = '';
    /**
     * The IPv6 address assigned to the instance.
     * (Deprecated) This property was applicable only
     * to First Generation instances.
     *
     * Generated from protobuf field <code>string ipv6_address = 15 [deprecated = true];</code>
     * @deprecated
     */
    protected $ipv6_address = '';
    /**
     * The service account email address assigned to the instance.\This
     * property is read-only.
     *
     * Generated from protobuf field <code>string service_account_email_address = 16;</code>
     */
    private $service_account_email_address = '';
    /**
     * Configuration specific to on-premises instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.OnPremisesConfiguration on_premises_configuration = 17;</code>
     */
    private $on_premises_configuration = null;
    /**
     * Configuration specific to failover replicas and read replicas.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.ReplicaConfiguration replica_configuration = 18;</code>
     */
    private $replica_configuration = null;
    /**
     * The backend type.
     * `SECOND_GEN`: Cloud SQL database instance.
     * `EXTERNAL`: A database server that is not managed by Google.
     * This property is read-only; use the `tier` property in the `settings`
     * object to determine the database type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlBackendType backend_type = 19;</code>
     */
    private $backend_type = 0;
    /**
     * The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 20;</code>
     */
    private $self_link = '';
    /**
     * If the instance state is SUSPENDED, the reason for the suspension.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.SqlSuspensionReason suspension_reason = 21;</code>
     */
    private $suspension_reason;
    /**
     * Connection name of the Cloud SQL instance used in connection strings.
     *
     * Generated from protobuf field <code>string connection_name = 22;</code>
     */
    private $connection_name = '';
    /**
     * Name of the Cloud SQL instance. This does not include the project ID.
     *
     * Generated from protobuf field <code>string name = 23;</code>
     */
    private $name = '';
    /**
     * The geographical region. Can be:
     * *  `us-central` (`FIRST_GEN` instances only)
     * *  `us-central1` (`SECOND_GEN` instances only)
     * *  `asia-east1` or `europe-west1`.
     * Defaults to `us-central` or `us-central1` depending on the instance
     * type. The region cannot be changed after instance creation.
     *
     * Generated from protobuf field <code>string region = 24;</code>
     */
    private $region = '';
    /**
     * The Compute Engine zone that the instance is currently serving from. This
     * value could be different from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary zone. WARNING:
     * Changing this might restart the instance.
     *
     * Generated from protobuf field <code>string gce_zone = 25;</code>
     */
    private $gce_zone = '';
    /**
     * The Compute Engine zone that the failover instance is currently serving
     * from for a regional instance. This value could be different
     * from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary/failover zone.
     *
     * Generated from protobuf field <code>string secondary_gce_zone = 34;</code>
     */
    private $secondary_gce_zone = '';
    /**
     * Disk encryption configuration specific to an instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DiskEncryptionConfiguration disk_encryption_configuration = 26;</code>
     */
    private $disk_encryption_configuration = null;
    /**
     * Disk encryption status specific to an instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DiskEncryptionStatus disk_encryption_status = 27;</code>
     */
    private $disk_encryption_status = null;
    /**
     * Initial root password. Use only on creation. You must set root passwords
     * before you can connect to PostgreSQL instances.
     *
     * Generated from protobuf field <code>string root_password = 29;</code>
     */
    private $root_password = '';
    /**
     * The start time of any upcoming scheduled maintenance for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlScheduledMaintenance scheduled_maintenance = 30;</code>
     */
    private $scheduled_maintenance = null;
    /**
     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     */
    private $satisfies_pzs = null;
    /**
     * Output only. Stores the current database version running on the instance
     * including minor version such as `MYSQL_8_0_18`.
     *
     * Generated from protobuf field <code>string database_installed_version = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $database_installed_version = '';
    /**
     * This field represents the report generated by the proactive database
     * wellness job for OutOfDisk issues.
     * *  Writers:
     *   *  the proactive database wellness job for OOD.
     * *  Readers:
     *   *  the proactive database wellness job
     *
     * Generated from protobuf field <code>optional .google.cloud.sql.v1.DatabaseInstance.SqlOutOfDiskReport out_of_disk_report = 38;</code>
     */
    private $out_of_disk_report = null;
    /**
     * Output only. The time when the instance was created in
     * [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
     * `2012-11-15T16:19:00.094Z`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. List all maintenance versions applicable on the instance
     *
     * Generated from protobuf field <code>repeated string available_maintenance_versions = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $available_maintenance_versions;
    /**
     * The current software version on the instance.
     *
     * Generated from protobuf field <code>string maintenance_version = 42;</code>
     */
    private $maintenance_version = '';
    /**
     * Output only. The link to service attachment of PSC instance.
     *
     * Generated from protobuf field <code>optional string psc_service_attachment_link = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $psc_service_attachment_link = null;
    /**
     * Output only. The dns name of the instance.
     *
     * Generated from protobuf field <code>optional string dns_name = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $dns_name = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $kind
     *           This is always `sql#instance`.
     *     @type int $state
     *           The current serving state of the Cloud SQL instance.
     *     @type int $database_version
     *           The database engine type and version. The `databaseVersion` field cannot
     *           be changed after instance creation.
     *     @type \Google\Cloud\Sql\V1\Settings $settings
     *           The user settings.
     *     @type string $etag
     *           This field is deprecated and will be removed from a future version of the
     *           API. Use the `settings.settingsVersion` field instead.
     *     @type \Google\Cloud\Sql\V1\DatabaseInstance\SqlFailoverReplica $failover_replica
     *           The name and status of the failover replica.
     *     @type string $master_instance_name
     *           The name of the instance which will act as primary in the replication
     *           setup.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $replica_names
     *           The replicas of the instance.
     *     @type \Google\Protobuf\Int64Value $max_disk_size
     *           The maximum disk size of the instance in bytes.
     *     @type \Google\Protobuf\Int64Value $current_disk_size
     *           The current disk usage of the instance in bytes. This property has been
     *           deprecated. Use the
     *           "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     *           Monitoring API instead. Please see [this
     *           announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
     *           for details.
     *     @type array<\Google\Cloud\Sql\V1\IpMapping>|\Google\Protobuf\Internal\RepeatedField $ip_addresses
     *           The assigned IP addresses for the instance.
     *     @type \Google\Cloud\Sql\V1\SslCert $server_ca_cert
     *           SSL configuration.
     *     @type int $instance_type
     *           The instance type.
     *     @type string $project
     *           The project ID of the project containing the Cloud SQL instance. The Google
     *           apps domain is prefixed if applicable.
     *     @type string $ipv6_address
     *           The IPv6 address assigned to the instance.
     *           (Deprecated) This property was applicable only
     *           to First Generation instances.
     *     @type string $service_account_email_address
     *           The service account email address assigned to the instance.\This
     *           property is read-only.
     *     @type \Google\Cloud\Sql\V1\OnPremisesConfiguration $on_premises_configuration
     *           Configuration specific to on-premises instances.
     *     @type \Google\Cloud\Sql\V1\ReplicaConfiguration $replica_configuration
     *           Configuration specific to failover replicas and read replicas.
     *     @type int $backend_type
     *           The backend type.
     *           `SECOND_GEN`: Cloud SQL database instance.
     *           `EXTERNAL`: A database server that is not managed by Google.
     *           This property is read-only; use the `tier` property in the `settings`
     *           object to determine the database type.
     *     @type string $self_link
     *           The URI of this resource.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $suspension_reason
     *           If the instance state is SUSPENDED, the reason for the suspension.
     *     @type string $connection_name
     *           Connection name of the Cloud SQL instance used in connection strings.
     *     @type string $name
     *           Name of the Cloud SQL instance. This does not include the project ID.
     *     @type string $region
     *           The geographical region. Can be:
     *           *  `us-central` (`FIRST_GEN` instances only)
     *           *  `us-central1` (`SECOND_GEN` instances only)
     *           *  `asia-east1` or `europe-west1`.
     *           Defaults to `us-central` or `us-central1` depending on the instance
     *           type. The region cannot be changed after instance creation.
     *     @type string $gce_zone
     *           The Compute Engine zone that the instance is currently serving from. This
     *           value could be different from the zone that was specified when the instance
     *           was created if the instance has failed over to its secondary zone. WARNING:
     *           Changing this might restart the instance.
     *     @type string $secondary_gce_zone
     *           The Compute Engine zone that the failover instance is currently serving
     *           from for a regional instance. This value could be different
     *           from the zone that was specified when the instance
     *           was created if the instance has failed over to its secondary/failover zone.
     *     @type \Google\Cloud\Sql\V1\DiskEncryptionConfiguration $disk_encryption_configuration
     *           Disk encryption configuration specific to an instance.
     *     @type \Google\Cloud\Sql\V1\DiskEncryptionStatus $disk_encryption_status
     *           Disk encryption status specific to an instance.
     *     @type string $root_password
     *           Initial root password. Use only on creation. You must set root passwords
     *           before you can connect to PostgreSQL instances.
     *     @type \Google\Cloud\Sql\V1\DatabaseInstance\SqlScheduledMaintenance $scheduled_maintenance
     *           The start time of any upcoming scheduled maintenance for this instance.
     *     @type \Google\Protobuf\BoolValue $satisfies_pzs
     *           The status indicating if instance satisfiesPzs.
     *           Reserved for future use.
     *     @type string $database_installed_version
     *           Output only. Stores the current database version running on the instance
     *           including minor version such as `MYSQL_8_0_18`.
     *     @type \Google\Cloud\Sql\V1\DatabaseInstance\SqlOutOfDiskReport $out_of_disk_report
     *           This field represents the report generated by the proactive database
     *           wellness job for OutOfDisk issues.
     *           *  Writers:
     *             *  the proactive database wellness job for OOD.
     *           *  Readers:
     *             *  the proactive database wellness job
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the instance was created in
     *           [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
     *           `2012-11-15T16:19:00.094Z`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $available_maintenance_versions
     *           Output only. List all maintenance versions applicable on the instance
     *     @type string $maintenance_version
     *           The current software version on the instance.
     *     @type string $psc_service_attachment_link
     *           Output only. The link to service attachment of PSC instance.
     *     @type string $dns_name
     *           Output only. The dns name of the instance.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Sql\V1\CloudSqlInstances::initOnce();
        parent::__construct($data);
    }

    /**
     * This is always `sql#instance`.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * This is always `sql#instance`.
     *
     * Generated from protobuf field <code>string kind = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * The current serving state of the Cloud SQL instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlInstanceState state = 2;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * The current serving state of the Cloud SQL instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlInstanceState state = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\DatabaseInstance\SqlInstanceState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The database engine type and version. The `databaseVersion` field cannot
     * be changed after instance creation.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDatabaseVersion database_version = 3;</code>
     * @return int
     */
    public function getDatabaseVersion()
    {
        return $this->database_version;
    }

    /**
     * The database engine type and version. The `databaseVersion` field cannot
     * be changed after instance creation.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlDatabaseVersion database_version = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setDatabaseVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlDatabaseVersion::class);
        $this->database_version = $var;

        return $this;
    }

    /**
     * The user settings.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings settings = 4;</code>
     * @return \Google\Cloud\Sql\V1\Settings|null
     */
    public function getSettings()
    {
        return $this->settings;
    }

    public function hasSettings()
    {
        return isset($this->settings);
    }

    public function clearSettings()
    {
        unset($this->settings);
    }

    /**
     * The user settings.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.Settings settings = 4;</code>
     * @param \Google\Cloud\Sql\V1\Settings $var
     * @return $this
     */
    public function setSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\Settings::class);
        $this->settings = $var;

        return $this;
    }

    /**
     * This field is deprecated and will be removed from a future version of the
     * API. Use the `settings.settingsVersion` field instead.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * This field is deprecated and will be removed from a future version of the
     * API. Use the `settings.settingsVersion` field instead.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * The name and status of the failover replica.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlFailoverReplica failover_replica = 6;</code>
     * @return \Google\Cloud\Sql\V1\DatabaseInstance\SqlFailoverReplica|null
     */
    public function getFailoverReplica()
    {
        return $this->failover_replica;
    }

    public function hasFailoverReplica()
    {
        return isset($this->failover_replica);
    }

    public function clearFailoverReplica()
    {
        unset($this->failover_replica);
    }

    /**
     * The name and status of the failover replica.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlFailoverReplica failover_replica = 6;</code>
     * @param \Google\Cloud\Sql\V1\DatabaseInstance\SqlFailoverReplica $var
     * @return $this
     */
    public function setFailoverReplica($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\DatabaseInstance\SqlFailoverReplica::class);
        $this->failover_replica = $var;

        return $this;
    }

    /**
     * The name of the instance which will act as primary in the replication
     * setup.
     *
     * Generated from protobuf field <code>string master_instance_name = 7;</code>
     * @return string
     */
    public function getMasterInstanceName()
    {
        return $this->master_instance_name;
    }

    /**
     * The name of the instance which will act as primary in the replication
     * setup.
     *
     * Generated from protobuf field <code>string master_instance_name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setMasterInstanceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->master_instance_name = $var;

        return $this;
    }

    /**
     * The replicas of the instance.
     *
     * Generated from protobuf field <code>repeated string replica_names = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReplicaNames()
    {
        return $this->replica_names;
    }

    /**
     * The replicas of the instance.
     *
     * Generated from protobuf field <code>repeated string replica_names = 8;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReplicaNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->replica_names = $arr;

        return $this;
    }

    /**
     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @return \Google\Protobuf\Int64Value|null
     * @deprecated
     */
    public function getMaxDiskSize()
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        return $this->max_disk_size;
    }

    public function hasMaxDiskSize()
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        return isset($this->max_disk_size);
    }

    public function clearMaxDiskSize()
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        unset($this->max_disk_size);
    }

    /**
     * Returns the unboxed value from <code>getMaxDiskSize()</code>

     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @return int|string|null
     */
    public function getMaxDiskSizeValue()
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("max_disk_size");
    }

    /**
     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @param \Google\Protobuf\Int64Value $var
     * @return $this
     * @deprecated
     */
    public function setMaxDiskSize($var)
    {
        @trigger_error('max_disk_size is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Int64Value::class);
        $this->max_disk_size = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int64Value object.

     * The maximum disk size of the instance in bytes.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value max_disk_size = 9 [deprecated = true];</code>
     * @param int|string|null $var
     * @return $this
     */
    public function setMaxDiskSizeValue($var)
    {
        $this->writeWrapperValue("max_disk_size", $var);
        return $this;}

    /**
     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see [this
     * announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
     * for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @return \Google\Protobuf\Int64Value|null
     * @deprecated
     */
    public function getCurrentDiskSize()
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        return $this->current_disk_size;
    }

    public function hasCurrentDiskSize()
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        return isset($this->current_disk_size);
    }

    public function clearCurrentDiskSize()
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        unset($this->current_disk_size);
    }

    /**
     * Returns the unboxed value from <code>getCurrentDiskSize()</code>

     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see [this
     * announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
     * for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @return int|string|null
     */
    public function getCurrentDiskSizeValue()
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("current_disk_size");
    }

    /**
     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see [this
     * announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
     * for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @param \Google\Protobuf\Int64Value $var
     * @return $this
     * @deprecated
     */
    public function setCurrentDiskSize($var)
    {
        @trigger_error('current_disk_size is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Int64Value::class);
        $this->current_disk_size = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int64Value object.

     * The current disk usage of the instance in bytes. This property has been
     * deprecated. Use the
     * "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
     * Monitoring API instead. Please see [this
     * announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
     * for details.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value current_disk_size = 10 [deprecated = true];</code>
     * @param int|string|null $var
     * @return $this
     */
    public function setCurrentDiskSizeValue($var)
    {
        $this->writeWrapperValue("current_disk_size", $var);
        return $this;}

    /**
     * The assigned IP addresses for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.IpMapping ip_addresses = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIpAddresses()
    {
        return $this->ip_addresses;
    }

    /**
     * The assigned IP addresses for the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.IpMapping ip_addresses = 11;</code>
     * @param array<\Google\Cloud\Sql\V1\IpMapping>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIpAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Sql\V1\IpMapping::class);
        $this->ip_addresses = $arr;

        return $this;
    }

    /**
     * SSL configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SslCert server_ca_cert = 12;</code>
     * @return \Google\Cloud\Sql\V1\SslCert|null
     */
    public function getServerCaCert()
    {
        return $this->server_ca_cert;
    }

    public function hasServerCaCert()
    {
        return isset($this->server_ca_cert);
    }

    public function clearServerCaCert()
    {
        unset($this->server_ca_cert);
    }

    /**
     * SSL configuration.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SslCert server_ca_cert = 12;</code>
     * @param \Google\Cloud\Sql\V1\SslCert $var
     * @return $this
     */
    public function setServerCaCert($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\SslCert::class);
        $this->server_ca_cert = $var;

        return $this;
    }

    /**
     * The instance type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlInstanceType instance_type = 13;</code>
     * @return int
     */
    public function getInstanceType()
    {
        return $this->instance_type;
    }

    /**
     * The instance type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlInstanceType instance_type = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setInstanceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlInstanceType::class);
        $this->instance_type = $var;

        return $this;
    }

    /**
     * The project ID of the project containing the Cloud SQL instance. The Google
     * apps domain is prefixed if applicable.
     *
     * Generated from protobuf field <code>string project = 14;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * The project ID of the project containing the Cloud SQL instance. The Google
     * apps domain is prefixed if applicable.
     *
     * Generated from protobuf field <code>string project = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * The IPv6 address assigned to the instance.
     * (Deprecated) This property was applicable only
     * to First Generation instances.
     *
     * Generated from protobuf field <code>string ipv6_address = 15 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getIpv6Address()
    {
        @trigger_error('ipv6_address is deprecated.', E_USER_DEPRECATED);
        return $this->ipv6_address;
    }

    /**
     * The IPv6 address assigned to the instance.
     * (Deprecated) This property was applicable only
     * to First Generation instances.
     *
     * Generated from protobuf field <code>string ipv6_address = 15 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setIpv6Address($var)
    {
        @trigger_error('ipv6_address is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->ipv6_address = $var;

        return $this;
    }

    /**
     * The service account email address assigned to the instance.\This
     * property is read-only.
     *
     * Generated from protobuf field <code>string service_account_email_address = 16;</code>
     * @return string
     */
    public function getServiceAccountEmailAddress()
    {
        return $this->service_account_email_address;
    }

    /**
     * The service account email address assigned to the instance.\This
     * property is read-only.
     *
     * Generated from protobuf field <code>string service_account_email_address = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountEmailAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_email_address = $var;

        return $this;
    }

    /**
     * Configuration specific to on-premises instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.OnPremisesConfiguration on_premises_configuration = 17;</code>
     * @return \Google\Cloud\Sql\V1\OnPremisesConfiguration|null
     */
    public function getOnPremisesConfiguration()
    {
        return $this->on_premises_configuration;
    }

    public function hasOnPremisesConfiguration()
    {
        return isset($this->on_premises_configuration);
    }

    public function clearOnPremisesConfiguration()
    {
        unset($this->on_premises_configuration);
    }

    /**
     * Configuration specific to on-premises instances.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.OnPremisesConfiguration on_premises_configuration = 17;</code>
     * @param \Google\Cloud\Sql\V1\OnPremisesConfiguration $var
     * @return $this
     */
    public function setOnPremisesConfiguration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\OnPremisesConfiguration::class);
        $this->on_premises_configuration = $var;

        return $this;
    }

    /**
     * Configuration specific to failover replicas and read replicas.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.ReplicaConfiguration replica_configuration = 18;</code>
     * @return \Google\Cloud\Sql\V1\ReplicaConfiguration|null
     */
    public function getReplicaConfiguration()
    {
        return $this->replica_configuration;
    }

    public function hasReplicaConfiguration()
    {
        return isset($this->replica_configuration);
    }

    public function clearReplicaConfiguration()
    {
        unset($this->replica_configuration);
    }

    /**
     * Configuration specific to failover replicas and read replicas.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.ReplicaConfiguration replica_configuration = 18;</code>
     * @param \Google\Cloud\Sql\V1\ReplicaConfiguration $var
     * @return $this
     */
    public function setReplicaConfiguration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\ReplicaConfiguration::class);
        $this->replica_configuration = $var;

        return $this;
    }

    /**
     * The backend type.
     * `SECOND_GEN`: Cloud SQL database instance.
     * `EXTERNAL`: A database server that is not managed by Google.
     * This property is read-only; use the `tier` property in the `settings`
     * object to determine the database type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlBackendType backend_type = 19;</code>
     * @return int
     */
    public function getBackendType()
    {
        return $this->backend_type;
    }

    /**
     * The backend type.
     * `SECOND_GEN`: Cloud SQL database instance.
     * `EXTERNAL`: A database server that is not managed by Google.
     * This property is read-only; use the `tier` property in the `settings`
     * object to determine the database type.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.SqlBackendType backend_type = 19;</code>
     * @param int $var
     * @return $this
     */
    public function setBackendType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Sql\V1\SqlBackendType::class);
        $this->backend_type = $var;

        return $this;
    }

    /**
     * The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 20;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * The URI of this resource.
     *
     * Generated from protobuf field <code>string self_link = 20;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * If the instance state is SUSPENDED, the reason for the suspension.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.SqlSuspensionReason suspension_reason = 21;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSuspensionReason()
    {
        return $this->suspension_reason;
    }

    /**
     * If the instance state is SUSPENDED, the reason for the suspension.
     *
     * Generated from protobuf field <code>repeated .google.cloud.sql.v1.SqlSuspensionReason suspension_reason = 21;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSuspensionReason($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Sql\V1\SqlSuspensionReason::class);
        $this->suspension_reason = $arr;

        return $this;
    }

    /**
     * Connection name of the Cloud SQL instance used in connection strings.
     *
     * Generated from protobuf field <code>string connection_name = 22;</code>
     * @return string
     */
    public function getConnectionName()
    {
        return $this->connection_name;
    }

    /**
     * Connection name of the Cloud SQL instance used in connection strings.
     *
     * Generated from protobuf field <code>string connection_name = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setConnectionName($var)
    {
        GPBUtil::checkString($var, True);
        $this->connection_name = $var;

        return $this;
    }

    /**
     * Name of the Cloud SQL instance. This does not include the project ID.
     *
     * Generated from protobuf field <code>string name = 23;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the Cloud SQL instance. This does not include the project ID.
     *
     * Generated from protobuf field <code>string name = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The geographical region. Can be:
     * *  `us-central` (`FIRST_GEN` instances only)
     * *  `us-central1` (`SECOND_GEN` instances only)
     * *  `asia-east1` or `europe-west1`.
     * Defaults to `us-central` or `us-central1` depending on the instance
     * type. The region cannot be changed after instance creation.
     *
     * Generated from protobuf field <code>string region = 24;</code>
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * The geographical region. Can be:
     * *  `us-central` (`FIRST_GEN` instances only)
     * *  `us-central1` (`SECOND_GEN` instances only)
     * *  `asia-east1` or `europe-west1`.
     * Defaults to `us-central` or `us-central1` depending on the instance
     * type. The region cannot be changed after instance creation.
     *
     * Generated from protobuf field <code>string region = 24;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * The Compute Engine zone that the instance is currently serving from. This
     * value could be different from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary zone. WARNING:
     * Changing this might restart the instance.
     *
     * Generated from protobuf field <code>string gce_zone = 25;</code>
     * @return string
     */
    public function getGceZone()
    {
        return $this->gce_zone;
    }

    /**
     * The Compute Engine zone that the instance is currently serving from. This
     * value could be different from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary zone. WARNING:
     * Changing this might restart the instance.
     *
     * Generated from protobuf field <code>string gce_zone = 25;</code>
     * @param string $var
     * @return $this
     */
    public function setGceZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->gce_zone = $var;

        return $this;
    }

    /**
     * The Compute Engine zone that the failover instance is currently serving
     * from for a regional instance. This value could be different
     * from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary/failover zone.
     *
     * Generated from protobuf field <code>string secondary_gce_zone = 34;</code>
     * @return string
     */
    public function getSecondaryGceZone()
    {
        return $this->secondary_gce_zone;
    }

    /**
     * The Compute Engine zone that the failover instance is currently serving
     * from for a regional instance. This value could be different
     * from the zone that was specified when the instance
     * was created if the instance has failed over to its secondary/failover zone.
     *
     * Generated from protobuf field <code>string secondary_gce_zone = 34;</code>
     * @param string $var
     * @return $this
     */
    public function setSecondaryGceZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->secondary_gce_zone = $var;

        return $this;
    }

    /**
     * Disk encryption configuration specific to an instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DiskEncryptionConfiguration disk_encryption_configuration = 26;</code>
     * @return \Google\Cloud\Sql\V1\DiskEncryptionConfiguration|null
     */
    public function getDiskEncryptionConfiguration()
    {
        return $this->disk_encryption_configuration;
    }

    public function hasDiskEncryptionConfiguration()
    {
        return isset($this->disk_encryption_configuration);
    }

    public function clearDiskEncryptionConfiguration()
    {
        unset($this->disk_encryption_configuration);
    }

    /**
     * Disk encryption configuration specific to an instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DiskEncryptionConfiguration disk_encryption_configuration = 26;</code>
     * @param \Google\Cloud\Sql\V1\DiskEncryptionConfiguration $var
     * @return $this
     */
    public function setDiskEncryptionConfiguration($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\DiskEncryptionConfiguration::class);
        $this->disk_encryption_configuration = $var;

        return $this;
    }

    /**
     * Disk encryption status specific to an instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DiskEncryptionStatus disk_encryption_status = 27;</code>
     * @return \Google\Cloud\Sql\V1\DiskEncryptionStatus|null
     */
    public function getDiskEncryptionStatus()
    {
        return $this->disk_encryption_status;
    }

    public function hasDiskEncryptionStatus()
    {
        return isset($this->disk_encryption_status);
    }

    public function clearDiskEncryptionStatus()
    {
        unset($this->disk_encryption_status);
    }

    /**
     * Disk encryption status specific to an instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DiskEncryptionStatus disk_encryption_status = 27;</code>
     * @param \Google\Cloud\Sql\V1\DiskEncryptionStatus $var
     * @return $this
     */
    public function setDiskEncryptionStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\DiskEncryptionStatus::class);
        $this->disk_encryption_status = $var;

        return $this;
    }

    /**
     * Initial root password. Use only on creation. You must set root passwords
     * before you can connect to PostgreSQL instances.
     *
     * Generated from protobuf field <code>string root_password = 29;</code>
     * @return string
     */
    public function getRootPassword()
    {
        return $this->root_password;
    }

    /**
     * Initial root password. Use only on creation. You must set root passwords
     * before you can connect to PostgreSQL instances.
     *
     * Generated from protobuf field <code>string root_password = 29;</code>
     * @param string $var
     * @return $this
     */
    public function setRootPassword($var)
    {
        GPBUtil::checkString($var, True);
        $this->root_password = $var;

        return $this;
    }

    /**
     * The start time of any upcoming scheduled maintenance for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlScheduledMaintenance scheduled_maintenance = 30;</code>
     * @return \Google\Cloud\Sql\V1\DatabaseInstance\SqlScheduledMaintenance|null
     */
    public function getScheduledMaintenance()
    {
        return $this->scheduled_maintenance;
    }

    public function hasScheduledMaintenance()
    {
        return isset($this->scheduled_maintenance);
    }

    public function clearScheduledMaintenance()
    {
        unset($this->scheduled_maintenance);
    }

    /**
     * The start time of any upcoming scheduled maintenance for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.sql.v1.DatabaseInstance.SqlScheduledMaintenance scheduled_maintenance = 30;</code>
     * @param \Google\Cloud\Sql\V1\DatabaseInstance\SqlScheduledMaintenance $var
     * @return $this
     */
    public function setScheduledMaintenance($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\DatabaseInstance\SqlScheduledMaintenance::class);
        $this->scheduled_maintenance = $var;

        return $this;
    }

    /**
     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * Returns the unboxed value from <code>getSatisfiesPzs()</code>

     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     * @return bool|null
     */
    public function getSatisfiesPzsValue()
    {
        return $this->readWrapperValue("satisfies_pzs");
    }

    /**
     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * The status indicating if instance satisfiesPzs.
     * Reserved for future use.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue satisfies_pzs = 35;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setSatisfiesPzsValue($var)
    {
        $this->writeWrapperValue("satisfies_pzs", $var);
        return $this;}

    /**
     * Output only. Stores the current database version running on the instance
     * including minor version such as `MYSQL_8_0_18`.
     *
     * Generated from protobuf field <code>string database_installed_version = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDatabaseInstalledVersion()
    {
        return $this->database_installed_version;
    }

    /**
     * Output only. Stores the current database version running on the instance
     * including minor version such as `MYSQL_8_0_18`.
     *
     * Generated from protobuf field <code>string database_installed_version = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabaseInstalledVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->database_installed_version = $var;

        return $this;
    }

    /**
     * This field represents the report generated by the proactive database
     * wellness job for OutOfDisk issues.
     * *  Writers:
     *   *  the proactive database wellness job for OOD.
     * *  Readers:
     *   *  the proactive database wellness job
     *
     * Generated from protobuf field <code>optional .google.cloud.sql.v1.DatabaseInstance.SqlOutOfDiskReport out_of_disk_report = 38;</code>
     * @return \Google\Cloud\Sql\V1\DatabaseInstance\SqlOutOfDiskReport|null
     */
    public function getOutOfDiskReport()
    {
        return $this->out_of_disk_report;
    }

    public function hasOutOfDiskReport()
    {
        return isset($this->out_of_disk_report);
    }

    public function clearOutOfDiskReport()
    {
        unset($this->out_of_disk_report);
    }

    /**
     * This field represents the report generated by the proactive database
     * wellness job for OutOfDisk issues.
     * *  Writers:
     *   *  the proactive database wellness job for OOD.
     * *  Readers:
     *   *  the proactive database wellness job
     *
     * Generated from protobuf field <code>optional .google.cloud.sql.v1.DatabaseInstance.SqlOutOfDiskReport out_of_disk_report = 38;</code>
     * @param \Google\Cloud\Sql\V1\DatabaseInstance\SqlOutOfDiskReport $var
     * @return $this
     */
    public function setOutOfDiskReport($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Sql\V1\DatabaseInstance\SqlOutOfDiskReport::class);
        $this->out_of_disk_report = $var;

        return $this;
    }

    /**
     * Output only. The time when the instance was created in
     * [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
     * `2012-11-15T16:19:00.094Z`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the instance was created in
     * [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
     * `2012-11-15T16:19:00.094Z`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. List all maintenance versions applicable on the instance
     *
     * Generated from protobuf field <code>repeated string available_maintenance_versions = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAvailableMaintenanceVersions()
    {
        return $this->available_maintenance_versions;
    }

    /**
     * Output only. List all maintenance versions applicable on the instance
     *
     * Generated from protobuf field <code>repeated string available_maintenance_versions = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAvailableMaintenanceVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->available_maintenance_versions = $arr;

        return $this;
    }

    /**
     * The current software version on the instance.
     *
     * Generated from protobuf field <code>string maintenance_version = 42;</code>
     * @return string
     */
    public function getMaintenanceVersion()
    {
        return $this->maintenance_version;
    }

    /**
     * The current software version on the instance.
     *
     * Generated from protobuf field <code>string maintenance_version = 42;</code>
     * @param string $var
     * @return $this
     */
    public function setMaintenanceVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->maintenance_version = $var;

        return $this;
    }

    /**
     * Output only. The link to service attachment of PSC instance.
     *
     * Generated from protobuf field <code>optional string psc_service_attachment_link = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPscServiceAttachmentLink()
    {
        return isset($this->psc_service_attachment_link) ? $this->psc_service_attachment_link : '';
    }

    public function hasPscServiceAttachmentLink()
    {
        return isset($this->psc_service_attachment_link);
    }

    public function clearPscServiceAttachmentLink()
    {
        unset($this->psc_service_attachment_link);
    }

    /**
     * Output only. The link to service attachment of PSC instance.
     *
     * Generated from protobuf field <code>optional string psc_service_attachment_link = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPscServiceAttachmentLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->psc_service_attachment_link = $var;

        return $this;
    }

    /**
     * Output only. The dns name of the instance.
     *
     * Generated from protobuf field <code>optional string dns_name = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDnsName()
    {
        return isset($this->dns_name) ? $this->dns_name : '';
    }

    public function hasDnsName()
    {
        return isset($this->dns_name);
    }

    public function clearDnsName()
    {
        unset($this->dns_name);
    }

    /**
     * Output only. The dns name of the instance.
     *
     * Generated from protobuf field <code>optional string dns_name = 49 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDnsName($var)
    {
        GPBUtil::checkString($var, True);
        $this->dns_name = $var;

        return $this;
    }

}

