<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/catalog.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Catalog level attribute config for an attribute. For example, if customers
 * want to enable/disable facet for a specific attribute.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.CatalogAttribute</code>
 */
class CatalogAttribute extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Attribute name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     * To be indexable, the attribute name can contain only alpha-numeric
     * characters and underscores. For example, an attribute named
     * `attributes.abc_xyz` can be indexed, but an attribute named
     * `attributes.abc-xyz` cannot be indexed.
     * If the attribute key starts with `attributes.`, then the attribute is a
     * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     * built-in and called system attributes.
     *
     * Generated from protobuf field <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $key = '';
    /**
     * Output only. Indicates whether this attribute has been used by any
     * products. `True` if at least one [Product][google.cloud.retail.v2.Product]
     * is using this attribute in
     * [Product.attributes][google.cloud.retail.v2.Product.attributes]. Otherwise,
     * this field is `False`.
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] can be
     * pre-loaded by using
     * [CatalogService.AddCatalogAttribute][google.cloud.retail.v2.CatalogService.AddCatalogAttribute],
     * [CatalogService.ImportCatalogAttributes][], or
     * [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2.CatalogService.UpdateAttributesConfig]
     * APIs. This field is `False` for pre-loaded
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]s.
     * Only pre-loaded [catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
     * use by products nor predefined can be deleted. [Catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are
     * either in use by products or are predefined attributes cannot be deleted;
     * however, their configuration properties will reset to default values upon
     * removal request.
     * After catalog changes, it takes about 10 minutes for this field to update.
     *
     * Generated from protobuf field <code>bool in_use = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $in_use = false;
    /**
     * Output only. The type of this attribute. This is derived from the attribute
     * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $type = 0;
    /**
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     * are indexed so that it can be filtered, faceted, or boosted in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
     */
    private $indexable_option = 0;
    /**
     * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;</code>
     */
    private $dynamic_facetable_option = 0;
    /**
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     * are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     * will not be searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     * there are no text values associated to numerical attributes.
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
     */
    private $searchable_option = 0;
    /**
     * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     * This property only applies to textual custom attributes and requires
     * indexable set to enabled to enable exact-searchable. If unset, the server
     * behavior defaults to
     * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;</code>
     */
    private $exact_searchable_option = 0;
    /**
     * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     * results. If unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;</code>
     */
    private $retrievable_option = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $key
     *           Required. Attribute name.
     *           For example: `color`, `brands`, `attributes.custom_attribute`, such as
     *           `attributes.xyz`.
     *           To be indexable, the attribute name can contain only alpha-numeric
     *           characters and underscores. For example, an attribute named
     *           `attributes.abc_xyz` can be indexed, but an attribute named
     *           `attributes.abc-xyz` cannot be indexed.
     *           If the attribute key starts with `attributes.`, then the attribute is a
     *           custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     *           built-in and called system attributes.
     *     @type bool $in_use
     *           Output only. Indicates whether this attribute has been used by any
     *           products. `True` if at least one [Product][google.cloud.retail.v2.Product]
     *           is using this attribute in
     *           [Product.attributes][google.cloud.retail.v2.Product.attributes]. Otherwise,
     *           this field is `False`.
     *           [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] can be
     *           pre-loaded by using
     *           [CatalogService.AddCatalogAttribute][google.cloud.retail.v2.CatalogService.AddCatalogAttribute],
     *           [CatalogService.ImportCatalogAttributes][], or
     *           [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2.CatalogService.UpdateAttributesConfig]
     *           APIs. This field is `False` for pre-loaded
     *           [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]s.
     *           Only pre-loaded [catalog
     *           attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
     *           use by products nor predefined can be deleted. [Catalog
     *           attributes][google.cloud.retail.v2.CatalogAttribute] that are
     *           either in use by products or are predefined attributes cannot be deleted;
     *           however, their configuration properties will reset to default values upon
     *           removal request.
     *           After catalog changes, it takes about 10 minutes for this field to update.
     *     @type int $type
     *           Output only. The type of this attribute. This is derived from the attribute
     *           in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     *     @type int $indexable_option
     *           When
     *           [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     *           is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     *           are indexed so that it can be filtered, faceted, or boosted in
     *           [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *           Must be specified, otherwise throws INVALID_FORMAT error.
     *     @type int $dynamic_facetable_option
     *           If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     *           facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     *           [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     *           is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     *           Must be specified, otherwise throws INVALID_FORMAT error.
     *     @type int $searchable_option
     *           When
     *           [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     *           is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     *           are searchable by text queries in
     *           [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     *           If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     *           will not be searchable by text queries in
     *           [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     *           there are no text values associated to numerical attributes.
     *           Must be specified, otherwise throws INVALID_FORMAT error.
     *     @type int $exact_searchable_option
     *           If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     *           This property only applies to textual custom attributes and requires
     *           indexable set to enabled to enable exact-searchable. If unset, the server
     *           behavior defaults to
     *           [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     *     @type int $retrievable_option
     *           If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     *           results. If unset, the server behavior defaults to
     *           [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\Catalog::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Attribute name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     * To be indexable, the attribute name can contain only alpha-numeric
     * characters and underscores. For example, an attribute named
     * `attributes.abc_xyz` can be indexed, but an attribute named
     * `attributes.abc-xyz` cannot be indexed.
     * If the attribute key starts with `attributes.`, then the attribute is a
     * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     * built-in and called system attributes.
     *
     * Generated from protobuf field <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * Required. Attribute name.
     * For example: `color`, `brands`, `attributes.custom_attribute`, such as
     * `attributes.xyz`.
     * To be indexable, the attribute name can contain only alpha-numeric
     * characters and underscores. For example, an attribute named
     * `attributes.abc_xyz` can be indexed, but an attribute named
     * `attributes.abc-xyz` cannot be indexed.
     * If the attribute key starts with `attributes.`, then the attribute is a
     * custom attribute. Attributes such as `brands`, `patterns`, and `title` are
     * built-in and called system attributes.
     *
     * Generated from protobuf field <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->key = $var;

        return $this;
    }

    /**
     * Output only. Indicates whether this attribute has been used by any
     * products. `True` if at least one [Product][google.cloud.retail.v2.Product]
     * is using this attribute in
     * [Product.attributes][google.cloud.retail.v2.Product.attributes]. Otherwise,
     * this field is `False`.
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] can be
     * pre-loaded by using
     * [CatalogService.AddCatalogAttribute][google.cloud.retail.v2.CatalogService.AddCatalogAttribute],
     * [CatalogService.ImportCatalogAttributes][], or
     * [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2.CatalogService.UpdateAttributesConfig]
     * APIs. This field is `False` for pre-loaded
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]s.
     * Only pre-loaded [catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
     * use by products nor predefined can be deleted. [Catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are
     * either in use by products or are predefined attributes cannot be deleted;
     * however, their configuration properties will reset to default values upon
     * removal request.
     * After catalog changes, it takes about 10 minutes for this field to update.
     *
     * Generated from protobuf field <code>bool in_use = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getInUse()
    {
        return $this->in_use;
    }

    /**
     * Output only. Indicates whether this attribute has been used by any
     * products. `True` if at least one [Product][google.cloud.retail.v2.Product]
     * is using this attribute in
     * [Product.attributes][google.cloud.retail.v2.Product.attributes]. Otherwise,
     * this field is `False`.
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] can be
     * pre-loaded by using
     * [CatalogService.AddCatalogAttribute][google.cloud.retail.v2.CatalogService.AddCatalogAttribute],
     * [CatalogService.ImportCatalogAttributes][], or
     * [CatalogService.UpdateAttributesConfig][google.cloud.retail.v2.CatalogService.UpdateAttributesConfig]
     * APIs. This field is `False` for pre-loaded
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute]s.
     * Only pre-loaded [catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are neither in
     * use by products nor predefined can be deleted. [Catalog
     * attributes][google.cloud.retail.v2.CatalogAttribute] that are
     * either in use by products or are predefined attributes cannot be deleted;
     * however, their configuration properties will reset to default values upon
     * removal request.
     * After catalog changes, it takes about 10 minutes for this field to update.
     *
     * Generated from protobuf field <code>bool in_use = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setInUse($var)
    {
        GPBUtil::checkBool($var);
        $this->in_use = $var;

        return $this;
    }

    /**
     * Output only. The type of this attribute. This is derived from the attribute
     * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Output only. The type of this attribute. This is derived from the attribute
     * in [Product.attributes][google.cloud.retail.v2.Product.attributes].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.AttributeType type = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\CatalogAttribute\AttributeType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     * are indexed so that it can be filtered, faceted, or boosted in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
     * @return int
     */
    public function getIndexableOption()
    {
        return $this->indexable_option;
    }

    /**
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if INDEXABLE_ENABLED attribute values
     * are indexed so that it can be filtered, faceted, or boosted in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.IndexableOption indexable_option = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setIndexableOption($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\CatalogAttribute\IndexableOption::class);
        $this->indexable_option = $var;

        return $this;
    }

    /**
     * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;</code>
     * @return int
     */
    public function getDynamicFacetableOption()
    {
        return $this->dynamic_facetable_option;
    }

    /**
     * If DYNAMIC_FACETABLE_ENABLED, attribute values are available for dynamic
     * facet. Could only be DYNAMIC_FACETABLE_DISABLED if
     * [CatalogAttribute.indexable_option][google.cloud.retail.v2.CatalogAttribute.indexable_option]
     * is INDEXABLE_DISABLED. Otherwise, an INVALID_ARGUMENT error is returned.
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.DynamicFacetableOption dynamic_facetable_option = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setDynamicFacetableOption($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\CatalogAttribute\DynamicFacetableOption::class);
        $this->dynamic_facetable_option = $var;

        return $this;
    }

    /**
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     * are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     * will not be searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     * there are no text values associated to numerical attributes.
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
     * @return int
     */
    public function getSearchableOption()
    {
        return $this->searchable_option;
    }

    /**
     * When
     * [AttributesConfig.attribute_config_level][google.cloud.retail.v2.AttributesConfig.attribute_config_level]
     * is CATALOG_LEVEL_ATTRIBUTE_CONFIG, if SEARCHABLE_ENABLED, attribute values
     * are searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search].
     * If SEARCHABLE_ENABLED but attribute type is numerical, attribute values
     * will not be searchable by text queries in
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search], as
     * there are no text values associated to numerical attributes.
     * Must be specified, otherwise throws INVALID_FORMAT error.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.SearchableOption searchable_option = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setSearchableOption($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\CatalogAttribute\SearchableOption::class);
        $this->searchable_option = $var;

        return $this;
    }

    /**
     * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     * This property only applies to textual custom attributes and requires
     * indexable set to enabled to enable exact-searchable. If unset, the server
     * behavior defaults to
     * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;</code>
     * @return int
     */
    public function getExactSearchableOption()
    {
        return $this->exact_searchable_option;
    }

    /**
     * If EXACT_SEARCHABLE_ENABLED, attribute values will be exact searchable.
     * This property only applies to textual custom attributes and requires
     * indexable set to enabled to enable exact-searchable. If unset, the server
     * behavior defaults to
     * [EXACT_SEARCHABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption.EXACT_SEARCHABLE_DISABLED].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.ExactSearchableOption exact_searchable_option = 11;</code>
     * @param int $var
     * @return $this
     */
    public function setExactSearchableOption($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\CatalogAttribute\ExactSearchableOption::class);
        $this->exact_searchable_option = $var;

        return $this;
    }

    /**
     * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     * results. If unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;</code>
     * @return int
     */
    public function getRetrievableOption()
    {
        return $this->retrievable_option;
    }

    /**
     * If RETRIEVABLE_ENABLED, attribute values are retrievable in the search
     * results. If unset, the server behavior defaults to
     * [RETRIEVABLE_DISABLED][google.cloud.retail.v2.CatalogAttribute.RetrievableOption.RETRIEVABLE_DISABLED].
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.CatalogAttribute.RetrievableOption retrievable_option = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setRetrievableOption($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\CatalogAttribute\RetrievableOption::class);
        $this->retrievable_option = $var;

        return $this;
    }

}

