<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/change_stream.proto

namespace Google\Cloud\Spanner\V1\ChangeStreamRecord;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A partition start record serves as a notification that the client should
 * schedule the partitions to be queried. PartitionStartRecord returns
 * information about one or more partitions.
 *
 * Generated from protobuf message <code>google.spanner.v1.ChangeStreamRecord.PartitionStartRecord</code>
 */
class PartitionStartRecord extends \Google\Protobuf\Internal\Message
{
    /**
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps >= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     */
    protected $start_timestamp = null;
    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     */
    protected $record_sequence = '';
    /**
     * Unique partition identifiers to be used in queries.
     *
     * Generated from protobuf field <code>repeated string partition_tokens = 3;</code>
     */
    private $partition_tokens;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Timestamp $start_timestamp
     *           Start timestamp at which the partitions should be queried to return
     *           change stream records with timestamps >= start_timestamp.
     *           DataChangeRecord.commit_timestamps,
     *           PartitionStartRecord.start_timestamps,
     *           PartitionEventRecord.commit_timestamps, and
     *           PartitionEndRecord.end_timestamps can have the same value in the same
     *           partition.
     *     @type string $record_sequence
     *           Record sequence numbers are unique and monotonically increasing (but not
     *           necessarily contiguous) for a specific timestamp across record
     *           types in the same partition. To guarantee ordered processing, the reader
     *           should process records (of potentially different types) in
     *           record_sequence order for a specific timestamp in the same partition.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $partition_tokens
     *           Unique partition identifiers to be used in queries.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\ChangeStream::initOnce();
        parent::__construct($data);
    }

    /**
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps >= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTimestamp()
    {
        return $this->start_timestamp;
    }

    public function hasStartTimestamp()
    {
        return isset($this->start_timestamp);
    }

    public function clearStartTimestamp()
    {
        unset($this->start_timestamp);
    }

    /**
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps >= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_timestamp = $var;

        return $this;
    }

    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     * @return string
     */
    public function getRecordSequence()
    {
        return $this->record_sequence;
    }

    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRecordSequence($var)
    {
        GPBUtil::checkString($var, True);
        $this->record_sequence = $var;

        return $this;
    }

    /**
     * Unique partition identifiers to be used in queries.
     *
     * Generated from protobuf field <code>repeated string partition_tokens = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPartitionTokens()
    {
        return $this->partition_tokens;
    }

    /**
     * Unique partition identifiers to be used in queries.
     *
     * Generated from protobuf field <code>repeated string partition_tokens = 3;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPartitionTokens($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->partition_tokens = $arr;

        return $this;
    }

}


