<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/issueresolution/v1/issueresolution.proto

namespace Google\Shopping\Merchant\IssueResolution\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An actionable step that can be executed to solve the issue.
 *
 * Generated from protobuf message <code>google.shopping.merchant.issueresolution.v1.Action</code>
 */
class Action extends \Google\Protobuf\Internal\Message
{
    /**
     * Label of the action button.
     *
     * Generated from protobuf field <code>string button_label = 4;</code>
     */
    protected $button_label = '';
    /**
     * Controlling whether the button is active or disabled. The value is 'false'
     * when the action was already requested or is not available. If the action is
     * not available then a
     * [reason][google.shopping.merchant.issueresolution.v1.Action.reasons] will
     * be present. If (your) third-party application shows a disabled button for
     * action that is not available, then it should also show reasons.
     *
     * Generated from protobuf field <code>bool is_available = 5;</code>
     */
    protected $is_available = false;
    /**
     * List of reasons why the action is not available. The list of reasons is
     * empty if the action is available. If there is only one reason, it can be
     * displayed next to the disabled button. If there are more reasons, all of
     * them should be displayed, for example in a pop-up dialog.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.issueresolution.v1.Action.Reason reasons = 6;</code>
     */
    private $reasons;
    protected $action;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Shopping\Merchant\IssueResolution\V1\BuiltInSimpleAction $builtin_simple_action
     *           Action implemented and performed in (your) third-party application. The
     *           application should point the business to the place, where they can access
     *           the corresponding functionality or provide instructions, if the specific
     *           functionality is not available.
     *     @type \Google\Shopping\Merchant\IssueResolution\V1\ExternalAction $external_action
     *           Action that is implemented and performed outside of (your) third-party
     *           application. The application needs to redirect the business to the
     *           external location where they can perform the action.
     *     @type \Google\Shopping\Merchant\IssueResolution\V1\BuiltInUserInputAction $builtin_user_input_action
     *           Action implemented and performed in (your) third-party application.
     *           The application needs to show an additional content and input form to the
     *           business as specified for given action. They can trigger the action only
     *           when they provided all required inputs.
     *     @type string $button_label
     *           Label of the action button.
     *     @type bool $is_available
     *           Controlling whether the button is active or disabled. The value is 'false'
     *           when the action was already requested or is not available. If the action is
     *           not available then a
     *           [reason][google.shopping.merchant.issueresolution.v1.Action.reasons] will
     *           be present. If (your) third-party application shows a disabled button for
     *           action that is not available, then it should also show reasons.
     *     @type array<\Google\Shopping\Merchant\IssueResolution\V1\Action\Reason>|\Google\Protobuf\Internal\RepeatedField $reasons
     *           List of reasons why the action is not available. The list of reasons is
     *           empty if the action is available. If there is only one reason, it can be
     *           displayed next to the disabled button. If there are more reasons, all of
     *           them should be displayed, for example in a pop-up dialog.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Issueresolution\V1\Issueresolution::initOnce();
        parent::__construct($data);
    }

    /**
     * Action implemented and performed in (your) third-party application. The
     * application should point the business to the place, where they can access
     * the corresponding functionality or provide instructions, if the specific
     * functionality is not available.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.issueresolution.v1.BuiltInSimpleAction builtin_simple_action = 2;</code>
     * @return \Google\Shopping\Merchant\IssueResolution\V1\BuiltInSimpleAction|null
     */
    public function getBuiltinSimpleAction()
    {
        return $this->readOneof(2);
    }

    public function hasBuiltinSimpleAction()
    {
        return $this->hasOneof(2);
    }

    /**
     * Action implemented and performed in (your) third-party application. The
     * application should point the business to the place, where they can access
     * the corresponding functionality or provide instructions, if the specific
     * functionality is not available.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.issueresolution.v1.BuiltInSimpleAction builtin_simple_action = 2;</code>
     * @param \Google\Shopping\Merchant\IssueResolution\V1\BuiltInSimpleAction $var
     * @return $this
     */
    public function setBuiltinSimpleAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\IssueResolution\V1\BuiltInSimpleAction::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Action that is implemented and performed outside of (your) third-party
     * application. The application needs to redirect the business to the
     * external location where they can perform the action.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.issueresolution.v1.ExternalAction external_action = 3;</code>
     * @return \Google\Shopping\Merchant\IssueResolution\V1\ExternalAction|null
     */
    public function getExternalAction()
    {
        return $this->readOneof(3);
    }

    public function hasExternalAction()
    {
        return $this->hasOneof(3);
    }

    /**
     * Action that is implemented and performed outside of (your) third-party
     * application. The application needs to redirect the business to the
     * external location where they can perform the action.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.issueresolution.v1.ExternalAction external_action = 3;</code>
     * @param \Google\Shopping\Merchant\IssueResolution\V1\ExternalAction $var
     * @return $this
     */
    public function setExternalAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\IssueResolution\V1\ExternalAction::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Action implemented and performed in (your) third-party application.
     * The application needs to show an additional content and input form to the
     * business as specified for given action. They can trigger the action only
     * when they provided all required inputs.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.issueresolution.v1.BuiltInUserInputAction builtin_user_input_action = 7;</code>
     * @return \Google\Shopping\Merchant\IssueResolution\V1\BuiltInUserInputAction|null
     */
    public function getBuiltinUserInputAction()
    {
        return $this->readOneof(7);
    }

    public function hasBuiltinUserInputAction()
    {
        return $this->hasOneof(7);
    }

    /**
     * Action implemented and performed in (your) third-party application.
     * The application needs to show an additional content and input form to the
     * business as specified for given action. They can trigger the action only
     * when they provided all required inputs.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.issueresolution.v1.BuiltInUserInputAction builtin_user_input_action = 7;</code>
     * @param \Google\Shopping\Merchant\IssueResolution\V1\BuiltInUserInputAction $var
     * @return $this
     */
    public function setBuiltinUserInputAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\IssueResolution\V1\BuiltInUserInputAction::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Label of the action button.
     *
     * Generated from protobuf field <code>string button_label = 4;</code>
     * @return string
     */
    public function getButtonLabel()
    {
        return $this->button_label;
    }

    /**
     * Label of the action button.
     *
     * Generated from protobuf field <code>string button_label = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setButtonLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->button_label = $var;

        return $this;
    }

    /**
     * Controlling whether the button is active or disabled. The value is 'false'
     * when the action was already requested or is not available. If the action is
     * not available then a
     * [reason][google.shopping.merchant.issueresolution.v1.Action.reasons] will
     * be present. If (your) third-party application shows a disabled button for
     * action that is not available, then it should also show reasons.
     *
     * Generated from protobuf field <code>bool is_available = 5;</code>
     * @return bool
     */
    public function getIsAvailable()
    {
        return $this->is_available;
    }

    /**
     * Controlling whether the button is active or disabled. The value is 'false'
     * when the action was already requested or is not available. If the action is
     * not available then a
     * [reason][google.shopping.merchant.issueresolution.v1.Action.reasons] will
     * be present. If (your) third-party application shows a disabled button for
     * action that is not available, then it should also show reasons.
     *
     * Generated from protobuf field <code>bool is_available = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsAvailable($var)
    {
        GPBUtil::checkBool($var);
        $this->is_available = $var;

        return $this;
    }

    /**
     * List of reasons why the action is not available. The list of reasons is
     * empty if the action is available. If there is only one reason, it can be
     * displayed next to the disabled button. If there are more reasons, all of
     * them should be displayed, for example in a pop-up dialog.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.issueresolution.v1.Action.Reason reasons = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getReasons()
    {
        return $this->reasons;
    }

    /**
     * List of reasons why the action is not available. The list of reasons is
     * empty if the action is available. If there is only one reason, it can be
     * displayed next to the disabled button. If there are more reasons, all of
     * them should be displayed, for example in a pop-up dialog.
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.issueresolution.v1.Action.Reason reasons = 6;</code>
     * @param array<\Google\Shopping\Merchant\IssueResolution\V1\Action\Reason>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setReasons($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\IssueResolution\V1\Action\Reason::class);
        $this->reasons = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getAction()
    {
        return $this->whichOneof("action");
    }

}

