<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/job.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Job represents the configuration of a single job, which references a
 * container image that is run to completion.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.Job</code>
 */
class Job extends \Google\Protobuf\Internal\Message
{
    /**
     * The fully qualified name of this Job.
     * Format:
     * projects/{project}/locations/{location}/jobs/{job}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $generation = 0;
    /**
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     * <p>Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     * <p>This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5;</code>
     */
    private $annotations;
    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delete_time = null;
    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $expire_time = null;
    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $creator = '';
    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_modifier = '';
    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 12;</code>
     */
    protected $client = '';
    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 13;</code>
     */
    protected $client_version = '';
    /**
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 14;</code>
     */
    protected $launch_stage = 0;
    /**
     * Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     */
    protected $binary_authorization = null;
    /**
     * Required. The template used to create executions for this Job.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $template = null;
    /**
     * Output only. The generation of this Job. See comments in `reconciling` for
     * additional information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>int64 observed_generation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $observed_generation = 0;
    /**
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $terminal_condition = null;
    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $conditions;
    /**
     * Output only. Number of executions created for this job.
     *
     * Generated from protobuf field <code>int32 execution_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $execution_count = 0;
    /**
     * Output only. Name of the last created execution.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $latest_created_execution = null;
    /**
     * Output only. Returns true if the Job is currently being acted upon by the
     * system to bring it into the desired state.
     * When a new Job is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Job to the
     * desired state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation` and
     * `latest_succeeded_execution`, will have transient values that might
     * mismatch the intended state: Once reconciliation is over (and this field is
     * false), there are two possible outcomes: reconciliation succeeded and the
     * state matches the Job, or there was an error,  and reconciliation failed.
     * This state can be found in `terminal_condition.state`.
     * If reconciliation succeeded, the following fields will match:
     * `observed_generation` and `generation`, `latest_succeeded_execution` and
     * `latest_created_execution`.
     * If reconciliation failed, `observed_generation` and
     * `latest_succeeded_execution` will have the state of the last succeeded
     * execution or empty for newly created Job. Additional information on the
     * failure can be found in `terminal_condition` and `conditions`.
     *
     * Generated from protobuf field <code>bool reconciling = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    protected $create_execution;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The fully qualified name of this Job.
     *           Format:
     *           projects/{project}/locations/{location}/jobs/{job}
     *     @type string $uid
     *           Output only. Server assigned unique identifier for the Execution. The value
     *           is a UUID4 string and guaranteed to remain unchanged until the resource is
     *           deleted.
     *     @type int|string $generation
     *           Output only. A number that monotonically increases every time the user
     *           modifies the desired state.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Unstructured key value map that can be used to organize and categorize
     *           objects.
     *           User-provided labels are shared with Google's billing system, so they can
     *           be used to filter, or break down billing charges by team, component,
     *           environment, state, etc. For more information, visit
     *           https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     *           https://cloud.google.com/run/docs/configuring/labels.
     *           <p>Cloud Run API v2 does not support labels with `run.googleapis.com`,
     *           `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     *           namespaces, and they will be rejected. All system labels in v1 now have a
     *           corresponding field in v2 Job.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Unstructured key value map that may
     *           be set by external tools to store and arbitrary metadata.
     *           They are not queryable and should be preserved
     *           when modifying objects.
     *           <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     *           `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     *           namespaces, and they will be rejected on new resources. All system
     *           annotations in v1 now have a corresponding field in v2 Job.
     *           <p>This field follows Kubernetes annotations' namespacing, limits, and
     *           rules.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last-modified time.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. The deletion time. It is only populated as a response to a
     *           Delete request.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Output only. For a deleted resource, the time after which it will be
     *           permamently deleted.
     *     @type string $creator
     *           Output only. Email address of the authenticated creator.
     *     @type string $last_modifier
     *           Output only. Email address of the last authenticated modifier.
     *     @type string $client
     *           Arbitrary identifier for the API client.
     *     @type string $client_version
     *           Arbitrary version identifier for the API client.
     *     @type int $launch_stage
     *           The launch stage as defined by [Google Cloud Platform
     *           Launch Stages](https://cloud.google.com/terms/launch-stages).
     *           Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     *           is assumed.
     *           Set the launch stage to a preview stage on input to allow use of preview
     *           features in that stage. On read (or output), describes whether the resource
     *           uses preview features.
     *           For example, if ALPHA is provided as input, but only BETA and GA-level
     *           features are used, this field will be BETA on output.
     *     @type \Google\Cloud\Run\V2\BinaryAuthorization $binary_authorization
     *           Settings for the Binary Authorization feature.
     *     @type \Google\Cloud\Run\V2\ExecutionTemplate $template
     *           Required. The template used to create executions for this Job.
     *     @type int|string $observed_generation
     *           Output only. The generation of this Job. See comments in `reconciling` for
     *           additional information on reconciliation process in Cloud Run.
     *     @type \Google\Cloud\Run\V2\Condition $terminal_condition
     *           Output only. The Condition of this Job, containing its readiness status,
     *           and detailed error information in case it did not reach the desired state.
     *     @type array<\Google\Cloud\Run\V2\Condition>|\Google\Protobuf\Internal\RepeatedField $conditions
     *           Output only. The Conditions of all other associated sub-resources. They
     *           contain additional diagnostics information in case the Job does not reach
     *           its desired state. See comments in `reconciling` for additional information
     *           on reconciliation process in Cloud Run.
     *     @type int $execution_count
     *           Output only. Number of executions created for this job.
     *     @type \Google\Cloud\Run\V2\ExecutionReference $latest_created_execution
     *           Output only. Name of the last created execution.
     *     @type bool $reconciling
     *           Output only. Returns true if the Job is currently being acted upon by the
     *           system to bring it into the desired state.
     *           When a new Job is created, or an existing one is updated, Cloud Run
     *           will asynchronously perform all necessary steps to bring the Job to the
     *           desired state. This process is called reconciliation.
     *           While reconciliation is in process, `observed_generation` and
     *           `latest_succeeded_execution`, will have transient values that might
     *           mismatch the intended state: Once reconciliation is over (and this field is
     *           false), there are two possible outcomes: reconciliation succeeded and the
     *           state matches the Job, or there was an error,  and reconciliation failed.
     *           This state can be found in `terminal_condition.state`.
     *           If reconciliation succeeded, the following fields will match:
     *           `observed_generation` and `generation`, `latest_succeeded_execution` and
     *           `latest_created_execution`.
     *           If reconciliation failed, `observed_generation` and
     *           `latest_succeeded_execution` will have the state of the last succeeded
     *           execution or empty for newly created Job. Additional information on the
     *           failure can be found in `terminal_condition` and `conditions`.
     *     @type bool $satisfies_pzs
     *           Output only. Reserved for future use.
     *     @type string $start_execution_token
     *           A unique string used as a suffix creating a new execution. The Job will
     *           become ready when the execution is successfully started.
     *           The sum of job name and token length must be fewer than 63 characters.
     *     @type string $run_execution_token
     *           A unique string used as a suffix for creating a new execution. The Job
     *           will become ready when the execution is successfully completed.
     *           The sum of job name and token length must be fewer than 63 characters.
     *     @type string $etag
     *           Optional. A system-generated fingerprint for this version of the
     *           resource. May be used to detect modification conflict during updates.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\Job::initOnce();
        parent::__construct($data);
    }

    /**
     * The fully qualified name of this Job.
     * Format:
     * projects/{project}/locations/{location}/jobs/{job}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The fully qualified name of this Job.
     * Format:
     * projects/{project}/locations/{location}/jobs/{job}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     *
     * Generated from protobuf field <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->generation = $var;

        return $this;
    }

    /**
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     * <p>Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     * <p>Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     * <p>This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     * <p>Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     * <p>This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCreator()
    {
        return $this->creator;
    }

    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCreator($var)
    {
        GPBUtil::checkString($var, True);
        $this->creator = $var;

        return $this;
    }

    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastModifier()
    {
        return $this->last_modifier;
    }

    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastModifier($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_modifier = $var;

        return $this;
    }

    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 12;</code>
     * @return string
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setClient($var)
    {
        GPBUtil::checkString($var, True);
        $this->client = $var;

        return $this;
    }

    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 13;</code>
     * @return string
     */
    public function getClientVersion()
    {
        return $this->client_version;
    }

    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setClientVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_version = $var;

        return $this;
    }

    /**
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 14;</code>
     * @return int
     */
    public function getLaunchStage()
    {
        return $this->launch_stage;
    }

    /**
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 14;</code>
     * @param int $var
     * @return $this
     */
    public function setLaunchStage($var)
    {
        GPBUtil::checkEnum($var, \Google\Api\LaunchStage::class);
        $this->launch_stage = $var;

        return $this;
    }

    /**
     * Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     * @return \Google\Cloud\Run\V2\BinaryAuthorization|null
     */
    public function getBinaryAuthorization()
    {
        return $this->binary_authorization;
    }

    public function hasBinaryAuthorization()
    {
        return isset($this->binary_authorization);
    }

    public function clearBinaryAuthorization()
    {
        unset($this->binary_authorization);
    }

    /**
     * Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     * @param \Google\Cloud\Run\V2\BinaryAuthorization $var
     * @return $this
     */
    public function setBinaryAuthorization($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\BinaryAuthorization::class);
        $this->binary_authorization = $var;

        return $this;
    }

    /**
     * Required. The template used to create executions for this Job.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Run\V2\ExecutionTemplate|null
     */
    public function getTemplate()
    {
        return $this->template;
    }

    public function hasTemplate()
    {
        return isset($this->template);
    }

    public function clearTemplate()
    {
        unset($this->template);
    }

    /**
     * Required. The template used to create executions for this Job.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Run\V2\ExecutionTemplate $var
     * @return $this
     */
    public function setTemplate($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\ExecutionTemplate::class);
        $this->template = $var;

        return $this;
    }

    /**
     * Output only. The generation of this Job. See comments in `reconciling` for
     * additional information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>int64 observed_generation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getObservedGeneration()
    {
        return $this->observed_generation;
    }

    /**
     * Output only. The generation of this Job. See comments in `reconciling` for
     * additional information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>int64 observed_generation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setObservedGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->observed_generation = $var;

        return $this;
    }

    /**
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Run\V2\Condition|null
     */
    public function getTerminalCondition()
    {
        return $this->terminal_condition;
    }

    public function hasTerminalCondition()
    {
        return isset($this->terminal_condition);
    }

    public function clearTerminalCondition()
    {
        unset($this->terminal_condition);
    }

    /**
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Run\V2\Condition $var
     * @return $this
     */
    public function setTerminalCondition($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\Condition::class);
        $this->terminal_condition = $var;

        return $this;
    }

    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConditions()
    {
        return $this->conditions;
    }

    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Run\V2\Condition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConditions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Condition::class);
        $this->conditions = $arr;

        return $this;
    }

    /**
     * Output only. Number of executions created for this job.
     *
     * Generated from protobuf field <code>int32 execution_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getExecutionCount()
    {
        return $this->execution_count;
    }

    /**
     * Output only. Number of executions created for this job.
     *
     * Generated from protobuf field <code>int32 execution_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setExecutionCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->execution_count = $var;

        return $this;
    }

    /**
     * Output only. Name of the last created execution.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Run\V2\ExecutionReference|null
     */
    public function getLatestCreatedExecution()
    {
        return $this->latest_created_execution;
    }

    public function hasLatestCreatedExecution()
    {
        return isset($this->latest_created_execution);
    }

    public function clearLatestCreatedExecution()
    {
        unset($this->latest_created_execution);
    }

    /**
     * Output only. Name of the last created execution.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Run\V2\ExecutionReference $var
     * @return $this
     */
    public function setLatestCreatedExecution($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\ExecutionReference::class);
        $this->latest_created_execution = $var;

        return $this;
    }

    /**
     * Output only. Returns true if the Job is currently being acted upon by the
     * system to bring it into the desired state.
     * When a new Job is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Job to the
     * desired state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation` and
     * `latest_succeeded_execution`, will have transient values that might
     * mismatch the intended state: Once reconciliation is over (and this field is
     * false), there are two possible outcomes: reconciliation succeeded and the
     * state matches the Job, or there was an error,  and reconciliation failed.
     * This state can be found in `terminal_condition.state`.
     * If reconciliation succeeded, the following fields will match:
     * `observed_generation` and `generation`, `latest_succeeded_execution` and
     * `latest_created_execution`.
     * If reconciliation failed, `observed_generation` and
     * `latest_succeeded_execution` will have the state of the last succeeded
     * execution or empty for newly created Job. Additional information on the
     * failure can be found in `terminal_condition` and `conditions`.
     *
     * Generated from protobuf field <code>bool reconciling = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Returns true if the Job is currently being acted upon by the
     * system to bring it into the desired state.
     * When a new Job is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Job to the
     * desired state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation` and
     * `latest_succeeded_execution`, will have transient values that might
     * mismatch the intended state: Once reconciliation is over (and this field is
     * false), there are two possible outcomes: reconciliation succeeded and the
     * state matches the Job, or there was an error,  and reconciliation failed.
     * This state can be found in `terminal_condition.state`.
     * If reconciliation succeeded, the following fields will match:
     * `observed_generation` and `generation`, `latest_succeeded_execution` and
     * `latest_created_execution`.
     * If reconciliation failed, `observed_generation` and
     * `latest_succeeded_execution` will have the state of the last succeeded
     * execution or empty for newly created Job. Additional information on the
     * failure can be found in `terminal_condition` and `conditions`.
     *
     * Generated from protobuf field <code>bool reconciling = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * A unique string used as a suffix creating a new execution. The Job will
     * become ready when the execution is successfully started.
     * The sum of job name and token length must be fewer than 63 characters.
     *
     * Generated from protobuf field <code>string start_execution_token = 26;</code>
     * @return string
     */
    public function getStartExecutionToken()
    {
        return $this->readOneof(26);
    }

    public function hasStartExecutionToken()
    {
        return $this->hasOneof(26);
    }

    /**
     * A unique string used as a suffix creating a new execution. The Job will
     * become ready when the execution is successfully started.
     * The sum of job name and token length must be fewer than 63 characters.
     *
     * Generated from protobuf field <code>string start_execution_token = 26;</code>
     * @param string $var
     * @return $this
     */
    public function setStartExecutionToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(26, $var);

        return $this;
    }

    /**
     * A unique string used as a suffix for creating a new execution. The Job
     * will become ready when the execution is successfully completed.
     * The sum of job name and token length must be fewer than 63 characters.
     *
     * Generated from protobuf field <code>string run_execution_token = 27;</code>
     * @return string
     */
    public function getRunExecutionToken()
    {
        return $this->readOneof(27);
    }

    public function hasRunExecutionToken()
    {
        return $this->hasOneof(27);
    }

    /**
     * A unique string used as a suffix for creating a new execution. The Job
     * will become ready when the execution is successfully completed.
     * The sum of job name and token length must be fewer than 63 characters.
     *
     * Generated from protobuf field <code>string run_execution_token = 27;</code>
     * @param string $var
     * @return $this
     */
    public function setRunExecutionToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(27, $var);

        return $this;
    }

    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getCreateExecution()
    {
        return $this->whichOneof("create_execution");
    }

}

