<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/retail/v2/catalog_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Retail\V2\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Retail\V2\AddCatalogAttributeRequest;
use Google\Cloud\Retail\V2\AttributesConfig;
use Google\Cloud\Retail\V2\Catalog;
use Google\Cloud\Retail\V2\CompletionConfig;
use Google\Cloud\Retail\V2\GetAttributesConfigRequest;
use Google\Cloud\Retail\V2\GetCompletionConfigRequest;
use Google\Cloud\Retail\V2\GetDefaultBranchRequest;
use Google\Cloud\Retail\V2\GetDefaultBranchResponse;
use Google\Cloud\Retail\V2\ListCatalogsRequest;
use Google\Cloud\Retail\V2\RemoveCatalogAttributeRequest;
use Google\Cloud\Retail\V2\ReplaceCatalogAttributeRequest;
use Google\Cloud\Retail\V2\SetDefaultBranchRequest;
use Google\Cloud\Retail\V2\UpdateAttributesConfigRequest;
use Google\Cloud\Retail\V2\UpdateCatalogRequest;
use Google\Cloud\Retail\V2\UpdateCompletionConfigRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service for managing catalog configuration.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<AttributesConfig> addCatalogAttributeAsync(AddCatalogAttributeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AttributesConfig> getAttributesConfigAsync(GetAttributesConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CompletionConfig> getCompletionConfigAsync(GetCompletionConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<GetDefaultBranchResponse> getDefaultBranchAsync(GetDefaultBranchRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCatalogsAsync(ListCatalogsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AttributesConfig> removeCatalogAttributeAsync(RemoveCatalogAttributeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AttributesConfig> replaceCatalogAttributeAsync(ReplaceCatalogAttributeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> setDefaultBranchAsync(SetDefaultBranchRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AttributesConfig> updateAttributesConfigAsync(UpdateAttributesConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Catalog> updateCatalogAsync(UpdateCatalogRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CompletionConfig> updateCompletionConfigAsync(UpdateCompletionConfigRequest $request, array $optionalArgs = [])
 */
final class CatalogServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.retail.v2.CatalogService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'retail.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'retail.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/catalog_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/catalog_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/catalog_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/catalog_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * attributes_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     *
     * @return string The formatted attributes_config resource.
     */
    public static function attributesConfigName(string $project, string $location, string $catalog): string
    {
        return self::getPathTemplate('attributesConfig')->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a branch
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     * @param string $branch
     *
     * @return string The formatted branch resource.
     */
    public static function branchName(string $project, string $location, string $catalog, string $branch): string
    {
        return self::getPathTemplate('branch')->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
            'branch' => $branch,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a catalog
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     *
     * @return string The formatted catalog resource.
     */
    public static function catalogName(string $project, string $location, string $catalog): string
    {
        return self::getPathTemplate('catalog')->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * completion_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     *
     * @return string The formatted completion_config resource.
     */
    public static function completionConfigName(string $project, string $location, string $catalog): string
    {
        return self::getPathTemplate('completionConfig')->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - attributesConfig: projects/{project}/locations/{location}/catalogs/{catalog}/attributesConfig
     * - branch: projects/{project}/locations/{location}/catalogs/{catalog}/branches/{branch}
     * - catalog: projects/{project}/locations/{location}/catalogs/{catalog}
     * - completionConfig: projects/{project}/locations/{location}/catalogs/{catalog}/completionConfig
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'retail.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Retail\V2\CatalogServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new CatalogServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Adds the specified
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to the
     * [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
     *
     * If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to add
     * already exists, an ALREADY_EXISTS error is returned.
     *
     * The async variant is {@see CatalogServiceClient::addCatalogAttributeAsync()} .
     *
     * @example samples/V2/CatalogServiceClient/add_catalog_attribute.php
     *
     * @param AddCatalogAttributeRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AttributesConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addCatalogAttribute(AddCatalogAttributeRequest $request, array $callOptions = []): AttributesConfig
    {
        return $this->startApiCall('AddCatalogAttribute', $request, $callOptions)->wait();
    }

    /**
     * Gets an [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
     *
     * The async variant is {@see CatalogServiceClient::getAttributesConfigAsync()} .
     *
     * @example samples/V2/CatalogServiceClient/get_attributes_config.php
     *
     * @param GetAttributesConfigRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AttributesConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAttributesConfig(GetAttributesConfigRequest $request, array $callOptions = []): AttributesConfig
    {
        return $this->startApiCall('GetAttributesConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets a [CompletionConfig][google.cloud.retail.v2.CompletionConfig].
     *
     * The async variant is {@see CatalogServiceClient::getCompletionConfigAsync()} .
     *
     * @example samples/V2/CatalogServiceClient/get_completion_config.php
     *
     * @param GetCompletionConfigRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CompletionConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCompletionConfig(GetCompletionConfigRequest $request, array $callOptions = []): CompletionConfig
    {
        return $this->startApiCall('GetCompletionConfig', $request, $callOptions)->wait();
    }

    /**
     * Get which branch is currently default branch set by
     * [CatalogService.SetDefaultBranch][google.cloud.retail.v2.CatalogService.SetDefaultBranch]
     * method under a specified parent catalog.
     *
     * The async variant is {@see CatalogServiceClient::getDefaultBranchAsync()} .
     *
     * @example samples/V2/CatalogServiceClient/get_default_branch.php
     *
     * @param GetDefaultBranchRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GetDefaultBranchResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDefaultBranch(
        GetDefaultBranchRequest $request,
        array $callOptions = []
    ): GetDefaultBranchResponse {
        return $this->startApiCall('GetDefaultBranch', $request, $callOptions)->wait();
    }

    /**
     * Lists all the [Catalog][google.cloud.retail.v2.Catalog]s associated with
     * the project.
     *
     * The async variant is {@see CatalogServiceClient::listCatalogsAsync()} .
     *
     * @example samples/V2/CatalogServiceClient/list_catalogs.php
     *
     * @param ListCatalogsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCatalogs(ListCatalogsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCatalogs', $request, $callOptions);
    }

    /**
     * Removes the specified
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] from the
     * [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
     *
     * If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to
     * remove does not exist, a NOT_FOUND error is returned.
     *
     * The async variant is {@see CatalogServiceClient::removeCatalogAttributeAsync()}
     * .
     *
     * @example samples/V2/CatalogServiceClient/remove_catalog_attribute.php
     *
     * @param RemoveCatalogAttributeRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AttributesConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeCatalogAttribute(
        RemoveCatalogAttributeRequest $request,
        array $callOptions = []
    ): AttributesConfig {
        return $this->startApiCall('RemoveCatalogAttribute', $request, $callOptions)->wait();
    }

    /**
     * Replaces the specified
     * [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] in the
     * [AttributesConfig][google.cloud.retail.v2.AttributesConfig] by updating the
     * catalog attribute with the same
     * [CatalogAttribute.key][google.cloud.retail.v2.CatalogAttribute.key].
     *
     * If the [CatalogAttribute][google.cloud.retail.v2.CatalogAttribute] to
     * replace does not exist, a NOT_FOUND error is returned.
     *
     * The async variant is {@see CatalogServiceClient::replaceCatalogAttributeAsync()}
     * .
     *
     * @example samples/V2/CatalogServiceClient/replace_catalog_attribute.php
     *
     * @param ReplaceCatalogAttributeRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AttributesConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function replaceCatalogAttribute(
        ReplaceCatalogAttributeRequest $request,
        array $callOptions = []
    ): AttributesConfig {
        return $this->startApiCall('ReplaceCatalogAttribute', $request, $callOptions)->wait();
    }

    /**
     * Set a specified branch id as default branch. API methods such as
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search],
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct],
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts]
     * will treat requests using "default_branch" to the actual branch id set as
     * default.
     *
     * For example, if `projects/&#42;/locations/&#42;/catalogs/&#42;/branches/1` is set as
     * default, setting
     * [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
     * `projects/&#42;/locations/&#42;/catalogs/&#42;/branches/default_branch` is equivalent
     * to setting
     * [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
     * `projects/&#42;/locations/&#42;/catalogs/&#42;/branches/1`.
     *
     * Using multiple branches can be useful when developers would like
     * to have a staging branch to test and verify for future usage. When it
     * becomes ready, developers switch on the staging branch using this API
     * while keeping using
     * `projects/&#42;/locations/&#42;/catalogs/&#42;/branches/default_branch` as
     * [SearchRequest.branch][google.cloud.retail.v2.SearchRequest.branch] to
     * route the traffic to this staging branch.
     *
     * CAUTION: If you have live predict/search traffic, switching the default
     * branch could potentially cause outages if the ID space of the new branch
     * is very different from the old one.
     *
     * More specifically:
     *
     * * PredictionService will only return product IDs from branch {newBranch}.
     * * SearchService will only return product IDs from branch {newBranch}
     * (if branch is not explicitly set).
     * * UserEventService will only join events with products from branch
     * {newBranch}.
     *
     * The async variant is {@see CatalogServiceClient::setDefaultBranchAsync()} .
     *
     * @example samples/V2/CatalogServiceClient/set_default_branch.php
     *
     * @param SetDefaultBranchRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setDefaultBranch(SetDefaultBranchRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('SetDefaultBranch', $request, $callOptions)->wait();
    }

    /**
     * Updates the [AttributesConfig][google.cloud.retail.v2.AttributesConfig].
     *
     * The catalog attributes in the request will be updated in the catalog, or
     * inserted if they do not exist. Existing catalog attributes not included in
     * the request will remain unchanged. Attributes that are assigned to
     * products, but do not exist at the catalog level, are always included in the
     * response. The product attribute is assigned default values for missing
     * catalog attribute fields, e.g., searchable and dynamic facetable options.
     *
     * The async variant is {@see CatalogServiceClient::updateAttributesConfigAsync()}
     * .
     *
     * @example samples/V2/CatalogServiceClient/update_attributes_config.php
     *
     * @param UpdateAttributesConfigRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AttributesConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAttributesConfig(
        UpdateAttributesConfigRequest $request,
        array $callOptions = []
    ): AttributesConfig {
        return $this->startApiCall('UpdateAttributesConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the [Catalog][google.cloud.retail.v2.Catalog]s.
     *
     * The async variant is {@see CatalogServiceClient::updateCatalogAsync()} .
     *
     * @example samples/V2/CatalogServiceClient/update_catalog.php
     *
     * @param UpdateCatalogRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Catalog
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCatalog(UpdateCatalogRequest $request, array $callOptions = []): Catalog
    {
        return $this->startApiCall('UpdateCatalog', $request, $callOptions)->wait();
    }

    /**
     * Updates the [CompletionConfig][google.cloud.retail.v2.CompletionConfig]s.
     *
     * The async variant is {@see CatalogServiceClient::updateCompletionConfigAsync()}
     * .
     *
     * @example samples/V2/CatalogServiceClient/update_completion_config.php
     *
     * @param UpdateCompletionConfigRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CompletionConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCompletionConfig(
        UpdateCompletionConfigRequest $request,
        array $callOptions = []
    ): CompletionConfig {
        return $this->startApiCall('UpdateCompletionConfig', $request, $callOptions)->wait();
    }
}
