<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/oracledatabase/v1/autonomous_database.proto

namespace Google\Cloud\OracleDatabase\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The properties of an Autonomous Database.
 *
 * Generated from protobuf message <code>google.cloud.oracledatabase.v1.AutonomousDatabaseProperties</code>
 */
class AutonomousDatabaseProperties extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. OCID of the Autonomous Database.
     * https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
     *
     * Generated from protobuf field <code>string ocid = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $ocid = '';
    /**
     * Optional. The number of compute servers for the Autonomous Database.
     *
     * Generated from protobuf field <code>float compute_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $compute_count = 0.0;
    /**
     * Optional. The number of CPU cores to be made available to the database.
     *
     * Generated from protobuf field <code>int32 cpu_core_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cpu_core_count = 0;
    /**
     * Optional. The size of the data stored in the database, in terabytes.
     *
     * Generated from protobuf field <code>int32 data_storage_size_tb = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $data_storage_size_tb = 0;
    /**
     * Optional. The size of the data stored in the database, in gigabytes.
     *
     * Generated from protobuf field <code>int32 data_storage_size_gb = 63 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $data_storage_size_gb = 0;
    /**
     * Required. The workload type of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DBWorkload db_workload = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $db_workload = 0;
    /**
     * Optional. The edition of the Autonomous Databases.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseEdition db_edition = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $db_edition = 0;
    /**
     * Optional. The character set for the Autonomous Database. The default is
     * AL32UTF8.
     *
     * Generated from protobuf field <code>string character_set = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $character_set = '';
    /**
     * Optional. The national character set for the Autonomous Database. The
     * default is AL16UTF16.
     *
     * Generated from protobuf field <code>string n_character_set = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $n_character_set = '';
    /**
     * Optional. The private endpoint IP address for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint_ip = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $private_endpoint_ip = '';
    /**
     * Optional. The private endpoint label for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint_label = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $private_endpoint_label = '';
    /**
     * Optional. The Oracle Database version for the Autonomous Database.
     *
     * Generated from protobuf field <code>string db_version = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $db_version = '';
    /**
     * Optional. This field indicates if auto scaling is enabled for the
     * Autonomous Database CPU core count.
     *
     * Generated from protobuf field <code>bool is_auto_scaling_enabled = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $is_auto_scaling_enabled = false;
    /**
     * Optional. This field indicates if auto scaling is enabled for the
     * Autonomous Database storage.
     *
     * Generated from protobuf field <code>bool is_storage_auto_scaling_enabled = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $is_storage_auto_scaling_enabled = false;
    /**
     * Required. The license type used for the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LicenseType license_type = 16 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $license_type = 0;
    /**
     * Optional. The list of customer contacts.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.CustomerContact customer_contacts = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $customer_contacts;
    /**
     * Optional. The ID of the Oracle Cloud Infrastructure vault secret.
     *
     * Generated from protobuf field <code>string secret_id = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $secret_id = '';
    /**
     * Optional. The ID of the Oracle Cloud Infrastructure vault.
     *
     * Generated from protobuf field <code>string vault_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $vault_id = '';
    /**
     * Optional. The maintenance schedule of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.MaintenanceScheduleType maintenance_schedule_type = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $maintenance_schedule_type = 0;
    /**
     * Optional. This field specifies if the Autonomous Database requires mTLS
     * connections.
     *
     * Generated from protobuf field <code>bool mtls_connection_required = 34 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $mtls_connection_required = false;
    /**
     * Optional. The retention period for the Autonomous Database. This field is
     * specified in days, can range from 1 day to 60 days, and has a default value
     * of 60 days.
     *
     * Generated from protobuf field <code>int32 backup_retention_period_days = 57 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $backup_retention_period_days = 0;
    /**
     * Output only. The amount of storage currently being used for user and system
     * data, in terabytes.
     *
     * Generated from protobuf field <code>double actual_used_data_storage_size_tb = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $actual_used_data_storage_size_tb = 0.0;
    /**
     * Output only. The amount of storage currently allocated for the database
     * tables and billed for, rounded up in terabytes.
     *
     * Generated from protobuf field <code>double allocated_storage_size_tb = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $allocated_storage_size_tb = 0.0;
    /**
     * Output only. The details for the Oracle APEX Application Development.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseApex apex_details = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $apex_details = null;
    /**
     * Output only. This field indicates the status of Data Guard and Access
     * control for the Autonomous Database. The field's value is null if Data
     * Guard is disabled or Access Control is disabled. The field's value is TRUE
     * if both Data Guard and Access Control are enabled, and the Autonomous
     * Database is using primary IP access control list (ACL) for standby. The
     * field's value is FALSE if both Data Guard and Access Control are enabled,
     * and the Autonomous Database is using a different IP access control list
     * (ACL) for standby compared to primary.
     *
     * Generated from protobuf field <code>optional bool are_primary_allowlisted_ips_used = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $are_primary_allowlisted_ips_used = null;
    /**
     * Output only. The details of the current lifestyle state of the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>string lifecycle_details = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $lifecycle_details = '';
    /**
     * Output only. The current lifecycle state of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.State state = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The Autonomous Container Database OCID.
     *
     * Generated from protobuf field <code>string autonomous_container_database_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $autonomous_container_database_id = '';
    /**
     * Output only. The list of available Oracle Database upgrade versions for an
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string available_upgrade_versions = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $available_upgrade_versions;
    /**
     * Output only. The connection strings used to connect to an Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionStrings connection_strings = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $connection_strings = null;
    /**
     * Output only. The Oracle Connection URLs for an Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionUrls connection_urls = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $connection_urls = null;
    /**
     * Output only. This field indicates the number of seconds of data loss during
     * a Data Guard failover.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration failed_data_recovery_duration = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $failed_data_recovery_duration = null;
    /**
     * Output only. The memory assigned to in-memory tables in an Autonomous
     * Database.
     *
     * Generated from protobuf field <code>int32 memory_table_gbs = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $memory_table_gbs = 0;
    /**
     * Output only. This field indicates whether the Autonomous Database has local
     * (in-region) Data Guard enabled.
     *
     * Generated from protobuf field <code>bool is_local_data_guard_enabled = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $is_local_data_guard_enabled = false;
    /**
     * Output only. This field indicates the maximum data loss limit for an
     * Autonomous Database, in seconds.
     *
     * Generated from protobuf field <code>int32 local_adg_auto_failover_max_data_loss_limit = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $local_adg_auto_failover_max_data_loss_limit = 0;
    /**
     * Output only. The details of the Autonomous Data Guard standby database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary local_standby_db = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $local_standby_db = null;
    /**
     * Output only. The amount of memory enabled per ECPU, in gigabytes.
     *
     * Generated from protobuf field <code>int32 memory_per_oracle_compute_unit_gbs = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $memory_per_oracle_compute_unit_gbs = 0;
    /**
     * Output only. This field indicates the local disaster recovery (DR) type of
     * an Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LocalDisasterRecoveryType local_disaster_recovery_type = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $local_disaster_recovery_type = 0;
    /**
     * Output only. The current state of the Data Safe registration for the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DataSafeState data_safe_state = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $data_safe_state = 0;
    /**
     * Output only. The current state of database management for the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseManagementState database_management_state = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $database_management_state = 0;
    /**
     * Output only. This field indicates the current mode of the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.OpenMode open_mode = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $open_mode = 0;
    /**
     * Output only. This field indicates the state of Operations Insights for the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.OperationsInsightsState operations_insights_state = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $operations_insights_state = 0;
    /**
     * Output only. The list of OCIDs of standby databases located in Autonomous
     * Data Guard remote regions that are associated with the source database.
     *
     * Generated from protobuf field <code>repeated string peer_db_ids = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $peer_db_ids;
    /**
     * Output only. The permission level of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.PermissionLevel permission_level = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $permission_level = 0;
    /**
     * Output only. The private endpoint for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $private_endpoint = '';
    /**
     * Output only. The refresh mode of the cloned Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableMode refreshable_mode = 46 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $refreshable_mode = 0;
    /**
     * Output only. The refresh State of the clone.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableState refreshable_state = 47 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $refreshable_state = 0;
    /**
     * Output only. The Data Guard role of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.Role role = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $role = 0;
    /**
     * Output only. The list and details of the scheduled operations of the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.ScheduledOperationDetails scheduled_operation_details = 64 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $scheduled_operation_details;
    /**
     * Output only. The SQL Web Developer URL for the Autonomous Database.
     *
     * Generated from protobuf field <code>string sql_web_developer_url = 50 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $sql_web_developer_url = '';
    /**
     * Output only. The list of available regions that can be used to create a
     * clone for the Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string supported_clone_regions = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $supported_clone_regions;
    /**
     * Output only. The storage space used by Autonomous Database, in gigabytes.
     *
     * Generated from protobuf field <code>int32 used_data_storage_size_tbs = 53 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $used_data_storage_size_tbs = 0;
    /**
     * Output only. The Oracle Cloud Infrastructure link for the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>string oci_url = 54 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $oci_url = '';
    /**
     * Output only. The storage space used by automatic backups of Autonomous
     * Database, in gigabytes.
     *
     * Generated from protobuf field <code>float total_auto_backup_storage_size_gbs = 59 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $total_auto_backup_storage_size_gbs = 0.0;
    /**
     * Output only. The long term backup schedule of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_long_term_backup_time = 60 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $next_long_term_backup_time = null;
    /**
     * Output only. The date and time the Autonomous Data Guard role was changed
     * for the standby Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp data_guard_role_changed_time = 61 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $data_guard_role_changed_time = null;
    /**
     * Output only. The date and time the Disaster Recovery role was changed for
     * the standby Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp disaster_recovery_role_changed_time = 62 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $disaster_recovery_role_changed_time = null;
    /**
     * Output only. The date and time when maintenance will begin.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp maintenance_begin_time = 65 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $maintenance_begin_time = null;
    /**
     * Output only. The date and time when maintenance will end.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp maintenance_end_time = 66 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $maintenance_end_time = null;
    /**
     * Optional. The list of allowlisted IP addresses for the Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string allowlisted_ips = 67 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowlisted_ips;
    /**
     * Optional. The encryption key used to encrypt the Autonomous Database.
     * Updating this field will add a new entry in the
     * `encryption_key_history_entries` field with the former version.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.EncryptionKey encryption_key = 68 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $encryption_key = null;
    /**
     * Output only. The history of the encryption keys used to encrypt the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.EncryptionKeyHistoryEntry encryption_key_history_entries = 69 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $encryption_key_history_entries;
    /**
     * Output only. An Oracle-managed Google Cloud service account on which
     * customers can grant roles to access resources in the customer project.
     *
     * Generated from protobuf field <code>string service_agent_email = 70 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $service_agent_email = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $ocid
     *           Output only. OCID of the Autonomous Database.
     *           https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
     *     @type float $compute_count
     *           Optional. The number of compute servers for the Autonomous Database.
     *     @type int $cpu_core_count
     *           Optional. The number of CPU cores to be made available to the database.
     *     @type int $data_storage_size_tb
     *           Optional. The size of the data stored in the database, in terabytes.
     *     @type int $data_storage_size_gb
     *           Optional. The size of the data stored in the database, in gigabytes.
     *     @type int $db_workload
     *           Required. The workload type of the Autonomous Database.
     *     @type int $db_edition
     *           Optional. The edition of the Autonomous Databases.
     *     @type string $character_set
     *           Optional. The character set for the Autonomous Database. The default is
     *           AL32UTF8.
     *     @type string $n_character_set
     *           Optional. The national character set for the Autonomous Database. The
     *           default is AL16UTF16.
     *     @type string $private_endpoint_ip
     *           Optional. The private endpoint IP address for the Autonomous Database.
     *     @type string $private_endpoint_label
     *           Optional. The private endpoint label for the Autonomous Database.
     *     @type string $db_version
     *           Optional. The Oracle Database version for the Autonomous Database.
     *     @type bool $is_auto_scaling_enabled
     *           Optional. This field indicates if auto scaling is enabled for the
     *           Autonomous Database CPU core count.
     *     @type bool $is_storage_auto_scaling_enabled
     *           Optional. This field indicates if auto scaling is enabled for the
     *           Autonomous Database storage.
     *     @type int $license_type
     *           Required. The license type used for the Autonomous Database.
     *     @type array<\Google\Cloud\OracleDatabase\V1\CustomerContact>|\Google\Protobuf\Internal\RepeatedField $customer_contacts
     *           Optional. The list of customer contacts.
     *     @type string $secret_id
     *           Optional. The ID of the Oracle Cloud Infrastructure vault secret.
     *     @type string $vault_id
     *           Optional. The ID of the Oracle Cloud Infrastructure vault.
     *     @type int $maintenance_schedule_type
     *           Optional. The maintenance schedule of the Autonomous Database.
     *     @type bool $mtls_connection_required
     *           Optional. This field specifies if the Autonomous Database requires mTLS
     *           connections.
     *     @type int $backup_retention_period_days
     *           Optional. The retention period for the Autonomous Database. This field is
     *           specified in days, can range from 1 day to 60 days, and has a default value
     *           of 60 days.
     *     @type float $actual_used_data_storage_size_tb
     *           Output only. The amount of storage currently being used for user and system
     *           data, in terabytes.
     *     @type float $allocated_storage_size_tb
     *           Output only. The amount of storage currently allocated for the database
     *           tables and billed for, rounded up in terabytes.
     *     @type \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseApex $apex_details
     *           Output only. The details for the Oracle APEX Application Development.
     *     @type bool $are_primary_allowlisted_ips_used
     *           Output only. This field indicates the status of Data Guard and Access
     *           control for the Autonomous Database. The field's value is null if Data
     *           Guard is disabled or Access Control is disabled. The field's value is TRUE
     *           if both Data Guard and Access Control are enabled, and the Autonomous
     *           Database is using primary IP access control list (ACL) for standby. The
     *           field's value is FALSE if both Data Guard and Access Control are enabled,
     *           and the Autonomous Database is using a different IP access control list
     *           (ACL) for standby compared to primary.
     *     @type string $lifecycle_details
     *           Output only. The details of the current lifestyle state of the Autonomous
     *           Database.
     *     @type int $state
     *           Output only. The current lifecycle state of the Autonomous Database.
     *     @type string $autonomous_container_database_id
     *           Output only. The Autonomous Container Database OCID.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $available_upgrade_versions
     *           Output only. The list of available Oracle Database upgrade versions for an
     *           Autonomous Database.
     *     @type \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseConnectionStrings $connection_strings
     *           Output only. The connection strings used to connect to an Autonomous
     *           Database.
     *     @type \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseConnectionUrls $connection_urls
     *           Output only. The Oracle Connection URLs for an Autonomous Database.
     *     @type \Google\Protobuf\Duration $failed_data_recovery_duration
     *           Output only. This field indicates the number of seconds of data loss during
     *           a Data Guard failover.
     *     @type int $memory_table_gbs
     *           Output only. The memory assigned to in-memory tables in an Autonomous
     *           Database.
     *     @type bool $is_local_data_guard_enabled
     *           Output only. This field indicates whether the Autonomous Database has local
     *           (in-region) Data Guard enabled.
     *     @type int $local_adg_auto_failover_max_data_loss_limit
     *           Output only. This field indicates the maximum data loss limit for an
     *           Autonomous Database, in seconds.
     *     @type \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseStandbySummary $local_standby_db
     *           Output only. The details of the Autonomous Data Guard standby database.
     *     @type int $memory_per_oracle_compute_unit_gbs
     *           Output only. The amount of memory enabled per ECPU, in gigabytes.
     *     @type int $local_disaster_recovery_type
     *           Output only. This field indicates the local disaster recovery (DR) type of
     *           an Autonomous Database.
     *     @type int $data_safe_state
     *           Output only. The current state of the Data Safe registration for the
     *           Autonomous Database.
     *     @type int $database_management_state
     *           Output only. The current state of database management for the Autonomous
     *           Database.
     *     @type int $open_mode
     *           Output only. This field indicates the current mode of the Autonomous
     *           Database.
     *     @type int $operations_insights_state
     *           Output only. This field indicates the state of Operations Insights for the
     *           Autonomous Database.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $peer_db_ids
     *           Output only. The list of OCIDs of standby databases located in Autonomous
     *           Data Guard remote regions that are associated with the source database.
     *     @type int $permission_level
     *           Output only. The permission level of the Autonomous Database.
     *     @type string $private_endpoint
     *           Output only. The private endpoint for the Autonomous Database.
     *     @type int $refreshable_mode
     *           Output only. The refresh mode of the cloned Autonomous Database.
     *     @type int $refreshable_state
     *           Output only. The refresh State of the clone.
     *     @type int $role
     *           Output only. The Data Guard role of the Autonomous Database.
     *     @type array<\Google\Cloud\OracleDatabase\V1\ScheduledOperationDetails>|\Google\Protobuf\Internal\RepeatedField $scheduled_operation_details
     *           Output only. The list and details of the scheduled operations of the
     *           Autonomous Database.
     *     @type string $sql_web_developer_url
     *           Output only. The SQL Web Developer URL for the Autonomous Database.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $supported_clone_regions
     *           Output only. The list of available regions that can be used to create a
     *           clone for the Autonomous Database.
     *     @type int $used_data_storage_size_tbs
     *           Output only. The storage space used by Autonomous Database, in gigabytes.
     *     @type string $oci_url
     *           Output only. The Oracle Cloud Infrastructure link for the Autonomous
     *           Database.
     *     @type float $total_auto_backup_storage_size_gbs
     *           Output only. The storage space used by automatic backups of Autonomous
     *           Database, in gigabytes.
     *     @type \Google\Protobuf\Timestamp $next_long_term_backup_time
     *           Output only. The long term backup schedule of the Autonomous Database.
     *     @type \Google\Protobuf\Timestamp $data_guard_role_changed_time
     *           Output only. The date and time the Autonomous Data Guard role was changed
     *           for the standby Autonomous Database.
     *     @type \Google\Protobuf\Timestamp $disaster_recovery_role_changed_time
     *           Output only. The date and time the Disaster Recovery role was changed for
     *           the standby Autonomous Database.
     *     @type \Google\Protobuf\Timestamp $maintenance_begin_time
     *           Output only. The date and time when maintenance will begin.
     *     @type \Google\Protobuf\Timestamp $maintenance_end_time
     *           Output only. The date and time when maintenance will end.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowlisted_ips
     *           Optional. The list of allowlisted IP addresses for the Autonomous Database.
     *     @type \Google\Cloud\OracleDatabase\V1\EncryptionKey $encryption_key
     *           Optional. The encryption key used to encrypt the Autonomous Database.
     *           Updating this field will add a new entry in the
     *           `encryption_key_history_entries` field with the former version.
     *     @type array<\Google\Cloud\OracleDatabase\V1\EncryptionKeyHistoryEntry>|\Google\Protobuf\Internal\RepeatedField $encryption_key_history_entries
     *           Output only. The history of the encryption keys used to encrypt the
     *           Autonomous Database.
     *     @type string $service_agent_email
     *           Output only. An Oracle-managed Google Cloud service account on which
     *           customers can grant roles to access resources in the customer project.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Oracledatabase\V1\AutonomousDatabase::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. OCID of the Autonomous Database.
     * https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
     *
     * Generated from protobuf field <code>string ocid = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOcid()
    {
        return $this->ocid;
    }

    /**
     * Output only. OCID of the Autonomous Database.
     * https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
     *
     * Generated from protobuf field <code>string ocid = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOcid($var)
    {
        GPBUtil::checkString($var, True);
        $this->ocid = $var;

        return $this;
    }

    /**
     * Optional. The number of compute servers for the Autonomous Database.
     *
     * Generated from protobuf field <code>float compute_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getComputeCount()
    {
        return $this->compute_count;
    }

    /**
     * Optional. The number of compute servers for the Autonomous Database.
     *
     * Generated from protobuf field <code>float compute_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setComputeCount($var)
    {
        GPBUtil::checkFloat($var);
        $this->compute_count = $var;

        return $this;
    }

    /**
     * Optional. The number of CPU cores to be made available to the database.
     *
     * Generated from protobuf field <code>int32 cpu_core_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getCpuCoreCount()
    {
        return $this->cpu_core_count;
    }

    /**
     * Optional. The number of CPU cores to be made available to the database.
     *
     * Generated from protobuf field <code>int32 cpu_core_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setCpuCoreCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->cpu_core_count = $var;

        return $this;
    }

    /**
     * Optional. The size of the data stored in the database, in terabytes.
     *
     * Generated from protobuf field <code>int32 data_storage_size_tb = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDataStorageSizeTb()
    {
        return $this->data_storage_size_tb;
    }

    /**
     * Optional. The size of the data stored in the database, in terabytes.
     *
     * Generated from protobuf field <code>int32 data_storage_size_tb = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDataStorageSizeTb($var)
    {
        GPBUtil::checkInt32($var);
        $this->data_storage_size_tb = $var;

        return $this;
    }

    /**
     * Optional. The size of the data stored in the database, in gigabytes.
     *
     * Generated from protobuf field <code>int32 data_storage_size_gb = 63 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDataStorageSizeGb()
    {
        return $this->data_storage_size_gb;
    }

    /**
     * Optional. The size of the data stored in the database, in gigabytes.
     *
     * Generated from protobuf field <code>int32 data_storage_size_gb = 63 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDataStorageSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->data_storage_size_gb = $var;

        return $this;
    }

    /**
     * Required. The workload type of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DBWorkload db_workload = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getDbWorkload()
    {
        return $this->db_workload;
    }

    /**
     * Required. The workload type of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.DBWorkload db_workload = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setDbWorkload($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\DBWorkload::class);
        $this->db_workload = $var;

        return $this;
    }

    /**
     * Optional. The edition of the Autonomous Databases.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseEdition db_edition = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getDbEdition()
    {
        return $this->db_edition;
    }

    /**
     * Optional. The edition of the Autonomous Databases.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseEdition db_edition = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setDbEdition($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\DatabaseEdition::class);
        $this->db_edition = $var;

        return $this;
    }

    /**
     * Optional. The character set for the Autonomous Database. The default is
     * AL32UTF8.
     *
     * Generated from protobuf field <code>string character_set = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getCharacterSet()
    {
        return $this->character_set;
    }

    /**
     * Optional. The character set for the Autonomous Database. The default is
     * AL32UTF8.
     *
     * Generated from protobuf field <code>string character_set = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setCharacterSet($var)
    {
        GPBUtil::checkString($var, True);
        $this->character_set = $var;

        return $this;
    }

    /**
     * Optional. The national character set for the Autonomous Database. The
     * default is AL16UTF16.
     *
     * Generated from protobuf field <code>string n_character_set = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getNCharacterSet()
    {
        return $this->n_character_set;
    }

    /**
     * Optional. The national character set for the Autonomous Database. The
     * default is AL16UTF16.
     *
     * Generated from protobuf field <code>string n_character_set = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setNCharacterSet($var)
    {
        GPBUtil::checkString($var, True);
        $this->n_character_set = $var;

        return $this;
    }

    /**
     * Optional. The private endpoint IP address for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint_ip = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPrivateEndpointIp()
    {
        return $this->private_endpoint_ip;
    }

    /**
     * Optional. The private endpoint IP address for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint_ip = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateEndpointIp($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_endpoint_ip = $var;

        return $this;
    }

    /**
     * Optional. The private endpoint label for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint_label = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPrivateEndpointLabel()
    {
        return $this->private_endpoint_label;
    }

    /**
     * Optional. The private endpoint label for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint_label = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateEndpointLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_endpoint_label = $var;

        return $this;
    }

    /**
     * Optional. The Oracle Database version for the Autonomous Database.
     *
     * Generated from protobuf field <code>string db_version = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDbVersion()
    {
        return $this->db_version;
    }

    /**
     * Optional. The Oracle Database version for the Autonomous Database.
     *
     * Generated from protobuf field <code>string db_version = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDbVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->db_version = $var;

        return $this;
    }

    /**
     * Optional. This field indicates if auto scaling is enabled for the
     * Autonomous Database CPU core count.
     *
     * Generated from protobuf field <code>bool is_auto_scaling_enabled = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIsAutoScalingEnabled()
    {
        return $this->is_auto_scaling_enabled;
    }

    /**
     * Optional. This field indicates if auto scaling is enabled for the
     * Autonomous Database CPU core count.
     *
     * Generated from protobuf field <code>bool is_auto_scaling_enabled = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsAutoScalingEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->is_auto_scaling_enabled = $var;

        return $this;
    }

    /**
     * Optional. This field indicates if auto scaling is enabled for the
     * Autonomous Database storage.
     *
     * Generated from protobuf field <code>bool is_storage_auto_scaling_enabled = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIsStorageAutoScalingEnabled()
    {
        return $this->is_storage_auto_scaling_enabled;
    }

    /**
     * Optional. This field indicates if auto scaling is enabled for the
     * Autonomous Database storage.
     *
     * Generated from protobuf field <code>bool is_storage_auto_scaling_enabled = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsStorageAutoScalingEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->is_storage_auto_scaling_enabled = $var;

        return $this;
    }

    /**
     * Required. The license type used for the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LicenseType license_type = 16 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getLicenseType()
    {
        return $this->license_type;
    }

    /**
     * Required. The license type used for the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LicenseType license_type = 16 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setLicenseType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\LicenseType::class);
        $this->license_type = $var;

        return $this;
    }

    /**
     * Optional. The list of customer contacts.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.CustomerContact customer_contacts = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomerContacts()
    {
        return $this->customer_contacts;
    }

    /**
     * Optional. The list of customer contacts.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.CustomerContact customer_contacts = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\OracleDatabase\V1\CustomerContact>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomerContacts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OracleDatabase\V1\CustomerContact::class);
        $this->customer_contacts = $arr;

        return $this;
    }

    /**
     * Optional. The ID of the Oracle Cloud Infrastructure vault secret.
     *
     * Generated from protobuf field <code>string secret_id = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSecretId()
    {
        return $this->secret_id;
    }

    /**
     * Optional. The ID of the Oracle Cloud Infrastructure vault secret.
     *
     * Generated from protobuf field <code>string secret_id = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSecretId($var)
    {
        GPBUtil::checkString($var, True);
        $this->secret_id = $var;

        return $this;
    }

    /**
     * Optional. The ID of the Oracle Cloud Infrastructure vault.
     *
     * Generated from protobuf field <code>string vault_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getVaultId()
    {
        return $this->vault_id;
    }

    /**
     * Optional. The ID of the Oracle Cloud Infrastructure vault.
     *
     * Generated from protobuf field <code>string vault_id = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setVaultId($var)
    {
        GPBUtil::checkString($var, True);
        $this->vault_id = $var;

        return $this;
    }

    /**
     * Optional. The maintenance schedule of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.MaintenanceScheduleType maintenance_schedule_type = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMaintenanceScheduleType()
    {
        return $this->maintenance_schedule_type;
    }

    /**
     * Optional. The maintenance schedule of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.MaintenanceScheduleType maintenance_schedule_type = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMaintenanceScheduleType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\MaintenanceScheduleType::class);
        $this->maintenance_schedule_type = $var;

        return $this;
    }

    /**
     * Optional. This field specifies if the Autonomous Database requires mTLS
     * connections.
     *
     * Generated from protobuf field <code>bool mtls_connection_required = 34 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getMtlsConnectionRequired()
    {
        return $this->mtls_connection_required;
    }

    /**
     * Optional. This field specifies if the Autonomous Database requires mTLS
     * connections.
     *
     * Generated from protobuf field <code>bool mtls_connection_required = 34 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setMtlsConnectionRequired($var)
    {
        GPBUtil::checkBool($var);
        $this->mtls_connection_required = $var;

        return $this;
    }

    /**
     * Optional. The retention period for the Autonomous Database. This field is
     * specified in days, can range from 1 day to 60 days, and has a default value
     * of 60 days.
     *
     * Generated from protobuf field <code>int32 backup_retention_period_days = 57 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getBackupRetentionPeriodDays()
    {
        return $this->backup_retention_period_days;
    }

    /**
     * Optional. The retention period for the Autonomous Database. This field is
     * specified in days, can range from 1 day to 60 days, and has a default value
     * of 60 days.
     *
     * Generated from protobuf field <code>int32 backup_retention_period_days = 57 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setBackupRetentionPeriodDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->backup_retention_period_days = $var;

        return $this;
    }

    /**
     * Output only. The amount of storage currently being used for user and system
     * data, in terabytes.
     *
     * Generated from protobuf field <code>double actual_used_data_storage_size_tb = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getActualUsedDataStorageSizeTb()
    {
        return $this->actual_used_data_storage_size_tb;
    }

    /**
     * Output only. The amount of storage currently being used for user and system
     * data, in terabytes.
     *
     * Generated from protobuf field <code>double actual_used_data_storage_size_tb = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setActualUsedDataStorageSizeTb($var)
    {
        GPBUtil::checkDouble($var);
        $this->actual_used_data_storage_size_tb = $var;

        return $this;
    }

    /**
     * Output only. The amount of storage currently allocated for the database
     * tables and billed for, rounded up in terabytes.
     *
     * Generated from protobuf field <code>double allocated_storage_size_tb = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getAllocatedStorageSizeTb()
    {
        return $this->allocated_storage_size_tb;
    }

    /**
     * Output only. The amount of storage currently allocated for the database
     * tables and billed for, rounded up in terabytes.
     *
     * Generated from protobuf field <code>double allocated_storage_size_tb = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setAllocatedStorageSizeTb($var)
    {
        GPBUtil::checkDouble($var);
        $this->allocated_storage_size_tb = $var;

        return $this;
    }

    /**
     * Output only. The details for the Oracle APEX Application Development.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseApex apex_details = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseApex|null
     */
    public function getApexDetails()
    {
        return $this->apex_details;
    }

    public function hasApexDetails()
    {
        return isset($this->apex_details);
    }

    public function clearApexDetails()
    {
        unset($this->apex_details);
    }

    /**
     * Output only. The details for the Oracle APEX Application Development.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseApex apex_details = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseApex $var
     * @return $this
     */
    public function setApexDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseApex::class);
        $this->apex_details = $var;

        return $this;
    }

    /**
     * Output only. This field indicates the status of Data Guard and Access
     * control for the Autonomous Database. The field's value is null if Data
     * Guard is disabled or Access Control is disabled. The field's value is TRUE
     * if both Data Guard and Access Control are enabled, and the Autonomous
     * Database is using primary IP access control list (ACL) for standby. The
     * field's value is FALSE if both Data Guard and Access Control are enabled,
     * and the Autonomous Database is using a different IP access control list
     * (ACL) for standby compared to primary.
     *
     * Generated from protobuf field <code>optional bool are_primary_allowlisted_ips_used = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getArePrimaryAllowlistedIpsUsed()
    {
        return isset($this->are_primary_allowlisted_ips_used) ? $this->are_primary_allowlisted_ips_used : false;
    }

    public function hasArePrimaryAllowlistedIpsUsed()
    {
        return isset($this->are_primary_allowlisted_ips_used);
    }

    public function clearArePrimaryAllowlistedIpsUsed()
    {
        unset($this->are_primary_allowlisted_ips_used);
    }

    /**
     * Output only. This field indicates the status of Data Guard and Access
     * control for the Autonomous Database. The field's value is null if Data
     * Guard is disabled or Access Control is disabled. The field's value is TRUE
     * if both Data Guard and Access Control are enabled, and the Autonomous
     * Database is using primary IP access control list (ACL) for standby. The
     * field's value is FALSE if both Data Guard and Access Control are enabled,
     * and the Autonomous Database is using a different IP access control list
     * (ACL) for standby compared to primary.
     *
     * Generated from protobuf field <code>optional bool are_primary_allowlisted_ips_used = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setArePrimaryAllowlistedIpsUsed($var)
    {
        GPBUtil::checkBool($var);
        $this->are_primary_allowlisted_ips_used = $var;

        return $this;
    }

    /**
     * Output only. The details of the current lifestyle state of the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>string lifecycle_details = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLifecycleDetails()
    {
        return $this->lifecycle_details;
    }

    /**
     * Output only. The details of the current lifestyle state of the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>string lifecycle_details = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLifecycleDetails($var)
    {
        GPBUtil::checkString($var, True);
        $this->lifecycle_details = $var;

        return $this;
    }

    /**
     * Output only. The current lifecycle state of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.State state = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The current lifecycle state of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.State state = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The Autonomous Container Database OCID.
     *
     * Generated from protobuf field <code>string autonomous_container_database_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getAutonomousContainerDatabaseId()
    {
        return $this->autonomous_container_database_id;
    }

    /**
     * Output only. The Autonomous Container Database OCID.
     *
     * Generated from protobuf field <code>string autonomous_container_database_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setAutonomousContainerDatabaseId($var)
    {
        GPBUtil::checkString($var, True);
        $this->autonomous_container_database_id = $var;

        return $this;
    }

    /**
     * Output only. The list of available Oracle Database upgrade versions for an
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string available_upgrade_versions = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAvailableUpgradeVersions()
    {
        return $this->available_upgrade_versions;
    }

    /**
     * Output only. The list of available Oracle Database upgrade versions for an
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string available_upgrade_versions = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAvailableUpgradeVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->available_upgrade_versions = $arr;

        return $this;
    }

    /**
     * Output only. The connection strings used to connect to an Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionStrings connection_strings = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseConnectionStrings|null
     */
    public function getConnectionStrings()
    {
        return $this->connection_strings;
    }

    public function hasConnectionStrings()
    {
        return isset($this->connection_strings);
    }

    public function clearConnectionStrings()
    {
        unset($this->connection_strings);
    }

    /**
     * Output only. The connection strings used to connect to an Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionStrings connection_strings = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseConnectionStrings $var
     * @return $this
     */
    public function setConnectionStrings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseConnectionStrings::class);
        $this->connection_strings = $var;

        return $this;
    }

    /**
     * Output only. The Oracle Connection URLs for an Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionUrls connection_urls = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseConnectionUrls|null
     */
    public function getConnectionUrls()
    {
        return $this->connection_urls;
    }

    public function hasConnectionUrls()
    {
        return isset($this->connection_urls);
    }

    public function clearConnectionUrls()
    {
        unset($this->connection_urls);
    }

    /**
     * Output only. The Oracle Connection URLs for an Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionUrls connection_urls = 30 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseConnectionUrls $var
     * @return $this
     */
    public function setConnectionUrls($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseConnectionUrls::class);
        $this->connection_urls = $var;

        return $this;
    }

    /**
     * Output only. This field indicates the number of seconds of data loss during
     * a Data Guard failover.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration failed_data_recovery_duration = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getFailedDataRecoveryDuration()
    {
        return $this->failed_data_recovery_duration;
    }

    public function hasFailedDataRecoveryDuration()
    {
        return isset($this->failed_data_recovery_duration);
    }

    public function clearFailedDataRecoveryDuration()
    {
        unset($this->failed_data_recovery_duration);
    }

    /**
     * Output only. This field indicates the number of seconds of data loss during
     * a Data Guard failover.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration failed_data_recovery_duration = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setFailedDataRecoveryDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->failed_data_recovery_duration = $var;

        return $this;
    }

    /**
     * Output only. The memory assigned to in-memory tables in an Autonomous
     * Database.
     *
     * Generated from protobuf field <code>int32 memory_table_gbs = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getMemoryTableGbs()
    {
        return $this->memory_table_gbs;
    }

    /**
     * Output only. The memory assigned to in-memory tables in an Autonomous
     * Database.
     *
     * Generated from protobuf field <code>int32 memory_table_gbs = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setMemoryTableGbs($var)
    {
        GPBUtil::checkInt32($var);
        $this->memory_table_gbs = $var;

        return $this;
    }

    /**
     * Output only. This field indicates whether the Autonomous Database has local
     * (in-region) Data Guard enabled.
     *
     * Generated from protobuf field <code>bool is_local_data_guard_enabled = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getIsLocalDataGuardEnabled()
    {
        return $this->is_local_data_guard_enabled;
    }

    /**
     * Output only. This field indicates whether the Autonomous Database has local
     * (in-region) Data Guard enabled.
     *
     * Generated from protobuf field <code>bool is_local_data_guard_enabled = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsLocalDataGuardEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->is_local_data_guard_enabled = $var;

        return $this;
    }

    /**
     * Output only. This field indicates the maximum data loss limit for an
     * Autonomous Database, in seconds.
     *
     * Generated from protobuf field <code>int32 local_adg_auto_failover_max_data_loss_limit = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getLocalAdgAutoFailoverMaxDataLossLimit()
    {
        return $this->local_adg_auto_failover_max_data_loss_limit;
    }

    /**
     * Output only. This field indicates the maximum data loss limit for an
     * Autonomous Database, in seconds.
     *
     * Generated from protobuf field <code>int32 local_adg_auto_failover_max_data_loss_limit = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setLocalAdgAutoFailoverMaxDataLossLimit($var)
    {
        GPBUtil::checkInt32($var);
        $this->local_adg_auto_failover_max_data_loss_limit = $var;

        return $this;
    }

    /**
     * Output only. The details of the Autonomous Data Guard standby database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary local_standby_db = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseStandbySummary|null
     */
    public function getLocalStandbyDb()
    {
        return $this->local_standby_db;
    }

    public function hasLocalStandbyDb()
    {
        return isset($this->local_standby_db);
    }

    public function clearLocalStandbyDb()
    {
        unset($this->local_standby_db);
    }

    /**
     * Output only. The details of the Autonomous Data Guard standby database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary local_standby_db = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseStandbySummary $var
     * @return $this
     */
    public function setLocalStandbyDb($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseStandbySummary::class);
        $this->local_standby_db = $var;

        return $this;
    }

    /**
     * Output only. The amount of memory enabled per ECPU, in gigabytes.
     *
     * Generated from protobuf field <code>int32 memory_per_oracle_compute_unit_gbs = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getMemoryPerOracleComputeUnitGbs()
    {
        return $this->memory_per_oracle_compute_unit_gbs;
    }

    /**
     * Output only. The amount of memory enabled per ECPU, in gigabytes.
     *
     * Generated from protobuf field <code>int32 memory_per_oracle_compute_unit_gbs = 37 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setMemoryPerOracleComputeUnitGbs($var)
    {
        GPBUtil::checkInt32($var);
        $this->memory_per_oracle_compute_unit_gbs = $var;

        return $this;
    }

    /**
     * Output only. This field indicates the local disaster recovery (DR) type of
     * an Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LocalDisasterRecoveryType local_disaster_recovery_type = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getLocalDisasterRecoveryType()
    {
        return $this->local_disaster_recovery_type;
    }

    /**
     * Output only. This field indicates the local disaster recovery (DR) type of
     * an Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LocalDisasterRecoveryType local_disaster_recovery_type = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setLocalDisasterRecoveryType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\LocalDisasterRecoveryType::class);
        $this->local_disaster_recovery_type = $var;

        return $this;
    }

    /**
     * Output only. The current state of the Data Safe registration for the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DataSafeState data_safe_state = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getDataSafeState()
    {
        return $this->data_safe_state;
    }

    /**
     * Output only. The current state of the Data Safe registration for the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DataSafeState data_safe_state = 39 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDataSafeState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\DataSafeState::class);
        $this->data_safe_state = $var;

        return $this;
    }

    /**
     * Output only. The current state of database management for the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseManagementState database_management_state = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getDatabaseManagementState()
    {
        return $this->database_management_state;
    }

    /**
     * Output only. The current state of database management for the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseManagementState database_management_state = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setDatabaseManagementState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\DatabaseManagementState::class);
        $this->database_management_state = $var;

        return $this;
    }

    /**
     * Output only. This field indicates the current mode of the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.OpenMode open_mode = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getOpenMode()
    {
        return $this->open_mode;
    }

    /**
     * Output only. This field indicates the current mode of the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.OpenMode open_mode = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setOpenMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\OpenMode::class);
        $this->open_mode = $var;

        return $this;
    }

    /**
     * Output only. This field indicates the state of Operations Insights for the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.OperationsInsightsState operations_insights_state = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getOperationsInsightsState()
    {
        return $this->operations_insights_state;
    }

    /**
     * Output only. This field indicates the state of Operations Insights for the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.OperationsInsightsState operations_insights_state = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setOperationsInsightsState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\OperationsInsightsState::class);
        $this->operations_insights_state = $var;

        return $this;
    }

    /**
     * Output only. The list of OCIDs of standby databases located in Autonomous
     * Data Guard remote regions that are associated with the source database.
     *
     * Generated from protobuf field <code>repeated string peer_db_ids = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPeerDbIds()
    {
        return $this->peer_db_ids;
    }

    /**
     * Output only. The list of OCIDs of standby databases located in Autonomous
     * Data Guard remote regions that are associated with the source database.
     *
     * Generated from protobuf field <code>repeated string peer_db_ids = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPeerDbIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->peer_db_ids = $arr;

        return $this;
    }

    /**
     * Output only. The permission level of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.PermissionLevel permission_level = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getPermissionLevel()
    {
        return $this->permission_level;
    }

    /**
     * Output only. The permission level of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.PermissionLevel permission_level = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setPermissionLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\PermissionLevel::class);
        $this->permission_level = $var;

        return $this;
    }

    /**
     * Output only. The private endpoint for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPrivateEndpoint()
    {
        return $this->private_endpoint;
    }

    /**
     * Output only. The private endpoint for the Autonomous Database.
     *
     * Generated from protobuf field <code>string private_endpoint = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_endpoint = $var;

        return $this;
    }

    /**
     * Output only. The refresh mode of the cloned Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableMode refreshable_mode = 46 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRefreshableMode()
    {
        return $this->refreshable_mode;
    }

    /**
     * Output only. The refresh mode of the cloned Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableMode refreshable_mode = 46 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRefreshableMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\RefreshableMode::class);
        $this->refreshable_mode = $var;

        return $this;
    }

    /**
     * Output only. The refresh State of the clone.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableState refreshable_state = 47 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRefreshableState()
    {
        return $this->refreshable_state;
    }

    /**
     * Output only. The refresh State of the clone.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableState refreshable_state = 47 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRefreshableState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\RefreshableState::class);
        $this->refreshable_state = $var;

        return $this;
    }

    /**
     * Output only. The Data Guard role of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.Role role = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getRole()
    {
        return $this->role;
    }

    /**
     * Output only. The Data Guard role of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.Role role = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setRole($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\OracleDatabase\V1\AutonomousDatabaseProperties\Role::class);
        $this->role = $var;

        return $this;
    }

    /**
     * Output only. The list and details of the scheduled operations of the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.ScheduledOperationDetails scheduled_operation_details = 64 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getScheduledOperationDetails()
    {
        return $this->scheduled_operation_details;
    }

    /**
     * Output only. The list and details of the scheduled operations of the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.ScheduledOperationDetails scheduled_operation_details = 64 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\OracleDatabase\V1\ScheduledOperationDetails>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setScheduledOperationDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OracleDatabase\V1\ScheduledOperationDetails::class);
        $this->scheduled_operation_details = $arr;

        return $this;
    }

    /**
     * Output only. The SQL Web Developer URL for the Autonomous Database.
     *
     * Generated from protobuf field <code>string sql_web_developer_url = 50 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSqlWebDeveloperUrl()
    {
        return $this->sql_web_developer_url;
    }

    /**
     * Output only. The SQL Web Developer URL for the Autonomous Database.
     *
     * Generated from protobuf field <code>string sql_web_developer_url = 50 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSqlWebDeveloperUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->sql_web_developer_url = $var;

        return $this;
    }

    /**
     * Output only. The list of available regions that can be used to create a
     * clone for the Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string supported_clone_regions = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSupportedCloneRegions()
    {
        return $this->supported_clone_regions;
    }

    /**
     * Output only. The list of available regions that can be used to create a
     * clone for the Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string supported_clone_regions = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSupportedCloneRegions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->supported_clone_regions = $arr;

        return $this;
    }

    /**
     * Output only. The storage space used by Autonomous Database, in gigabytes.
     *
     * Generated from protobuf field <code>int32 used_data_storage_size_tbs = 53 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getUsedDataStorageSizeTbs()
    {
        return $this->used_data_storage_size_tbs;
    }

    /**
     * Output only. The storage space used by Autonomous Database, in gigabytes.
     *
     * Generated from protobuf field <code>int32 used_data_storage_size_tbs = 53 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setUsedDataStorageSizeTbs($var)
    {
        GPBUtil::checkInt32($var);
        $this->used_data_storage_size_tbs = $var;

        return $this;
    }

    /**
     * Output only. The Oracle Cloud Infrastructure link for the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>string oci_url = 54 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOciUrl()
    {
        return $this->oci_url;
    }

    /**
     * Output only. The Oracle Cloud Infrastructure link for the Autonomous
     * Database.
     *
     * Generated from protobuf field <code>string oci_url = 54 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOciUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->oci_url = $var;

        return $this;
    }

    /**
     * Output only. The storage space used by automatic backups of Autonomous
     * Database, in gigabytes.
     *
     * Generated from protobuf field <code>float total_auto_backup_storage_size_gbs = 59 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return float
     */
    public function getTotalAutoBackupStorageSizeGbs()
    {
        return $this->total_auto_backup_storage_size_gbs;
    }

    /**
     * Output only. The storage space used by automatic backups of Autonomous
     * Database, in gigabytes.
     *
     * Generated from protobuf field <code>float total_auto_backup_storage_size_gbs = 59 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param float $var
     * @return $this
     */
    public function setTotalAutoBackupStorageSizeGbs($var)
    {
        GPBUtil::checkFloat($var);
        $this->total_auto_backup_storage_size_gbs = $var;

        return $this;
    }

    /**
     * Output only. The long term backup schedule of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_long_term_backup_time = 60 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getNextLongTermBackupTime()
    {
        return $this->next_long_term_backup_time;
    }

    public function hasNextLongTermBackupTime()
    {
        return isset($this->next_long_term_backup_time);
    }

    public function clearNextLongTermBackupTime()
    {
        unset($this->next_long_term_backup_time);
    }

    /**
     * Output only. The long term backup schedule of the Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_long_term_backup_time = 60 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setNextLongTermBackupTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->next_long_term_backup_time = $var;

        return $this;
    }

    /**
     * Output only. The date and time the Autonomous Data Guard role was changed
     * for the standby Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp data_guard_role_changed_time = 61 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDataGuardRoleChangedTime()
    {
        return $this->data_guard_role_changed_time;
    }

    public function hasDataGuardRoleChangedTime()
    {
        return isset($this->data_guard_role_changed_time);
    }

    public function clearDataGuardRoleChangedTime()
    {
        unset($this->data_guard_role_changed_time);
    }

    /**
     * Output only. The date and time the Autonomous Data Guard role was changed
     * for the standby Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp data_guard_role_changed_time = 61 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDataGuardRoleChangedTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->data_guard_role_changed_time = $var;

        return $this;
    }

    /**
     * Output only. The date and time the Disaster Recovery role was changed for
     * the standby Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp disaster_recovery_role_changed_time = 62 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDisasterRecoveryRoleChangedTime()
    {
        return $this->disaster_recovery_role_changed_time;
    }

    public function hasDisasterRecoveryRoleChangedTime()
    {
        return isset($this->disaster_recovery_role_changed_time);
    }

    public function clearDisasterRecoveryRoleChangedTime()
    {
        unset($this->disaster_recovery_role_changed_time);
    }

    /**
     * Output only. The date and time the Disaster Recovery role was changed for
     * the standby Autonomous Database.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp disaster_recovery_role_changed_time = 62 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDisasterRecoveryRoleChangedTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->disaster_recovery_role_changed_time = $var;

        return $this;
    }

    /**
     * Output only. The date and time when maintenance will begin.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp maintenance_begin_time = 65 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getMaintenanceBeginTime()
    {
        return $this->maintenance_begin_time;
    }

    public function hasMaintenanceBeginTime()
    {
        return isset($this->maintenance_begin_time);
    }

    public function clearMaintenanceBeginTime()
    {
        unset($this->maintenance_begin_time);
    }

    /**
     * Output only. The date and time when maintenance will begin.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp maintenance_begin_time = 65 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setMaintenanceBeginTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->maintenance_begin_time = $var;

        return $this;
    }

    /**
     * Output only. The date and time when maintenance will end.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp maintenance_end_time = 66 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getMaintenanceEndTime()
    {
        return $this->maintenance_end_time;
    }

    public function hasMaintenanceEndTime()
    {
        return isset($this->maintenance_end_time);
    }

    public function clearMaintenanceEndTime()
    {
        unset($this->maintenance_end_time);
    }

    /**
     * Output only. The date and time when maintenance will end.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp maintenance_end_time = 66 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setMaintenanceEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->maintenance_end_time = $var;

        return $this;
    }

    /**
     * Optional. The list of allowlisted IP addresses for the Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string allowlisted_ips = 67 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowlistedIps()
    {
        return $this->allowlisted_ips;
    }

    /**
     * Optional. The list of allowlisted IP addresses for the Autonomous Database.
     *
     * Generated from protobuf field <code>repeated string allowlisted_ips = 67 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowlistedIps($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowlisted_ips = $arr;

        return $this;
    }

    /**
     * Optional. The encryption key used to encrypt the Autonomous Database.
     * Updating this field will add a new entry in the
     * `encryption_key_history_entries` field with the former version.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.EncryptionKey encryption_key = 68 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\OracleDatabase\V1\EncryptionKey|null
     */
    public function getEncryptionKey()
    {
        return $this->encryption_key;
    }

    public function hasEncryptionKey()
    {
        return isset($this->encryption_key);
    }

    public function clearEncryptionKey()
    {
        unset($this->encryption_key);
    }

    /**
     * Optional. The encryption key used to encrypt the Autonomous Database.
     * Updating this field will add a new entry in the
     * `encryption_key_history_entries` field with the former version.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.EncryptionKey encryption_key = 68 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\OracleDatabase\V1\EncryptionKey $var
     * @return $this
     */
    public function setEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\EncryptionKey::class);
        $this->encryption_key = $var;

        return $this;
    }

    /**
     * Output only. The history of the encryption keys used to encrypt the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.EncryptionKeyHistoryEntry encryption_key_history_entries = 69 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEncryptionKeyHistoryEntries()
    {
        return $this->encryption_key_history_entries;
    }

    /**
     * Output only. The history of the encryption keys used to encrypt the
     * Autonomous Database.
     *
     * Generated from protobuf field <code>repeated .google.cloud.oracledatabase.v1.EncryptionKeyHistoryEntry encryption_key_history_entries = 69 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\OracleDatabase\V1\EncryptionKeyHistoryEntry>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEncryptionKeyHistoryEntries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OracleDatabase\V1\EncryptionKeyHistoryEntry::class);
        $this->encryption_key_history_entries = $arr;

        return $this;
    }

    /**
     * Output only. An Oracle-managed Google Cloud service account on which
     * customers can grant roles to access resources in the customer project.
     *
     * Generated from protobuf field <code>string service_agent_email = 70 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getServiceAgentEmail()
    {
        return $this->service_agent_email;
    }

    /**
     * Output only. An Oracle-managed Google Cloud service account on which
     * customers can grant roles to access resources in the customer project.
     *
     * Generated from protobuf field <code>string service_agent_email = 70 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAgentEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_agent_email = $var;

        return $this;
    }

}

