<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/hypercomputecluster/v1beta/hypercompute_cluster.proto

namespace Google\Cloud\HypercomputeCluster\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for Slurm nodesets in the cluster. Nodesets are groups of
 * compute nodes used by Slurm that are responsible for running workloads
 * submitted to the cluster.
 *
 * Generated from protobuf message <code>google.cloud.hypercomputecluster.v1beta.SlurmNodeSet</code>
 */
class SlurmNodeSet extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Identifier for the nodeset, which allows it to be referenced by
     * partitions. Must conform to
     * [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
     * alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $id = '';
    /**
     * Optional. ID of the compute resource on which this nodeset will run. Must
     * match a key in the cluster's
     * [compute_resources](Cluster.compute_resources).
     *
     * Generated from protobuf field <code>string compute_id = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $compute_id = '';
    /**
     * Optional. How [storage
     * resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
     * be mounted on each compute node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.StorageConfig storage_configs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $storage_configs;
    /**
     * Optional. Number of nodes to be statically created for this nodeset. The
     * cluster will attempt to ensure that at least this many nodes exist at all
     * times.
     *
     * Generated from protobuf field <code>int64 static_node_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $static_node_count = 0;
    /**
     * Optional. Controls how many additional nodes a cluster can bring online to
     * handle workloads. Set this value to enable dynamic node creation and limit
     * the number of additional nodes the cluster can bring online. Leave empty if
     * you do not want the cluster to create nodes dynamically, and instead rely
     * only on static nodes.
     *
     * Generated from protobuf field <code>int64 max_dynamic_node_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $max_dynamic_node_count = 0;
    protected $type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\HypercomputeCluster\V1beta\ComputeInstanceSlurmNodeSet $compute_instance
     *           Optional. If set, indicates that the nodeset should be backed by Compute
     *           Engine instances.
     *     @type string $id
     *           Required. Identifier for the nodeset, which allows it to be referenced by
     *           partitions. Must conform to
     *           [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
     *           alphanumeric, and at most 63 characters).
     *     @type string $compute_id
     *           Optional. ID of the compute resource on which this nodeset will run. Must
     *           match a key in the cluster's
     *           [compute_resources](Cluster.compute_resources).
     *     @type array<\Google\Cloud\HypercomputeCluster\V1beta\StorageConfig>|\Google\Protobuf\Internal\RepeatedField $storage_configs
     *           Optional. How [storage
     *           resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
     *           be mounted on each compute node.
     *     @type int|string $static_node_count
     *           Optional. Number of nodes to be statically created for this nodeset. The
     *           cluster will attempt to ensure that at least this many nodes exist at all
     *           times.
     *     @type int|string $max_dynamic_node_count
     *           Optional. Controls how many additional nodes a cluster can bring online to
     *           handle workloads. Set this value to enable dynamic node creation and limit
     *           the number of additional nodes the cluster can bring online. Leave empty if
     *           you do not want the cluster to create nodes dynamically, and instead rely
     *           only on static nodes.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Hypercomputecluster\V1Beta\HypercomputeCluster::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. If set, indicates that the nodeset should be backed by Compute
     * Engine instances.
     *
     * Generated from protobuf field <code>.google.cloud.hypercomputecluster.v1beta.ComputeInstanceSlurmNodeSet compute_instance = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\HypercomputeCluster\V1beta\ComputeInstanceSlurmNodeSet|null
     */
    public function getComputeInstance()
    {
        return $this->readOneof(17);
    }

    public function hasComputeInstance()
    {
        return $this->hasOneof(17);
    }

    /**
     * Optional. If set, indicates that the nodeset should be backed by Compute
     * Engine instances.
     *
     * Generated from protobuf field <code>.google.cloud.hypercomputecluster.v1beta.ComputeInstanceSlurmNodeSet compute_instance = 17 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\HypercomputeCluster\V1beta\ComputeInstanceSlurmNodeSet $var
     * @return $this
     */
    public function setComputeInstance($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\HypercomputeCluster\V1beta\ComputeInstanceSlurmNodeSet::class);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * Required. Identifier for the nodeset, which allows it to be referenced by
     * partitions. Must conform to
     * [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
     * alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Required. Identifier for the nodeset, which allows it to be referenced by
     * partitions. Must conform to
     * [RFC-1034](https://datatracker.ietf.org/doc/html/rfc1034) (lower-case,
     * alphanumeric, and at most 63 characters).
     *
     * Generated from protobuf field <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Optional. ID of the compute resource on which this nodeset will run. Must
     * match a key in the cluster's
     * [compute_resources](Cluster.compute_resources).
     *
     * Generated from protobuf field <code>string compute_id = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getComputeId()
    {
        return $this->compute_id;
    }

    /**
     * Optional. ID of the compute resource on which this nodeset will run. Must
     * match a key in the cluster's
     * [compute_resources](Cluster.compute_resources).
     *
     * Generated from protobuf field <code>string compute_id = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setComputeId($var)
    {
        GPBUtil::checkString($var, True);
        $this->compute_id = $var;

        return $this;
    }

    /**
     * Optional. How [storage
     * resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
     * be mounted on each compute node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.StorageConfig storage_configs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStorageConfigs()
    {
        return $this->storage_configs;
    }

    /**
     * Optional. How [storage
     * resources][google.cloud.hypercomputecluster.v1beta.StorageResource] should
     * be mounted on each compute node.
     *
     * Generated from protobuf field <code>repeated .google.cloud.hypercomputecluster.v1beta.StorageConfig storage_configs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\HypercomputeCluster\V1beta\StorageConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStorageConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\HypercomputeCluster\V1beta\StorageConfig::class);
        $this->storage_configs = $arr;

        return $this;
    }

    /**
     * Optional. Number of nodes to be statically created for this nodeset. The
     * cluster will attempt to ensure that at least this many nodes exist at all
     * times.
     *
     * Generated from protobuf field <code>int64 static_node_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getStaticNodeCount()
    {
        return $this->static_node_count;
    }

    /**
     * Optional. Number of nodes to be statically created for this nodeset. The
     * cluster will attempt to ensure that at least this many nodes exist at all
     * times.
     *
     * Generated from protobuf field <code>int64 static_node_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setStaticNodeCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->static_node_count = $var;

        return $this;
    }

    /**
     * Optional. Controls how many additional nodes a cluster can bring online to
     * handle workloads. Set this value to enable dynamic node creation and limit
     * the number of additional nodes the cluster can bring online. Leave empty if
     * you do not want the cluster to create nodes dynamically, and instead rely
     * only on static nodes.
     *
     * Generated from protobuf field <code>int64 max_dynamic_node_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getMaxDynamicNodeCount()
    {
        return $this->max_dynamic_node_count;
    }

    /**
     * Optional. Controls how many additional nodes a cluster can bring online to
     * handle workloads. Set this value to enable dynamic node creation and limit
     * the number of additional nodes the cluster can bring online. Leave empty if
     * you do not want the cluster to create nodes dynamically, and instead rely
     * only on static nodes.
     *
     * Generated from protobuf field <code>int64 max_dynamic_node_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setMaxDynamicNodeCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->max_dynamic_node_count = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->whichOneof("type");
    }

}

