<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/firestore/v1/document.proto

namespace Google\Cloud\Firestore\V1\Pipeline;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A single operation within a pipeline.
 * A stage is made up of a unique name, and a list of arguments. The exact
 * number of arguments & types is dependent on the stage type.
 * To give an example, the stage `filter(state = "MD")` would be encoded as:
 * ```
 * name: "filter"
 * args {
 *   function_value {
 *     name: "eq"
 *     args { field_reference_value: "state" }
 *     args { string_value: "MD" }
 *   }
 * }
 * ```
 * See public documentation for the full list.
 *
 * Generated from protobuf message <code>google.firestore.v1.Pipeline.Stage</code>
 */
class Stage extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the stage to evaluate.
     * **Requires:**
     * * must be in snake case (lower case with underscore separator).
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $name = '';
    /**
     * Optional. Ordered list of arguments the given stage expects.
     *
     * Generated from protobuf field <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $args;
    /**
     * Optional. Optional named arguments that certain functions may support.
     *
     * Generated from protobuf field <code>map<string, .google.firestore.v1.Value> options = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $options;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The name of the stage to evaluate.
     *           **Requires:**
     *           * must be in snake case (lower case with underscore separator).
     *     @type array<\Google\Cloud\Firestore\V1\Value>|\Google\Protobuf\Internal\RepeatedField $args
     *           Optional. Ordered list of arguments the given stage expects.
     *     @type array|\Google\Protobuf\Internal\MapField $options
     *           Optional. Optional named arguments that certain functions may support.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Firestore\V1\Document::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the stage to evaluate.
     * **Requires:**
     * * must be in snake case (lower case with underscore separator).
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The name of the stage to evaluate.
     * **Requires:**
     * * must be in snake case (lower case with underscore separator).
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. Ordered list of arguments the given stage expects.
     *
     * Generated from protobuf field <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getArgs()
    {
        return $this->args;
    }

    /**
     * Optional. Ordered list of arguments the given stage expects.
     *
     * Generated from protobuf field <code>repeated .google.firestore.v1.Value args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Firestore\V1\Value>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setArgs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Firestore\V1\Value::class);
        $this->args = $arr;

        return $this;
    }

    /**
     * Optional. Optional named arguments that certain functions may support.
     *
     * Generated from protobuf field <code>map<string, .google.firestore.v1.Value> options = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * Optional. Optional named arguments that certain functions may support.
     *
     * Generated from protobuf field <code>map<string, .google.firestore.v1.Value> options = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setOptions($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Firestore\V1\Value::class);
        $this->options = $arr;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Stage::class, \Google\Cloud\Firestore\V1\Pipeline_Stage::class);

