<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/databasecenter/v1beta/signals.proto

namespace Google\Cloud\DatabaseCenter\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Metadata about inefficient query signal info for a database resource.
 *
 * Generated from protobuf message <code>google.cloud.databasecenter.v1beta.InefficientQueryInfo</code>
 */
class InefficientQueryInfo extends \Google\Protobuf\Internal\Message
{
    /**
     * Name of the database where index is required. For example, "db1", which is
     * the name of the database present in the instance.
     *
     * Generated from protobuf field <code>string database = 1;</code>
     */
    protected $database = '';
    /**
     * Name of the table where index is required
     *
     * Generated from protobuf field <code>string table = 2;</code>
     */
    protected $table = '';
    /**
     * SQL statement of the index. Based on the ddl type, this will be either
     * CREATE INDEX or DROP INDEX.
     *
     * Generated from protobuf field <code>string sql_index_statement = 3;</code>
     */
    protected $sql_index_statement = '';
    /**
     * Cost of additional disk usage in bytes
     *
     * Generated from protobuf field <code>int64 storage_cost_bytes = 4;</code>
     */
    protected $storage_cost_bytes = 0;
    /**
     * Count of queries to be impacted if index is applied
     *
     * Generated from protobuf field <code>int64 impacted_queries_count = 5;</code>
     */
    protected $impacted_queries_count = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $database
     *           Name of the database where index is required. For example, "db1", which is
     *           the name of the database present in the instance.
     *     @type string $table
     *           Name of the table where index is required
     *     @type string $sql_index_statement
     *           SQL statement of the index. Based on the ddl type, this will be either
     *           CREATE INDEX or DROP INDEX.
     *     @type int|string $storage_cost_bytes
     *           Cost of additional disk usage in bytes
     *     @type int|string $impacted_queries_count
     *           Count of queries to be impacted if index is applied
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Databasecenter\V1Beta\Signals::initOnce();
        parent::__construct($data);
    }

    /**
     * Name of the database where index is required. For example, "db1", which is
     * the name of the database present in the instance.
     *
     * Generated from protobuf field <code>string database = 1;</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Name of the database where index is required. For example, "db1", which is
     * the name of the database present in the instance.
     *
     * Generated from protobuf field <code>string database = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * Name of the table where index is required
     *
     * Generated from protobuf field <code>string table = 2;</code>
     * @return string
     */
    public function getTable()
    {
        return $this->table;
    }

    /**
     * Name of the table where index is required
     *
     * Generated from protobuf field <code>string table = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setTable($var)
    {
        GPBUtil::checkString($var, True);
        $this->table = $var;

        return $this;
    }

    /**
     * SQL statement of the index. Based on the ddl type, this will be either
     * CREATE INDEX or DROP INDEX.
     *
     * Generated from protobuf field <code>string sql_index_statement = 3;</code>
     * @return string
     */
    public function getSqlIndexStatement()
    {
        return $this->sql_index_statement;
    }

    /**
     * SQL statement of the index. Based on the ddl type, this will be either
     * CREATE INDEX or DROP INDEX.
     *
     * Generated from protobuf field <code>string sql_index_statement = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setSqlIndexStatement($var)
    {
        GPBUtil::checkString($var, True);
        $this->sql_index_statement = $var;

        return $this;
    }

    /**
     * Cost of additional disk usage in bytes
     *
     * Generated from protobuf field <code>int64 storage_cost_bytes = 4;</code>
     * @return int|string
     */
    public function getStorageCostBytes()
    {
        return $this->storage_cost_bytes;
    }

    /**
     * Cost of additional disk usage in bytes
     *
     * Generated from protobuf field <code>int64 storage_cost_bytes = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setStorageCostBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->storage_cost_bytes = $var;

        return $this;
    }

    /**
     * Count of queries to be impacted if index is applied
     *
     * Generated from protobuf field <code>int64 impacted_queries_count = 5;</code>
     * @return int|string
     */
    public function getImpactedQueriesCount()
    {
        return $this->impacted_queries_count;
    }

    /**
     * Count of queries to be impacted if index is applied
     *
     * Generated from protobuf field <code>int64 impacted_queries_count = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setImpactedQueriesCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->impacted_queries_count = $var;

        return $this;
    }

}

